/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.edit;

import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;
import org.herac.tuxguitar.util.TGContext;

public class TGEditToolBarSectionEdit
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "edit";
    private UIToolCheckableItem voice1;
    private UIToolCheckableItem voice2;
    private UIToolCheckableItem modeSelection;
    private UIToolCheckableItem modeEdition;
    private UIToolCheckableItem notNaturalKey;

    public TGEditToolBarSectionEdit(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
    }

    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.voice1 = toolBar.createCheckItem();
        this.voice1.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-1"));
        this.voice2 = toolBar.createCheckItem();
        this.voice2.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-2"));
        toolBar.createSeparator();
        this.modeSelection = toolBar.createCheckItem();
        this.modeSelection.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-selection"));
        this.modeEdition = toolBar.createCheckItem();
        this.modeEdition.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = toolBar.createCheckItem();
        this.notNaturalKey.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-natural-key"));
    }

    public void updateSectionItems() {
        TablatureEditor editor = TablatureEditor.getInstance(this.getToolBar().getContext());
        EditorKit editorKit = editor.getTablature().getEditorKit();
        boolean running = MidiPlayer.getInstance((TGContext)this.getToolBar().getContext()).isRunning();
        this.voice1.setChecked(editor.getTablature().getCaret().getVoice() == 0);
        this.voice1.setEnabled(!running);
        this.voice2.setChecked(editor.getTablature().getCaret().getVoice() == 1);
        this.voice2.setEnabled(!running);
        this.modeSelection.setChecked(editorKit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!running);
        this.modeEdition.setChecked(editorKit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!running);
        this.notNaturalKey.setChecked(!editorKit.isNatural());
        this.notNaturalKey.setEnabled(!running && editorKit.getMouseMode() == 2);
    }

    public void loadSectionProperties() {
        this.voice1.setToolTipText(this.getText("edit.voice-1"));
        this.voice2.setToolTipText(this.getText("edit.voice-2"));
        this.modeSelection.setToolTipText(this.getText("edit.mouse-mode-selection"));
        this.modeEdition.setToolTipText(this.getText("edit.mouse-mode-edition"));
        this.notNaturalKey.setToolTipText(this.getText("edit.not-natural-key"));
    }

    public void loadSectionIcons() {
        this.voice1.setImage(this.getIconManager().getEditVoice1());
        this.voice2.setImage(this.getIconManager().getEditVoice2());
        this.modeSelection.setImage(this.getIconManager().getEditModeSelection());
        this.modeEdition.setImage(this.getIconManager().getEditModeEdition());
        this.notNaturalKey.setImage(this.getIconManager().getEditModeEditionNotNatural());
    }
}

