/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.edit;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;

public class TGEditToolBarSectionComposition
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "composition";
    private UIToolActionItem tempo;
    private UIToolActionItem timeSignature;
    private UIToolCheckableItem repeatOpen;
    private UIToolCheckableItem repeatClose;
    private UIToolCheckableItem repeatAlternative;

    public TGEditToolBarSectionComposition(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
    }

    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.tempo = toolBar.createActionItem();
        this.tempo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-tempo-dialog"));
        this.timeSignature = toolBar.createActionItem();
        this.timeSignature.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-time-signature-dialog"));
        toolBar.createSeparator();
        this.repeatOpen = toolBar.createCheckItem();
        this.repeatOpen.addSelectionListener((UISelectionListener)this.createActionProcessor("action.insert.open-repeat"));
        this.repeatClose = toolBar.createCheckItem();
        this.repeatClose.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-repeat-close-dialog"));
        this.repeatAlternative = toolBar.createCheckItem();
        this.repeatAlternative.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-repeat-alternative-dialog"));
    }

    public void updateSectionItems() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        TGMeasureImpl measure = this.getTablature().getCaret().getMeasure();
        this.tempo.setEnabled(!running);
        this.timeSignature.setEnabled(!running);
        this.repeatOpen.setEnabled(!running);
        this.repeatOpen.setChecked(measure != null && measure.isRepeatOpen());
        this.repeatClose.setEnabled(!running);
        this.repeatClose.setChecked(measure != null && measure.getRepeatClose() > 0);
        this.repeatAlternative.setEnabled(!running);
        this.repeatAlternative.setChecked(measure != null && measure.getHeader().getRepeatAlternative() > 0);
    }

    public void loadSectionProperties() {
        this.tempo.setToolTipText(this.getText("composition.tempo"));
        this.timeSignature.setToolTipText(this.getText("composition.timesignature"));
        this.repeatOpen.setToolTipText(this.getText("repeat.open"));
        this.repeatClose.setToolTipText(this.getText("repeat.close"));
        this.repeatAlternative.setToolTipText(this.getText("repeat.alternative"));
    }

    public void loadSectionIcons() {
        this.tempo.setImage(this.getIconManager().getCompositionTempo());
        this.timeSignature.setImage(this.getIconManager().getCompositionTimeSignature());
        this.repeatOpen.setImage(this.getIconManager().getCompositionRepeatOpen());
        this.repeatClose.setImage(this.getIconManager().getCompositionRepeatClose());
        this.repeatAlternative.setImage(this.getIconManager().getCompositionRepeatAlternative());
    }
}

