/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class EditMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem editMenuItem;
    private UIMenuActionItem undo;
    private UIMenuActionItem redo;
    private UIMenuCheckableItem modeSelection;
    private UIMenuCheckableItem modeEdition;
    private UIMenuCheckableItem notNaturalKey;
    private UIMenuCheckableItem voice1;
    private UIMenuCheckableItem voice2;

    public EditMenuItem(UIMenu parent) {
        this.editMenuItem = parent.createSubMenuItem();
    }

    public void showItems() {
        this.undo = this.editMenuItem.getMenu().createActionItem();
        this.undo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.undo"));
        this.redo = this.editMenuItem.getMenu().createActionItem();
        this.redo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.redo"));
        this.editMenuItem.getMenu().createSeparator();
        this.modeSelection = this.editMenuItem.getMenu().createRadioItem();
        this.modeSelection.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-selection"));
        this.modeEdition = this.editMenuItem.getMenu().createRadioItem();
        this.modeEdition.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = this.editMenuItem.getMenu().createCheckItem();
        this.notNaturalKey.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-natural-key"));
        this.editMenuItem.getMenu().createSeparator();
        this.voice1 = this.editMenuItem.getMenu().createRadioItem();
        this.voice1.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-1"));
        this.voice2 = this.editMenuItem.getMenu().createRadioItem();
        this.voice2.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-2"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        EditorKit kit = TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.undo.setEnabled(!running && TuxGuitar.getInstance().getUndoableManager().canUndo());
        this.redo.setEnabled(!running && TuxGuitar.getInstance().getUndoableManager().canRedo());
        this.modeSelection.setChecked(kit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!running);
        this.modeEdition.setChecked(kit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!running);
        this.notNaturalKey.setChecked(!kit.isNatural());
        this.notNaturalKey.setEnabled(!running && kit.getMouseMode() == 2);
        this.voice1.setChecked(kit.getTablature().getCaret().getVoice() == 0);
        this.voice2.setChecked(kit.getTablature().getCaret().getVoice() == 1);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.editMenuItem, "edit.menu", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.undo, "edit.undo", "action.edit.undo");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.redo, "edit.redo", "action.edit.redo");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.modeSelection, "edit.mouse-mode-selection", "action.edit.set-mouse-mode-selection");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.modeEdition, "edit.mouse-mode-edition", "action.edit.set-mouse-mode-edition");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.notNaturalKey, "edit.not-natural-key", "action.edit.set-natural-key");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voice1, "edit.voice-1", "action.edit.voice-1");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voice2, "edit.voice-2", "action.edit.voice-2");
    }

    public void loadIcons() {
        this.undo.setImage(TuxGuitar.getInstance().getIconManager().getEditUndo());
        this.redo.setImage(TuxGuitar.getInstance().getIconManager().getEditRedo());
    }
}

