/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class MainOption
extends TGSettingsOption {
    private static final String VAR_START = "${";
    private static final String VAR_END = "}";
    private static final String[] VAR_NAMES = new String[]{"appname", "appversion", "filename", "filepath", "songname", "songalbum", "songartist", "songauthor"};
    private boolean initialized = false;
    private UICheckBox showSplash;
    private UICheckBox autoSizeTable;
    private UITextField windowTitle;

    public MainOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.main"));
    }

    public void createOption() {
        UIFactory uiFactory = this.getUIFactory();
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.main"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionMain());
        this.getToolItem().addSelectionListener((UISelectionListener)this);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.main.window-title"), true, 1, 1);
        UITableLayout titleSectionLayout = new UITableLayout();
        UIPanel titleSection = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        titleSection.setLayout((UILayout)titleSectionLayout);
        this.indent((UIControl)titleSection, 2, 1);
        UITableLayout windowTitleLayout = new UITableLayout();
        UIPanel windowTitleComposite = uiFactory.createPanel((UIContainer)titleSection, false);
        windowTitleComposite.setLayout((UILayout)windowTitleLayout);
        titleSectionLayout.set((UIControl)windowTitleComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.windowTitle = uiFactory.createTextField((UIContainer)windowTitleComposite);
        this.windowTitle.setTextLimit(Integer.valueOf(80));
        windowTitleLayout.set((UIControl)this.windowTitle, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout infoHeaderLayout = new UITableLayout();
        UIPanel infoHeader = uiFactory.createPanel((UIContainer)titleSection, false);
        infoHeader.setLayout((UILayout)infoHeaderLayout);
        titleSectionLayout.set((UIControl)infoHeader, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.showImageLabel((UILayoutContainer)infoHeader, TuxGuitar.getInstance().getIconManager().getStatusInfo(), 1, 1);
        this.showLabel((UILayoutContainer)infoHeader, TuxGuitar.getProperty("settings.config.main.window-title.help"), false, 1, 2);
        UIPanel infoBody = uiFactory.createPanel((UIContainer)titleSection, false);
        infoBody.setLayout((UILayout)new UITableLayout());
        titleSectionLayout.set((UIControl)infoBody, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        for (int i = 0; i < VAR_NAMES.length; ++i) {
            this.showLabel((UILayoutContainer)infoBody, this.getVar(VAR_NAMES[i]), true, i + 1, 1);
            this.showLabel((UILayoutContainer)infoBody, TuxGuitar.getProperty("settings.config.main.window-title.var.description." + VAR_NAMES[i]), false, i + 1, 2);
        }
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.main.options"), true, 3, 1);
        UITableLayout optionsLayout = new UITableLayout();
        UIPanel options = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        options.setLayout((UILayout)optionsLayout);
        this.indent((UIControl)options, 4, 1);
        this.autoSizeTable = uiFactory.createCheckBox((UIContainer)options);
        this.autoSizeTable.setText(TuxGuitar.getProperty("settings.config.main.table.auto-size.enabled"));
        optionsLayout.set((UIControl)this.autoSizeTable, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.showSplash = uiFactory.createCheckBox((UIContainer)options);
        this.showSplash.setText(TuxGuitar.getProperty("settings.config.main.splash-enabled"));
        optionsLayout.set((UIControl)this.showSplash, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final String windowTitle = MainOption.this.getConfig().getStringValue("window.title");
                final boolean showSplash = MainOption.this.getConfig().getBooleanValue("show.splash");
                final boolean autoSizeTable = MainOption.this.getConfig().getBooleanValue("table.auto-size");
                TGSynchronizer.getInstance((TGContext)MainOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!MainOption.this.isDisposed()) {
                            MainOption.this.windowTitle.setText(windowTitle);
                            MainOption.this.showSplash.setSelected(showSplash);
                            MainOption.this.autoSizeTable.setSelected(autoSizeTable);
                            MainOption.this.initialized = true;
                            MainOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setValue("window.title", this.windowTitle.getText());
            this.getConfig().setValue("show.splash", this.showSplash.isSelected());
            this.getConfig().setValue("table.auto-size", this.autoSizeTable.isSelected());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("window.title", this.getDefaults().getValue("window.title"));
            this.getConfig().setValue("show.splash", this.getDefaults().getValue("show.splash"));
            this.getConfig().setValue("table.auto-size", this.getDefaults().getValue("table.auto-size"));
        }
    }

    public String getVar(String varName) {
        return VAR_START + varName + VAR_END;
    }
}

