/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.piano;

import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.dialog.piano.TGPianoConfig;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIImageView;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISeparator;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGPiano {
    private static final boolean[] TYPE_NOTES = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true};
    private static final int NATURAL_NOTES = 7;
    private static final int MAX_OCTAVES = 8;
    private static final int NATURAL_WIDTH = 15;
    private static final int SHARP_WIDTH = 8;
    private static final int NATURAL_HEIGHT = 60;
    private static final int SHARP_HEIGHT = 40;
    private TGContext context;
    private int duration;
    private boolean changes;
    private TGPianoConfig config;
    private UIPanel control;
    private UIPanel toolComposite;
    private UICanvas canvas;
    private UIImageView durationLabel;
    private UILabel scaleName;
    private UIButton scale;
    private UIButton goLeft;
    private UIButton goRight;
    private UIButton increment;
    private UIButton decrement;
    private UIButton settings;
    private TGBeat beat;
    private TGBeat externalBeat;
    private UIImage image;

    public TGPiano(TGContext context, UIWindow parent) {
        this.context = context;
        this.config = new TGPianoConfig(context);
        this.config.load();
        this.control = this.getUIFactory().createPanel((UIContainer)parent, false);
        this.initToolBar();
        this.initCanvas();
        this.createControlLayout();
        this.loadIcons();
        this.loadProperties();
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((UIControl)this.toolComposite);
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((UIControl)this.canvas);
    }

    public void createControlLayout() {
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        uiLayout.set((UIControl)this.toolComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        uiLayout.set((UIControl)this.canvas, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set((UIControl)this.canvas, "packed_width", (Object)Float.valueOf(840.0f));
        uiLayout.set((UIControl)this.canvas, "packed_height", (Object)Float.valueOf(60.0f));
        this.control.setLayout((UILayout)uiLayout);
    }

    private void initToolBar() {
        UIFactory uiFactory = this.getUIFactory();
        int column = 0;
        this.toolComposite = uiFactory.createPanel((UIContainer)this.control, false);
        this.createToolBarLayout();
        this.goLeft = uiFactory.createButton((UIContainer)this.toolComposite);
        this.goLeft.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-left"));
        this.createToolItemLayout((UIControl)this.goLeft, ++column);
        this.goRight = uiFactory.createButton((UIContainer)this.toolComposite);
        this.goRight.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-right"));
        this.createToolItemLayout((UIControl)this.goRight, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.decrement = uiFactory.createButton((UIContainer)this.toolComposite);
        this.decrement.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.decrement-duration"));
        this.createToolItemLayout((UIControl)this.decrement, ++column);
        this.durationLabel = uiFactory.createImageView((UIContainer)this.toolComposite);
        this.createToolItemLayout((UIControl)this.durationLabel, ++column);
        this.increment = uiFactory.createButton((UIContainer)this.toolComposite);
        this.increment.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.increment-duration"));
        this.createToolItemLayout((UIControl)this.increment, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.scale = uiFactory.createButton((UIContainer)this.toolComposite);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-scale-dialog"));
        this.createToolItemLayout((UIControl)this.scale, ++column);
        this.scaleName = uiFactory.createLabel((UIContainer)this.toolComposite);
        this.createToolItemLayout((UIControl)this.scaleName, ++column, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, false, false);
        this.settings = uiFactory.createButton((UIContainer)this.toolComposite);
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGPiano.this.configure();
            }
        });
        this.createToolItemLayout((UIControl)this.settings, ++column, UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, true, false);
        this.toolComposite.getLayout().set((UIControl)this.goLeft, "margin_left", (Object)Float.valueOf(0.0f));
        this.toolComposite.getLayout().set((UIControl)this.settings, "margin_right", (Object)Float.valueOf(0.0f));
    }

    private void createToolBarLayout() {
        UITableLayout uiLayout = new UITableLayout();
        uiLayout.set("margin_left", (Object)Float.valueOf(0.0f));
        uiLayout.set("margin_right", (Object)Float.valueOf(0.0f));
        this.toolComposite.setLayout((UILayout)uiLayout);
    }

    private void createToolItemLayout(UIControl uiControl, int column) {
        this.createToolItemLayout(uiControl, column, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, false, false);
    }

    private void createToolItemLayout(UIControl uiControl, int column, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY) {
        UITableLayout uiLayout = (UITableLayout)this.toolComposite.getLayout();
        uiLayout.set(uiControl, Integer.valueOf(1), Integer.valueOf(column), alignX, alignY, fillX, fillX);
    }

    private void createToolSeparator(UIFactory uiFactory, int column) {
        UISeparator uiSeparator = uiFactory.createVerticalSeparator((UIContainer)this.toolComposite);
        UITableLayout uiLayout = (UITableLayout)this.toolComposite.getLayout();
        uiLayout.set((UIControl)uiSeparator, Integer.valueOf(1), Integer.valueOf(column), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set((UIControl)uiSeparator, "packed_width", (Object)Float.valueOf(20.0f));
        uiLayout.set((UIControl)uiSeparator, "packed_height", (Object)Float.valueOf(20.0f));
    }

    private void loadDurationImage(boolean force) {
        int duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (force || this.duration != duration) {
            this.duration = duration;
            this.durationLabel.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.duration));
        }
    }

    private void loadScaleName() {
        int scaleKey = TuxGuitar.getInstance().getScaleManager().getSelectionKey();
        int scaleIndex = TuxGuitar.getInstance().getScaleManager().getSelectionIndex();
        String key = TuxGuitar.getInstance().getScaleManager().getKeyName(scaleKey);
        String name = TuxGuitar.getInstance().getScaleManager().getScaleName(scaleIndex);
        this.scaleName.setText(key != null && name != null ? key + " - " + name : "");
    }

    private void initCanvas() {
        this.image = this.makePianoImage();
        this.canvas = this.getUIFactory().createCanvas((UIContainer)this.control, true);
        this.canvas.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.context, new TGPianoPainterListener()));
        this.canvas.addMouseUpListener((UIMouseUpListener)new TGPianoMouseListener());
        this.canvas.setFocus();
    }

    private UIImage makePianoImage() {
        UIFactory factory = this.getUIFactory();
        UIImage image = factory.createImage(840.0f, 60.0f);
        UIPainter painter = image.createPainter();
        int x = 0;
        boolean y = false;
        painter.setBackground(this.config.getColorNatural());
        painter.initPath(2);
        painter.addRectangle((float)x, (float)y, 840.0f, 60.0f);
        painter.closePath();
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                painter.setForeground(this.config.getColorNotNatural());
                painter.initPath();
                painter.setAntialias(false);
                painter.addRectangle((float)x, (float)y, 15.0f, 60.0f);
                painter.closePath();
                x += 15;
                continue;
            }
            painter.setBackground(this.config.getColorNotNatural());
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle((float)(x - 4), (float)y, 8.0f, 40.0f);
            painter.closePath();
        }
        this.paintScale(painter);
        painter.dispose();
        return image;
    }

    private void paintScale(UIPainter painter) {
        painter.setBackground(this.config.getColorScale());
        painter.setForeground(this.config.getColorScale());
        int posX = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int width = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                width = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
            } else {
                width = 8;
            }
            if (TuxGuitar.getInstance().getScaleManager().getScale().getNote(i)) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    int x = posX;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        x -= 4;
                    }
                    int size = 8;
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(x + 1 + (15 - size) / 2), (float)(60 - size - (15 - size) / 2), (float)size, (float)size);
                    painter.closePath();
                } else {
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(posX + 1), 33.0f, 6.0f, 6.0f);
                    painter.closePath();
                }
            }
            posX += width;
        }
    }

    protected void paintNote(UIPainter painter, int value) {
        painter.setBackground(this.config.getColorNote());
        int posX = 0;
        int y = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int width = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                width = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    width -= 4;
                }
            } else {
                width = 8;
            }
            if (i == value) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(posX + 1), (float)(y + 1), (float)(width - 1), 40.0f);
                    int x = posX;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        x -= 4;
                    }
                    painter.addRectangle((float)(x + 1), (float)(y + 40 + 1), 14.0f, 19.0f);
                    painter.closePath();
                } else {
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle((float)(posX + 1), (float)(y + 1), (float)(width - 1), 39.0f);
                    painter.closePath();
                }
            }
            posX += width;
        }
    }

    protected void paintEditor(UIPainter painter) {
        this.updateEditor();
        painter.drawImage(this.image, 0.0f, 0.0f);
        if (this.beat != null) {
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                Iterator it = voice.getNotes().iterator();
                while (it.hasNext()) {
                    this.paintNote(painter, this.getRealNoteValue((TGNote)it.next()));
                }
            }
        }
    }

    private int getSelection(float x) {
        float posX = 0.0f;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            float width = 0.0f;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                width = 15.0f;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    width -= 4.0f;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    width -= 4.0f;
                }
            } else {
                width = 8.0f;
            }
            if (x >= posX && x < posX + width) {
                return i;
            }
            posX += width;
        }
        return -1;
    }

    protected void hit(float x, float y) {
        int value = this.getSelection(x);
        if (!this.removeNote(value)) {
            this.addNote(value);
        }
    }

    private boolean removeNote(int value) {
        if (this.beat != null) {
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (this.getRealNoteValue(note) != value) continue;
                    TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.beat.general.delete-note");
                    tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
                    tgActionProcessor.process();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean addNote(int value) {
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        List strings = caret.getTrack().getStrings();
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = (TGString)strings.get(i);
            if (value < string.getValue()) continue;
            boolean emptyString = true;
            if (this.beat != null) {
                block1: for (int v = 0; v < this.beat.countVoices(); ++v) {
                    TGVoice voice = this.beat.getVoice(v);
                    for (TGNoteImpl note : voice.getNotes()) {
                        if (note.getString() != string.getNumber()) continue;
                        emptyString = false;
                        continue block1;
                    }
                }
            }
            if (!emptyString) continue;
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.note.general.change");
            tgActionProcessor.setAttribute("fret", (Object)(value - string.getValue()));
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
            tgActionProcessor.process();
            return true;
        }
        return false;
    }

    protected int getRealNoteValue(TGNote note) {
        TGTrack track;
        TGMeasure measure;
        TGBeat beat;
        TGVoice voice = note.getVoice();
        if (voice != null && (beat = voice.getBeat()) != null && (measure = beat.getMeasure()) != null && (track = measure.getTrack()) != null) {
            return note.getValue() + track.getString(note.getString()).getValue();
        }
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        TGTrackImpl track2 = caret.getTrack();
        if (track2 != null) {
            return note.getValue() + track2.getString(note.getString()).getValue();
        }
        return 0;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    public void setExternalBeat(TGBeat externalBeat) {
        this.externalBeat = externalBeat;
    }

    public TGBeat getExternalBeat() {
        return this.externalBeat;
    }

    protected void updateEditor() {
        if (this.isVisible()) {
            if (this.hasChanges()) {
                this.image.dispose();
                this.image = this.makePianoImage();
            }
            this.beat = TuxGuitar.getInstance().getPlayer().isRunning() ? TuxGuitar.getInstance().getEditorCache().getPlayBeat() : (this.externalBeat != null ? this.externalBeat : TuxGuitar.getInstance().getEditorCache().getEditBeat());
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.control.redraw();
            this.canvas.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setVisible(boolean visible) {
        this.control.setVisible(visible);
    }

    public boolean isVisible() {
        return this.control.isVisible();
    }

    public boolean isDisposed() {
        return this.control.isDisposed();
    }

    public void dispose() {
        this.control.dispose();
        this.image.dispose();
        this.config.dispose();
    }

    public void loadProperties() {
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.loadScaleName();
        this.control.layout();
    }

    public void loadIcons() {
        this.goLeft.setImage(TuxGuitar.getInstance().getIconManager().getArrowLeft());
        this.goRight.setImage(TuxGuitar.getInstance().getIconManager().getArrowRight());
        this.decrement.setImage(TuxGuitar.getInstance().getIconManager().getArrowUp());
        this.increment.setImage(TuxGuitar.getInstance().getIconManager().getArrowDown());
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.loadDurationImage(true);
        this.control.layout();
    }

    public void loadScale() {
        this.loadScaleName();
        this.setChanges(true);
        this.control.layout();
    }

    public void configure() {
        this.config.configure((UIWindow)this.control.getParent());
    }

    public void reloadFromConfig() {
        this.setChanges(true);
        this.redraw();
    }

    public UIPanel getControl() {
        return this.control;
    }

    public UICanvas getCanvas() {
        return this.canvas;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    private class TGPianoPainterListener
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        public void paintControl(UIPainter painter) {
            TGPiano.this.paintEditor(painter);
        }

        public UICanvas getPaintableControl() {
            return TGPiano.this.canvas;
        }
    }

    private class TGPianoMouseListener
    implements UIMouseUpListener {
        public void onMouseUp(UIMouseEvent event) {
            TGPiano.this.getCanvas().setFocus();
            if (event.getButton() == 1) {
                if (!TuxGuitar.getInstance().getPlayer().isRunning() && !TGEditorManager.getInstance((TGContext)TGPiano.this.context).isLocked()) {
                    if (TGPiano.this.getExternalBeat() == null) {
                        TGPiano.this.hit(event.getPosition().getX(), event.getPosition().getY());
                    } else {
                        TGPiano.this.setExternalBeat(null);
                        TuxGuitar.getInstance().updateCache(true);
                    }
                }
            } else {
                new TGActionProcessor(TGPiano.this.context, "action.caret.go-right").process();
            }
        }
    }
}

