/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import java.util.Arrays;

public class SoftChorus
implements SoftAudioProcessor {
    private boolean mix = true;
    private SoftAudioBuffer inputA;
    private SoftAudioBuffer left;
    private SoftAudioBuffer right;
    private SoftAudioBuffer reverb;
    private LFODelay vdelay1L;
    private LFODelay vdelay1R;
    private float rgain = 0.0f;
    private boolean dirty = true;
    private double dirty_vdelay1L_rate;
    private double dirty_vdelay1R_rate;
    private double dirty_vdelay1L_depth;
    private double dirty_vdelay1R_depth;
    private float dirty_vdelay1L_feedback;
    private float dirty_vdelay1R_feedback;
    private float dirty_vdelay1L_reverbsendgain;
    private float dirty_vdelay1R_reverbsendgain;
    private float controlrate;
    double silentcounter = 1000.0;

    public void init(float f, float f2) {
        this.controlrate = f2;
        this.vdelay1L = new LFODelay(f, f2);
        this.vdelay1R = new LFODelay(f, f2);
        this.vdelay1L.setGain(1.0f);
        this.vdelay1R.setGain(1.0f);
        this.vdelay1L.setPhase(1.5707963267948966);
        this.vdelay1R.setPhase(0.0);
        this.globalParameterControlChange(new int[]{130}, 0L, 2L);
    }

    public void globalParameterControlChange(int[] nArray, long l, long l2) {
        if (nArray.length == 1 && nArray[0] == 130) {
            if (l == 0L) {
                switch ((int)l2) {
                    case 0: {
                        this.globalParameterControlChange(nArray, 3L, 0L);
                        this.globalParameterControlChange(nArray, 1L, 3L);
                        this.globalParameterControlChange(nArray, 2L, 5L);
                        this.globalParameterControlChange(nArray, 4L, 0L);
                        break;
                    }
                    case 1: {
                        this.globalParameterControlChange(nArray, 3L, 5L);
                        this.globalParameterControlChange(nArray, 1L, 9L);
                        this.globalParameterControlChange(nArray, 2L, 19L);
                        this.globalParameterControlChange(nArray, 4L, 0L);
                        break;
                    }
                    case 2: {
                        this.globalParameterControlChange(nArray, 3L, 8L);
                        this.globalParameterControlChange(nArray, 1L, 3L);
                        this.globalParameterControlChange(nArray, 2L, 19L);
                        this.globalParameterControlChange(nArray, 4L, 0L);
                        break;
                    }
                    case 3: {
                        this.globalParameterControlChange(nArray, 3L, 16L);
                        this.globalParameterControlChange(nArray, 1L, 9L);
                        this.globalParameterControlChange(nArray, 2L, 16L);
                        this.globalParameterControlChange(nArray, 4L, 0L);
                        break;
                    }
                    case 4: {
                        this.globalParameterControlChange(nArray, 3L, 64L);
                        this.globalParameterControlChange(nArray, 1L, 2L);
                        this.globalParameterControlChange(nArray, 2L, 24L);
                        this.globalParameterControlChange(nArray, 4L, 0L);
                        break;
                    }
                    case 5: {
                        this.globalParameterControlChange(nArray, 3L, 112L);
                        this.globalParameterControlChange(nArray, 1L, 1L);
                        this.globalParameterControlChange(nArray, 2L, 5L);
                        this.globalParameterControlChange(nArray, 4L, 0L);
                        break;
                    }
                }
            } else if (l == 1L) {
                this.dirty_vdelay1L_rate = (double)l2 * 0.122;
                this.dirty_vdelay1R_rate = (double)l2 * 0.122;
                this.dirty = true;
            } else if (l == 2L) {
                this.dirty_vdelay1L_depth = (double)(l2 + 1L) / 3200.0;
                this.dirty_vdelay1R_depth = (double)(l2 + 1L) / 3200.0;
                this.dirty = true;
            } else if (l == 3L) {
                this.dirty_vdelay1L_feedback = (float)l2 * 0.00763f;
                this.dirty_vdelay1R_feedback = (float)l2 * 0.00763f;
                this.dirty = true;
            }
            if (l == 4L) {
                this.rgain = (float)l2 * 0.00787f;
                this.dirty_vdelay1L_reverbsendgain = (float)l2 * 0.00787f;
                this.dirty_vdelay1R_reverbsendgain = (float)l2 * 0.00787f;
                this.dirty = true;
            }
        }
    }

    public void processControlLogic() {
        if (this.dirty) {
            this.dirty = false;
            this.vdelay1L.setRate(this.dirty_vdelay1L_rate);
            this.vdelay1R.setRate(this.dirty_vdelay1R_rate);
            this.vdelay1L.setDepth(this.dirty_vdelay1L_depth);
            this.vdelay1R.setDepth(this.dirty_vdelay1R_depth);
            this.vdelay1L.setFeedBack(this.dirty_vdelay1L_feedback);
            this.vdelay1R.setFeedBack(this.dirty_vdelay1R_feedback);
            this.vdelay1L.setReverbSendGain(this.dirty_vdelay1L_reverbsendgain);
            this.vdelay1R.setReverbSendGain(this.dirty_vdelay1R_reverbsendgain);
        }
    }

    public void processAudio() {
        float[] fArray;
        if (this.inputA.isSilent()) {
            this.silentcounter += (double)(1.0f / this.controlrate);
            if (this.silentcounter > 1.0) {
                if (!this.mix) {
                    this.left.clear();
                    this.right.clear();
                }
                return;
            }
        } else {
            this.silentcounter = 0.0;
        }
        float[] fArray2 = this.inputA.array();
        float[] fArray3 = this.left.array();
        float[] fArray4 = this.right == null ? null : this.right.array();
        float[] fArray5 = fArray = this.rgain != 0.0f ? this.reverb.array() : null;
        if (this.mix) {
            this.vdelay1L.processMix(fArray2, fArray3, fArray);
            if (fArray4 != null) {
                this.vdelay1R.processMix(fArray2, fArray4, fArray);
            }
        } else {
            this.vdelay1L.processReplace(fArray2, fArray3, fArray);
            if (fArray4 != null) {
                this.vdelay1R.processReplace(fArray2, fArray4, fArray);
            }
        }
    }

    public void setInput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.inputA = softAudioBuffer;
        }
    }

    public void setMixMode(boolean bl) {
        this.mix = bl;
    }

    public void setOutput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.left = softAudioBuffer;
        }
        if (n == 1) {
            this.right = softAudioBuffer;
        }
        if (n == 2) {
            this.reverb = softAudioBuffer;
        }
    }

    private static class LFODelay {
        private double phase = 1.0;
        private double phase_step = 0.0;
        private double depth = 0.0;
        private VariableDelay vdelay;
        private double samplerate;
        private double controlrate;

        public LFODelay(double d, double d2) {
            this.samplerate = d;
            this.controlrate = d2;
            this.vdelay = new VariableDelay((int)((this.depth + 10.0) * 2.0));
        }

        public void setDepth(double d) {
            this.depth = d * this.samplerate;
            this.vdelay = new VariableDelay((int)((this.depth + 10.0) * 2.0));
        }

        public void setRate(double d) {
            double d2;
            this.phase_step = d2 = Math.PI * 2 * (d / this.controlrate);
        }

        public void setPhase(double d) {
            this.phase = d;
        }

        public void setFeedBack(float f) {
            this.vdelay.setFeedBack(f);
        }

        public void setGain(float f) {
            this.vdelay.setGain(f);
        }

        public void setReverbSendGain(float f) {
            this.vdelay.setReverbSendGain(f);
        }

        public void processMix(float[] fArray, float[] fArray2, float[] fArray3) {
            this.phase += this.phase_step;
            while (this.phase > Math.PI * 2) {
                this.phase -= Math.PI * 2;
            }
            this.vdelay.setDelay((float)(this.depth * 0.5 * (Math.cos(this.phase) + 2.0)));
            this.vdelay.processMix(fArray, fArray2, fArray3);
        }

        public void processReplace(float[] fArray, float[] fArray2, float[] fArray3) {
            this.phase += this.phase_step;
            while (this.phase > Math.PI * 2) {
                this.phase -= Math.PI * 2;
            }
            this.vdelay.setDelay((float)(this.depth * 0.5 * (Math.cos(this.phase) + 2.0)));
            this.vdelay.processReplace(fArray, fArray2, fArray3);
        }
    }

    private static class VariableDelay {
        private float[] delaybuffer;
        private int rovepos = 0;
        private float gain = 1.0f;
        private float rgain = 0.0f;
        private float delay = 0.0f;
        private float lastdelay = 0.0f;
        private float feedback = 0.0f;

        public VariableDelay(int n) {
            this.delaybuffer = new float[n];
        }

        public void setDelay(float f) {
            this.delay = f;
        }

        public void setFeedBack(float f) {
            this.feedback = f;
        }

        public void setGain(float f) {
            this.gain = f;
        }

        public void setReverbSendGain(float f) {
            this.rgain = f;
        }

        public void processMix(float[] fArray, float[] fArray2, float[] fArray3) {
            float f = this.gain;
            float f2 = this.delay;
            float f3 = this.feedback;
            float[] fArray4 = this.delaybuffer;
            int n = fArray.length;
            float f4 = (f2 - this.lastdelay) / (float)n;
            int n2 = fArray4.length;
            int n3 = this.rovepos;
            if (fArray3 == null) {
                for (int i = 0; i < n; ++i) {
                    float f5 = (float)n3 - (this.lastdelay + 2.0f) + (float)n2;
                    int n4 = (int)f5;
                    float f6 = f5 - (float)n4;
                    float f7 = fArray4[n4 % n2];
                    float f8 = fArray4[(n4 + 1) % n2];
                    float f9 = f7 * (1.0f - f6) + f8 * f6;
                    int n5 = i;
                    fArray2[n5] = fArray2[n5] + f9 * f;
                    fArray4[n3] = fArray[i] + f9 * f3;
                    n3 = (n3 + 1) % n2;
                    this.lastdelay += f4;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    float f10 = (float)n3 - (this.lastdelay + 2.0f) + (float)n2;
                    int n6 = (int)f10;
                    float f11 = f10 - (float)n6;
                    float f12 = fArray4[n6 % n2];
                    float f13 = fArray4[(n6 + 1) % n2];
                    float f14 = f12 * (1.0f - f11) + f13 * f11;
                    int n7 = i;
                    fArray2[n7] = fArray2[n7] + f14 * f;
                    int n8 = i;
                    fArray3[n8] = fArray3[n8] + f14 * this.rgain;
                    fArray4[n3] = fArray[i] + f14 * f3;
                    n3 = (n3 + 1) % n2;
                    this.lastdelay += f4;
                }
            }
            this.rovepos = n3;
            this.lastdelay = f2;
        }

        public void processReplace(float[] fArray, float[] fArray2, float[] fArray3) {
            Arrays.fill(fArray2, 0.0f);
            Arrays.fill(fArray3, 0.0f);
            this.processMix(fArray, fArray2, fArray3);
        }
    }
}

