/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models.effects;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TGEffectBend {
    public static final int SEMITONE_LENGTH = 1;
    public static final int MAX_POSITION_LENGTH = 12;
    public static final int MAX_VALUE_LENGTH = 12;
    private List<BendPoint> points = new ArrayList<BendPoint>();

    public void addPoint(int position, int value) {
        this.points.add(new BendPoint(position, value));
    }

    public List<BendPoint> getPoints() {
        return this.points;
    }

    public TGEffectBend clone(TGFactory factory) {
        TGEffectBend effect = factory.newEffectBend();
        for (BendPoint point : this.getPoints()) {
            effect.addPoint(point.getPosition(), point.getValue());
        }
        return effect;
    }

    public class BendPoint {
        private int position;
        private int value;

        public BendPoint(int position, int value) {
            this.position = position;
            this.value = value;
        }

        public int getPosition() {
            return this.position;
        }

        public int getValue() {
            return this.value;
        }

        public long getTime(long duration) {
            return duration * (long)this.getPosition() / 12L;
        }

        public Object clone() {
            return new BendPoint(this.getPosition(), this.getValue());
        }
    }
}

