/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGTrackManager {
    private TGSongManager songManager;

    public TGTrackManager(TGSongManager songManager) {
        this.songManager = songManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public TGMeasure getFirstMeasure(TGTrack track) {
        TGMeasure firstMeasure = null;
        Iterator<TGMeasure> measures = track.getMeasures();
        while (measures.hasNext()) {
            TGMeasure currMeasure = measures.next();
            if (firstMeasure != null && currMeasure.getStart() >= firstMeasure.getStart()) continue;
            firstMeasure = currMeasure;
        }
        return firstMeasure;
    }

    public TGMeasure getLastMeasure(TGTrack track) {
        return track.getMeasure(track.countMeasures() - 1);
    }

    public TGMeasure getPrevMeasure(TGMeasure measure) {
        return measure.getTrack().getMeasure(measure.getNumber() - 2);
    }

    public TGMeasure getNextMeasure(TGMeasure measure) {
        return measure.getTrack().getMeasure(measure.getNumber());
    }

    public TGMeasure getMeasureAt(TGTrack track, long start) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            long measureStart = measure.getStart();
            long measureLength = measure.getLength();
            if (start < measureStart || start >= measureStart + measureLength) continue;
            return measure;
        }
        return null;
    }

    public TGMeasure getMeasure(TGTrack track, int number) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            if (measure.getNumber() != number) continue;
            return measure;
        }
        return null;
    }

    public List<TGMeasure> getMeasuresBeforeEnd(TGTrack track, long fromStart) {
        ArrayList<TGMeasure> measures = new ArrayList<TGMeasure>();
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure currMeasure = it.next();
            if (currMeasure.getStart() < fromStart) continue;
            measures.add(currMeasure);
        }
        return measures;
    }

    public List<TGMeasure> getMeasuresBetween(TGTrack track, long p1, long p2) {
        ArrayList<TGMeasure> measures = new ArrayList<TGMeasure>();
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            if (measure.getStart() + measure.getLength() <= p1 || measure.getStart() >= p2) continue;
            measures.add(measure);
        }
        return measures;
    }

    public void addNewMeasureBeforeEnd(TGTrack track, TGMeasureHeader header) {
        this.addNewMeasureAfter(track, header, this.getLastMeasure(track));
    }

    public void addNewMeasureAfter(TGTrack track, TGMeasureHeader header, TGMeasure measure) {
        TGMeasure newMeasure = this.getSongManager().getFactory().newMeasure(header);
        newMeasure.setClef(measure.getClef());
        newMeasure.setKeySignature(measure.getKeySignature());
        this.addMeasure(track, newMeasure);
    }

    public void addNewMeasure(TGTrack track, TGMeasureHeader header) {
        TGMeasure previous = this.getMeasure(track, header.getNumber() == 1 ? header.getNumber() + 1 : header.getNumber() - 1);
        TGMeasure newMeasure = this.getSongManager().getFactory().newMeasure(header);
        newMeasure.setTrack(track);
        newMeasure.setClef(previous.getClef());
        newMeasure.setKeySignature(previous.getKeySignature());
        this.addMeasure(track, header.getNumber() - 1, newMeasure);
    }

    public void addMeasure(TGTrack track, TGMeasure measure) {
        track.addMeasure(measure);
    }

    public void addMeasure(TGTrack track, int index, TGMeasure measure) {
        track.addMeasure(index, measure);
    }

    public void removeLastMeasure(TGTrack track) {
        this.removeMeasure(this.getLastMeasure(track));
    }

    public void removeMeasure(TGTrack track, long start) {
        this.removeMeasure(this.getMeasureAt(track, start));
    }

    public void removeMeasure(TGMeasure measure) {
        measure.getTrack().removeMeasure(measure.getNumber() - 1);
    }

    public void copyMeasureFrom(TGMeasure measure, TGMeasure from) {
        measure.copyFrom(this.getSongManager().getFactory(), from);
    }

    public TGMeasure replaceMeasure(TGTrack track, TGMeasure newMeasure) {
        TGMeasure tgMeasure = this.getMeasureAt(track, newMeasure.getStart());
        this.copyMeasureFrom(tgMeasure, newMeasure);
        return tgMeasure;
    }

    public void moveMeasure(TGMeasure measure, long theMove) {
        this.getSongManager().getMeasureManager().moveAllBeats(measure, theMove);
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGTrack track, long start) {
        for (TGMeasure measure : this.getMeasuresBeforeEnd(track, start)) {
            this.getSongManager().getMeasureManager().moveOutOfBoundsBeatsToNewMeasure(measure);
        }
    }

    public void moveTrackBeats(TGTrack track, long measureStart, long moveStart, long theMove) {
        TGMeasure measure;
        int i;
        List<TGMeasure> measures = this.getMeasuresBeforeEnd(track, measureStart);
        for (i = 0; i < measures.size(); ++i) {
            measure = measures.get(i);
            if (moveStart + theMove < moveStart) {
                this.getSongManager().getMeasureManager().removeBeatsBetween(measure, moveStart, moveStart + Math.abs(theMove));
            }
            this.getSongManager().getMeasureManager().moveBeats(measure, moveStart, theMove);
        }
        for (i = 0; i < measures.size(); ++i) {
            measure = measures.get(i);
            this.getSongManager().getMeasureManager().moveOutOfBoundsBeatsToNewMeasure(measure, false);
        }
    }

    public void changeKeySignature(TGTrack track, long start, int keySignature, boolean toEnd) {
        this.changeKeySignature(track, this.getMeasureAt(track, start), keySignature, toEnd);
    }

    public void changeKeySignature(TGTrack track, TGMeasure measure, int keySignature, boolean toEnd) {
        measure.setKeySignature(keySignature);
        if (toEnd) {
            List<TGMeasure> measures = this.getMeasuresBeforeEnd(track, measure.getStart() + 1L);
            for (TGMeasure nextMeasure : measures) {
                nextMeasure.setKeySignature(keySignature);
            }
        }
    }

    public void changeClef(TGTrack track, long start, int clef, boolean toEnd) {
        this.changeClef(track, this.getMeasureAt(track, start), clef, toEnd);
    }

    public void changeClef(TGTrack track, TGMeasure measure, int clef, boolean toEnd) {
        measure.setClef(clef);
        if (toEnd) {
            List<TGMeasure> measures = this.getMeasuresBeforeEnd(track, measure.getStart() + 1L);
            for (TGMeasure nextMeasure : measures) {
                nextMeasure.setClef(clef);
            }
        }
    }

    public void changeSolo(TGTrack track, boolean solo) {
        track.setSolo(solo);
        track.setMute(track.isSolo() ? false : track.isMute());
    }

    public void changeMute(TGTrack track, boolean mute) {
        track.setMute(mute);
        track.setSolo(track.isMute() ? false : track.isSolo());
    }

    public void changeInfo(TGTrack track, String name, TGColor color, int offset) {
        track.setName(name);
        track.setOffset(offset);
        track.getColor().copyFrom(color);
    }

    public void changeOffset(TGTrack track, int offset) {
        track.setOffset(offset);
    }

    public void changeStringCount(TGTrack track, int count) {
        if (track.stringCount() != count) {
            if (count < track.getStrings().size()) {
                this.removeNotesAfterString(track, count);
            }
            if (this.getSongManager().isPercussionChannel(track.getSong(), track.getChannelId())) {
                track.setStrings(this.getSongManager().createPercussionStrings(count));
            } else {
                track.setStrings(this.getSongManager().createDefaultInstrumentStrings(count));
            }
        }
    }

    public void changeInstrumentStrings(TGTrack track, List<TGString> strings) {
        if (strings.size() < track.getStrings().size()) {
            this.removeNotesAfterString(track, strings.size());
        }
        track.setStrings(strings);
    }

    public void removeNotesAfterString(TGTrack track, int string) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.getSongManager().getMeasureManager().removeNotesAfterString(measure, string);
        }
    }

    public void changeChannel(TGTrack track, int channelId) {
        this.changeChannel(track, this.getSongManager().getChannel(track.getSong(), channelId));
    }

    public void changeChannel(TGTrack track, TGChannel channel) {
        boolean newPercussion;
        TGChannel oldChannel = this.getSongManager().getChannel(track.getSong(), track.getChannelId());
        track.setChannelId(channel != null ? channel.getChannelId() : -1);
        boolean oldPercussion = oldChannel != null && oldChannel.isPercussionChannel();
        boolean bl = newPercussion = channel != null && channel.isPercussionChannel();
        if (oldPercussion != newPercussion) {
            if (newPercussion) {
                track.setStrings(this.getSongManager().createPercussionStrings(track.stringCount()));
            } else {
                track.setStrings(this.getSongManager().createDefaultInstrumentStrings(track.stringCount()));
            }
        }
    }

    public void autoCompleteSilences(TGTrack track) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().autoCompleteSilences(measure);
        }
    }

    public void orderBeats(TGTrack track) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().orderBeats(measure);
        }
    }

    public void transposeNotes(TGTrack track, int transposition, boolean tryKeepString, boolean applyToChords, int applyToString) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().transposeNotes(measure, transposition, tryKeepString, applyToChords, applyToString);
        }
    }

    public void transposeNotes(TGTrack track, int[] transpositionStrings, boolean tryKeepString, boolean applyToChords) {
        Iterator<TGMeasure> it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = it.next();
            this.songManager.getMeasureManager().transposeNotes(measure, transpositionStrings, tryKeepString, applyToChords);
        }
    }

    public boolean isFirstMeasure(TGMeasure measure) {
        return measure.getNumber() == 1;
    }

    public boolean isLastMeasure(TGMeasure measure) {
        return measure.getTrack().getSong().countMeasureHeaders() == measure.getNumber();
    }
}

