/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.synth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.synth.TGSynthEvent;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.song.models.TGTimeSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGSynthSequenceHandler
extends MidiSequenceHandler {
    private List<TGSynthEvent> events = new ArrayList<TGSynthEvent>();

    public TGSynthSequenceHandler(int tracks) {
        super(tracks);
    }

    public void addNoteOn(long tick, int track, int channelId, int key, int velocity, int voice, boolean bendMode) {
        this.events.add(TGSynthEvent.noteOn(tick, channelId, key, velocity, voice, bendMode));
    }

    public void addNoteOff(long tick, int track, int channelId, int key, int velocity, int voice, boolean bendMode) {
        this.events.add(TGSynthEvent.noteOff(tick, channelId, key, velocity, voice, bendMode));
    }

    public void addPitchBend(long tick, int track, int channelId, int value, int voice, boolean bendMode) {
        this.events.add(TGSynthEvent.pitchBend(tick, channelId, value, voice, bendMode));
    }

    public void addControlChange(long tick, int track, int channelId, int controller, int value) {
        this.events.add(TGSynthEvent.controlChange(tick, channelId, controller, value));
    }

    public void addProgramChange(long tick, int track, int channelId, int value) {
        this.events.add(TGSynthEvent.programChange(tick, channelId, value));
    }

    public void addTempoInUSQ(long tick, int track, int usq) {
        this.events.add(TGSynthEvent.tempoInUSQ(tick, usq));
    }

    public void addTimeSignature(long tick, int track, TGTimeSignature ts) {
    }

    public void notifyFinish() {
    }

    public List<TGSynthEvent> getEvents() {
        return this.events;
    }
}

