/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.LineUnavailableException;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;
import org.classpath.icedtea.pulseaudio.StreamSampleSpecification;

final class Stream {
    public static long STATE_UNCONNECTED = -1L;
    public static long STATE_CREATING = -1L;
    public static long STATE_READY = -1L;
    public static long STATE_FAILED = -1L;
    public static long STATE_TERMINATED = -1L;
    public static long FLAG_NOFLAGS = -1L;
    public static long FLAG_START_CORKED = -1L;
    public static long FLAG_INTERPOLATE_TIMING = -1L;
    public static long FLAG_NOT_MONOTONIC = -1L;
    public static long FLAG_AUTO_TIMING_UPDATE = -1L;
    public static long FLAG_NO_REMAP_CHANNELS = -1L;
    public static long FLAG_NO_REMIX_CHANNELS = -1L;
    public static long FLAG_FIX_FORMAT = -1L;
    public static long FLAG_FIX_RATE = -1L;
    public static long FLAG_FIX_CHANNELS = -1L;
    public static long FLAG_DONT_MOVE = -1L;
    public static long FLAG_VARIABLE_RATE = -1L;
    public static long FLAG_PEAK_DETECT = -1L;
    public static long FLAG_START_MUTED = -1L;
    public static long FLAG_ADJUST_LATENCY = -1L;
    public static long FLAG_EARLY_REQUESTS = -1L;
    public static long FLAG_DONT_INHIBIT_AUTO_SUSPEND = -1L;
    public static long FLAG_START_UNMUTED = -1L;
    public static long FLAG_FAIL_ON_SUSPEND = -1L;
    public static final String DEFAULT_DEVICE = null;
    private byte[] streamPointer;
    private byte[] contextPointer;
    private Format format;
    private float cachedVolume;
    private StreamBufferAttributes bufAttr = new StreamBufferAttributes(0, 0, 0, 0, 0);
    private static final Object bufAttrMutex;
    private List<StateListener> stateListeners = new LinkedList<StateListener>();
    private List<WriteListener> writeListeners = new LinkedList<WriteListener>();
    private List<ReadListener> readListeners = new LinkedList<ReadListener>();
    private List<OverflowListener> overflowListeners = new LinkedList<OverflowListener>();
    private List<UnderflowListener> underflowListeners = new LinkedList<UnderflowListener>();
    private List<PlaybackStartedListener> playbackStartedListeners = new LinkedList<PlaybackStartedListener>();
    private List<LatencyUpdateListener> latencyUpdateListeners = new LinkedList<LatencyUpdateListener>();
    private List<MovedListener> movedListeners = new LinkedList<MovedListener>();
    private List<SuspendedListener> suspendedListeners = new LinkedList<SuspendedListener>();
    private List<CorkListener> corkListeners = new LinkedList<CorkListener>();

    public static long checkNativeStreamState(long l) {
        if (!Arrays.asList(STATE_UNCONNECTED, STATE_CREATING, STATE_READY, STATE_FAILED, STATE_TERMINATED).contains(l)) {
            throw new IllegalStateException("Illegal constant for ContextEvent: " + l);
        }
        return l;
    }

    private static native void init_constants();

    private native void native_pa_stream_new(byte[] var1, String var2, String var3, int var4, int var5);

    private native void native_pa_stream_unref();

    private native long native_pa_stream_get_state();

    private native byte[] native_pa_stream_get_context();

    private native int native_pa_stream_get_index();

    private native int native_pa_stream_get_device_index();

    private native String native_pa_stream_get_device_name();

    private native int native_pa_stream_is_suspended();

    private native int native_pa_stream_connect_playback(String var1, int var2, int var3, int var4, int var5, int var6, long var7, byte[] var9, byte[] var10);

    private native int native_pa_stream_connect_record(String var1, int var2, int var3, int var4, int var5, int var6, long var7, byte[] var9, byte[] var10);

    private native int native_pa_stream_disconnect();

    private native int native_pa_stream_write(byte[] var1, int var2, int var3);

    private native byte[] native_pa_stream_peek();

    private native int native_pa_stream_drop();

    private native int native_pa_stream_writable_size();

    private native int native_pa_stream_readable_size();

    private native byte[] native_pa_stream_drain();

    private native byte[] native_pa_stream_updateTimingInfo();

    public native int bytesInBuffer();

    private native int native_pa_stream_is_corked();

    private native byte[] native_pa_stream_cork(int var1);

    private native byte[] native_pa_stream_flush();

    private native byte[] native_pa_stream_trigger();

    private native byte[] native_pa_stream_set_name(String var1);

    private native long native_pa_stream_get_time();

    private native long native_pa_stream_get_latency();

    private native StreamSampleSpecification native_pa_stream_get_sample_spec();

    private native StreamBufferAttributes native_pa_stream_get_buffer_attr();

    private native byte[] native_pa_stream_set_buffer_attr(StreamBufferAttributes var1);

    private native byte[] native_pa_stream_update_sample_rate(int var1);

    native byte[] native_set_volume(float var1);

    native byte[] native_update_volume();

    Stream(byte[] byArray, String string, Format format, int n, int n2) {
        this.format = format;
        StreamSampleSpecification streamSampleSpecification = new StreamSampleSpecification(format, n, n2);
        this.native_pa_stream_new(byArray, string, streamSampleSpecification.getFormat().toString(), streamSampleSpecification.getRate(), streamSampleSpecification.getChannels());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStateListener(StateListener stateListener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStateListener(StateListener stateListener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWriteListener(WriteListener writeListener) {
        List<WriteListener> list = this.writeListeners;
        synchronized (list) {
            this.writeListeners.add(writeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWriteListener(WriteListener writeListener) {
        List<WriteListener> list = this.writeListeners;
        synchronized (list) {
            this.writeListeners.remove(writeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReadListener(ReadListener readListener) {
        List<ReadListener> list = this.readListeners;
        synchronized (list) {
            this.readListeners.add(readListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReadListener(ReadListener readListener) {
        List<ReadListener> list = this.readListeners;
        synchronized (list) {
            this.readListeners.remove(readListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOverflowListener(OverflowListener overflowListener) {
        List<OverflowListener> list = this.overflowListeners;
        synchronized (list) {
            this.overflowListeners.add(overflowListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOverflowListener(OverflowListener overflowListener) {
        List<OverflowListener> list = this.overflowListeners;
        synchronized (list) {
            this.overflowListeners.remove(overflowListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnderflowListener(UnderflowListener underflowListener) {
        List<UnderflowListener> list = this.underflowListeners;
        synchronized (list) {
            this.underflowListeners.add(underflowListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUnderflowListener(UnderflowListener underflowListener) {
        List<UnderflowListener> list = this.underflowListeners;
        synchronized (list) {
            this.underflowListeners.remove(underflowListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCorkListener(CorkListener corkListener) {
        List<CorkListener> list = this.corkListeners;
        synchronized (list) {
            this.corkListeners.add(corkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCorkListener(CorkListener corkListener) {
        List<CorkListener> list = this.corkListeners;
        synchronized (list) {
            this.corkListeners.remove(corkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPlaybackStartedListener(PlaybackStartedListener playbackStartedListener) {
        List<PlaybackStartedListener> list = this.playbackStartedListeners;
        synchronized (list) {
            this.playbackStartedListeners.add(playbackStartedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePlaybackStartedListener(PlaybackStartedListener playbackStartedListener) {
        List<PlaybackStartedListener> list = this.playbackStartedListeners;
        synchronized (list) {
            this.playbackStartedListeners.remove(playbackStartedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLatencyUpdateListener(LatencyUpdateListener latencyUpdateListener) {
        List<LatencyUpdateListener> list = this.latencyUpdateListeners;
        synchronized (list) {
            this.latencyUpdateListeners.add(latencyUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLatencyUpdateListener(LatencyUpdateListener latencyUpdateListener) {
        List<PlaybackStartedListener> list = this.playbackStartedListeners;
        synchronized (list) {
            this.latencyUpdateListeners.remove(latencyUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMovedListener(MovedListener movedListener) {
        List<MovedListener> list = this.movedListeners;
        synchronized (list) {
            this.movedListeners.add(movedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMovedListener(MovedListener movedListener) {
        List<MovedListener> list = this.movedListeners;
        synchronized (list) {
            this.movedListeners.remove(movedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuspendedListener(SuspendedListener suspendedListener) {
        List<SuspendedListener> list = this.suspendedListeners;
        synchronized (list) {
            this.suspendedListeners.add(suspendedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSuspendedListener(SuspendedListener suspendedListener) {
        List<SuspendedListener> list = this.suspendedListeners;
        synchronized (list) {
            this.suspendedListeners.remove(suspendedListener);
        }
    }

    long getState() {
        return Stream.checkNativeStreamState(this.native_pa_stream_get_state());
    }

    byte[] getContextPointer() {
        return this.native_pa_stream_get_context();
    }

    int getSinkInputIndex() {
        return this.native_pa_stream_get_index();
    }

    int getDeviceIndex() {
        return this.native_pa_stream_get_device_index();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBufAttr() {
        Object object = bufAttrMutex;
        synchronized (object) {
            this.bufAttr = this.native_pa_stream_get_buffer_attr();
        }
    }

    private void bufferAttrCallback() {
        this.setBufAttr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBufferSize() {
        Object object = bufAttrMutex;
        synchronized (object) {
            return this.bufAttr.getMaxLength();
        }
    }

    String getDeviceName() {
        return this.native_pa_stream_get_device_name();
    }

    boolean isSuspended() {
        return this.native_pa_stream_is_suspended() != 0;
    }

    void connectForPlayback(String string, StreamBufferAttributes streamBufferAttributes, byte[] byArray) throws LineUnavailableException {
        int n = this.native_pa_stream_connect_playback(string, streamBufferAttributes.getMaxLength(), streamBufferAttributes.getTargetLength(), streamBufferAttributes.getPreBuffering(), streamBufferAttributes.getMinimumRequest(), streamBufferAttributes.getFragmentSize(), FLAG_START_CORKED, null, byArray);
        if (n < 0) {
            throw new LineUnavailableException("Unable To connect a line for playback");
        }
    }

    void connectForRecording(String string, long l, StreamBufferAttributes streamBufferAttributes) throws LineUnavailableException {
        int n = this.native_pa_stream_connect_record(string, streamBufferAttributes.getMaxLength(), streamBufferAttributes.getTargetLength(), streamBufferAttributes.getPreBuffering(), streamBufferAttributes.getMinimumRequest(), streamBufferAttributes.getFragmentSize(), l, null, null);
        if (n < 0) {
            throw new LineUnavailableException("Unable to connect line for recording");
        }
    }

    void disconnect() {
        int n = this.native_pa_stream_disconnect();
        assert (n == 0);
    }

    int write(byte[] byArray, int n, int n2) {
        return this.native_pa_stream_write(byArray, n, n2);
    }

    byte[] peek() {
        return this.native_pa_stream_peek();
    }

    void drop() {
        this.native_pa_stream_drop();
    }

    int getWritableSize() {
        return this.native_pa_stream_writable_size();
    }

    int getReableSize() {
        return this.native_pa_stream_readable_size();
    }

    Operation drain() {
        Operation operation = new Operation(this.native_pa_stream_drain());
        return operation;
    }

    Operation updateTimingInfo() {
        Operation operation = new Operation(this.native_pa_stream_updateTimingInfo());
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateCallback() {
        List<StateListener> list = EventLoop.getEventLoop().threadLock;
        synchronized (list) {
            if (this.getState() == STATE_READY) {
                this.setBufAttr();
            }
        }
        list = this.stateListeners;
        synchronized (list) {
            for (StateListener stateListener : this.stateListeners) {
                stateListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCallback() {
        List<WriteListener> list = this.writeListeners;
        synchronized (list) {
            for (WriteListener writeListener : this.writeListeners) {
                writeListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCallback() {
        List<ReadListener> list = this.readListeners;
        synchronized (list) {
            for (ReadListener readListener : this.readListeners) {
                readListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overflowCallback() {
        System.out.println("overflowCallback called");
        List<OverflowListener> list = this.overflowListeners;
        synchronized (list) {
            for (OverflowListener overflowListener : this.overflowListeners) {
                overflowListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void underflowCallback() {
        List<UnderflowListener> list = this.underflowListeners;
        synchronized (list) {
            for (UnderflowListener underflowListener : this.underflowListeners) {
                underflowListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playbackStartedCallback() {
        List<PlaybackStartedListener> list = this.playbackStartedListeners;
        synchronized (list) {
            for (PlaybackStartedListener playbackStartedListener : this.playbackStartedListeners) {
                playbackStartedListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void latencyUpdateCallback() {
        List<LatencyUpdateListener> list = this.latencyUpdateListeners;
        synchronized (list) {
            for (LatencyUpdateListener latencyUpdateListener : this.latencyUpdateListeners) {
                latencyUpdateListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movedCallback() {
        List<MovedListener> list = this.movedListeners;
        synchronized (list) {
            for (MovedListener movedListener : this.movedListeners) {
                movedListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corkCallback() {
        List<CorkListener> list = this.corkListeners;
        synchronized (list) {
            for (CorkListener corkListener : this.corkListeners) {
                corkListener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendedCallback() {
        List<SuspendedListener> list = this.suspendedListeners;
        synchronized (list) {
            for (SuspendedListener suspendedListener : this.suspendedListeners) {
                suspendedListener.update();
            }
        }
    }

    boolean isCorked() {
        int n = this.native_pa_stream_is_corked();
        if (n < 0) {
            throw new IllegalStateException("Unable to determine state");
        }
        return n != 0;
    }

    Operation cork(boolean bl) {
        int n = bl ? 1 : 0;
        Operation operation = new Operation(this.native_pa_stream_cork(n));
        return operation;
    }

    Operation cork() {
        return this.cork(true);
    }

    Operation unCork() {
        return this.cork(false);
    }

    Operation flush() {
        Operation operation = new Operation(this.native_pa_stream_flush());
        return operation;
    }

    Operation triggerStart() {
        Operation operation = new Operation(this.native_pa_stream_trigger());
        return operation;
    }

    Operation setName(String string) {
        Operation operation = new Operation(this.native_pa_stream_set_name(string));
        return operation;
    }

    long getTime() {
        return this.native_pa_stream_get_time();
    }

    long getLatency() {
        return this.native_pa_stream_get_latency();
    }

    Format getFormat() {
        return this.format;
    }

    StreamBufferAttributes getBufferAttributes() {
        return this.native_pa_stream_get_buffer_attr();
    }

    Operation setBufferAtrributes(StreamBufferAttributes streamBufferAttributes) {
        return new Operation(this.native_pa_stream_set_buffer_attr(streamBufferAttributes));
    }

    Operation updateSampleRate(int n) {
        return new Operation(this.native_pa_stream_update_sample_rate(n));
    }

    byte[] getStreamPointer() {
        return this.streamPointer;
    }

    void free() {
        this.native_pa_stream_unref();
    }

    float getCachedVolume() {
        return this.cachedVolume;
    }

    void setCachedVolume(float f) {
        this.cachedVolume = f;
    }

    void update_channels_and_volume(int n, float f) {
        this.cachedVolume = f;
    }

    static {
        SecurityWrapper.loadNativeLibrary();
        Stream.init_constants();
        bufAttrMutex = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        PA_SAMPLE_U8,
        PA_SAMPLE_ULAW,
        PA_SAMPLE_ALAW,
        PA_SAMPLE_S16LE,
        PA_SAMPLE_S16BE,
        PA_SAMPLE_FLOAT32LE,
        PA_SAMPLE_FLOAT32BE,
        PA_SAMPLE_S32LE,
        PA_SAMPLE_S32BE;

    }

    public static interface SuspendedListener {
        public void update();
    }

    public static interface UpdateTimingInfoListener {
        public void update();
    }

    public static interface MovedListener {
        public void update();
    }

    public static interface LatencyUpdateListener {
        public void update();
    }

    public static interface PlaybackStartedListener {
        public void update();
    }

    public static interface UnderflowListener {
        public void update();
    }

    public static interface OverflowListener {
        public void update();
    }

    public static interface ReadListener {
        public void update();
    }

    public static interface WriteListener {
        public void update();
    }

    public static interface CorkListener {
        public void update();
    }

    public static interface StateListener {
        public void update();
    }
}

