/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import javax.sound.sampled.FloatControl;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;

final class PulseAudioVolumeControl
extends FloatControl {
    static final int MAX_VOLUME = 65536;
    static final int MIN_VOLUME = 0;
    private EventLoop eventLoop;
    private PulseAudioPlaybackLine line;

    protected PulseAudioVolumeControl(PulseAudioPlaybackLine pulseAudioPlaybackLine, EventLoop eventLoop) {
        super(FloatControl.Type.VOLUME, 0.0f, 65536.0f, 1.0f, -1, pulseAudioPlaybackLine.getCachedVolume(), "pulseaudio units", "Volume Off", "Default Volume", "Full Volume");
        this.line = pulseAudioPlaybackLine;
        this.eventLoop = eventLoop;
    }

    public synchronized void setValue(float f) {
        if (f > 65536.0f || f < 0.0f) {
            throw new IllegalArgumentException("invalid value");
        }
        if (!this.line.isOpen()) {
            return;
        }
        this.setStreamVolume(f);
        this.line.setCachedVolume(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setStreamVolume(float f) {
        Operation operation;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = new Operation(this.line.native_set_volume(f));
        }
        operation.waitForCompletion();
        operation.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float getValue() {
        Operation operation;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = new Operation(this.line.native_update_volume());
        }
        operation.waitForCompletion();
        operation.releaseReference();
        return this.line.getCachedVolume();
    }
}

