/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.Stream;

abstract class PulseAudioDataLine
extends PulseAudioLine
implements DataLine {
    protected static final int DEFAULT_BUFFER_SIZE = 50000;
    protected String streamName;
    protected boolean isStarted = false;
    protected boolean dataWritten = false;
    protected AudioFormat[] supportedFormats = null;
    protected AudioFormat currentFormat = null;
    protected AudioFormat defaultFormat = null;
    protected boolean sendEvents = true;
    protected long framesSinceOpen = 0L;
    protected EventLoop eventLoop = null;
    protected Semaphore semaphore = new Semaphore(0);
    protected Stream stream;
    boolean writeInterrupted = false;

    PulseAudioDataLine() {
    }

    protected void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (this.isOpen()) {
            throw new IllegalStateException("Line is already open");
        }
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        if (!pulseAudioMixer.isOpen()) {
            pulseAudioMixer.open();
        }
        this.eventLoop = EventLoop.getEventLoop();
        this.createStream(audioFormat);
        this.addStreamListeners();
        this.connect(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStream(AudioFormat audioFormat) throws LineUnavailableException {
        for (AudioFormat audioFormat2 : this.supportedFormats) {
            if (!audioFormat.matches(audioFormat2)) continue;
            float f = audioFormat.getSampleRate();
            if (f == -1.0f) {
                f = 44100.0f;
            }
            String string = (String)audioFormat2.getProperty("PulseAudioFormatKey");
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.stream = new Stream(this.eventLoop.getContextPointer(), this.streamName, Stream.Format.valueOf(string), (int)f, audioFormat2.getChannels());
            }
            this.currentFormat = audioFormat;
            this.isOpen = true;
        }
        if (!this.isOpen()) {
            throw new IllegalArgumentException("Invalid format");
        }
    }

    private void addStreamListeners() {
        Stream.StateListener stateListener = new Stream.StateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                Object object = PulseAudioDataLine.this.eventLoop.threadLock;
                synchronized (object) {
                    if (PulseAudioDataLine.this.stream.getState() == Stream.STATE_READY) {
                        if (PulseAudioDataLine.this.sendEvents) {
                            PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.OPEN, PulseAudioDataLine.this.framesSinceOpen));
                        }
                        PulseAudioDataLine.this.semaphore.release();
                    } else if (PulseAudioDataLine.this.stream.getState() == Stream.STATE_TERMINATED || PulseAudioDataLine.this.stream.getState() == Stream.STATE_FAILED) {
                        if (PulseAudioDataLine.this.sendEvents) {
                            PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.CLOSE, PulseAudioDataLine.this.framesSinceOpen));
                        }
                        PulseAudioDataLine.this.semaphore.release();
                    }
                }
            }
        };
        this.stream.addStateListener(stateListener);
        Stream.UnderflowListener underflowListener = new Stream.UnderflowListener(){

            public void update() {
                PulseAudioDataLine.this.dataWritten = false;
                PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.STOP, PulseAudioDataLine.this.framesSinceOpen));
            }
        };
        this.stream.addUnderflowListener(underflowListener);
        Stream.PlaybackStartedListener playbackStartedListener = new Stream.PlaybackStartedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                if (!PulseAudioDataLine.this.dataWritten) {
                    PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.START, PulseAudioDataLine.this.framesSinceOpen));
                    PulseAudioDataLine pulseAudioDataLine = PulseAudioDataLine.this;
                    synchronized (pulseAudioDataLine) {
                        PulseAudioDataLine.this.notifyAll();
                    }
                }
                PulseAudioDataLine.this.dataWritten = true;
            }
        };
        this.stream.addPlaybackStartedListener(playbackStartedListener);
        Stream.WriteListener writeListener = new Stream.WriteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                Object object = PulseAudioDataLine.this.eventLoop.threadLock;
                synchronized (object) {
                    PulseAudioDataLine.this.eventLoop.threadLock.notifyAll();
                }
            }
        };
        this.stream.addWriteListener(writeListener);
        Stream.CorkListener corkListener = new Stream.CorkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                Object object = PulseAudioDataLine.this.eventLoop.threadLock;
                synchronized (object) {
                    PulseAudioDataLine.this.eventLoop.threadLock.notifyAll();
                }
            }
        };
        this.stream.addCorkListener(corkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Stream stream, int n) throws LineUnavailableException {
        Object object;
        try {
            object = this.eventLoop.threadLock;
            synchronized (object) {
                this.connectLine(n, stream);
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.stream.free();
            this.stream = null;
            throw lineUnavailableException;
        }
        try {
            this.semaphore.acquire();
            object = this.eventLoop.threadLock;
            synchronized (object) {
                if (this.stream.getState() != Stream.STATE_READY) {
                    this.stream.disconnect();
                    this.stream.free();
                    throw new LineUnavailableException("unable to obtain a line");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new LineUnavailableException("unable to prepare stream");
        }
    }

    protected void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, 50000);
    }

    public void open() throws LineUnavailableException {
        assert (this.defaultFormat != null);
        this.open(this.defaultFormat, 50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.disconnect();
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("unable to prepare stream");
        }
        object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.free();
        }
        super.close();
        this.isStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnectforSynchronization(Stream stream) throws LineUnavailableException {
        this.sendEvents = false;
        this.drain();
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.disconnect();
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("unable to prepare stream");
        }
        this.createStream(this.getFormat());
        this.addStreamListeners();
        this.connect(stream, this.getBufferSize());
        this.sendEvents = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Operation operation;
        if (!this.isOpen()) {
            throw new IllegalStateException("Line must be open()ed before it can be start()ed");
        }
        if (this.isStarted) {
            return;
        }
        if (this.dataWritten && !this.isStarted) {
            this.fireLineEvent(new LineEvent(this, LineEvent.Type.START, this.framesSinceOpen));
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.unCork();
        }
        operation.waitForCompletion();
        operation.releaseReference();
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        this.isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Operation operation;
        if (!this.isOpen()) {
            return;
        }
        this.writeInterrupted = true;
        if (!this.isStarted) {
            return;
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.cork();
            if (this.dataWritten && this.isStarted) {
                this.fireLineEvent(new LineEvent(this, LineEvent.Type.STOP, this.framesSinceOpen));
            }
        }
        operation.waitForCompletion();
        operation.releaseReference();
        this.isStarted = false;
    }

    public boolean isActive() {
        return this.isStarted;
    }

    public boolean isRunning() {
        return this.isStarted && this.dataWritten;
    }

    protected abstract void connectLine(int var1, Stream var2) throws LineUnavailableException;

    public Stream getStream() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Line must be open");
        }
        return this.stream;
    }

    public int getBufferSize() {
        if (!this.isOpen()) {
            return 50000;
        }
        return this.stream.getBufferSize();
    }

    public AudioFormat getFormat() {
        if (!this.isOpen()) {
            return this.defaultFormat;
        }
        return this.currentFormat;
    }

    public float getLevel() {
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        if (this.isOpen()) {
            Operation operation;
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                operation = this.stream.setName(string);
            }
            operation.waitForCompletion();
            operation.releaseReference();
        }
        this.streamName = string;
    }

    public String getName() {
        return this.streamName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesInBuffer() {
        Operation operation;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.updateTimingInfo();
        }
        operation.waitForCompletion();
        operation.releaseReference();
        return this.stream.bytesInBuffer();
    }
}

