/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;
import org.classpath.icedtea.pulseaudio.PulseAudioVolumeControl;
import org.classpath.icedtea.pulseaudio.Stream;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;

public final class PulseAudioClip
extends PulseAudioDataLine
implements Clip,
PulseAudioPlaybackLine {
    private byte[] data = null;
    private int currentFrame = 0;
    private int frameCount = 0;
    private int startFrame = 0;
    private int endFrame = 0;
    public static final String DEFAULT_CLIP_NAME = "Audio Clip";
    private Object clipLock = new Object();
    private int loopsLeft = 0;
    private ClipThread clipThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFrames(int n, int n2) {
        Stream.WriteListener writeListener = new Stream.WriteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                Object object = PulseAudioClip.this.eventLoop.threadLock;
                synchronized (object) {
                    PulseAudioClip.this.eventLoop.threadLock.notifyAll();
                }
            }
        };
        this.stream.addWriteListener(writeListener);
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioClip$ClipThread.writeFrames(): Writing");
        int n3 = n2 - n - 1;
        while (n3 > 0) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                int n4;
                do {
                    if ((n4 = this.stream.getWritableSize()) < 0) {
                        Thread.currentThread().interrupt();
                        this.stream.removeWriteListener(writeListener);
                        return;
                    }
                    if (n4 != 0) continue;
                    try {
                        this.eventLoop.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        this.stream.removeWriteListener(writeListener);
                        return;
                    }
                } while (n4 == 0);
                int n5 = Math.min(n3, n4 / this.getFormat().getFrameSize());
                this.stream.write(this.data, this.currentFrame * this.getFormat().getFrameSize(), n5 * this.getFormat().getFrameSize());
                n3 -= n5;
                this.currentFrame += n5;
                this.framesSinceOpen += (long)n5;
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.stream.removeWriteListener(writeListener);
    }

    PulseAudioClip(AudioFormat[] audioFormatArray, AudioFormat audioFormat) {
        this.supportedFormats = audioFormatArray;
        this.defaultFormat = audioFormat;
        this.currentFormat = audioFormat;
        this.streamName = DEFAULT_CLIP_NAME;
        this.clipThread = new ClipThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectLine(int n, Stream stream) throws LineUnavailableException {
        StreamBufferAttributes streamBufferAttributes = new StreamBufferAttributes(n, n / 4, n / 8, n / 10 > 100 ? n / 10 : 100, 0);
        if (stream != null) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, streamBufferAttributes, stream.getStreamPointer());
            }
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, streamBufferAttributes, null);
        }
    }

    public int available() {
        return 0;
    }

    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("line already closed");
        }
        this.clipThread.interrupt();
        try {
            this.clipThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.currentFrame = 0;
        this.framesSinceOpen = 0L;
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        pulseAudioMixer.removeSourceLine(this);
        super.close();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioClip.close(): Clip closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        Operation operation;
        if (!this.isOpen) {
            throw new IllegalStateException("line not open");
        }
        while (this.clipThread != null && this.clipThread.isAlive()) {
            try {
                this.clipThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.drain();
        }
        operation.waitForCompletion();
        operation.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Operation operation;
        if (!this.isOpen) {
            throw new IllegalStateException("line not open");
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.flush();
            operation.waitForCompletion();
        }
        operation.releaseReference();
    }

    public int getFrameLength() {
        if (!this.isOpen) {
            return -1;
        }
        return this.frameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFramePosition() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        Object object = this.clipLock;
        synchronized (object) {
            return (int)this.framesSinceOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongFramePosition() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        Object object = this.clipLock;
        synchronized (object) {
            return this.framesSinceOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondLength() {
        if (!this.isOpen) {
            return -1L;
        }
        Object object = this.clipLock;
        synchronized (object) {
            return (long)((float)this.frameCount / this.currentFormat.getFrameRate() * 1000000.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondPosition() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        Object object = this.clipLock;
        synchronized (object) {
            return (long)((float)this.framesSinceOpen / this.currentFormat.getFrameRate() * 1000000.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(int n) {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (n < 0 && n != -1) {
            throw new IllegalArgumentException("invalid value for count:" + n);
        }
        if (this.clipThread.isAlive() && n != 0) {
            return;
        }
        super.start();
        Object object = this.clipLock;
        synchronized (object) {
            this.loopsLeft = this.currentFrame > this.endFrame ? 0 : n;
        }
        if (!this.clipThread.isAlive()) {
            this.clipThread = new ClipThread();
            this.clipThread.start();
        }
    }

    public void open() throws LineUnavailableException {
        throw new IllegalArgumentException("open() on a Clip is not allowed");
    }

    public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        super.open(audioFormat);
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
        this.frameCount = n2 / audioFormat.getFrameSize();
        this.currentFrame = 0;
        this.framesSinceOpen = 0L;
        this.startFrame = 0;
        this.endFrame = this.frameCount - 1;
        this.loopsLeft = 0;
        PulseAudioVolumeControl pulseAudioVolumeControl = new PulseAudioVolumeControl(this, this.eventLoop);
        this.controls.add(pulseAudioVolumeControl);
        PulseAudioMixer pulseAudioMixer = PulseAudioMixer.getInstance();
        pulseAudioMixer.addSourceLine(this);
        this.isOpen = true;
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioClip.open(): Clip opened");
    }

    public byte[] native_set_volume(float f) {
        return this.stream.native_set_volume(f);
    }

    public byte[] native_update_volume() {
        return this.stream.native_update_volume();
    }

    public float getCachedVolume() {
        return this.stream.getCachedVolume();
    }

    public void setCachedVolume(float f) {
        this.stream.setCachedVolume(f);
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        byte[] byArray = new byte[(int)(audioInputStream.getFrameLength() * (long)audioInputStream.getFormat().getFrameSize())];
        audioInputStream.read(byArray, 0, byArray.length);
        this.open(audioInputStream.getFormat(), byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFramePosition(int n) {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (n < 0 || n > this.frameCount) {
            throw new IllegalArgumentException("incorreft frame value");
        }
        Object object = this.clipLock;
        synchronized (object) {
            this.currentFrame = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopPoints(int n, int n2) {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (n2 == -1) {
            n2 = this.frameCount - 1;
        }
        if (n2 < n) {
            throw new IllegalArgumentException("ending point must be greater than or equal to the starting point");
        }
        if (n < 0) {
            throw new IllegalArgumentException("starting point must be greater than or equal to 0");
        }
        Object object = this.clipLock;
        synchronized (object) {
            this.startFrame = n;
            this.endFrame = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicrosecondPosition(long l) {
        float f;
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        for (f = (float)l * this.currentFormat.getFrameRate() / 1000000.0f; f < 0.0f; f += (float)this.frameCount) {
        }
        f %= (float)this.frameCount;
        Object object = this.clipLock;
        synchronized (object) {
            this.currentFrame = (int)f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isStarted) {
            return;
        }
        super.start();
        if (!this.clipThread.isAlive()) {
            Object object = this.clipLock;
            synchronized (object) {
                this.loopsLeft = 0;
            }
            this.clipThread = new ClipThread();
            this.clipThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (!this.isStarted) {
            return;
        }
        if (this.clipThread.isAlive()) {
            this.clipThread.interrupt();
        }
        try {
            this.clipThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Object object = this.clipLock;
        synchronized (object) {
            this.loopsLeft = 0;
        }
        super.stop();
    }

    public Line.Info getLineInfo() {
        return new DataLine.Info(Clip.class, this.supportedFormats, 0, 1000000);
    }

    private final class ClipThread
    extends Thread {
        private ClipThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            while (true) {
                PulseAudioClip.this.writeFrames(PulseAudioClip.this.currentFrame, PulseAudioClip.this.endFrame + 1);
                if (Thread.interrupted()) break;
                if (PulseAudioClip.this.loopsLeft == 0) {
                    PulseAudioClip.this.writeFrames(PulseAudioClip.this.endFrame, PulseAudioClip.this.getFrameLength());
                    break;
                }
                object = PulseAudioClip.this.clipLock;
                synchronized (object) {
                    PulseAudioClip.this.currentFrame = PulseAudioClip.this.startFrame;
                    if (PulseAudioClip.this.loopsLeft != Integer.MIN_VALUE) {
                        PulseAudioClip.this.loopsLeft--;
                    }
                }
            }
            Object object2 = PulseAudioClip.this.eventLoop.threadLock;
            synchronized (object2) {
                object = PulseAudioClip.this.stream.drain();
            }
            ((Operation)object).waitForCompletion();
            ((Operation)object).releaseReference();
        }
    }
}

