/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.ArrayList;
import java.util.List;
import org.classpath.icedtea.pulseaudio.ContextEvent;
import org.classpath.icedtea.pulseaudio.ContextListener;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventLoop
implements Runnable {
    final Object threadLock = new Object();
    private static EventLoop instance = null;
    private List<ContextListener> contextListeners;
    private String appName;
    private String serverString;
    private long status;
    private List<String> targetPortNameList = new ArrayList<String>();
    private List<String> sourcePortNameList = new ArrayList<String>();
    private byte[] contextPointer;
    private byte[] mainloopPointer;

    private native void native_setup(String var1, String var2);

    private native int native_iterate(int var1);

    private native void native_shutdown();

    private EventLoop() {
        this.contextListeners = new ArrayList<ContextListener>();
    }

    static synchronized EventLoop getEventLoop() {
        if (instance == null) {
            instance = new EventLoop();
        }
        return instance;
    }

    void setAppName(String string) {
        this.appName = string;
    }

    void setServer(String string) {
        this.serverString = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.native_setup(this.appName, this.serverString);
        Debug.println(Debug.DebugLevel.Info, "Eventloop.run(): eventloop starting");
        while (true) {
            Object object = this.threadLock;
            synchronized (object) {
                this.native_iterate(100);
                if (Thread.interrupted()) {
                    this.native_shutdown();
                    List<ContextListener> list = this.contextListeners;
                    synchronized (list) {
                        this.contextListeners.clear();
                    }
                    Debug.println(Debug.DebugLevel.Info, "EventLoop.run(): event loop terminated");
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContextListener(ContextListener contextListener) {
        List<ContextListener> list = this.contextListeners;
        synchronized (list) {
            this.contextListeners.add(contextListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextListener(ContextListener contextListener) {
        List<ContextListener> list = this.contextListeners;
        synchronized (list) {
            this.contextListeners.remove(contextListener);
        }
    }

    long getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(long l) {
        Object object = this.threadLock;
        synchronized (object) {
            this.status = l;
            this.fireEvent(new ContextEvent(l));
        }
        if (l == ContextEvent.FAILED) {
            Debug.println(Debug.DebugLevel.Warning, "EventLoop.update(): Context failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ContextEvent contextEvent) {
        List<ContextListener> list = this.contextListeners;
        synchronized (list) {
            for (ContextListener contextListener : this.contextListeners) {
                contextListener.update(contextEvent);
            }
        }
    }

    byte[] getContextPointer() {
        return this.contextPointer;
    }

    byte[] getMainLoopPointer() {
        return this.mainloopPointer;
    }

    private native byte[] nativeUpdateTargetPortNameList();

    private native byte[] nativeUpdateSourcePortNameList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<String> updateTargetPortNameList() {
        Operation operation;
        this.targetPortNameList = new ArrayList<String>();
        Object object = this.threadLock;
        synchronized (object) {
            operation = new Operation(this.nativeUpdateTargetPortNameList());
        }
        operation.waitForCompletion();
        assert (operation.getState() == Operation.DONE);
        operation.releaseReference();
        return this.targetPortNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<String> updateSourcePortNameList() {
        Operation operation;
        this.sourcePortNameList = new ArrayList<String>();
        Object object = this.threadLock;
        synchronized (object) {
            operation = new Operation(this.nativeUpdateSourcePortNameList());
        }
        operation.waitForCompletion();
        assert (operation.getState() == Operation.DONE);
        operation.releaseReference();
        return this.sourcePortNameList;
    }

    public void source_callback(String string) {
        this.sourcePortNameList.add(string);
    }

    public void sink_callback(String string) {
        this.targetPortNameList.add(string);
    }

    static {
        SecurityWrapper.loadNativeLibrary();
    }
}

