/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMChannelRouterConfigurator {
    private GMChannelRouter router;

    public GMChannelRouterConfigurator(GMChannelRouter router) {
        this.router = router;
    }

    public void configureRouter(Iterator<TGChannel> iterator) {
        ArrayList<TGChannel> channels = new ArrayList<TGChannel>();
        while (iterator.hasNext()) {
            channels.add(iterator.next());
        }
        this.configureRouter(channels);
    }

    public void configureRouter(List<TGChannel> channels) {
        List<GMChannelRoute> routes = this.findCurrentRoutes(channels);
        this.router.resetRoutes();
        for (TGChannel channel : channels) {
            this.router.configureRoutes(this.findOrCreateCurrentRoute(routes, channel), channel.isPercussionChannel());
        }
        for (TGChannel channel : channels) {
            int channel1 = this.getIntegerChannelParameter(channel, "gm-channel-1", -1);
            int channel2 = this.getIntegerChannelParameter(channel, "gm-channel-2", -1);
            if (channel1 < 0) continue;
            GMChannelRoute route = this.router.getRoute(channel.getChannelId());
            if (route == null) {
                route = new GMChannelRoute(channel.getChannelId());
            }
            route.setChannel1(channel1);
            route.setChannel2(channel2);
            this.router.configureRoutes(route, channel.isPercussionChannel());
        }
    }

    private List<GMChannelRoute> findCurrentRoutes(List<TGChannel> channels) {
        ArrayList<GMChannelRoute> routes = new ArrayList<GMChannelRoute>();
        for (TGChannel channel : channels) {
            GMChannelRoute route = this.router.getRoute(channel.getChannelId());
            if (route == null) continue;
            routes.add(route);
        }
        return routes;
    }

    private GMChannelRoute findCurrentRoute(List<GMChannelRoute> routes, TGChannel channel) {
        for (GMChannelRoute route : routes) {
            if (route.getChannelId() != channel.getChannelId()) continue;
            return route;
        }
        return null;
    }

    private GMChannelRoute findOrCreateCurrentRoute(List<GMChannelRoute> routes, TGChannel channel) {
        GMChannelRoute cmChannelRoute = this.findCurrentRoute(routes, channel);
        if (cmChannelRoute == null) {
            cmChannelRoute = new GMChannelRoute(channel.getChannelId());
        }
        return cmChannelRoute;
    }

    private int getIntegerChannelParameter(TGChannel tgChannel, String key, int nullValue) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter != null && tgChannelParameter.getValue() != null) {
            return Integer.parseInt(tgChannelParameter.getValue());
        }
        return nullValue;
    }

    private TGChannelParameter findChannelParameter(TGChannel tgChannel, String key) {
        Iterator it = tgChannel.getParameters();
        while (it.hasNext()) {
            TGChannelParameter parameter = (TGChannelParameter)it.next();
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        return null;
    }
}

