
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IDHCPGroupConfig.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
A configuration that applies to a group of NICs.

Interface ID: <tt>{537707F7-EBF9-4D5C-7AEA-877BFC4256BA}</tt>
*/
public class IDHCPGroupConfig extends IDHCPConfig
{

    public IDHCPGroupConfig(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
The group name.
@return String
*/
    public String getName()
    {
        try
        {
            String retVal = port.idhcpGroupConfigGetName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The group name.
@param value String

*/
    public void setName(String value)
    {
        try
        {
        port.idhcpGroupConfigSetName(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Group membership conditions.

Add new conditions by calling{@link org.virtualbox_6_1.IDHCPGroupConfig#addCondition(Boolean,org.virtualbox_6_1.DHCPGroupConditionType,String)}and use{@link org.virtualbox_6_1.IDHCPGroupCondition#remove()}to remove.
@return List&lt;org.virtualbox_6_1.IDHCPGroupCondition&gt;
*/
    public List<org.virtualbox_6_1.IDHCPGroupCondition> getConditions()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            List<String> retVal = port.idhcpGroupConfigGetConditions(obj);
            return Helper.wrap(org.virtualbox_6_1.IDHCPGroupCondition.class, getObjMgr(), port, retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }
    public static IDHCPGroupConfig queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IDHCPGroupConfig(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Adds a new condition.
*/
    public org.virtualbox_6_1.IDHCPGroupCondition addCondition(Boolean inclusive, org.virtualbox_6_1.DHCPGroupConditionType type, String value)
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal;
        retVal = port.idhcpGroupConfigAddCondition(obj, inclusive, org.virtualbox_6_1.jaxws.DHCPGroupConditionType.fromValue(type.name()), value);
           return (retVal.length() > 0) ? new org.virtualbox_6_1.IDHCPGroupCondition(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Removes all conditions.
*/
    public void removeAllConditions()
    {
        try
        {
        port.idhcpGroupConfigRemoveAllConditions(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
