
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * DHCPGroupConditionType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
public enum DHCPGroupConditionType
{

/**
MAC address
*/
    MAC(0),

/**
MAC address wildcard pattern.
*/
    MACWildcard(1),

/**
Vendor class ID
*/
    vendorClassID(2),

/**
Vendor class ID wildcard pattern.
*/
    vendorClassIDWildcard(3),

/**
User class ID
*/
    userClassID(4),

/**
User class ID wildcard pattern.
*/
    userClassIDWildcard(5);

    private final int value;

    DHCPGroupConditionType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static DHCPGroupConditionType fromValue(long v)
    {
        for (DHCPGroupConditionType c: DHCPGroupConditionType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static DHCPGroupConditionType fromValue(String v)
    {
        return valueOf(DHCPGroupConditionType.class, v);
    }
}

