
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * GuestSessionStatus.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
Guest session status. This enumeration represents possible values of
the{@link org.virtualbox_6_1.IGuestSession#getStatus()}attribute.
Interface ID: <tt>{AC2669DA-4624-44F2-85B5-0B0BFB8D8673}</tt>
*/
public enum GuestSessionStatus
{

/**
Guest session is in an undefined state.
*/
    Undefined(0),

/**
Guest session is being started.
*/
    Starting(10),

/**
Guest session has been started.
*/
    Started(100),

/**
Guest session is being terminated.
*/
    Terminating(480),

/**
Guest session terminated normally.
*/
    Terminated(500),

/**
Guest session timed out and was killed.
*/
    TimedOutKilled(512),

/**
Guest session timed out and was not killed successfully.
*/
    TimedOutAbnormally(513),

/**
Service/OS is stopping, guest session was killed.
*/
    Down(600),

/**
Something went wrong.
*/
    Error(800);

    private final int value;

    GuestSessionStatus(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static GuestSessionStatus fromValue(long v)
    {
        for (GuestSessionStatus c: GuestSessionStatus.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static GuestSessionStatus fromValue(String v)
    {
        return valueOf(GuestSessionStatus.class, v);
    }
}

