
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * DHCPOptionEncoding.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
public enum DHCPOptionEncoding
{

/**
Value format is specific to the option and generally user friendly.
*/
    Normal(0),

/**
Value format is a series of hex bytes (09314f3200fe), optionally colons
as byte separators (9:31:4f:32::fe).
*/
    Hex(1);

    private final int value;

    DHCPOptionEncoding(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static DHCPOptionEncoding fromValue(long v)
    {
        for (DHCPOptionEncoding c: DHCPOptionEncoding.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static DHCPOptionEncoding fromValue(String v)
    {
        return valueOf(DHCPOptionEncoding.class, v);
    }
}

