/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Stack;

public class XMLWriter
extends FilterWriter {
    private Stack<String> elements = new Stack();
    private boolean emptyElement;
    private boolean elementWithText;

    public XMLWriter(OutputStream outputStream) throws IOException {
        super(new OutputStreamWriter(outputStream, "UTF-8"));
        this.out.write("<?xml version='1.0'?>\n");
    }

    public void writeStartElement(String string) throws IOException {
        if (this.elements.size() > 0) {
            if (this.emptyElement) {
                this.out.write(">");
            }
            this.writeIndentation();
        }
        this.out.write("<" + string);
        this.elements.push(string);
        this.emptyElement = true;
        this.elementWithText = false;
    }

    public void writeEndElement() throws IOException {
        String string = this.elements.pop();
        if (this.emptyElement) {
            this.out.write("/>");
        } else {
            if (!this.elementWithText) {
                this.writeIndentation();
            }
            this.out.write("</" + string + ">");
        }
        this.emptyElement = false;
        this.elementWithText = false;
    }

    private void writeIndentation() throws IOException {
        this.out.write("\n");
        for (int i = 0; i < this.elements.size(); ++i) {
            this.out.write("  ");
        }
    }

    public void writeAttribute(String string, String string2) throws IOException {
        this.out.write(" " + string + "='" + XMLWriter.replaceByEntities(string2) + "'");
    }

    public void writeAttribute(String string, String string2, String string3) throws IOException {
        if (!(string2 == null && string2 == string3 || string2.equals(string3))) {
            this.writeAttribute(string, string2);
        }
    }

    public void writeIntegerAttribute(String string, int n) throws IOException {
        this.writeAttribute(string, String.valueOf(n));
    }

    public void writeIntegerAttribute(String string, int n, int n2) throws IOException {
        if (n != n2) {
            this.writeAttribute(string, String.valueOf(n));
        }
    }

    public void writeLongAttribute(String string, long l) throws IOException {
        this.writeAttribute(string, String.valueOf(l));
    }

    public void writeLongAttribute(String string, Long l) throws IOException {
        if (l != null) {
            this.writeAttribute(string, l.toString());
        }
    }

    public void writeFloatAttribute(String string, float f) throws IOException {
        this.writeAttribute(string, String.valueOf(f));
    }

    public void writeFloatAttribute(String string, float f, float f2) throws IOException {
        if (f != f2) {
            this.writeFloatAttribute(string, f);
        }
    }

    public void writeFloatAttribute(String string, Float f) throws IOException {
        if (f != null) {
            this.writeAttribute(string, f.toString());
        }
    }

    public void writeBigDecimalAttribute(String string, BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            this.writeAttribute(string, String.valueOf(bigDecimal));
        }
    }

    public void writeBooleanAttribute(String string, boolean bl, boolean bl2) throws IOException {
        if (bl != bl2) {
            this.writeAttribute(string, String.valueOf(bl));
        }
    }

    public void writeColorAttribute(String string, Integer n) throws IOException {
        if (n != null) {
            this.writeAttribute(string, String.format("%08X", n));
        }
    }

    public void writeText(String string) throws IOException {
        if (this.emptyElement) {
            this.out.write(">");
            this.emptyElement = false;
            this.elementWithText = true;
        }
        this.out.write(XMLWriter.replaceByEntities(string));
    }

    private static String replaceByEntities(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace("'", "&apos;").replace("\"", "&quot;").replace("\n", "&#10;");
    }

    public void write(int n) throws IOException {
        this.writeText(String.valueOf((char)n));
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writeText(new String(cArray, n, n2));
    }

    public void write(String string, int n, int n2) throws IOException {
        this.writeText(string.substring(n, n + n2));
    }
}

