/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.viewcontroller;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.ImportFurnitureTaskView;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactoryAdapter;
import java.util.concurrent.Callable;

public class ImportFurnitureController
implements Controller {
    private ThreadedTaskController threadedTaskController;

    public ImportFurnitureController(final FurnitureLibrary furnitureLibrary, final String[] stringArray, final Runnable runnable, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, final EditorViewFactory editorViewFactory, final ContentManager contentManager) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException {
                ImportFurnitureTaskView importFurnitureTaskView = (ImportFurnitureTaskView)ImportFurnitureController.this.threadedTaskController.getView();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    try {
                        importFurnitureTaskView.setProgress(i, 0, stringArray.length);
                        final CatalogPieceOfFurniture catalogPieceOfFurniture = importFurnitureTaskView.readPieceOfFurniture(contentManager.getContent(string));
                        if (catalogPieceOfFurniture == null) continue;
                        importFurnitureTaskView.invokeLater(new Runnable(){

                            public void run() {
                                furnitureLibrary.addPieceOfFurniture(catalogPieceOfFurniture);
                            }
                        });
                        continue;
                    }
                    catch (RecorderException recorderException) {
                        // empty catch block
                    }
                }
                importFurnitureTaskView.invokeLater(runnable);
                return null;
            }
        };
        ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

            public void handleException(Exception exception) {
                if (!(exception instanceof InterruptedException)) {
                    exception.printStackTrace();
                }
            }
        };
        ViewFactoryAdapter viewFactoryAdapter = new ViewFactoryAdapter(){

            public ThreadedTaskView createThreadedTaskView(String string, UserPreferences userPreferences, ThreadedTaskController threadedTaskController) {
                return editorViewFactory.createImportFurnitureView(string, (FurnitureLibraryUserPreferences)userPreferences, threadedTaskController);
            }
        };
        String string = furnitureLibraryUserPreferences.getLocalizedString(ImportFurnitureController.class, "importFurnitureMessage", new Object[0]);
        this.threadedTaskController = new ThreadedTaskController(callable, string, exceptionHandler, furnitureLibraryUserPreferences, viewFactoryAdapter);
    }

    public void executeTask(View view) {
        this.threadedTaskController.executeTask(view);
    }

    public View getView() {
        return this.threadedTaskController.getView();
    }
}

