/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.ImportFurnitureTaskView;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.OBJWriter;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.ThreadedTaskPanel;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.vecmath.Vector3f;

public class ImportFurnitureTaskPanel
extends ThreadedTaskPanel
implements ImportFurnitureTaskView {
    private static final int PREVIEW_PREFERRED_SIZE = 128;
    private final FurnitureLibraryUserPreferences preferences;
    private ModelPreviewComponent iconPreviewComponent;
    private boolean firstRendering = true;

    public ImportFurnitureTaskPanel(String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, ThreadedTaskController threadedTaskController) {
        super(string, furnitureLibraryUserPreferences, threadedTaskController);
        this.preferences = furnitureLibraryUserPreferences;
        this.iconPreviewComponent = new ModelPreviewComponent();
        Insets insets = this.iconPreviewComponent.getInsets();
        this.iconPreviewComponent.setPreferredSize(new Dimension(128 + insets.left + insets.right, 128 + insets.top + insets.bottom));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(this.getComponent(0), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 16, 0, new Insets(0, 0, 10, 0), 0, 0));
        gridBagLayout.setConstraints(this.getComponent(1), new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.iconPreviewComponent, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogPieceOfFurniture readPieceOfFurniture(Content content) throws InterruptedException {
        try {
            Object object;
            String string;
            Object object2;
            URLContent uRLContent;
            Object object3 = "model";
            final AtomicReference<BranchGroup> atomicReference = new AtomicReference<BranchGroup>();
            try {
                atomicReference.set(ModelManager.getInstance().loadModel(content));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URLContent uRLContent2 = null;
            if (atomicReference.get() != null) {
                if (content instanceof URLContent && ((String)(object3 = URLDecoder.decode(((URLContent)content).getURL().getFile().replace("+", "%2B"), "UTF-8"))).lastIndexOf(47) != -1) {
                    object3 = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
                }
                uRLContent2 = ImportFurnitureTaskPanel.copyToTemporaryOBJContent((BranchGroup)atomicReference.get(), content);
                int n = ((String)object3).lastIndexOf(46);
                if (n != -1) {
                    object3 = ((String)object3).substring(0, n);
                }
                ModelManager.getInstance().loadModel(content, true, new ModelManager.ModelObserver(){

                    public void modelUpdated(BranchGroup branchGroup) {
                    }

                    public void modelError(Exception exception) {
                    }
                });
            } else {
                ZipInputStream zipInputStream = null;
                try {
                    uRLContent = TemporaryURLContent.copyToTemporaryURLContent(content);
                    zipInputStream = new ZipInputStream(uRLContent.openStream());
                    while ((object2 = zipInputStream.getNextEntry()) != null) {
                        int n;
                        string = ((ZipEntry)object2).getName();
                        if (string.endsWith("/") || ((String)(object = string.substring((n = string.lastIndexOf(47)) + 1))).startsWith(".")) continue;
                        int n2 = ((String)object).lastIndexOf(".");
                        object3 = n2 != -1 ? ((String)object).substring(0, n2) : object;
                        URL uRL = new URL("jar:" + uRLContent.getURL() + "!/" + URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%2F", "/"));
                        TemporaryURLContent temporaryURLContent = new TemporaryURLContent(uRL);
                        ModelManager.getInstance().loadModel(temporaryURLContent, true, new ModelManager.ModelObserver(){

                            public void modelUpdated(BranchGroup branchGroup) {
                                atomicReference.set(branchGroup);
                            }

                            public void modelError(Exception exception) {
                            }
                        });
                        if (atomicReference.get() == null) continue;
                        uRLContent2 = new TemporaryURLContent(uRL);
                        if (!((String)object).toLowerCase().endsWith(".obj") && (this.preferences.isModelContentAlwaysConvertedToOBJFormat() || n > 0)) {
                            uRLContent2 = ImportFurnitureTaskPanel.copyToTemporaryOBJContent((BranchGroup)atomicReference.get(), content);
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = null;
                    return catalogPieceOfFurniture;
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (atomicReference.get() == null) {
                return null;
            }
            Vector3f vector3f = ModelManager.getInstance().getSize((Node)atomicReference.get());
            uRLContent = uRLContent2;
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ImportFurnitureTaskPanel.this.iconPreviewComponent.setModel(uRLContent);
                }
            });
            Thread.sleep(this.firstRendering ? 1000L : 100L);
            this.firstRendering = false;
            object2 = new AtomicReference();
            EventQueue.invokeAndWait(new Runnable((AtomicReference)object2){
                final /* synthetic */ AtomicReference val$iconContent;
                {
                    this.val$iconContent = atomicReference;
                }

                public void run() {
                    try {
                        this.val$iconContent.set(ImportFurnitureTaskPanel.this.iconPreviewComponent.getIcon(100));
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Couldn't retrieve icon", iOException);
                    }
                }
            });
            if (Arrays.asList(this.preferences.getEditedProperties()).contains("ID")) {
                string = this.preferences.getDefaultCreator();
                if (string == null) {
                    string = System.getProperty("user.name");
                }
                string = string + "#" + (String)object3;
            } else {
                string = null;
            }
            CatalogPieceOfFurniture catalogPieceOfFurniture = new CatalogPieceOfFurniture(string, this.getPieceOfFurnitureName((String)object3), null, null, new String[0], null, null, (Content)((AtomicReference)object2).get(), null, uRLContent2, vector3f.x, vector3f.z, vector3f.y, 0.0f, 1.0f, true, null, null, false, uRLContent2.getSize(), this.preferences.getDefaultCreator(), true, true, true, true, null, null, null);
            object = new FurnitureCategory(this.preferences.getLocalizedString(ImportFurnitureTaskPanel.class, "defaultCategory", new Object[0]));
            new FurnitureCatalog().add((FurnitureCategory)object, catalogPieceOfFurniture);
            return catalogPieceOfFurniture;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    protected String getPieceOfFurnitureName(String string) {
        String string2 = "" + Character.toUpperCase(string.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-' || c == '_') {
                string2 = string2 + ' ';
                continue;
            }
            if (Character.isDigit(c) && i >= string.length() - 1) continue;
            if ((Character.isUpperCase(c) || Character.isDigit(c)) && Character.isLowerCase(string.charAt(i - 1))) {
                string2 = string2 + ' ';
                c = Character.toLowerCase(c);
            }
            string2 = string2 + c;
        }
        return string2;
    }

    static URLContent copyToTemporaryOBJContent(BranchGroup branchGroup, Content content) throws IOException {
        String string;
        if (content instanceof URLContent) {
            string = ((URLContent)content).getURL().getFile();
            if (string.lastIndexOf(47) != -1) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            if (!(string = new File(string).getName()).toLowerCase().endsWith(".obj")) {
                if (string.lastIndexOf(46) != -1) {
                    string = string.substring(0, string.lastIndexOf(46));
                }
                string = string + ".obj";
            }
            if ((string = URLDecoder.decode(string.replace("+", "%2B"), "UTF-8")).matches(".*[^a-zA-Z0-9_\\.\\-\\ ].*")) {
                string = "model.obj";
            }
        } else {
            string = "model.obj";
        }
        File file = File.createTempFile("urlContent", "tmp");
        file.deleteOnExit();
        OBJWriter.writeNodeInZIPFile((Node)branchGroup, file, 0, string, "3D model " + string);
        return new TemporaryURLContent(new URL("jar:" + file.toURI().toURL() + "!/" + URLEncoder.encode(string, "UTF-8").replace("+", "%20")));
    }
}

