/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLibraryController;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.CatalogItemToolTip;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureLibraryTable
extends JTable
implements View {
    private ListSelectionListener tableSelectionListener;
    private CatalogItemToolTip toolTip;

    public FurnitureLibraryTable(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLibraryController furnitureLibraryController, FurnitureLanguageController furnitureLanguageController) {
        super(new FurnitureLibraryTableModel(furnitureLibrary, furnitureLanguageController), new FurnitureLibraryTableColumnModel(furnitureLibrary, furnitureLibraryUserPreferences, furnitureLanguageController));
        this.toolTip = new CatalogItemToolTip(CatalogItemToolTip.DisplayedInformation.ICON, (UserPreferences)furnitureLibraryUserPreferences);
        this.addTableHeaderListener();
        this.setAutoResizeMode(0);
        this.updateTableColumnsWidth();
        if (furnitureLibraryController != null) {
            this.addSelectionListeners(furnitureLibraryController);
            this.addMouseListener(furnitureLibraryController);
            this.addFurnitureLanguageListener(furnitureLibrary, furnitureLanguageController);
            this.setTransferHandler(new TableTransferHandler(furnitureLibraryController));
        }
        this.addUserPreferencesListener(furnitureLibraryUserPreferences);
    }

    private void addUserPreferencesListener(UserPreferences userPreferences) {
        userPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, new UserPreferencesChangeListener(this));
    }

    private void addSelectionListeners(final FurnitureLibraryController furnitureLibraryController) {
        final SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureLibraryTable.this.setSelectedFurniture(furnitureLibraryController.getSelectedFurniture());
            }
        };
        this.tableSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    furnitureLibraryController.removeSelectionListener(selectionListener);
                    int[] nArray = FurnitureLibraryTable.this.getSelectedRows();
                    ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>(nArray.length);
                    TableModel tableModel = FurnitureLibraryTable.this.getModel();
                    for (int n : nArray) {
                        arrayList.add((CatalogPieceOfFurniture)tableModel.getValueAt(n, 0));
                    }
                    furnitureLibraryController.setSelectedFurniture(arrayList);
                    furnitureLibraryController.addSelectionListener(selectionListener);
                }
            }
        };
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        furnitureLibraryController.addSelectionListener(selectionListener);
    }

    private void addMouseListener(final FurnitureLibraryController furnitureLibraryController) {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    furnitureLibraryController.modifySelectedFurniture();
                }
            }
        });
    }

    private void addTableHeaderListener() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)FurnitureLibraryTable.this.getModel();
                ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
                for (int n : FurnitureLibraryTable.this.getSelectedRows()) {
                    arrayList.add((CatalogPieceOfFurniture)furnitureLibraryTableModel.getValueAt(n, 0));
                }
                int n = FurnitureLibraryTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                Object object = FurnitureLibraryTable.this.getColumnModel().getColumn(n).getIdentifier();
                if (object instanceof String) {
                    String string = (String)object;
                    if (object.equals(furnitureLibraryTableModel.getSortProperty())) {
                        if (furnitureLibraryTableModel.isDescendingOrder()) {
                            furnitureLibraryTableModel.setSortProperty(null);
                        } else {
                            furnitureLibraryTableModel.setDescendingOrder(true);
                        }
                    } else if (furnitureLibraryTableModel.getFurnitureComparator(string) != null) {
                        furnitureLibraryTableModel.setSortProperty(string);
                        furnitureLibraryTableModel.setDescendingOrder(false);
                    }
                }
                FurnitureLibraryTable.this.getTableHeader().repaint();
                FurnitureLibraryTable.this.setSelectedFurniture(arrayList);
            }
        });
    }

    private void setSelectedFurniture(List<CatalogPieceOfFurniture> list) {
        this.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        this.clearSelection();
        FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)this.getModel();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
            int n3;
            if (!(catalogPieceOfFurniture instanceof CatalogPieceOfFurniture) || (n3 = furnitureLibraryTableModel.getPieceOfFurnitureIndex(catalogPieceOfFurniture)) == -1) continue;
            this.addRowSelectionInterval(n3, n3);
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        if (n != Integer.MIN_VALUE) {
            this.makeRowsVisible(n, n2);
        }
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    private void makeRowsVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (n != n2) {
            rectangle = rectangle.union(this.getCellRect(n2, 0, true));
        }
        if (this.getAutoResizeMode() == 0) {
            int n3 = this.getColumnCount() - 1;
            rectangle = rectangle.union(this.getCellRect(n, n3, true));
            if (n != n2) {
                rectangle = rectangle.union(this.getCellRect(n2, n3, true));
            }
        }
        this.scrollRectToVisible(rectangle);
    }

    private void addFurnitureLanguageListener(FurnitureLibrary furnitureLibrary, FurnitureLanguageController furnitureLanguageController) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
            private boolean sorting = false;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!this.sorting) {
                    this.sorting = true;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)FurnitureLibraryTable.this.getModel();
                            ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
                            for (int n : FurnitureLibraryTable.this.getSelectedRows()) {
                                arrayList.add((CatalogPieceOfFurniture)furnitureLibraryTableModel.getValueAt(n, 0));
                            }
                            furnitureLibraryTableModel.sortFurniture();
                            FurnitureLibraryTable.this.setSelectedFurniture(arrayList);
                            sorting = false;
                        }
                    });
                }
            }
        };
        furnitureLanguageController.addPropertyChangeListener(FurnitureLanguageController.Property.FURNITURE_LANGUAGE, propertyChangeListener);
        furnitureLibrary.addPropertyChangeListener(FurnitureLibrary.Property.LOCALIZED_DATA, propertyChangeListener);
    }

    private void updateTableColumnsWidth() {
        int n = this.getIntercellSpacing().width;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableModel tableModel = this.getModel();
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = this.convertColumnIndexToModel(i);
            int n4 = tableColumn.getPreferredWidth();
            n4 = Math.max(n4, tableColumn.getHeaderRenderer().getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width);
            int n5 = tableModel.getRowCount();
            for (int j = 0; j < n5; ++j) {
                n4 = Math.max(n4, tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)this, (Object)tableModel.getValueAt((int)j, (int)n3), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width);
            }
            tableColumn.setPreferredWidth(n4 + n);
            tableColumn.setWidth(n4 + n);
        }
    }

    @Override
    public JToolTip createToolTip() {
        if (this.toolTip.isTipTextComplete()) {
            return super.createToolTip();
        }
        this.toolTip.setComponent(this);
        return this.toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n2 != -1 && "ICON".equals(this.getColumnModel().getColumn(n2).getIdentifier()) && (n = this.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.toolTip.setCatalogItem((CatalogPieceOfFurniture)this.getModel().getValueAt(n, 0));
            return this.toolTip.getTipText();
        }
        return null;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getPreferredSize().width, 400);
    }

    private class TableTransferHandler
    extends TransferHandler {
        private final FurnitureLibraryController furnitureController;

        public TableTransferHandler(FurnitureLibraryController furnitureLibraryController) {
            this.furnitureController = furnitureLibraryController;
        }

        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return this.furnitureController != null && Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    final ArrayList<String> arrayList = new ArrayList<String>();
                    for (File file : list) {
                        if (file.isDirectory()) continue;
                        String string = file.getAbsolutePath();
                        arrayList.add(string);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            TableTransferHandler.this.furnitureController.importFurniture(arrayList.toArray(new String[arrayList.size()]));
                        }
                    });
                    return !arrayList.isEmpty();
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    throw new RuntimeException("Can't import", unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Can't access to data", iOException);
                }
            }
            return false;
        }
    }

    private static class FurnitureLibraryTableColumnModel
    extends DefaultTableColumnModel {
        public FurnitureLibraryTableColumnModel(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController) {
            this.createColumns(furnitureLibrary, furnitureLibraryUserPreferences, furnitureLanguageController);
            this.addLanguageListener(furnitureLibraryUserPreferences);
        }

        private void createColumns(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController) {
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer();
            for (String string : furnitureLibraryUserPreferences.getEditedProperties()) {
                if ("MODEL_ROTATION".equals(string) || "MODEL".equals(string) || "DOOR_OR_WINDOW_CUT_OUT_SHAPE".equals(string)) continue;
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier(string);
                tableColumn.setHeaderValue(this.getColumnName(string, furnitureLibraryUserPreferences));
                tableColumn.setPreferredWidth(this.getColumnPreferredWidth(string));
                tableColumn.setCellRenderer(this.getColumnRenderer(string, furnitureLibrary, furnitureLibraryUserPreferences, furnitureLanguageController));
                tableColumn.setHeaderRenderer(tableCellRenderer);
                this.addColumn(tableColumn);
            }
        }

        private void addLanguageListener(UserPreferences userPreferences) {
            userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
        }

        private String getColumnName(String string, UserPreferences userPreferences) {
            if ("ID".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "idColumn", new Object[0]);
            }
            if ("NAME".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "nameColumn", new Object[0]);
            }
            if ("DESCRIPTION".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "descriptionColumn", new Object[0]);
            }
            if ("CREATOR".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "creatorColumn", new Object[0]);
            }
            if ("INFORMATION".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "informationColumn", new Object[0]);
            }
            if ("TAGS".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "tagsColumn", new Object[0]);
            }
            if ("CREATION_DATE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "creationDateColumn", new Object[0]);
            }
            if ("GRADE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "gradeColumn", new Object[0]);
            }
            if ("CATEGORY".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "categoryColumn", new Object[0]);
            }
            if ("PRICE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "priceColumn", new Object[0]);
            }
            if ("VALUE_ADDED_TAX_PERCENTAGE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "valueAddedTaxPercentageColumn", new Object[0]);
            }
            if ("ICON".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "iconColumn", new Object[0]);
            }
            if ("PLAN_ICON".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "planIconColumn", new Object[0]);
            }
            if ("MODEL".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "modelColumn", new Object[0]);
            }
            if ("WIDTH".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "widthColumn", new Object[0]);
            }
            if ("DEPTH".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "depthColumn", new Object[0]);
            }
            if ("HEIGHT".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "heightColumn", new Object[0]);
            }
            if ("MOVABLE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "movableColumn", new Object[0]);
            }
            if ("DOOR_OR_WINDOW".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "doorOrWindowColumn", new Object[0]);
            }
            if ("STAIRCASE_CUT_OUT_SHAPE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "staircaseColumn", new Object[0]);
            }
            if ("ELEVATION".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "elevationColumn", new Object[0]);
            }
            if ("MODEL_ROTATION".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "modelRotationColumn", new Object[0]);
            }
            if ("RESIZABLE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "resizableColumn", new Object[0]);
            }
            if ("DEFORMABLE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "deformableColumn", new Object[0]);
            }
            if ("TEXTURABLE".equals(string)) {
                return userPreferences.getLocalizedString(FurnitureLibraryTable.class, "texturableColumn", new Object[0]);
            }
            throw new IllegalArgumentException("Unknown key " + string);
        }

        private int getColumnPreferredWidth(String string) {
            if ("ID".equals(string)) {
                return 120;
            }
            if ("NAME".equals(string)) {
                return 100;
            }
            if ("DESCRIPTION".equals(string) || "INFORMATION".equals(string) || "TAGS".equals(string)) {
                return 150;
            }
            if ("CREATION_DATE".equals(string) || "GRADE".equals(string)) {
                return 50;
            }
            if ("CREATOR".equals(string)) {
                return 100;
            }
            if ("CATEGORY".equals(string)) {
                return 70;
            }
            if ("PRICE".equals(string)) {
                return 70;
            }
            if ("VALUE_ADDED_TAX_PERCENTAGE".equals(string)) {
                return 50;
            }
            if ("ICON".equals(string) || "PLAN_ICON".equals(string)) {
                return 50;
            }
            if ("MODEL".equals(string)) {
                return 70;
            }
            if ("WIDTH".equals(string) || "DEPTH".equals(string) || "HEIGHT".equals(string) || "ELEVATION".equals(string)) {
                return 45;
            }
            if ("MOVABLE".equals(string) || "DOOR_OR_WINDOW".equals(string) || "STAIRCASE_CUT_OUT_SHAPE".equals(string) || "RESIZABLE".equals(string) || "DEFORMABLE".equals(string) || "TEXTURABLE".equals(string)) {
                return 20;
            }
            if ("MODEL_ROTATION".equals(string)) {
                return 70;
            }
            throw new IllegalArgumentException("Unknown key " + string);
        }

        private TableCellRenderer getColumnRenderer(String string, FurnitureLibrary furnitureLibrary, UserPreferences userPreferences, FurnitureLanguageController furnitureLanguageController) {
            if ("ID".equals(string) || "NAME".equals(string) || "DESCRIPTION".equals(string) || "INFORMATION".equals(string) || "TAGS".equals(string) || "CATEGORY".equals(string) || "CREATOR".equals(string)) {
                return this.getStringRenderer(string, furnitureLibrary, furnitureLanguageController);
            }
            if ("ICON".equals(string) || "PLAN_ICON".equals(string)) {
                return this.getIconRenderer(string);
            }
            if ("CREATION_DATE".equals(string)) {
                return this.getCreationDateRenderer();
            }
            if ("GRADE".equals(string)) {
                return this.getGradeRenderer();
            }
            if ("MODEL".equals(string)) {
                return this.getButtonRenderer(string, userPreferences);
            }
            if ("PRICE".equals(string)) {
                return this.getPriceRenderer(userPreferences);
            }
            if ("VALUE_ADDED_TAX_PERCENTAGE".equals(string)) {
                return this.getValueAddedTaxPercentageRenderer();
            }
            if ("WIDTH".equals(string) || "DEPTH".equals(string) || "HEIGHT".equals(string) || "ELEVATION".equals(string)) {
                return this.getSizeRenderer(string, userPreferences);
            }
            if ("MOVABLE".equals(string) || "DOOR_OR_WINDOW".equals(string) || "STAIRCASE_CUT_OUT_SHAPE".equals(string) || "RESIZABLE".equals(string) || "DEFORMABLE".equals(string) || "TEXTURABLE".equals(string)) {
                return this.getBooleanRenderer(string);
            }
            if ("MODEL_ROTATION".equals(string)) {
                return this.getButtonRenderer(string, userPreferences);
            }
            throw new IllegalArgumentException("Unknown key " + string);
        }

        private TableCellRenderer getStringRenderer(final String string, final FurnitureLibrary furnitureLibrary, final FurnitureLanguageController furnitureLanguageController) {
            if ("ID".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).getId(), bl, bl2, n, n2);
                    }
                };
            }
            if ("NAME".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                        String string2 = (String)furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), string, catalogPieceOfFurniture.getName());
                        return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                    }
                };
            }
            if ("DESCRIPTION".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                        String string2 = (String)furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), string, catalogPieceOfFurniture.getDescription());
                        return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                    }
                };
            }
            if ("INFORMATION".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                        String string2 = (String)furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), string, catalogPieceOfFurniture.getInformation());
                        return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                    }
                };
            }
            if ("TAGS".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                        Object[] objectArray = (String[])furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), string, catalogPieceOfFurniture.getTags());
                        String string2 = Arrays.toString(objectArray);
                        return super.getTableCellRendererComponent(jTable, string2.substring(1, string2.length() - 1), bl, bl2, n, n2);
                    }
                };
            }
            if ("CATEGORY".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                        String string2 = (String)furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), string, catalogPieceOfFurniture.getCategory().getName());
                        return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                    }
                };
            }
            if ("CREATOR".equals(string)) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).getCreator(), bl, bl2, n, n2);
                    }
                };
            }
            throw new IllegalArgumentException(string + " column not a string column");
        }

        private TableCellRenderer getButtonRenderer(String string, final UserPreferences userPreferences) {
            if ("MODEL".equals(string) || "MODEL_ROTATION".equals(string)) {
                return new TableCellRenderer(){
                    private JButton component = new JButton();

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        this.component.setText(userPreferences.getLocalizedString(FurnitureLibraryTable.class, "modifyButton", new Object[0]));
                        return this.component;
                    }
                };
            }
            throw new IllegalArgumentException(string + " column not a button column");
        }

        private TableCellRenderer getIconRenderer(final String string) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
                    Content content = "ICON".equals(string) ? catalogPieceOfFurniture.getIcon() : catalogPieceOfFurniture.getPlanIcon();
                    if (content != null) {
                        jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight(), jTable));
                        jLabel.setHorizontalAlignment(0);
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getCreationDateRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    object = (object = ((CatalogPieceOfFurniture)object).getCreationDate()) != null ? DateFormat.getDateInstance(3).format(object) : "";
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getGradeRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    object = (object = ((CatalogPieceOfFurniture)object).getGrade()) != null ? DecimalFormat.getPercentInstance().format(object) : "";
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getSizeRenderer(String string, final UserPreferences userPreferences) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SizeRenderer
            extends DefaultTableCellRenderer {
                final /* synthetic */ UserPreferences val$preferences;

                SizeRenderer() {
                    this.val$preferences = userPreferences;
                }

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    object = this.val$preferences.getLengthUnit().getFormat().format((Float)object);
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            }
            if ("WIDTH".equals(string)) {
                return new SizeRenderer(){
                    {
                        super(FurnitureLibraryTableColumnModel.this, userPreferences2);
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, Float.valueOf(((CatalogPieceOfFurniture)object).getWidth()), bl, bl2, n, n2);
                    }
                };
            }
            if ("DEPTH".equals(string)) {
                return new SizeRenderer(){
                    {
                        super(FurnitureLibraryTableColumnModel.this, userPreferences2);
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, Float.valueOf(((CatalogPieceOfFurniture)object).getDepth()), bl, bl2, n, n2);
                    }
                };
            }
            if ("HEIGHT".equals(string)) {
                return new SizeRenderer(){
                    {
                        super(FurnitureLibraryTableColumnModel.this, userPreferences2);
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, Float.valueOf(((CatalogPieceOfFurniture)object).getHeight()), bl, bl2, n, n2);
                    }
                };
            }
            if ("ELEVATION".equals(string)) {
                return new SizeRenderer(){
                    {
                        super(FurnitureLibraryTableColumnModel.this, userPreferences2);
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, Float.valueOf(((CatalogPieceOfFurniture)object).getElevation()), bl, bl2, n, n2);
                    }
                };
            }
            throw new IllegalArgumentException(string + " column not a size column");
        }

        private TableCellRenderer getPriceRenderer(final UserPreferences userPreferences) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if ((object = ((CatalogPieceOfFurniture)object).getPrice()) != null) {
                        NumberFormat numberFormat;
                        String string = userPreferences.getCurrency();
                        if (string != null) {
                            numberFormat = DecimalFormat.getCurrencyInstance();
                            numberFormat.setCurrency(Currency.getInstance(string));
                        } else {
                            numberFormat = new DecimalFormat("##0.00");
                        }
                        object = numberFormat.format(object);
                    } else {
                        object = "";
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getValueAddedTaxPercentageRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    BigDecimal bigDecimal = ((CatalogPieceOfFurniture)object).getValueAddedTaxPercentage();
                    if (bigDecimal != null) {
                        NumberFormat numberFormat = DecimalFormat.getPercentInstance();
                        numberFormat.setMinimumFractionDigits(bigDecimal.scale() - 2);
                        object = numberFormat.format(bigDecimal);
                    } else {
                        object = "";
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getBooleanRenderer(String string) {
            class BooleanRenderer
            implements TableCellRenderer {
                private TableCellRenderer booleanRenderer;

                BooleanRenderer() {
                }

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.booleanRenderer == null) {
                        this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                    }
                    return this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            }
            if ("MOVABLE".equals(string)) {
                return new BooleanRenderer(){
                    {
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).isMovable(), bl, bl2, n, n2);
                    }
                };
            }
            if ("DOOR_OR_WINDOW".equals(string)) {
                return new BooleanRenderer(){
                    {
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).isDoorOrWindow(), bl, bl2, n, n2);
                    }
                };
            }
            if ("STAIRCASE_CUT_OUT_SHAPE".equals(string)) {
                return new BooleanRenderer(){
                    {
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).getStaircaseCutOutShape() != null, bl, bl2, n, n2);
                    }
                };
            }
            if ("RESIZABLE".equals(string)) {
                return new BooleanRenderer(){
                    {
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).isResizable(), bl, bl2, n, n2);
                    }
                };
            }
            if ("DEFORMABLE".equals(string)) {
                return new BooleanRenderer(){
                    {
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).isDeformable(), bl, bl2, n, n2);
                    }
                };
            }
            if ("TEXTURABLE".equals(string)) {
                return new BooleanRenderer(){
                    {
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        return super.getTableCellRendererComponent(jTable, ((CatalogPieceOfFurniture)object).isTexturable(), bl, bl2, n, n2);
                    }
                };
            }
            throw new IllegalArgumentException(string + " column not a boolean column");
        }

        private TableCellRenderer getHeaderRenderer() {
            return new TableCellRenderer(){
                private TableCellRenderer headerRenderer;
                private ImageIcon ascendingSortIcon = new ImageIcon(this.getClass().getResource("resources/ascending.png"));
                private ImageIcon descendingSortIcon = new ImageIcon(this.getClass().getResource("resources/descending.png"));

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.headerRenderer == null) {
                        this.headerRenderer = jTable.getTableHeader().getDefaultRenderer();
                    }
                    JLabel jLabel = (JLabel)this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)jTable.getModel();
                    if (FurnitureLibraryTableColumnModel.this.getColumn(n2).getIdentifier().equals(furnitureLibraryTableModel.getSortProperty())) {
                        jLabel.setHorizontalTextPosition(10);
                        if (furnitureLibraryTableModel.isDescendingOrder()) {
                            jLabel.setIcon(this.descendingSortIcon);
                        } else {
                            jLabel.setIcon(this.ascendingSortIcon);
                        }
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private static class LanguageChangeListener
        implements PropertyChangeListener {
            private WeakReference<FurnitureLibraryTableColumnModel> furnitureTableColumnModel;

            public LanguageChangeListener(FurnitureLibraryTableColumnModel furnitureLibraryTableColumnModel) {
                this.furnitureTableColumnModel = new WeakReference<FurnitureLibraryTableColumnModel>(furnitureLibraryTableColumnModel);
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureLibraryTableColumnModel furnitureLibraryTableColumnModel = (FurnitureLibraryTableColumnModel)this.furnitureTableColumnModel.get();
                UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
                if (furnitureLibraryTableColumnModel == null) {
                    userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
                } else {
                    for (int i = 0; i < furnitureLibraryTableColumnModel.getColumnCount(); ++i) {
                        TableColumn tableColumn = furnitureLibraryTableColumnModel.getColumn(i);
                        Object object = tableColumn.getIdentifier();
                        if (!(object instanceof String)) continue;
                        try {
                            tableColumn.setHeaderValue(furnitureLibraryTableColumnModel.getColumnName((String)object, userPreferences));
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureLibraryTableModel
    extends AbstractTableModel {
        private final FurnitureLibrary furnitureLibrary;
        private final FurnitureLanguageController controller;
        private List<CatalogPieceOfFurniture> sortedFurniture;
        private String sortProperty;
        private boolean descendingOrder;

        public FurnitureLibraryTableModel(FurnitureLibrary furnitureLibrary, FurnitureLanguageController furnitureLanguageController) {
            this.furnitureLibrary = furnitureLibrary;
            this.controller = furnitureLanguageController;
            this.addFurnitureLibraryListener(furnitureLibrary);
            this.sortFurniture();
        }

        private void addFurnitureLibraryListener(final FurnitureLibrary furnitureLibrary) {
            furnitureLibrary.addListener(new CollectionListener<CatalogPieceOfFurniture>(){

                @Override
                public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = collectionEvent.getItem();
                    int n = collectionEvent.getIndex();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            int n2 = this.getPieceOfFurnitureInsertionIndex(catalogPieceOfFurniture, furnitureLibrary, n);
                            if (n2 == -1) break;
                            FurnitureLibraryTableModel.this.sortedFurniture.add(n2, catalogPieceOfFurniture);
                            FurnitureLibraryTableModel.this.fireTableRowsInserted(n2, n2);
                            break;
                        }
                        case DELETE: {
                            int n3 = this.getPieceOfFurnitureDeletionIndex(catalogPieceOfFurniture, furnitureLibrary, n);
                            if (n3 == -1) break;
                            FurnitureLibraryTableModel.this.sortedFurniture.remove(n3);
                            FurnitureLibraryTableModel.this.fireTableRowsDeleted(n3, n3);
                        }
                    }
                }

                private int getPieceOfFurnitureInsertionIndex(CatalogPieceOfFurniture catalogPieceOfFurniture, FurnitureLibrary furnitureLibrary2, int n) {
                    if (FurnitureLibraryTableModel.this.sortProperty == null) {
                        return n;
                    }
                    int n2 = Collections.binarySearch(FurnitureLibraryTableModel.this.sortedFurniture, catalogPieceOfFurniture, FurnitureLibraryTableModel.this.getFurnitureComparator(FurnitureLibraryTableModel.this.sortProperty));
                    if (n2 >= 0) {
                        return n2;
                    }
                    return -(n2 + 1);
                }

                private int getPieceOfFurnitureDeletionIndex(CatalogPieceOfFurniture catalogPieceOfFurniture, FurnitureLibrary furnitureLibrary2, int n) {
                    if (FurnitureLibraryTableModel.this.sortProperty == null) {
                        return n;
                    }
                    return FurnitureLibraryTableModel.this.getPieceOfFurnitureIndex(catalogPieceOfFurniture);
                }
            });
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.sortedFurniture.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.sortedFurniture.get(n);
        }

        public int getPieceOfFurnitureIndex(CatalogPieceOfFurniture catalogPieceOfFurniture) {
            int n = this.sortedFurniture.size();
            for (int i = 0; i < n; ++i) {
                CatalogPieceOfFurniture catalogPieceOfFurniture2 = this.sortedFurniture.get(i);
                if (catalogPieceOfFurniture != catalogPieceOfFurniture2) continue;
                return i;
            }
            return -1;
        }

        public void sortFurniture() {
            int n = this.sortedFurniture != null ? this.sortedFurniture.size() : 0;
            List<CatalogPieceOfFurniture> list = this.furnitureLibrary.getFurniture();
            this.sortedFurniture = new ArrayList<CatalogPieceOfFurniture>(list);
            if (this.sortProperty != null) {
                Comparator<CatalogPieceOfFurniture> comparator = this.getFurnitureComparator(this.sortProperty);
                Collections.sort(this.sortedFurniture, comparator);
            }
            if (n != this.sortedFurniture.size()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }

        public Comparator<CatalogPieceOfFurniture> getFurnitureComparator(final String string) {
            final Collator collator = Collator.getInstance();
            Comparator<CatalogPieceOfFurniture> comparator = null;
            comparator = "ID".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    if (catalogPieceOfFurniture.getId() == null) {
                        return -1;
                    }
                    if (catalogPieceOfFurniture2.getId() == null) {
                        return 1;
                    }
                    return collator.compare(catalogPieceOfFurniture.getId(), catalogPieceOfFurniture2.getId());
                }
            } : ("NAME".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    String string3 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture.getName());
                    String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getName());
                    return collator.compare(string3, string2);
                }
            } : ("DESCRIPTION".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    String string3 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture.getDescription());
                    if (string3 == null) {
                        return -1;
                    }
                    String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getDescription());
                    if (string2 == null) {
                        return 1;
                    }
                    return collator.compare(string3, string2);
                }
            } : ("CREATOR".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return collator.compare(catalogPieceOfFurniture.getCreator(), catalogPieceOfFurniture2.getCreator());
                }
            } : ("TAGS".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    Object[] objectArray = (String[])FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture.getTags());
                    if (objectArray == null) {
                        return -1;
                    }
                    Object[] objectArray2 = (String[])FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getTags());
                    if (objectArray2 == null) {
                        return 1;
                    }
                    return collator.compare(Arrays.toString(objectArray), Arrays.toString(objectArray2));
                }
            } : ("INFORMATION".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    String string3 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture.getInformation());
                    if (string3 == null) {
                        return -1;
                    }
                    String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getInformation());
                    if (string2 == null) {
                        return 1;
                    }
                    return collator.compare(string3, string2);
                }
            } : ("CREATION_DATE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    if (catalogPieceOfFurniture.getCreationDate() == null) {
                        return -1;
                    }
                    if (catalogPieceOfFurniture2.getCreationDate() == null) {
                        return 1;
                    }
                    return catalogPieceOfFurniture.getCreationDate().compareTo(catalogPieceOfFurniture2.getCreationDate());
                }
            } : ("GRADE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    if (catalogPieceOfFurniture.getGrade() == null) {
                        return -1;
                    }
                    if (catalogPieceOfFurniture2.getGrade() == null) {
                        return 1;
                    }
                    return catalogPieceOfFurniture.getGrade().compareTo(catalogPieceOfFurniture2.getGrade());
                }
            } : ("CATEGORY".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    String string3 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture.getCategory().getName());
                    String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getCategory().getName());
                    return collator.compare(string3, string2);
                }
            } : ("PRICE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    if (catalogPieceOfFurniture.getPrice() == null) {
                        return -1;
                    }
                    if (catalogPieceOfFurniture2.getPrice() == null) {
                        return 1;
                    }
                    return catalogPieceOfFurniture.getPrice().compareTo(catalogPieceOfFurniture2.getPrice());
                }
            } : ("VALUE_ADDED_TAX_PERCENTAGE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    if (catalogPieceOfFurniture.getValueAddedTaxPercentage() == null) {
                        return -1;
                    }
                    if (catalogPieceOfFurniture2.getValueAddedTaxPercentage() == null) {
                        return 1;
                    }
                    return catalogPieceOfFurniture.getValueAddedTaxPercentage().compareTo(catalogPieceOfFurniture2.getValueAddedTaxPercentage());
                }
            } : ("WIDTH".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.getWidth() < catalogPieceOfFurniture2.getWidth() ? -1 : (catalogPieceOfFurniture.getWidth() == catalogPieceOfFurniture2.getWidth() ? 0 : 1);
                }
            } : ("DEPTH".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.getDepth() < catalogPieceOfFurniture2.getDepth() ? -1 : (catalogPieceOfFurniture.getDepth() == catalogPieceOfFurniture2.getDepth() ? 0 : 1);
                }
            } : ("HEIGHT".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.getHeight() < catalogPieceOfFurniture2.getHeight() ? -1 : (catalogPieceOfFurniture.getHeight() == catalogPieceOfFurniture2.getHeight() ? 0 : 1);
                }
            } : ("MOVABLE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.isMovable() == catalogPieceOfFurniture2.isMovable() ? 0 : (catalogPieceOfFurniture.isMovable() ? -1 : 1);
                }
            } : ("DOOR_OR_WINDOW".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.isDoorOrWindow() == catalogPieceOfFurniture2.isDoorOrWindow() ? 0 : (catalogPieceOfFurniture.isDoorOrWindow() ? -1 : 1);
                }
            } : ("STAIRCASE_CUT_OUT_SHAPE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    if (catalogPieceOfFurniture.getStaircaseCutOutShape() == null) {
                        return -1;
                    }
                    if (catalogPieceOfFurniture2.getStaircaseCutOutShape() == null) {
                        return 1;
                    }
                    return catalogPieceOfFurniture.getStaircaseCutOutShape().compareTo(catalogPieceOfFurniture2.getStaircaseCutOutShape());
                }
            } : ("ELEVATION".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.getElevation() < catalogPieceOfFurniture2.getElevation() ? -1 : (catalogPieceOfFurniture.getElevation() == catalogPieceOfFurniture2.getElevation() ? 0 : 1);
                }
            } : ("RESIZABLE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.isResizable() == catalogPieceOfFurniture2.isResizable() ? 0 : (catalogPieceOfFurniture.isResizable() ? -1 : 1);
                }
            } : ("DEFORMABLE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.isDeformable() == catalogPieceOfFurniture2.isDeformable() ? 0 : (catalogPieceOfFurniture.isDeformable() ? -1 : 1);
                }
            } : ("TEXTURABLE".equals(string) ? new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    return catalogPieceOfFurniture.isTexturable() == catalogPieceOfFurniture2.isTexturable() ? 0 : (catalogPieceOfFurniture.isTexturable() ? -1 : 1);
                }
            } : new Comparator<CatalogPieceOfFurniture>(){

                @Override
                public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                    Object object = FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string);
                    if (object == null || !(object instanceof Comparable)) {
                        return -1;
                    }
                    Object object2 = FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getDescription());
                    return ((Comparable)object).compareTo(object2);
                }
            }))))))))))))))))))));
            if (this.descendingOrder) {
                comparator = Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        public String getSortProperty() {
            return this.sortProperty;
        }

        public void setSortProperty(String string) {
            this.sortProperty = string;
            this.sortFurniture();
        }

        public boolean isDescendingOrder() {
            return this.descendingOrder;
        }

        public void setDescendingOrder(boolean bl) {
            this.descendingOrder = bl;
            this.sortFurniture();
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureLibraryTable> furnitureLibraryTable;

        public UserPreferencesChangeListener(FurnitureLibraryTable furnitureLibraryTable) {
            this.furnitureLibraryTable = new WeakReference<FurnitureLibraryTable>(furnitureLibraryTable);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureLibraryTable furnitureLibraryTable = (FurnitureLibraryTable)this.furnitureLibraryTable.get();
            if (furnitureLibraryTable == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                furnitureLibraryTable.repaint();
                furnitureLibraryTable.getTableHeader().repaint();
            }
        }
    }
}

