/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class FurnitureLanguageComboBox
extends JComboBox
implements View {
    private static final TreeSet<Locale> LOCALES = new TreeSet<Locale>(new Comparator<Locale>(){

        @Override
        public int compare(Locale locale, Locale locale2) {
            int n = locale.getLanguage().compareTo(locale2.getLanguage());
            if (n != 0) {
                return n;
            }
            return locale.getCountry().compareTo(locale2.getCountry());
        }
    });

    public FurnitureLanguageComboBox(final FurnitureLibrary furnitureLibrary, final FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, final FurnitureLanguageController furnitureLanguageController) {
        super(LOCALES.toArray());
        this.setRenderer(new DefaultListCellRenderer(){
            private Font defaultFont;
            private Font supportedLanguageFont;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Locale locale = (Locale)object;
                String string = locale.getDisplayLanguage(locale);
                if ("".equals(string)) {
                    string = furnitureLibraryUserPreferences.getLocalizedString(FurnitureLanguageComboBox.class, "defaultLanguage", new Object[0]);
                } else {
                    string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                    if (locale.getCountry().length() > 0) {
                        string = string + " - " + locale.getDisplayCountry(locale);
                    }
                }
                super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                if (this.defaultFont == null) {
                    this.defaultFont = this.getFont();
                    this.supportedLanguageFont = new Font(this.defaultFont.getFontName(), 1, this.defaultFont.getSize());
                }
                this.setFont(furnitureLibrary.getSupportedLanguages().contains(locale.toString()) ? this.supportedLanguageFont : this.defaultFont);
                return this;
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = furnitureLanguageController.getFurnitureLangauge();
                int n = string.indexOf(95);
                if (n != -1) {
                    FurnitureLanguageComboBox.this.setSelectedItem(new Locale(string.substring(0, n), string.substring(n + 1)));
                } else {
                    FurnitureLanguageComboBox.this.setSelectedItem(new Locale(string));
                }
            }
        };
        furnitureLanguageController.addPropertyChangeListener(FurnitureLanguageController.Property.FURNITURE_LANGUAGE, propertyChangeListener);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                furnitureLanguageController.removePropertyChangeListener(FurnitureLanguageController.Property.FURNITURE_LANGUAGE, propertyChangeListener);
                furnitureLanguageController.setFurnitureLanguage(FurnitureLanguageComboBox.this.getSelectedItem().toString());
                furnitureLanguageController.addPropertyChangeListener(FurnitureLanguageController.Property.FURNITURE_LANGUAGE, propertyChangeListener);
            }
        });
        furnitureLibraryUserPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new UserPreferencesChangeListener(this));
        this.setMaximumRowCount(20);
    }

    static {
        LOCALES.add(new Locale(""));
        for (Locale locale : Locale.getAvailableLocales()) {
            LOCALES.add(locale);
        }
        Iterator<Locale> iterator = LOCALES.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            if (locale.getCountry().length() <= 0) continue;
            int n = 0;
            for (Locale locale2 : LOCALES) {
                if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
                ++n;
            }
            if (n != 2) continue;
            iterator.remove();
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureLanguageComboBox> furnitureLanguageComboBox;

        public UserPreferencesChangeListener(FurnitureLanguageComboBox furnitureLanguageComboBox) {
            this.furnitureLanguageComboBox = new WeakReference<FurnitureLanguageComboBox>(furnitureLanguageComboBox);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureLanguageComboBox furnitureLanguageComboBox = (FurnitureLanguageComboBox)this.furnitureLanguageComboBox.get();
            if (furnitureLanguageComboBox == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                furnitureLanguageComboBox.repaint();
            }
        }
    }
}

