import QtQuick 2.1
import QtQuick.XmlListModel 2.0

XmlListModel {
    id: model

    property string feedUrl: ""
    property bool loading: status == XmlListModel.Loading
    namespaceDeclarations: "declare namespace content = 'http://purl.org/rss/1.0/modules/content/';"

    source: feedUrl
    query: "/rss/channel/item"
    XmlRole { name: "title"; query: "title/string()"; }
    XmlRole { name: "story"; query: "description/string()"; }
    XmlRole { name: "url"; query: "link/string()"; isKey: true }
    XmlRole { name: "pubDate"; query: "pubDate/string()"; isKey: true }
    
}
