import QtQuick 2.1
import org.kde.kquickcontrolsaddons 2.0
import org.kde.plasma.components 2.0 as PlasmaComponents
import org.kde.plasma.extras 2.0 as PlasmaExtras

PlasmaComponents.Page {
    id: infoPage

    property string title
    property string story
    property string storyIcon

    signal backClicked()

    anchors.fill: parent

    Flickable {
        id: flickable

        interactive: contentHeight > height
        contentWidth: width
        contentHeight: backButton.height + titleLabel.height + storyLabel.height + 3
        clip: true

        anchors { left: parent.left; right: scrollbar.left; top: parent.top; bottom: parent.bottom }

        PlasmaComponents.ToolButton {
            id: backButton
            text: i18n("Back")

            iconSource: "go-previous"
            onClicked: backClicked()

            anchors { left: parent.left; top: parent.top }
        }

        QIconItem {
            id: iconItem
            icon: storyIcon
            visible: storyIcon !== undefined && storyIcon !== ""

            anchors { left: parent.left; top: backButton.bottom; topMargin: 3 }
            width: 32; height: 32
        }

        PlasmaExtras.Heading {
            id: titleLabel
            text: title
            level: 3
            elide: Text.ElideRight

            anchors { left: iconItem.visible ? iconItem.right : parent.left; leftMargin: 3; right: parent.right; top: iconItem.top }
        }

        PlasmaExtras.Paragraph {
            id: storyLabel

            text: story
            onLinkActivated: plasmoid.openUrl(link)

            anchors { left: iconItem.visible ? iconItem.right : parent.left; leftMargin: 3; right: parent.right; top: titleLabel.bottom }
        }
    }

    PlasmaComponents.ScrollBar {
        id: scrollbar
        flickableItem: flickable

        anchors { right: parent.right; top: parent.top; bottom: parent.bottom }
    }
}
