import QtQuick 2.1

ListModel {
    id: infoModel

    property bool loading: false

    // HACK: in qml ListElements you can't call functions
    // this is a workaround to provide translations
    Component.onCompleted: {
        var data = [{
                        title: i18n("Chakra"),
                        story: i18n("Chakra is a community-developed GNU/Linux distribution with an emphasis on KDE and Qt technologies, utilizing a unique half-rolling release model that allows users to enjoy the latest versions of the Plasma desktop and their favorite applications on top of a periodically updated system core.<br><br>Chakra is a completely community-driven distribution where everyone is welcome to join and contribute. Wel would be happy to mentor you on your first steps, so don't hesitate to join us! We strive to keep it easy to get involved by offering documentation on our tools and procedures."),
                        icon: "chakra-shield"
                    },
                    {
                        title: i18n("The Chakra Experience"),
                        story: i18n("To truly appreciate the virtues of Chakra we urge you to use it for a while, as it offers much more than what can be included in a live image. There are several reasons that make Chakra stand apart as a distribution - the most notable ones being its focus on KDE and Qt software, the unique half-rolling release model and our friendly community.<br><br>Chakra is a KDE-centric distribution. We provide Plasma as the only available desktop environment, matched with a variety of KDE and Qt applications in our repositories. Our packages are stripped from their Gtk+ dependencies, but we offer the most popular Gtk+ based applications to our users.<br>The half-rolling release model allows us to provide a distribution that is stable at its core components, yet provides all the latest application and security updates to the user. This enables Chakra to be used in a range of environments, such as personal desktop systems, computer labs of schools, as well as offices and small businesses."),
                        icon: "kde"
                    },
                    {
                        title: i18n("Chakra and Arch Linux"),
                        story: i18n("Chakra is derived from Arch Linux but is not compatible with the Arch Linux repositories and packages. Chakra has its own repositories, packages, and release schedule. Including Arch Linux repositories in your configuration and installing binary packages from there is neither recommended nor supported."),
                        icon: "chakra-shield" 
                    },
                    {
                        title: i18n("Chakra and Security"),
                        story: i18n("By default, installing Chakra includes ufw which can be configured through system settings. The kernel is built with several MAC hardening options, including Tomoyo and AppArmor, and the 'tomoyo-tools' package is included to let the user configure this system. A third tool to handle security is Clam AntiVirus, which handles detection and removal of malware."),
                        icon: "preferences-desktop-cryptography"
                    },
		    {   title: i18n("Work In Progress"),
                        story: i18n("Octopi is used as a GUI frontend for pacman in Chakra, but we plan to replace pacman with akabei - a new package manager developed by us which will be optimized for GUI usage."),
                        icon: "dialog-warning"
                        
                     }]

        for (var i in data)
            append(data[i]);
    }
}
