import QtQuick 2.1
import org.kde.plasma.core 2.0 as PlasmaCore
import org.kde.plasma.components 2.0 as PlasmaComponents
import org.kde.plasma.extras 2.0 as PlasmaExtras
import org.kde.kquickcontrolsaddons 2.0 as QtExtra

Item {
    id: infoDelegate

    property string story
    property string title
    property string storyIcon

    signal storyClicked(string page, variant propertys)

    height: Math.max(iconItem.height, titleLabel.paintedHeight + storyLabel.paintedHeight)
            + padding.margins.top + padding.margins.bottom
    width: parent.width

    PlasmaCore.FrameSvgItem {
        id: padding
        imagePath: "widgets/viewitem"
        prefix: "hover"
        opacity: 0

        anchors.fill: parent

        Behavior on opacity { PropertyAnimation {} }
    }

    MouseArea {
        id: container

        onClicked: storyClicked(Qt.resolvedUrl("InfoPage.qml"), { "title" : model.title, "story" : model.story, "storyIcon" : model.icon} )


        hoverEnabled: true
        onEntered: padding.opacity = 0.7
        onExited: padding.opacity = 0

        anchors {
            fill: parent
            topMargin: padding.margins.top
            leftMargin: padding.margins.left
            rightMargin: padding.margins.right
            bottomMargin: padding.margins.bottom
        }

        QtExtra.QIconItem {
            id: iconItem
            icon: storyIcon
            visible: storyIcon !== undefined && storyIcon !== ""

            anchors { left: parent.left; verticalCenter: parent.verticalCenter }
            width: 32; height: 32
        }

        PlasmaExtras.Heading {
            id: titleLabel
            text: title
            level: 4
            elide: Text.ElideRight

            height: paintedHeight
            anchors { left: iconItem.visible ? iconItem.right : parent.left; leftMargin: 5; right: parent.right; top: parent.top }
        }

        PlasmaComponents.Label {
            id: storyLabel

            // remove html tags, escape sequences at the beginning and only show the first line
            text: model.story.replace(/(<([^>]+)>)/ig,"").replace(/^\s+|\s+$/g, '').split('\n')[0];
            elide: Text.ElideRight
            wrapMode: Text.NoWrap
            clip: true
            opacity: 0.7

            height: paintedHeight
            anchors { left: iconItem.visible ? iconItem.right : parent.left; leftMargin: 5; right: parent.right; top: titleLabel.bottom }
        }
    }
}
