/*
*   Copyright 2017 Luca Giambonini <almack@chakralinux.org>
* 
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU Library General Public License as
*   published by the Free Software Foundation; either version 2, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU Library General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

import QtQuick 2.1
import QtQuick.Controls.Styles 1.4
import QtQuick.Layouts 1.2

import org.kde.plasma.core 2.0 as PlasmaCore
import org.kde.plasma.components 2.0 as PlasmaComponents

PlasmaComponents.Button {
    id: ueButton
    implicitWidth: iconSize *2
    implicitHeight: iconSize *2
    
    style: ButtonStyle {
            background: Item {
            opacity: control.hovered ? 1.0 : 0.5
            //This code is duplicated here and Button and ToolButton
            //maybe we can make an AbstractButton class?
            PlasmaCore.FrameSvgItem {
                id: surfaceNormal
                anchors.fill: parent
                imagePath: "widgets/button"
                prefix: "normal"
            }

            PlasmaCore.FrameSvgItem {
                id: surfacePressed
                anchors.fill: parent
                imagePath: "widgets/button"
                prefix: "pressed"
                opacity: 0
            }
            
            state: control.pressed || control.checked ? "pressed" : "normal"
         

        
            states: [
                State { name: "normal" },
                State { name: "pressed"
                        PropertyChanges {
                            target: surfaceNormal
                            opacity: 0
                        }
                        PropertyChanges {
                            target: surfacePressed
                            opacity: 1
                        }
                }
            ]

            transitions: [
                Transition {
                    to: "normal"
                    //Cross fade from pressed to normal
                    ParallelAnimation {
                        NumberAnimation { target: surfaceNormal; property: "opacity"; to: 1; duration: 100 }
                        NumberAnimation { target: surfacePressed; property: "opacity"; to: 0; duration: 100 }
                    }
                }
            ]

            Component.onCompleted: {
                padding.top = surfaceNormal.margins.top
                padding.left = surfaceNormal.margins.left
                padding.right = surfaceNormal.margins.right
                padding.bottom = surfaceNormal.margins.bottom
            }
        }

    
        label: Item {
            implicitHeight: buttonContent.Layout.preferredHeight
            implicitWidth: buttonContent.implicitWidth
            ColumnLayout {
                id: buttonContent
                anchors.fill: parent
                spacing: units.smallSpacing

                Layout.preferredHeight: iconSize+ label.implicitHeight

                property real minimumWidth: Layout.minimumWidth + style.padding.left + style.padding.right
                onMinimumWidthChanged: {
                    if (control.minimumWidth !== undefined) {
                        style.minimumWidth = minimumWidth;
                        control.minimumWidth = minimumWidth;
                    }
                }

                property real minimumHeight: Layout.preferredHeight + style.padding.top + style.padding.bottom
                onMinimumHeightChanged: {
                    if (control.minimumHeight !== undefined) {
                        style.minimumHeight = minimumHeight;
                        control.minimumHeight = minimumHeight;
                    }
                }

                PlasmaCore.IconItem {
                    id: icon
                    source: control.iconName || control.iconSource
                    anchors.horizontalCenter: parent.horizontalCenter

                    implicitHeight: iconSize
                    implicitWidth: iconSize

                    Layout.preferredHeight: iconSize
                    Layout.alignment: Qt.AlignHCenter
                    active: control.hovered
                    colorGroup: controlHovered || !flat ? PlasmaCore.Theme.ButtonColorGroup : PlasmaCore.ColorScope.colorGroup
                }
                
                PlasmaComponents.Label {
                    id: label
                    text: control.text
                    textFormat: Text.StyledText
                    font.pointSize: iconSize > 96 ? theme.defaultFont.pointSize : theme.smallestFont.pointSize
                    visible: control.text != ""
                    Layout.fillWidth: true
                    color: theme.buttonTextColor
                    horizontalAlignment: Text.AlignHCenter
                    wrapMode: Text.Wrap
                    maximumLineCount: 3                 
                }
            }
        }
    }
}
