/* NOTE: Do not edit this file, it is generated by a script:
   ExportTrace.py --api wgl 0 --prefix traceWGL -t traverseTraceWGL --library WGL -o traceWGL.c -x  -e GLAPIENTRY
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "trace.h"

#ifdef _WIN32
# define DLLEXPORT __declspec(dllexport)
#elif defined(__GNUC__) && __GNUC__>=4
# define DLLEXPORT __attribute__ ((visibility("default")))
#elif defined(__SUNPRO_C) || defined(__SUNPRO_CC)
# define DLLEXPORT __global
#else
# define DLLEXPORT
#endif

/* Define WGL calling convention. */

#if defined(__MINGW32__) || defined(__CYGWIN32__) || defined(__CYGWIN__) || defined(_MSC_VER)
# define GLAPIENTRY __stdcall
#else
# define GLAPIENTRY
#endif

/* Undefine DLLEXPORT. Use module definition file instead. */

#undef  DLLEXPORT
#define DLLEXPORT

/* Include windows.h header. */

#if !defined(WIN32_LEAN_AND_MEAN)
# define WIN32_LEAN_AND_MEAN 1
#endif
#if !defined(_GDI32_)
# define _GDI32_ 1
#endif
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#undef _GDI32_

/* Include WGL headers. */

#if defined(GL_GLEXT_PROTOTYPES)
# undef GL_GLEXT_PROTOTYPES
#endif
#if defined(WGL_WGLEXT_PROTOTYPES)
# undef WGL_WGLEXT_PROTOTYPES
#endif

/* Include typedefs and constants from GL headers. */

#define GL_FALSE 0

typedef unsigned int GLenum;
typedef unsigned int GLbitfield;
typedef unsigned int GLuint;
typedef int GLint;
typedef int GLsizei;
typedef unsigned char GLboolean;
typedef unsigned short GLushort;
typedef float GLfloat;

#if defined(_MSC_VER)
#  if _MSC_VER < 1400
typedef __int64 GLint64EXT;
typedef unsigned __int64 GLuint64EXT;
#  else
typedef signed long long GLint64EXT;
typedef unsigned long long GLuint64EXT;
#  endif
#else
#  if defined(__MINGW32__) || defined(__CYGWIN__)
#include <inttypes.h>
#  endif
typedef int64_t GLint64EXT;
typedef uint64_t GLuint64EXT;
#endif
typedef GLint64EXT  GLint64;
typedef GLuint64EXT GLuint64;

/* Include typedefs from WGL headers. */

#if defined(__CYGWIN__)
typedef struct _WGLSWAP
{
    HDC hdc;
    UINT uiFlags;
} WGLSWAP, *PWGLSWAP;
#endif

#ifndef WGL_ARB_pbuffer
DECLARE_HANDLE(HPBUFFERARB);
#endif
#ifndef WGL_EXT_pbuffer
DECLARE_HANDLE(HPBUFFEREXT);
#endif

#ifndef WGL_NV_present_video
DECLARE_HANDLE(HVIDEOOUTPUTDEVICENV);
#endif
#ifndef WGL_NV_video_output
DECLARE_HANDLE(HPVIDEODEV);
#endif
#ifndef WGL_NV_gpu_affinity
DECLARE_HANDLE(HPGPUNV);
DECLARE_HANDLE(HGPUNV);

typedef struct _GPU_DEVICE {
    DWORD  cb;
    CHAR   DeviceName[32];
    CHAR   DeviceString[128];
    DWORD  Flags;
    RECT   rcVirtualScreen;
} GPU_DEVICE, *PGPU_DEVICE;
#endif
#ifndef WGL_NV_video_capture
DECLARE_HANDLE(HVIDEOINPUTDEVICENV);
#endif

#if !defined(ARB_sync) && !defined(GL_TYPEDEFS_3_2)
typedef struct __GLsync *GLsync;
#endif

/* Declare WGL API functions. */

int GLAPIENTRY wglChoosePixelFormat(HDC, const PIXELFORMATDESCRIPTOR *);
int GLAPIENTRY wglDescribePixelFormat(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
int GLAPIENTRY wglGetPixelFormat(HDC);
BOOL GLAPIENTRY wglSetPixelFormat(HDC, int, const PIXELFORMATDESCRIPTOR *);
BOOL GLAPIENTRY wglSwapBuffers(HDC);
HGLRC GLAPIENTRY wglCreateContext(HDC);
HGLRC GLAPIENTRY wglCreateLayerContext(HDC, int);
BOOL GLAPIENTRY wglCopyContext(HGLRC, HGLRC, UINT);
BOOL GLAPIENTRY wglDeleteContext(HGLRC);
HGLRC GLAPIENTRY wglGetCurrentContext(void);
HDC GLAPIENTRY wglGetCurrentDC(void);
PROC GLAPIENTRY wglGetDefaultProcAddress(LPCSTR);
PROC GLAPIENTRY wglGetProcAddress(LPCSTR);
BOOL GLAPIENTRY wglMakeCurrent(HDC, HGLRC);
BOOL GLAPIENTRY wglShareLists(HGLRC, HGLRC);
BOOL GLAPIENTRY wglUseFontBitmapsA(HDC, DWORD, DWORD, DWORD);
BOOL GLAPIENTRY wglUseFontBitmapsW(HDC, DWORD, DWORD, DWORD);
BOOL GLAPIENTRY wglUseFontOutlinesA(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT);
BOOL GLAPIENTRY wglUseFontOutlinesW(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT);
BOOL GLAPIENTRY wglDescribeLayerPlane(HDC, int, int, UINT, LPLAYERPLANEDESCRIPTOR);
int GLAPIENTRY wglSetLayerPaletteEntries(HDC, int, int, int, const COLORREF *);
int GLAPIENTRY wglGetLayerPaletteEntries(HDC, int, int, int, COLORREF *);
BOOL GLAPIENTRY wglRealizeLayerPalette(HDC, int, BOOL);
BOOL GLAPIENTRY wglSwapLayerBuffers(HDC, UINT);
DWORD GLAPIENTRY wglSwapMultipleBuffers(UINT, const WGLSWAP *);
HANDLE GLAPIENTRY wglCreateBufferRegionARB(HDC, int, UINT);
VOID GLAPIENTRY wglDeleteBufferRegionARB(HANDLE);
BOOL GLAPIENTRY wglSaveBufferRegionARB(HANDLE, int, int, int, int);
BOOL GLAPIENTRY wglRestoreBufferRegionARB(HANDLE, int, int, int, int, int, int);
const char *GLAPIENTRY wglGetExtensionsStringARB(HDC);
BOOL GLAPIENTRY wglGetPixelFormatAttribivARB(HDC, int, int, UINT, const int *, int *);
BOOL GLAPIENTRY wglGetPixelFormatAttribfvARB(HDC, int, int, UINT, const int *, FLOAT *);
BOOL GLAPIENTRY wglChoosePixelFormatARB(HDC, const int *, const FLOAT *, UINT, int *, UINT *);
BOOL GLAPIENTRY wglMakeContextCurrentARB(HDC, HDC, HGLRC);
HDC GLAPIENTRY wglGetCurrentReadDCARB(void);
HPBUFFERARB GLAPIENTRY wglCreatePbufferARB(HDC, int, int, int, const int *);
HDC GLAPIENTRY wglGetPbufferDCARB(HPBUFFERARB);
int GLAPIENTRY wglReleasePbufferDCARB(HPBUFFERARB, HDC);
BOOL GLAPIENTRY wglDestroyPbufferARB(HPBUFFERARB);
BOOL GLAPIENTRY wglQueryPbufferARB(HPBUFFERARB, int, int *);
BOOL GLAPIENTRY wglBindTexImageARB(HPBUFFERARB, int);
BOOL GLAPIENTRY wglReleaseTexImageARB(HPBUFFERARB, int);
BOOL GLAPIENTRY wglSetPbufferAttribARB(HPBUFFERARB, const int *);
HGLRC GLAPIENTRY wglCreateContextAttribsARB(HDC, HGLRC, const int *);
GLboolean GLAPIENTRY wglCreateDisplayColorTableEXT(GLushort);
GLboolean GLAPIENTRY wglLoadDisplayColorTableEXT(const GLushort *, GLuint);
GLboolean GLAPIENTRY wglBindDisplayColorTableEXT(GLushort);
VOID GLAPIENTRY wglDestroyDisplayColorTableEXT(GLushort);
const char *GLAPIENTRY wglGetExtensionsStringEXT(void);
BOOL GLAPIENTRY wglMakeContextCurrentEXT(HDC, HDC, HGLRC);
HDC GLAPIENTRY wglGetCurrentReadDCEXT(void);
BOOL GLAPIENTRY wglGetPixelFormatAttribivEXT(HDC, int, int, UINT, const int *, int *);
BOOL GLAPIENTRY wglGetPixelFormatAttribfvEXT(HDC, int, int, UINT, const int *, FLOAT *);
BOOL GLAPIENTRY wglChoosePixelFormatEXT(HDC, const int *, const FLOAT *, UINT, int *, UINT *);
HPBUFFEREXT GLAPIENTRY wglCreatePbufferEXT(HDC, int, int, int, const int *);
HDC GLAPIENTRY wglGetPbufferDCEXT(HPBUFFEREXT);
int GLAPIENTRY wglReleasePbufferDCEXT(HPBUFFEREXT, HDC);
BOOL GLAPIENTRY wglDestroyPbufferEXT(HPBUFFEREXT);
BOOL GLAPIENTRY wglQueryPbufferEXT(HPBUFFEREXT, int, int *);
BOOL GLAPIENTRY wglSwapIntervalEXT(int);
int GLAPIENTRY wglGetSwapIntervalEXT(void);
void *GLAPIENTRY wglAllocateMemoryNV(GLsizei, GLfloat, GLfloat, GLfloat);
void GLAPIENTRY wglFreeMemoryNV(void *);
BOOL GLAPIENTRY wglGetSyncValuesOML(HDC, INT64 *, INT64 *, INT64 *);
BOOL GLAPIENTRY wglGetMscRateOML(HDC, INT32 *, INT32 *);
INT64 GLAPIENTRY wglSwapBuffersMscOML(HDC, INT64, INT64, INT64);
INT64 GLAPIENTRY wglSwapLayerBuffersMscOML(HDC, int, INT64, INT64, INT64);
BOOL GLAPIENTRY wglWaitForMscOML(HDC, INT64, INT64, INT64, INT64 *, INT64 *, INT64 *);
BOOL GLAPIENTRY wglWaitForSbcOML(HDC, INT64, INT64 *, INT64 *, INT64 *);
BOOL GLAPIENTRY wglGetDigitalVideoParametersI3D(HDC, int, int *);
BOOL GLAPIENTRY wglSetDigitalVideoParametersI3D(HDC, int, const int *);
BOOL GLAPIENTRY wglGetGammaTableParametersI3D(HDC, int, int *);
BOOL GLAPIENTRY wglSetGammaTableParametersI3D(HDC, int, const int *);
BOOL GLAPIENTRY wglGetGammaTableI3D(HDC, int, USHORT *, USHORT *, USHORT *);
BOOL GLAPIENTRY wglSetGammaTableI3D(HDC, int, const USHORT *, const USHORT *, const USHORT *);
BOOL GLAPIENTRY wglEnableGenlockI3D(HDC);
BOOL GLAPIENTRY wglDisableGenlockI3D(HDC);
BOOL GLAPIENTRY wglIsEnabledGenlockI3D(HDC, BOOL *);
BOOL GLAPIENTRY wglGenlockSourceI3D(HDC, UINT);
BOOL GLAPIENTRY wglGetGenlockSourceI3D(HDC, UINT *);
BOOL GLAPIENTRY wglGenlockSourceEdgeI3D(HDC, UINT);
BOOL GLAPIENTRY wglGetGenlockSourceEdgeI3D(HDC, UINT *);
BOOL GLAPIENTRY wglGenlockSampleRateI3D(HDC, UINT);
BOOL GLAPIENTRY wglGetGenlockSampleRateI3D(HDC, UINT *);
BOOL GLAPIENTRY wglGenlockSourceDelayI3D(HDC, UINT);
BOOL GLAPIENTRY wglGetGenlockSourceDelayI3D(HDC, UINT *);
BOOL GLAPIENTRY wglQueryGenlockMaxSourceDelayI3D(HDC, UINT *, UINT *);
LPVOID GLAPIENTRY wglCreateImageBufferI3D(HDC, DWORD, UINT);
BOOL GLAPIENTRY wglDestroyImageBufferI3D(HDC, LPVOID);
BOOL GLAPIENTRY wglAssociateImageBufferEventsI3D(HDC, const HANDLE *, const LPVOID *, const DWORD *, UINT);
BOOL GLAPIENTRY wglReleaseImageBufferEventsI3D(HDC, const LPVOID *, UINT);
BOOL GLAPIENTRY wglEnableFrameLockI3D(void);
BOOL GLAPIENTRY wglDisableFrameLockI3D(void);
BOOL GLAPIENTRY wglIsEnabledFrameLockI3D(BOOL *);
BOOL GLAPIENTRY wglQueryFrameLockMasterI3D(BOOL *);
BOOL GLAPIENTRY wglGetFrameUsageI3D(float *);
BOOL GLAPIENTRY wglBeginFrameTrackingI3D(void);
BOOL GLAPIENTRY wglEndFrameTrackingI3D(void);
BOOL GLAPIENTRY wglQueryFrameTrackingI3D(DWORD *, DWORD *, float *);
BOOL GLAPIENTRY wglSetStereoEmitterState3DL(HDC, UINT);
int GLAPIENTRY wglEnumerateVideoDevicesNV(HDC, HVIDEOOUTPUTDEVICENV *);
BOOL GLAPIENTRY wglBindVideoDeviceNV(HDC, unsigned int, HVIDEOOUTPUTDEVICENV, const int *);
BOOL GLAPIENTRY wglQueryCurrentContextNV(int, int *);
BOOL GLAPIENTRY wglGetVideoDeviceNV(HDC, int, HPVIDEODEV *);
BOOL GLAPIENTRY wglReleaseVideoDeviceNV(HPVIDEODEV);
BOOL GLAPIENTRY wglBindVideoImageNV(HPVIDEODEV, HPBUFFERARB, int);
BOOL GLAPIENTRY wglReleaseVideoImageNV(HPBUFFERARB, int);
BOOL GLAPIENTRY wglSendPbufferToVideoNV(HPBUFFERARB, int, unsigned long *, BOOL);
BOOL GLAPIENTRY wglGetVideoInfoNV(HPVIDEODEV, unsigned long *, unsigned long *);
BOOL GLAPIENTRY wglJoinSwapGroupNV(HDC, GLuint);
BOOL GLAPIENTRY wglBindSwapBarrierNV(GLuint, GLuint);
BOOL GLAPIENTRY wglQuerySwapGroupNV(HDC, GLuint *, GLuint *);
BOOL GLAPIENTRY wglQueryMaxSwapGroupsNV(HDC, GLuint *, GLuint *);
BOOL GLAPIENTRY wglQueryFrameCountNV(HDC, GLuint *);
BOOL GLAPIENTRY wglResetFrameCountNV(HDC);
BOOL GLAPIENTRY wglEnumGpusNV(UINT, HGPUNV *);
BOOL GLAPIENTRY wglEnumGpuDevicesNV(HGPUNV, UINT, PGPU_DEVICE);
HDC GLAPIENTRY wglCreateAffinityDCNV(const HGPUNV *);
BOOL GLAPIENTRY wglEnumGpusFromAffinityDCNV(HDC, UINT, HGPUNV *);
BOOL GLAPIENTRY wglDeleteDCNV(HDC);
UINT GLAPIENTRY wglGetGPUIDsAMD(UINT, UINT *);
INT GLAPIENTRY wglGetGPUInfoAMD(UINT, int, GLenum, UINT, void *);
UINT GLAPIENTRY wglGetContextGPUIDAMD(HGLRC);
HGLRC GLAPIENTRY wglCreateAssociatedContextAMD(UINT);
HGLRC GLAPIENTRY wglCreateAssociatedContextAttribsAMD(UINT, HGLRC, const int *);
BOOL GLAPIENTRY wglDeleteAssociatedContextAMD(HGLRC);
BOOL GLAPIENTRY wglMakeAssociatedContextCurrentAMD(HGLRC);
HGLRC GLAPIENTRY wglGetCurrentAssociatedContextAMD(void);
VOID GLAPIENTRY wglBlitContextFramebufferAMD(HGLRC, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
BOOL GLAPIENTRY wglBindVideoCaptureDeviceNV(UINT, HVIDEOINPUTDEVICENV);
UINT GLAPIENTRY wglEnumerateVideoCaptureDevicesNV(HDC, HVIDEOINPUTDEVICENV *);
BOOL GLAPIENTRY wglLockVideoCaptureDeviceNV(HDC, HVIDEOINPUTDEVICENV);
BOOL GLAPIENTRY wglQueryVideoCaptureDeviceNV(HDC, HVIDEOINPUTDEVICENV, int, int *);
BOOL GLAPIENTRY wglReleaseVideoCaptureDeviceNV(HDC, HVIDEOINPUTDEVICENV);
BOOL GLAPIENTRY wglCopyImageSubDataNV(HGLRC, GLuint, GLenum, GLint, GLint, GLint, GLint, HGLRC, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);

/* Load WGL library. */

#if defined(_WIN32)
# if !defined(WIN32_LEAN_AND_MEAN)
#   define WIN32_LEAN_AND_MEAN 1
# endif
# if !defined(NOGDI)
#   define NOGDI 1
# endif
# include <windows.h>
# undef WIN32_LEAN_AND_MEAN
# undef NOGDI
#elif defined(__APPLE__)
# include <AvailabilityMacros.h>
# if !defined(MAC_OS_X_VERSION_10_3)
#   include <mach-o/dyld.h>
# else
#   include <dlfcn.h>
# endif
#else
# include <dlfcn.h>
#endif

typedef struct _TraceWGL_Handle *TraceWGL_Handle;

static TraceWGL_Handle
traceWGL_LoadLibrary(const char *filename)
{
#if defined(_WIN32)
  return (TraceWGL_Handle) LoadLibrary(filename);
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return (TraceWGL_Handle) NSAddImage(filename, NSADDIMAGE_OPTION_NONE);
#else
  return (TraceWGL_Handle) dlopen(filename, RTLD_LAZY);
#endif
}

static int
traceWGL_FreeLibrary(TraceWGL_Handle handle)
{
#if defined(_WIN32)
  return FreeLibrary((HMODULE)handle) ? 1 : 0;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return 1;
#else
  return dlclose(handle) ? 0 : 1;
#endif
}

static void *
traceWGL_GetProcAddress(TraceWGL_Handle handle, const char *name)
{
#if defined(_WIN32)
  return handle ? GetProcAddress((HMODULE)handle, name) : NULL;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return NSIsSymbolNameDefined(name) ? NSAddressOfSymbol(NSLookupAndBindSymbol(name)) : NULL;
#else
  return dlsym(handle, name);
#endif
}

static int traceWGL_initialized = 0;
static TraceWGL_Handle traceWGL_handle = NULL;

/* WGL API function pointers. */

struct TraceWGL_Functions
{
  void *(GLAPIENTRY *wglAllocateMemoryNV)(GLsizei, GLfloat, GLfloat, GLfloat);
  BOOL (GLAPIENTRY *wglAssociateImageBufferEventsI3D)(HDC, const HANDLE *, const LPVOID *, const DWORD *, UINT);
  BOOL (GLAPIENTRY *wglBeginFrameTrackingI3D)(void);
  GLboolean (GLAPIENTRY *wglBindDisplayColorTableEXT)(GLushort);
  BOOL (GLAPIENTRY *wglBindSwapBarrierNV)(GLuint, GLuint);
  BOOL (GLAPIENTRY *wglBindTexImageARB)(HPBUFFERARB, int);
  BOOL (GLAPIENTRY *wglBindVideoCaptureDeviceNV)(UINT, HVIDEOINPUTDEVICENV);
  BOOL (GLAPIENTRY *wglBindVideoDeviceNV)(HDC, unsigned int, HVIDEOOUTPUTDEVICENV, const int *);
  BOOL (GLAPIENTRY *wglBindVideoImageNV)(HPVIDEODEV, HPBUFFERARB, int);
  VOID (GLAPIENTRY *wglBlitContextFramebufferAMD)(HGLRC, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
  int (GLAPIENTRY *wglChoosePixelFormat)(HDC, const PIXELFORMATDESCRIPTOR *);
  BOOL (GLAPIENTRY *wglChoosePixelFormatARB)(HDC, const int *, const FLOAT *, UINT, int *, UINT *);
  BOOL (GLAPIENTRY *wglChoosePixelFormatEXT)(HDC, const int *, const FLOAT *, UINT, int *, UINT *);
  BOOL (GLAPIENTRY *wglCopyContext)(HGLRC, HGLRC, UINT);
  BOOL (GLAPIENTRY *wglCopyImageSubDataNV)(HGLRC, GLuint, GLenum, GLint, GLint, GLint, GLint, HGLRC, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
  HDC (GLAPIENTRY *wglCreateAffinityDCNV)(const HGPUNV *);
  HGLRC (GLAPIENTRY *wglCreateAssociatedContextAMD)(UINT);
  HGLRC (GLAPIENTRY *wglCreateAssociatedContextAttribsAMD)(UINT, HGLRC, const int *);
  HANDLE (GLAPIENTRY *wglCreateBufferRegionARB)(HDC, int, UINT);
  HGLRC (GLAPIENTRY *wglCreateContext)(HDC);
  HGLRC (GLAPIENTRY *wglCreateContextAttribsARB)(HDC, HGLRC, const int *);
  GLboolean (GLAPIENTRY *wglCreateDisplayColorTableEXT)(GLushort);
  LPVOID (GLAPIENTRY *wglCreateImageBufferI3D)(HDC, DWORD, UINT);
  HGLRC (GLAPIENTRY *wglCreateLayerContext)(HDC, int);
  HPBUFFERARB (GLAPIENTRY *wglCreatePbufferARB)(HDC, int, int, int, const int *);
  HPBUFFEREXT (GLAPIENTRY *wglCreatePbufferEXT)(HDC, int, int, int, const int *);
  BOOL (GLAPIENTRY *wglDeleteAssociatedContextAMD)(HGLRC);
  VOID (GLAPIENTRY *wglDeleteBufferRegionARB)(HANDLE);
  BOOL (GLAPIENTRY *wglDeleteContext)(HGLRC);
  BOOL (GLAPIENTRY *wglDeleteDCNV)(HDC);
  BOOL (GLAPIENTRY *wglDescribeLayerPlane)(HDC, int, int, UINT, LPLAYERPLANEDESCRIPTOR);
  int (GLAPIENTRY *wglDescribePixelFormat)(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
  VOID (GLAPIENTRY *wglDestroyDisplayColorTableEXT)(GLushort);
  BOOL (GLAPIENTRY *wglDestroyImageBufferI3D)(HDC, LPVOID);
  BOOL (GLAPIENTRY *wglDestroyPbufferARB)(HPBUFFERARB);
  BOOL (GLAPIENTRY *wglDestroyPbufferEXT)(HPBUFFEREXT);
  BOOL (GLAPIENTRY *wglDisableFrameLockI3D)(void);
  BOOL (GLAPIENTRY *wglDisableGenlockI3D)(HDC);
  BOOL (GLAPIENTRY *wglEnableFrameLockI3D)(void);
  BOOL (GLAPIENTRY *wglEnableGenlockI3D)(HDC);
  BOOL (GLAPIENTRY *wglEndFrameTrackingI3D)(void);
  BOOL (GLAPIENTRY *wglEnumGpuDevicesNV)(HGPUNV, UINT, PGPU_DEVICE);
  BOOL (GLAPIENTRY *wglEnumGpusFromAffinityDCNV)(HDC, UINT, HGPUNV *);
  BOOL (GLAPIENTRY *wglEnumGpusNV)(UINT, HGPUNV *);
  UINT (GLAPIENTRY *wglEnumerateVideoCaptureDevicesNV)(HDC, HVIDEOINPUTDEVICENV *);
  int (GLAPIENTRY *wglEnumerateVideoDevicesNV)(HDC, HVIDEOOUTPUTDEVICENV *);
  void (GLAPIENTRY *wglFreeMemoryNV)(void *);
  BOOL (GLAPIENTRY *wglGenlockSampleRateI3D)(HDC, UINT);
  BOOL (GLAPIENTRY *wglGenlockSourceDelayI3D)(HDC, UINT);
  BOOL (GLAPIENTRY *wglGenlockSourceEdgeI3D)(HDC, UINT);
  BOOL (GLAPIENTRY *wglGenlockSourceI3D)(HDC, UINT);
  UINT (GLAPIENTRY *wglGetContextGPUIDAMD)(HGLRC);
  HGLRC (GLAPIENTRY *wglGetCurrentAssociatedContextAMD)(void);
  HGLRC (GLAPIENTRY *wglGetCurrentContext)(void);
  HDC (GLAPIENTRY *wglGetCurrentDC)(void);
  HDC (GLAPIENTRY *wglGetCurrentReadDCARB)(void);
  HDC (GLAPIENTRY *wglGetCurrentReadDCEXT)(void);
  PROC (GLAPIENTRY *wglGetDefaultProcAddress)(LPCSTR);
  BOOL (GLAPIENTRY *wglGetDigitalVideoParametersI3D)(HDC, int, int *);
  const char *(GLAPIENTRY *wglGetExtensionsStringARB)(HDC);
  const char *(GLAPIENTRY *wglGetExtensionsStringEXT)(void);
  BOOL (GLAPIENTRY *wglGetFrameUsageI3D)(float *);
  UINT (GLAPIENTRY *wglGetGPUIDsAMD)(UINT, UINT *);
  INT (GLAPIENTRY *wglGetGPUInfoAMD)(UINT, int, GLenum, UINT, void *);
  BOOL (GLAPIENTRY *wglGetGammaTableI3D)(HDC, int, USHORT *, USHORT *, USHORT *);
  BOOL (GLAPIENTRY *wglGetGammaTableParametersI3D)(HDC, int, int *);
  BOOL (GLAPIENTRY *wglGetGenlockSampleRateI3D)(HDC, UINT *);
  BOOL (GLAPIENTRY *wglGetGenlockSourceDelayI3D)(HDC, UINT *);
  BOOL (GLAPIENTRY *wglGetGenlockSourceEdgeI3D)(HDC, UINT *);
  BOOL (GLAPIENTRY *wglGetGenlockSourceI3D)(HDC, UINT *);
  int (GLAPIENTRY *wglGetLayerPaletteEntries)(HDC, int, int, int, COLORREF *);
  BOOL (GLAPIENTRY *wglGetMscRateOML)(HDC, INT32 *, INT32 *);
  HDC (GLAPIENTRY *wglGetPbufferDCARB)(HPBUFFERARB);
  HDC (GLAPIENTRY *wglGetPbufferDCEXT)(HPBUFFEREXT);
  int (GLAPIENTRY *wglGetPixelFormat)(HDC);
  BOOL (GLAPIENTRY *wglGetPixelFormatAttribfvARB)(HDC, int, int, UINT, const int *, FLOAT *);
  BOOL (GLAPIENTRY *wglGetPixelFormatAttribfvEXT)(HDC, int, int, UINT, const int *, FLOAT *);
  BOOL (GLAPIENTRY *wglGetPixelFormatAttribivARB)(HDC, int, int, UINT, const int *, int *);
  BOOL (GLAPIENTRY *wglGetPixelFormatAttribivEXT)(HDC, int, int, UINT, const int *, int *);
  PROC (GLAPIENTRY *wglGetProcAddress)(LPCSTR);
  int (GLAPIENTRY *wglGetSwapIntervalEXT)(void);
  BOOL (GLAPIENTRY *wglGetSyncValuesOML)(HDC, INT64 *, INT64 *, INT64 *);
  BOOL (GLAPIENTRY *wglGetVideoDeviceNV)(HDC, int, HPVIDEODEV *);
  BOOL (GLAPIENTRY *wglGetVideoInfoNV)(HPVIDEODEV, unsigned long *, unsigned long *);
  BOOL (GLAPIENTRY *wglIsEnabledFrameLockI3D)(BOOL *);
  BOOL (GLAPIENTRY *wglIsEnabledGenlockI3D)(HDC, BOOL *);
  BOOL (GLAPIENTRY *wglJoinSwapGroupNV)(HDC, GLuint);
  GLboolean (GLAPIENTRY *wglLoadDisplayColorTableEXT)(const GLushort *, GLuint);
  BOOL (GLAPIENTRY *wglLockVideoCaptureDeviceNV)(HDC, HVIDEOINPUTDEVICENV);
  BOOL (GLAPIENTRY *wglMakeAssociatedContextCurrentAMD)(HGLRC);
  BOOL (GLAPIENTRY *wglMakeContextCurrentARB)(HDC, HDC, HGLRC);
  BOOL (GLAPIENTRY *wglMakeContextCurrentEXT)(HDC, HDC, HGLRC);
  BOOL (GLAPIENTRY *wglMakeCurrent)(HDC, HGLRC);
  BOOL (GLAPIENTRY *wglQueryCurrentContextNV)(int, int *);
  BOOL (GLAPIENTRY *wglQueryFrameCountNV)(HDC, GLuint *);
  BOOL (GLAPIENTRY *wglQueryFrameLockMasterI3D)(BOOL *);
  BOOL (GLAPIENTRY *wglQueryFrameTrackingI3D)(DWORD *, DWORD *, float *);
  BOOL (GLAPIENTRY *wglQueryGenlockMaxSourceDelayI3D)(HDC, UINT *, UINT *);
  BOOL (GLAPIENTRY *wglQueryMaxSwapGroupsNV)(HDC, GLuint *, GLuint *);
  BOOL (GLAPIENTRY *wglQueryPbufferARB)(HPBUFFERARB, int, int *);
  BOOL (GLAPIENTRY *wglQueryPbufferEXT)(HPBUFFEREXT, int, int *);
  BOOL (GLAPIENTRY *wglQuerySwapGroupNV)(HDC, GLuint *, GLuint *);
  BOOL (GLAPIENTRY *wglQueryVideoCaptureDeviceNV)(HDC, HVIDEOINPUTDEVICENV, int, int *);
  BOOL (GLAPIENTRY *wglRealizeLayerPalette)(HDC, int, BOOL);
  BOOL (GLAPIENTRY *wglReleaseImageBufferEventsI3D)(HDC, const LPVOID *, UINT);
  int (GLAPIENTRY *wglReleasePbufferDCARB)(HPBUFFERARB, HDC);
  int (GLAPIENTRY *wglReleasePbufferDCEXT)(HPBUFFEREXT, HDC);
  BOOL (GLAPIENTRY *wglReleaseTexImageARB)(HPBUFFERARB, int);
  BOOL (GLAPIENTRY *wglReleaseVideoCaptureDeviceNV)(HDC, HVIDEOINPUTDEVICENV);
  BOOL (GLAPIENTRY *wglReleaseVideoDeviceNV)(HPVIDEODEV);
  BOOL (GLAPIENTRY *wglReleaseVideoImageNV)(HPBUFFERARB, int);
  BOOL (GLAPIENTRY *wglResetFrameCountNV)(HDC);
  BOOL (GLAPIENTRY *wglRestoreBufferRegionARB)(HANDLE, int, int, int, int, int, int);
  BOOL (GLAPIENTRY *wglSaveBufferRegionARB)(HANDLE, int, int, int, int);
  BOOL (GLAPIENTRY *wglSendPbufferToVideoNV)(HPBUFFERARB, int, unsigned long *, BOOL);
  BOOL (GLAPIENTRY *wglSetDigitalVideoParametersI3D)(HDC, int, const int *);
  BOOL (GLAPIENTRY *wglSetGammaTableI3D)(HDC, int, const USHORT *, const USHORT *, const USHORT *);
  BOOL (GLAPIENTRY *wglSetGammaTableParametersI3D)(HDC, int, const int *);
  int (GLAPIENTRY *wglSetLayerPaletteEntries)(HDC, int, int, int, const COLORREF *);
  BOOL (GLAPIENTRY *wglSetPbufferAttribARB)(HPBUFFERARB, const int *);
  BOOL (GLAPIENTRY *wglSetPixelFormat)(HDC, int, const PIXELFORMATDESCRIPTOR *);
  BOOL (GLAPIENTRY *wglSetStereoEmitterState3DL)(HDC, UINT);
  BOOL (GLAPIENTRY *wglShareLists)(HGLRC, HGLRC);
  BOOL (GLAPIENTRY *wglSwapBuffers)(HDC);
  INT64 (GLAPIENTRY *wglSwapBuffersMscOML)(HDC, INT64, INT64, INT64);
  BOOL (GLAPIENTRY *wglSwapIntervalEXT)(int);
  BOOL (GLAPIENTRY *wglSwapLayerBuffers)(HDC, UINT);
  INT64 (GLAPIENTRY *wglSwapLayerBuffersMscOML)(HDC, int, INT64, INT64, INT64);
  DWORD (GLAPIENTRY *wglSwapMultipleBuffers)(UINT, const WGLSWAP *);
  BOOL (GLAPIENTRY *wglUseFontBitmapsA)(HDC, DWORD, DWORD, DWORD);
  BOOL (GLAPIENTRY *wglUseFontBitmapsW)(HDC, DWORD, DWORD, DWORD);
  BOOL (GLAPIENTRY *wglUseFontOutlinesA)(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT);
  BOOL (GLAPIENTRY *wglUseFontOutlinesW)(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT);
  BOOL (GLAPIENTRY *wglWaitForMscOML)(HDC, INT64, INT64, INT64, INT64 *, INT64 *, INT64 *);
  BOOL (GLAPIENTRY *wglWaitForSbcOML)(HDC, INT64, INT64 *, INT64 *, INT64 *);
};

static struct TraceWGL_Functions traceWGL_Native;

/* WGL proc address related functions. */

static void  traceWGL_lookupNativeAddress(const char *name, void **procPtr);
static void *traceWGL_lookupWrapperAddress(const char *name, void *proc);

/* Initialize TraceWGL. */

void
traceWGL_init(void)
{
  const char *library = "WGL";
  const char *filename = NULL;

  if (traceWGL_initialized)
    return;

  /* Do pre-initialization */

  /* Load the native library */

  filename = traceLibraryLocation(library);
  traceWGL_handle = traceWGL_LoadLibrary(filename);
  if (!traceWGL_handle)
  {
    traceError("Failed to load %s from %s", library, filename);
    return;
  }
  traceInfo("Loaded %s from %s", library, filename);

  /* Load WGL API functions. */

  memset(&traceWGL_Native, 0, sizeof(struct TraceWGL_Functions));

  traceWGL_Native.wglChoosePixelFormat = (int (GLAPIENTRY *)(HDC, const PIXELFORMATDESCRIPTOR *)) traceWGL_GetProcAddress(traceWGL_handle, "wglChoosePixelFormat");
  traceWGL_Native.wglDescribePixelFormat = (int (GLAPIENTRY *)(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR)) traceWGL_GetProcAddress(traceWGL_handle, "wglDescribePixelFormat");
  traceWGL_Native.wglGetPixelFormat = (int (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPixelFormat");
  traceWGL_Native.wglSetPixelFormat = (BOOL (GLAPIENTRY *)(HDC, int, const PIXELFORMATDESCRIPTOR *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetPixelFormat");
  traceWGL_Native.wglSwapBuffers = (BOOL (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglSwapBuffers");
  traceWGL_Native.wglCreateContext = (HGLRC (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateContext");
  traceWGL_Native.wglCreateLayerContext = (HGLRC (GLAPIENTRY *)(HDC, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateLayerContext");
  traceWGL_Native.wglCopyContext = (BOOL (GLAPIENTRY *)(HGLRC, HGLRC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglCopyContext");
  traceWGL_Native.wglDeleteContext = (BOOL (GLAPIENTRY *)(HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglDeleteContext");
  traceWGL_Native.wglGetCurrentContext = (HGLRC (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetCurrentContext");
  traceWGL_Native.wglGetCurrentDC = (HDC (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetCurrentDC");
  traceWGL_Native.wglGetDefaultProcAddress = (PROC (GLAPIENTRY *)(LPCSTR)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetDefaultProcAddress");
  traceWGL_Native.wglGetProcAddress = (PROC (GLAPIENTRY *)(LPCSTR)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetProcAddress");
  traceWGL_Native.wglMakeCurrent = (BOOL (GLAPIENTRY *)(HDC, HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglMakeCurrent");
  traceWGL_Native.wglShareLists = (BOOL (GLAPIENTRY *)(HGLRC, HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglShareLists");
  traceWGL_Native.wglUseFontBitmapsA = (BOOL (GLAPIENTRY *)(HDC, DWORD, DWORD, DWORD)) traceWGL_GetProcAddress(traceWGL_handle, "wglUseFontBitmapsA");
  traceWGL_Native.wglUseFontBitmapsW = (BOOL (GLAPIENTRY *)(HDC, DWORD, DWORD, DWORD)) traceWGL_GetProcAddress(traceWGL_handle, "wglUseFontBitmapsW");
  traceWGL_Native.wglUseFontOutlinesA = (BOOL (GLAPIENTRY *)(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT)) traceWGL_GetProcAddress(traceWGL_handle, "wglUseFontOutlinesA");
  traceWGL_Native.wglUseFontOutlinesW = (BOOL (GLAPIENTRY *)(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT)) traceWGL_GetProcAddress(traceWGL_handle, "wglUseFontOutlinesW");
  traceWGL_Native.wglDescribeLayerPlane = (BOOL (GLAPIENTRY *)(HDC, int, int, UINT, LPLAYERPLANEDESCRIPTOR)) traceWGL_GetProcAddress(traceWGL_handle, "wglDescribeLayerPlane");
  traceWGL_Native.wglSetLayerPaletteEntries = (int (GLAPIENTRY *)(HDC, int, int, int, const COLORREF *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetLayerPaletteEntries");
  traceWGL_Native.wglGetLayerPaletteEntries = (int (GLAPIENTRY *)(HDC, int, int, int, COLORREF *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetLayerPaletteEntries");
  traceWGL_Native.wglRealizeLayerPalette = (BOOL (GLAPIENTRY *)(HDC, int, BOOL)) traceWGL_GetProcAddress(traceWGL_handle, "wglRealizeLayerPalette");
  traceWGL_Native.wglSwapLayerBuffers = (BOOL (GLAPIENTRY *)(HDC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglSwapLayerBuffers");
  traceWGL_Native.wglSwapMultipleBuffers = (DWORD (GLAPIENTRY *)(UINT, const WGLSWAP *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSwapMultipleBuffers");
  traceWGL_Native.wglCreateBufferRegionARB = (HANDLE (GLAPIENTRY *)(HDC, int, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateBufferRegionARB");
  traceWGL_Native.wglDeleteBufferRegionARB = (VOID (GLAPIENTRY *)(HANDLE)) traceWGL_GetProcAddress(traceWGL_handle, "wglDeleteBufferRegionARB");
  traceWGL_Native.wglSaveBufferRegionARB = (BOOL (GLAPIENTRY *)(HANDLE, int, int, int, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglSaveBufferRegionARB");
  traceWGL_Native.wglRestoreBufferRegionARB = (BOOL (GLAPIENTRY *)(HANDLE, int, int, int, int, int, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglRestoreBufferRegionARB");
  traceWGL_Native.wglGetExtensionsStringARB = (const char *(GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetExtensionsStringARB");
  traceWGL_Native.wglGetPixelFormatAttribivARB = (BOOL (GLAPIENTRY *)(HDC, int, int, UINT, const int *, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPixelFormatAttribivARB");
  traceWGL_Native.wglGetPixelFormatAttribfvARB = (BOOL (GLAPIENTRY *)(HDC, int, int, UINT, const int *, FLOAT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPixelFormatAttribfvARB");
  traceWGL_Native.wglChoosePixelFormatARB = (BOOL (GLAPIENTRY *)(HDC, const int *, const FLOAT *, UINT, int *, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglChoosePixelFormatARB");
  traceWGL_Native.wglMakeContextCurrentARB = (BOOL (GLAPIENTRY *)(HDC, HDC, HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglMakeContextCurrentARB");
  traceWGL_Native.wglGetCurrentReadDCARB = (HDC (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetCurrentReadDCARB");
  traceWGL_Native.wglCreatePbufferARB = (HPBUFFERARB (GLAPIENTRY *)(HDC, int, int, int, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreatePbufferARB");
  traceWGL_Native.wglGetPbufferDCARB = (HDC (GLAPIENTRY *)(HPBUFFERARB)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPbufferDCARB");
  traceWGL_Native.wglReleasePbufferDCARB = (int (GLAPIENTRY *)(HPBUFFERARB, HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleasePbufferDCARB");
  traceWGL_Native.wglDestroyPbufferARB = (BOOL (GLAPIENTRY *)(HPBUFFERARB)) traceWGL_GetProcAddress(traceWGL_handle, "wglDestroyPbufferARB");
  traceWGL_Native.wglQueryPbufferARB = (BOOL (GLAPIENTRY *)(HPBUFFERARB, int, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryPbufferARB");
  traceWGL_Native.wglBindTexImageARB = (BOOL (GLAPIENTRY *)(HPBUFFERARB, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglBindTexImageARB");
  traceWGL_Native.wglReleaseTexImageARB = (BOOL (GLAPIENTRY *)(HPBUFFERARB, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleaseTexImageARB");
  traceWGL_Native.wglSetPbufferAttribARB = (BOOL (GLAPIENTRY *)(HPBUFFERARB, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetPbufferAttribARB");
  traceWGL_Native.wglCreateContextAttribsARB = (HGLRC (GLAPIENTRY *)(HDC, HGLRC, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateContextAttribsARB");
  traceWGL_Native.wglCreateDisplayColorTableEXT = (GLboolean (GLAPIENTRY *)(GLushort)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateDisplayColorTableEXT");
  traceWGL_Native.wglLoadDisplayColorTableEXT = (GLboolean (GLAPIENTRY *)(const GLushort *, GLuint)) traceWGL_GetProcAddress(traceWGL_handle, "wglLoadDisplayColorTableEXT");
  traceWGL_Native.wglBindDisplayColorTableEXT = (GLboolean (GLAPIENTRY *)(GLushort)) traceWGL_GetProcAddress(traceWGL_handle, "wglBindDisplayColorTableEXT");
  traceWGL_Native.wglDestroyDisplayColorTableEXT = (VOID (GLAPIENTRY *)(GLushort)) traceWGL_GetProcAddress(traceWGL_handle, "wglDestroyDisplayColorTableEXT");
  traceWGL_Native.wglGetExtensionsStringEXT = (const char *(GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetExtensionsStringEXT");
  traceWGL_Native.wglMakeContextCurrentEXT = (BOOL (GLAPIENTRY *)(HDC, HDC, HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglMakeContextCurrentEXT");
  traceWGL_Native.wglGetCurrentReadDCEXT = (HDC (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetCurrentReadDCEXT");
  traceWGL_Native.wglGetPixelFormatAttribivEXT = (BOOL (GLAPIENTRY *)(HDC, int, int, UINT, const int *, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPixelFormatAttribivEXT");
  traceWGL_Native.wglGetPixelFormatAttribfvEXT = (BOOL (GLAPIENTRY *)(HDC, int, int, UINT, const int *, FLOAT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPixelFormatAttribfvEXT");
  traceWGL_Native.wglChoosePixelFormatEXT = (BOOL (GLAPIENTRY *)(HDC, const int *, const FLOAT *, UINT, int *, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglChoosePixelFormatEXT");
  traceWGL_Native.wglCreatePbufferEXT = (HPBUFFEREXT (GLAPIENTRY *)(HDC, int, int, int, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreatePbufferEXT");
  traceWGL_Native.wglGetPbufferDCEXT = (HDC (GLAPIENTRY *)(HPBUFFEREXT)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetPbufferDCEXT");
  traceWGL_Native.wglReleasePbufferDCEXT = (int (GLAPIENTRY *)(HPBUFFEREXT, HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleasePbufferDCEXT");
  traceWGL_Native.wglDestroyPbufferEXT = (BOOL (GLAPIENTRY *)(HPBUFFEREXT)) traceWGL_GetProcAddress(traceWGL_handle, "wglDestroyPbufferEXT");
  traceWGL_Native.wglQueryPbufferEXT = (BOOL (GLAPIENTRY *)(HPBUFFEREXT, int, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryPbufferEXT");
  traceWGL_Native.wglSwapIntervalEXT = (BOOL (GLAPIENTRY *)(int)) traceWGL_GetProcAddress(traceWGL_handle, "wglSwapIntervalEXT");
  traceWGL_Native.wglGetSwapIntervalEXT = (int (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetSwapIntervalEXT");
  traceWGL_Native.wglAllocateMemoryNV = (void *(GLAPIENTRY *)(GLsizei, GLfloat, GLfloat, GLfloat)) traceWGL_GetProcAddress(traceWGL_handle, "wglAllocateMemoryNV");
  traceWGL_Native.wglFreeMemoryNV = (void (GLAPIENTRY *)(void *)) traceWGL_GetProcAddress(traceWGL_handle, "wglFreeMemoryNV");
  traceWGL_Native.wglGetSyncValuesOML = (BOOL (GLAPIENTRY *)(HDC, INT64 *, INT64 *, INT64 *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetSyncValuesOML");
  traceWGL_Native.wglGetMscRateOML = (BOOL (GLAPIENTRY *)(HDC, INT32 *, INT32 *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetMscRateOML");
  traceWGL_Native.wglSwapBuffersMscOML = (INT64 (GLAPIENTRY *)(HDC, INT64, INT64, INT64)) traceWGL_GetProcAddress(traceWGL_handle, "wglSwapBuffersMscOML");
  traceWGL_Native.wglSwapLayerBuffersMscOML = (INT64 (GLAPIENTRY *)(HDC, int, INT64, INT64, INT64)) traceWGL_GetProcAddress(traceWGL_handle, "wglSwapLayerBuffersMscOML");
  traceWGL_Native.wglWaitForMscOML = (BOOL (GLAPIENTRY *)(HDC, INT64, INT64, INT64, INT64 *, INT64 *, INT64 *)) traceWGL_GetProcAddress(traceWGL_handle, "wglWaitForMscOML");
  traceWGL_Native.wglWaitForSbcOML = (BOOL (GLAPIENTRY *)(HDC, INT64, INT64 *, INT64 *, INT64 *)) traceWGL_GetProcAddress(traceWGL_handle, "wglWaitForSbcOML");
  traceWGL_Native.wglGetDigitalVideoParametersI3D = (BOOL (GLAPIENTRY *)(HDC, int, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetDigitalVideoParametersI3D");
  traceWGL_Native.wglSetDigitalVideoParametersI3D = (BOOL (GLAPIENTRY *)(HDC, int, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetDigitalVideoParametersI3D");
  traceWGL_Native.wglGetGammaTableParametersI3D = (BOOL (GLAPIENTRY *)(HDC, int, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGammaTableParametersI3D");
  traceWGL_Native.wglSetGammaTableParametersI3D = (BOOL (GLAPIENTRY *)(HDC, int, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetGammaTableParametersI3D");
  traceWGL_Native.wglGetGammaTableI3D = (BOOL (GLAPIENTRY *)(HDC, int, USHORT *, USHORT *, USHORT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGammaTableI3D");
  traceWGL_Native.wglSetGammaTableI3D = (BOOL (GLAPIENTRY *)(HDC, int, const USHORT *, const USHORT *, const USHORT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetGammaTableI3D");
  traceWGL_Native.wglEnableGenlockI3D = (BOOL (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnableGenlockI3D");
  traceWGL_Native.wglDisableGenlockI3D = (BOOL (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglDisableGenlockI3D");
  traceWGL_Native.wglIsEnabledGenlockI3D = (BOOL (GLAPIENTRY *)(HDC, BOOL *)) traceWGL_GetProcAddress(traceWGL_handle, "wglIsEnabledGenlockI3D");
  traceWGL_Native.wglGenlockSourceI3D = (BOOL (GLAPIENTRY *)(HDC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglGenlockSourceI3D");
  traceWGL_Native.wglGetGenlockSourceI3D = (BOOL (GLAPIENTRY *)(HDC, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGenlockSourceI3D");
  traceWGL_Native.wglGenlockSourceEdgeI3D = (BOOL (GLAPIENTRY *)(HDC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglGenlockSourceEdgeI3D");
  traceWGL_Native.wglGetGenlockSourceEdgeI3D = (BOOL (GLAPIENTRY *)(HDC, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGenlockSourceEdgeI3D");
  traceWGL_Native.wglGenlockSampleRateI3D = (BOOL (GLAPIENTRY *)(HDC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglGenlockSampleRateI3D");
  traceWGL_Native.wglGetGenlockSampleRateI3D = (BOOL (GLAPIENTRY *)(HDC, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGenlockSampleRateI3D");
  traceWGL_Native.wglGenlockSourceDelayI3D = (BOOL (GLAPIENTRY *)(HDC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglGenlockSourceDelayI3D");
  traceWGL_Native.wglGetGenlockSourceDelayI3D = (BOOL (GLAPIENTRY *)(HDC, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGenlockSourceDelayI3D");
  traceWGL_Native.wglQueryGenlockMaxSourceDelayI3D = (BOOL (GLAPIENTRY *)(HDC, UINT *, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryGenlockMaxSourceDelayI3D");
  traceWGL_Native.wglCreateImageBufferI3D = (LPVOID (GLAPIENTRY *)(HDC, DWORD, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateImageBufferI3D");
  traceWGL_Native.wglDestroyImageBufferI3D = (BOOL (GLAPIENTRY *)(HDC, LPVOID)) traceWGL_GetProcAddress(traceWGL_handle, "wglDestroyImageBufferI3D");
  traceWGL_Native.wglAssociateImageBufferEventsI3D = (BOOL (GLAPIENTRY *)(HDC, const HANDLE *, const LPVOID *, const DWORD *, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglAssociateImageBufferEventsI3D");
  traceWGL_Native.wglReleaseImageBufferEventsI3D = (BOOL (GLAPIENTRY *)(HDC, const LPVOID *, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleaseImageBufferEventsI3D");
  traceWGL_Native.wglEnableFrameLockI3D = (BOOL (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnableFrameLockI3D");
  traceWGL_Native.wglDisableFrameLockI3D = (BOOL (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglDisableFrameLockI3D");
  traceWGL_Native.wglIsEnabledFrameLockI3D = (BOOL (GLAPIENTRY *)(BOOL *)) traceWGL_GetProcAddress(traceWGL_handle, "wglIsEnabledFrameLockI3D");
  traceWGL_Native.wglQueryFrameLockMasterI3D = (BOOL (GLAPIENTRY *)(BOOL *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryFrameLockMasterI3D");
  traceWGL_Native.wglGetFrameUsageI3D = (BOOL (GLAPIENTRY *)(float *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetFrameUsageI3D");
  traceWGL_Native.wglBeginFrameTrackingI3D = (BOOL (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglBeginFrameTrackingI3D");
  traceWGL_Native.wglEndFrameTrackingI3D = (BOOL (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglEndFrameTrackingI3D");
  traceWGL_Native.wglQueryFrameTrackingI3D = (BOOL (GLAPIENTRY *)(DWORD *, DWORD *, float *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryFrameTrackingI3D");
  traceWGL_Native.wglSetStereoEmitterState3DL = (BOOL (GLAPIENTRY *)(HDC, UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglSetStereoEmitterState3DL");
  traceWGL_Native.wglEnumerateVideoDevicesNV = (int (GLAPIENTRY *)(HDC, HVIDEOOUTPUTDEVICENV *)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnumerateVideoDevicesNV");
  traceWGL_Native.wglBindVideoDeviceNV = (BOOL (GLAPIENTRY *)(HDC, unsigned int, HVIDEOOUTPUTDEVICENV, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglBindVideoDeviceNV");
  traceWGL_Native.wglQueryCurrentContextNV = (BOOL (GLAPIENTRY *)(int, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryCurrentContextNV");
  traceWGL_Native.wglGetVideoDeviceNV = (BOOL (GLAPIENTRY *)(HDC, int, HPVIDEODEV *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetVideoDeviceNV");
  traceWGL_Native.wglReleaseVideoDeviceNV = (BOOL (GLAPIENTRY *)(HPVIDEODEV)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleaseVideoDeviceNV");
  traceWGL_Native.wglBindVideoImageNV = (BOOL (GLAPIENTRY *)(HPVIDEODEV, HPBUFFERARB, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglBindVideoImageNV");
  traceWGL_Native.wglReleaseVideoImageNV = (BOOL (GLAPIENTRY *)(HPBUFFERARB, int)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleaseVideoImageNV");
  traceWGL_Native.wglSendPbufferToVideoNV = (BOOL (GLAPIENTRY *)(HPBUFFERARB, int, unsigned long *, BOOL)) traceWGL_GetProcAddress(traceWGL_handle, "wglSendPbufferToVideoNV");
  traceWGL_Native.wglGetVideoInfoNV = (BOOL (GLAPIENTRY *)(HPVIDEODEV, unsigned long *, unsigned long *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetVideoInfoNV");
  traceWGL_Native.wglJoinSwapGroupNV = (BOOL (GLAPIENTRY *)(HDC, GLuint)) traceWGL_GetProcAddress(traceWGL_handle, "wglJoinSwapGroupNV");
  traceWGL_Native.wglBindSwapBarrierNV = (BOOL (GLAPIENTRY *)(GLuint, GLuint)) traceWGL_GetProcAddress(traceWGL_handle, "wglBindSwapBarrierNV");
  traceWGL_Native.wglQuerySwapGroupNV = (BOOL (GLAPIENTRY *)(HDC, GLuint *, GLuint *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQuerySwapGroupNV");
  traceWGL_Native.wglQueryMaxSwapGroupsNV = (BOOL (GLAPIENTRY *)(HDC, GLuint *, GLuint *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryMaxSwapGroupsNV");
  traceWGL_Native.wglQueryFrameCountNV = (BOOL (GLAPIENTRY *)(HDC, GLuint *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryFrameCountNV");
  traceWGL_Native.wglResetFrameCountNV = (BOOL (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglResetFrameCountNV");
  traceWGL_Native.wglEnumGpusNV = (BOOL (GLAPIENTRY *)(UINT, HGPUNV *)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnumGpusNV");
  traceWGL_Native.wglEnumGpuDevicesNV = (BOOL (GLAPIENTRY *)(HGPUNV, UINT, PGPU_DEVICE)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnumGpuDevicesNV");
  traceWGL_Native.wglCreateAffinityDCNV = (HDC (GLAPIENTRY *)(const HGPUNV *)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateAffinityDCNV");
  traceWGL_Native.wglEnumGpusFromAffinityDCNV = (BOOL (GLAPIENTRY *)(HDC, UINT, HGPUNV *)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnumGpusFromAffinityDCNV");
  traceWGL_Native.wglDeleteDCNV = (BOOL (GLAPIENTRY *)(HDC)) traceWGL_GetProcAddress(traceWGL_handle, "wglDeleteDCNV");
  traceWGL_Native.wglGetGPUIDsAMD = (UINT (GLAPIENTRY *)(UINT, UINT *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGPUIDsAMD");
  traceWGL_Native.wglGetGPUInfoAMD = (INT (GLAPIENTRY *)(UINT, int, GLenum, UINT, void *)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetGPUInfoAMD");
  traceWGL_Native.wglGetContextGPUIDAMD = (UINT (GLAPIENTRY *)(HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetContextGPUIDAMD");
  traceWGL_Native.wglCreateAssociatedContextAMD = (HGLRC (GLAPIENTRY *)(UINT)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateAssociatedContextAMD");
  traceWGL_Native.wglCreateAssociatedContextAttribsAMD = (HGLRC (GLAPIENTRY *)(UINT, HGLRC, const int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglCreateAssociatedContextAttribsAMD");
  traceWGL_Native.wglDeleteAssociatedContextAMD = (BOOL (GLAPIENTRY *)(HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglDeleteAssociatedContextAMD");
  traceWGL_Native.wglMakeAssociatedContextCurrentAMD = (BOOL (GLAPIENTRY *)(HGLRC)) traceWGL_GetProcAddress(traceWGL_handle, "wglMakeAssociatedContextCurrentAMD");
  traceWGL_Native.wglGetCurrentAssociatedContextAMD = (HGLRC (GLAPIENTRY *)(void)) traceWGL_GetProcAddress(traceWGL_handle, "wglGetCurrentAssociatedContextAMD");
  traceWGL_Native.wglBlitContextFramebufferAMD = (VOID (GLAPIENTRY *)(HGLRC, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum)) traceWGL_GetProcAddress(traceWGL_handle, "wglBlitContextFramebufferAMD");
  traceWGL_Native.wglBindVideoCaptureDeviceNV = (BOOL (GLAPIENTRY *)(UINT, HVIDEOINPUTDEVICENV)) traceWGL_GetProcAddress(traceWGL_handle, "wglBindVideoCaptureDeviceNV");
  traceWGL_Native.wglEnumerateVideoCaptureDevicesNV = (UINT (GLAPIENTRY *)(HDC, HVIDEOINPUTDEVICENV *)) traceWGL_GetProcAddress(traceWGL_handle, "wglEnumerateVideoCaptureDevicesNV");
  traceWGL_Native.wglLockVideoCaptureDeviceNV = (BOOL (GLAPIENTRY *)(HDC, HVIDEOINPUTDEVICENV)) traceWGL_GetProcAddress(traceWGL_handle, "wglLockVideoCaptureDeviceNV");
  traceWGL_Native.wglQueryVideoCaptureDeviceNV = (BOOL (GLAPIENTRY *)(HDC, HVIDEOINPUTDEVICENV, int, int *)) traceWGL_GetProcAddress(traceWGL_handle, "wglQueryVideoCaptureDeviceNV");
  traceWGL_Native.wglReleaseVideoCaptureDeviceNV = (BOOL (GLAPIENTRY *)(HDC, HVIDEOINPUTDEVICENV)) traceWGL_GetProcAddress(traceWGL_handle, "wglReleaseVideoCaptureDeviceNV");
  traceWGL_Native.wglCopyImageSubDataNV = (BOOL (GLAPIENTRY *)(HGLRC, GLuint, GLenum, GLint, GLint, GLint, GLint, HGLRC, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei)) traceWGL_GetProcAddress(traceWGL_handle, "wglCopyImageSubDataNV");

  /* Validate WGL API functions. */

  if (traceWGL_Native.wglChoosePixelFormat)
  {
    if (traceWGL_Native.wglChoosePixelFormat == wglChoosePixelFormat)
    {
      traceWarning("Ignoring wglChoosePixelFormat loaded from traceWGL library.");
      traceWGL_Native.wglChoosePixelFormat = NULL;
    }
  }
  else
  {
    traceWarning("wglChoosePixelFormat not loaded.");
  }
  if (traceWGL_Native.wglDescribePixelFormat)
  {
    if (traceWGL_Native.wglDescribePixelFormat == wglDescribePixelFormat)
    {
      traceWarning("Ignoring wglDescribePixelFormat loaded from traceWGL library.");
      traceWGL_Native.wglDescribePixelFormat = NULL;
    }
  }
  else
  {
    traceWarning("wglDescribePixelFormat not loaded.");
  }
  if (traceWGL_Native.wglGetPixelFormat)
  {
    if (traceWGL_Native.wglGetPixelFormat == wglGetPixelFormat)
    {
      traceWarning("Ignoring wglGetPixelFormat loaded from traceWGL library.");
      traceWGL_Native.wglGetPixelFormat = NULL;
    }
  }
  else
  {
    traceWarning("wglGetPixelFormat not loaded.");
  }
  if (traceWGL_Native.wglSetPixelFormat)
  {
    if (traceWGL_Native.wglSetPixelFormat == wglSetPixelFormat)
    {
      traceWarning("Ignoring wglSetPixelFormat loaded from traceWGL library.");
      traceWGL_Native.wglSetPixelFormat = NULL;
    }
  }
  else
  {
    traceWarning("wglSetPixelFormat not loaded.");
  }
  if (traceWGL_Native.wglSwapBuffers)
  {
    if (traceWGL_Native.wglSwapBuffers == wglSwapBuffers)
    {
      traceWarning("Ignoring wglSwapBuffers loaded from traceWGL library.");
      traceWGL_Native.wglSwapBuffers = NULL;
    }
  }
  else
  {
    traceWarning("wglSwapBuffers not loaded.");
  }
  if (traceWGL_Native.wglCreateContext)
  {
    if (traceWGL_Native.wglCreateContext == wglCreateContext)
    {
      traceWarning("Ignoring wglCreateContext loaded from traceWGL library.");
      traceWGL_Native.wglCreateContext = NULL;
    }
  }
  else
  {
    traceWarning("wglCreateContext not loaded.");
  }
  if (traceWGL_Native.wglCreateLayerContext)
  {
    if (traceWGL_Native.wglCreateLayerContext == wglCreateLayerContext)
    {
      traceWarning("Ignoring wglCreateLayerContext loaded from traceWGL library.");
      traceWGL_Native.wglCreateLayerContext = NULL;
    }
  }
  else
  {
    traceWarning("wglCreateLayerContext not loaded.");
  }
  if (traceWGL_Native.wglCopyContext)
  {
    if (traceWGL_Native.wglCopyContext == wglCopyContext)
    {
      traceWarning("Ignoring wglCopyContext loaded from traceWGL library.");
      traceWGL_Native.wglCopyContext = NULL;
    }
  }
  else
  {
    traceWarning("wglCopyContext not loaded.");
  }
  if (traceWGL_Native.wglDeleteContext)
  {
    if (traceWGL_Native.wglDeleteContext == wglDeleteContext)
    {
      traceWarning("Ignoring wglDeleteContext loaded from traceWGL library.");
      traceWGL_Native.wglDeleteContext = NULL;
    }
  }
  else
  {
    traceWarning("wglDeleteContext not loaded.");
  }
  if (traceWGL_Native.wglGetCurrentContext)
  {
    if (traceWGL_Native.wglGetCurrentContext == wglGetCurrentContext)
    {
      traceWarning("Ignoring wglGetCurrentContext loaded from traceWGL library.");
      traceWGL_Native.wglGetCurrentContext = NULL;
    }
  }
  else
  {
    traceWarning("wglGetCurrentContext not loaded.");
  }
  if (traceWGL_Native.wglGetCurrentDC)
  {
    if (traceWGL_Native.wglGetCurrentDC == wglGetCurrentDC)
    {
      traceWarning("Ignoring wglGetCurrentDC loaded from traceWGL library.");
      traceWGL_Native.wglGetCurrentDC = NULL;
    }
  }
  else
  {
    traceWarning("wglGetCurrentDC not loaded.");
  }
  if (traceWGL_Native.wglGetDefaultProcAddress)
  {
    if (traceWGL_Native.wglGetDefaultProcAddress == wglGetDefaultProcAddress)
    {
      traceWarning("Ignoring wglGetDefaultProcAddress loaded from traceWGL library.");
      traceWGL_Native.wglGetDefaultProcAddress = NULL;
    }
  }
  else
  {
    traceWarning("wglGetDefaultProcAddress not loaded.");
  }
  if (traceWGL_Native.wglGetProcAddress)
  {
    if (traceWGL_Native.wglGetProcAddress == wglGetProcAddress)
    {
      traceWarning("Ignoring wglGetProcAddress loaded from traceWGL library.");
      traceWGL_Native.wglGetProcAddress = NULL;
    }
  }
  else
  {
    traceWarning("wglGetProcAddress not loaded.");
  }
  if (traceWGL_Native.wglMakeCurrent)
  {
    if (traceWGL_Native.wglMakeCurrent == wglMakeCurrent)
    {
      traceWarning("Ignoring wglMakeCurrent loaded from traceWGL library.");
      traceWGL_Native.wglMakeCurrent = NULL;
    }
  }
  else
  {
    traceWarning("wglMakeCurrent not loaded.");
  }
  if (traceWGL_Native.wglShareLists)
  {
    if (traceWGL_Native.wglShareLists == wglShareLists)
    {
      traceWarning("Ignoring wglShareLists loaded from traceWGL library.");
      traceWGL_Native.wglShareLists = NULL;
    }
  }
  else
  {
    traceWarning("wglShareLists not loaded.");
  }
  if (traceWGL_Native.wglUseFontBitmapsA)
  {
    if (traceWGL_Native.wglUseFontBitmapsA == wglUseFontBitmapsA)
    {
      traceWarning("Ignoring wglUseFontBitmapsA loaded from traceWGL library.");
      traceWGL_Native.wglUseFontBitmapsA = NULL;
    }
  }
  else
  {
    traceWarning("wglUseFontBitmapsA not loaded.");
  }
  if (traceWGL_Native.wglUseFontBitmapsW)
  {
    if (traceWGL_Native.wglUseFontBitmapsW == wglUseFontBitmapsW)
    {
      traceWarning("Ignoring wglUseFontBitmapsW loaded from traceWGL library.");
      traceWGL_Native.wglUseFontBitmapsW = NULL;
    }
  }
  else
  {
    traceWarning("wglUseFontBitmapsW not loaded.");
  }
  if (traceWGL_Native.wglUseFontOutlinesA)
  {
    if (traceWGL_Native.wglUseFontOutlinesA == wglUseFontOutlinesA)
    {
      traceWarning("Ignoring wglUseFontOutlinesA loaded from traceWGL library.");
      traceWGL_Native.wglUseFontOutlinesA = NULL;
    }
  }
  else
  {
    traceWarning("wglUseFontOutlinesA not loaded.");
  }
  if (traceWGL_Native.wglUseFontOutlinesW)
  {
    if (traceWGL_Native.wglUseFontOutlinesW == wglUseFontOutlinesW)
    {
      traceWarning("Ignoring wglUseFontOutlinesW loaded from traceWGL library.");
      traceWGL_Native.wglUseFontOutlinesW = NULL;
    }
  }
  else
  {
    traceWarning("wglUseFontOutlinesW not loaded.");
  }
  if (traceWGL_Native.wglDescribeLayerPlane)
  {
    if (traceWGL_Native.wglDescribeLayerPlane == wglDescribeLayerPlane)
    {
      traceWarning("Ignoring wglDescribeLayerPlane loaded from traceWGL library.");
      traceWGL_Native.wglDescribeLayerPlane = NULL;
    }
  }
  else
  {
    traceWarning("wglDescribeLayerPlane not loaded.");
  }
  if (traceWGL_Native.wglSetLayerPaletteEntries)
  {
    if (traceWGL_Native.wglSetLayerPaletteEntries == wglSetLayerPaletteEntries)
    {
      traceWarning("Ignoring wglSetLayerPaletteEntries loaded from traceWGL library.");
      traceWGL_Native.wglSetLayerPaletteEntries = NULL;
    }
  }
  else
  {
    traceWarning("wglSetLayerPaletteEntries not loaded.");
  }
  if (traceWGL_Native.wglGetLayerPaletteEntries)
  {
    if (traceWGL_Native.wglGetLayerPaletteEntries == wglGetLayerPaletteEntries)
    {
      traceWarning("Ignoring wglGetLayerPaletteEntries loaded from traceWGL library.");
      traceWGL_Native.wglGetLayerPaletteEntries = NULL;
    }
  }
  else
  {
    traceWarning("wglGetLayerPaletteEntries not loaded.");
  }
  if (traceWGL_Native.wglRealizeLayerPalette)
  {
    if (traceWGL_Native.wglRealizeLayerPalette == wglRealizeLayerPalette)
    {
      traceWarning("Ignoring wglRealizeLayerPalette loaded from traceWGL library.");
      traceWGL_Native.wglRealizeLayerPalette = NULL;
    }
  }
  else
  {
    traceWarning("wglRealizeLayerPalette not loaded.");
  }
  if (traceWGL_Native.wglSwapLayerBuffers)
  {
    if (traceWGL_Native.wglSwapLayerBuffers == wglSwapLayerBuffers)
    {
      traceWarning("Ignoring wglSwapLayerBuffers loaded from traceWGL library.");
      traceWGL_Native.wglSwapLayerBuffers = NULL;
    }
  }
  else
  {
    traceWarning("wglSwapLayerBuffers not loaded.");
  }
  if (traceWGL_Native.wglSwapMultipleBuffers)
  {
    if (traceWGL_Native.wglSwapMultipleBuffers == wglSwapMultipleBuffers)
    {
      traceWarning("Ignoring wglSwapMultipleBuffers loaded from traceWGL library.");
      traceWGL_Native.wglSwapMultipleBuffers = NULL;
    }
  }
  else
  {
    traceWarning("wglSwapMultipleBuffers not loaded.");
  }

  traceWGL_initialized = 1;
}

/* WGL API wrapper functions. */

int GLAPIENTRY
wglChoosePixelFormat(HDC hDC, const PIXELFORMATDESCRIPTOR *ppfd)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglChoosePixelFormat)
    traceWGL_lookupNativeAddress("wglChoosePixelFormat", (void **) &traceWGL_Native.wglChoosePixelFormat);

  traceThis = traceEnabled("wglChoosePixelFormat",&traceParam);

  if (!traceWGL_Native.wglChoosePixelFormat)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglChoosePixelFormat");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglChoosePixelFormat(hDC, ppfd);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglDescribePixelFormat(HDC hDC, int iPixelFormat, UINT nBytes, LPPIXELFORMATDESCRIPTOR ppfd)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDescribePixelFormat)
    traceWGL_lookupNativeAddress("wglDescribePixelFormat", (void **) &traceWGL_Native.wglDescribePixelFormat);

  traceThis = traceEnabled("wglDescribePixelFormat",&traceParam);

  if (!traceWGL_Native.wglDescribePixelFormat)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDescribePixelFormat");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("nBytes", "%u", nBytes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDescribePixelFormat(hDC, iPixelFormat, nBytes, ppfd);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglGetPixelFormat(HDC hDC)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPixelFormat)
    traceWGL_lookupNativeAddress("wglGetPixelFormat", (void **) &traceWGL_Native.wglGetPixelFormat);

  traceThis = traceEnabled("wglGetPixelFormat",&traceParam);

  if (!traceWGL_Native.wglGetPixelFormat)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPixelFormat");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPixelFormat(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSetPixelFormat(HDC hDC, int iPixelFormat, const PIXELFORMATDESCRIPTOR *ppfd)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetPixelFormat)
    traceWGL_lookupNativeAddress("wglSetPixelFormat", (void **) &traceWGL_Native.wglSetPixelFormat);

  traceThis = traceEnabled("wglSetPixelFormat",&traceParam);

  if (!traceWGL_Native.wglSetPixelFormat)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetPixelFormat");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetPixelFormat(hDC, iPixelFormat, ppfd);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSwapBuffers(HDC hDC)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSwapBuffers)
    traceWGL_lookupNativeAddress("wglSwapBuffers", (void **) &traceWGL_Native.wglSwapBuffers);

  traceThis = traceEnabled("wglSwapBuffers",&traceParam);

  if (!traceWGL_Native.wglSwapBuffers)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSwapBuffers");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSwapBuffers(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglCreateContext(HDC hDC)
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateContext)
    traceWGL_lookupNativeAddress("wglCreateContext", (void **) &traceWGL_Native.wglCreateContext);

  traceThis = traceEnabled("wglCreateContext",&traceParam);

  if (!traceWGL_Native.wglCreateContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateContext(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglCreateLayerContext(HDC hDC, int iLayerPlane)
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateLayerContext)
    traceWGL_lookupNativeAddress("wglCreateLayerContext", (void **) &traceWGL_Native.wglCreateLayerContext);

  traceThis = traceEnabled("wglCreateLayerContext",&traceParam);

  if (!traceWGL_Native.wglCreateLayerContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateLayerContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateLayerContext(hDC, iLayerPlane);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglCopyContext(HGLRC hglrcSrc, HGLRC hglrcDst, UINT mask)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCopyContext)
    traceWGL_lookupNativeAddress("wglCopyContext", (void **) &traceWGL_Native.wglCopyContext);

  traceThis = traceEnabled("wglCopyContext",&traceParam);

  if (!traceWGL_Native.wglCopyContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCopyContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hglrcSrc", "%p", hglrcSrc);
      traceInputParameter("hglrcDst", "%p", hglrcDst);
      traceInputParameter("mask", "%u", mask);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCopyContext(hglrcSrc, hglrcDst, mask);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDeleteContext(HGLRC hglrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDeleteContext)
    traceWGL_lookupNativeAddress("wglDeleteContext", (void **) &traceWGL_Native.wglDeleteContext);

  traceThis = traceEnabled("wglDeleteContext",&traceParam);

  if (!traceWGL_Native.wglDeleteContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDeleteContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hglrc", "%p", hglrc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDeleteContext(hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglGetCurrentContext()
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetCurrentContext)
    traceWGL_lookupNativeAddress("wglGetCurrentContext", (void **) &traceWGL_Native.wglGetCurrentContext);

  traceThis = traceEnabled("wglGetCurrentContext",&traceParam);

  if (!traceWGL_Native.wglGetCurrentContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetCurrentContext");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetCurrentContext();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HDC GLAPIENTRY
wglGetCurrentDC()
{
  HDC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetCurrentDC)
    traceWGL_lookupNativeAddress("wglGetCurrentDC", (void **) &traceWGL_Native.wglGetCurrentDC);

  traceThis = traceEnabled("wglGetCurrentDC",&traceParam);

  if (!traceWGL_Native.wglGetCurrentDC)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetCurrentDC");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetCurrentDC();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

PROC GLAPIENTRY
wglGetDefaultProcAddress(LPCSTR lpszProc)
{
  PROC ret = NULL;
  PROC retSwap = NULL;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetDefaultProcAddress)
    traceWGL_lookupNativeAddress("wglGetDefaultProcAddress", (void **) &traceWGL_Native.wglGetDefaultProcAddress);

  traceThis = traceEnabled("wglGetDefaultProcAddress",&traceParam);

  if (!traceWGL_Native.wglGetDefaultProcAddress)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetDefaultProcAddress");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("lpszProc", "%s", lpszProc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetDefaultProcAddress(lpszProc);
  retSwap = traceWGL_lookupWrapperAddress(lpszProc, ret);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", (void *) ret);

    /* Trace function end. */

    traceEnd();
  }

  return retSwap;
}

PROC GLAPIENTRY
wglGetProcAddress(LPCSTR lpszProc)
{
  PROC ret = NULL;
  PROC retSwap = NULL;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetProcAddress)
    traceWGL_lookupNativeAddress("wglGetProcAddress", (void **) &traceWGL_Native.wglGetProcAddress);

  traceThis = traceEnabled("wglGetProcAddress",&traceParam);

  if (!traceWGL_Native.wglGetProcAddress)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetProcAddress");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("lpszProc", "%s", lpszProc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetProcAddress(lpszProc);
  retSwap = traceWGL_lookupWrapperAddress(lpszProc, ret);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", (void *) ret);

    /* Trace function end. */

    traceEnd();
  }

  return retSwap;
}

BOOL GLAPIENTRY
wglMakeCurrent(HDC hDC, HGLRC hglrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglMakeCurrent)
    traceWGL_lookupNativeAddress("wglMakeCurrent", (void **) &traceWGL_Native.wglMakeCurrent);

  traceThis = traceEnabled("wglMakeCurrent",&traceParam);

  if (!traceWGL_Native.wglMakeCurrent)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglMakeCurrent");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("hglrc", "%p", hglrc);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglMakeCurrent(hDC, hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglShareLists(HGLRC hglrcShare, HGLRC hglrcSrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglShareLists)
    traceWGL_lookupNativeAddress("wglShareLists", (void **) &traceWGL_Native.wglShareLists);

  traceThis = traceEnabled("wglShareLists",&traceParam);

  if (!traceWGL_Native.wglShareLists)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglShareLists");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hglrcShare", "%p", hglrcShare);
      traceInputParameter("hglrcSrc", "%p", hglrcSrc);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglShareLists(hglrcShare, hglrcSrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglUseFontBitmapsA(HDC hDC, DWORD first, DWORD count, DWORD listBase)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglUseFontBitmapsA)
    traceWGL_lookupNativeAddress("wglUseFontBitmapsA", (void **) &traceWGL_Native.wglUseFontBitmapsA);

  traceThis = traceEnabled("wglUseFontBitmapsA",&traceParam);

  if (!traceWGL_Native.wglUseFontBitmapsA)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglUseFontBitmapsA");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("first", "%lu", first);
      traceInputParameter("count", "%lu", count);
      traceInputParameter("listBase", "%lu", listBase);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglUseFontBitmapsA(hDC, first, count, listBase);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglUseFontBitmapsW(HDC hDC, DWORD first, DWORD count, DWORD listBase)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglUseFontBitmapsW)
    traceWGL_lookupNativeAddress("wglUseFontBitmapsW", (void **) &traceWGL_Native.wglUseFontBitmapsW);

  traceThis = traceEnabled("wglUseFontBitmapsW",&traceParam);

  if (!traceWGL_Native.wglUseFontBitmapsW)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglUseFontBitmapsW");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("first", "%lu", first);
      traceInputParameter("count", "%lu", count);
      traceInputParameter("listBase", "%lu", listBase);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglUseFontBitmapsW(hDC, first, count, listBase);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglUseFontOutlinesA(HDC hDC, DWORD first, DWORD count, DWORD listBase, FLOAT deviation, FLOAT extrusion, int format, LPGLYPHMETRICSFLOAT lpgmf)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglUseFontOutlinesA)
    traceWGL_lookupNativeAddress("wglUseFontOutlinesA", (void **) &traceWGL_Native.wglUseFontOutlinesA);

  traceThis = traceEnabled("wglUseFontOutlinesA",&traceParam);

  if (!traceWGL_Native.wglUseFontOutlinesA)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglUseFontOutlinesA");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("first", "%lu", first);
      traceInputParameter("count", "%lu", count);
      traceInputParameter("listBase", "%lu", listBase);
      traceInputParameter("deviation", "%f", deviation);
      traceInputParameter("extrusion", "%f", extrusion);
      traceInputParameter("format", "%d", format);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglUseFontOutlinesA(hDC, first, count, listBase, deviation, extrusion, format, lpgmf);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglUseFontOutlinesW(HDC hDC, DWORD first, DWORD count, DWORD listBase, FLOAT deviation, FLOAT extrusion, int format, LPGLYPHMETRICSFLOAT lpgmf)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglUseFontOutlinesW)
    traceWGL_lookupNativeAddress("wglUseFontOutlinesW", (void **) &traceWGL_Native.wglUseFontOutlinesW);

  traceThis = traceEnabled("wglUseFontOutlinesW",&traceParam);

  if (!traceWGL_Native.wglUseFontOutlinesW)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglUseFontOutlinesW");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("first", "%lu", first);
      traceInputParameter("count", "%lu", count);
      traceInputParameter("listBase", "%lu", listBase);
      traceInputParameter("deviation", "%f", deviation);
      traceInputParameter("extrusion", "%f", extrusion);
      traceInputParameter("format", "%d", format);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglUseFontOutlinesW(hDC, first, count, listBase, deviation, extrusion, format, lpgmf);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDescribeLayerPlane(HDC hDC, int iPixelFormat, int iLayerPlane, UINT nBytes, LPLAYERPLANEDESCRIPTOR plpd)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDescribeLayerPlane)
    traceWGL_lookupNativeAddress("wglDescribeLayerPlane", (void **) &traceWGL_Native.wglDescribeLayerPlane);

  traceThis = traceEnabled("wglDescribeLayerPlane",&traceParam);

  if (!traceWGL_Native.wglDescribeLayerPlane)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDescribeLayerPlane");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("nBytes", "%u", nBytes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDescribeLayerPlane(hDC, iPixelFormat, iLayerPlane, nBytes, plpd);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglSetLayerPaletteEntries(HDC hDC, int iLayerPlane, int iStart, int nEntries, const COLORREF *pcr)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetLayerPaletteEntries)
    traceWGL_lookupNativeAddress("wglSetLayerPaletteEntries", (void **) &traceWGL_Native.wglSetLayerPaletteEntries);

  traceThis = traceEnabled("wglSetLayerPaletteEntries",&traceParam);

  if (!traceWGL_Native.wglSetLayerPaletteEntries)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetLayerPaletteEntries");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("iStart", "%d", iStart);
      traceInputParameter("nEntries", "%d", nEntries);
      traceInputParameter("pcr", "%lu[%d]", pcr, nEntries);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetLayerPaletteEntries(hDC, iLayerPlane, iStart, nEntries, pcr);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglGetLayerPaletteEntries(HDC hDC, int iLayerPlane, int iStart, int nEntries, COLORREF *pcr)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetLayerPaletteEntries)
    traceWGL_lookupNativeAddress("wglGetLayerPaletteEntries", (void **) &traceWGL_Native.wglGetLayerPaletteEntries);

  traceThis = traceEnabled("wglGetLayerPaletteEntries",&traceParam);

  if (!traceWGL_Native.wglGetLayerPaletteEntries)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetLayerPaletteEntries");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("iStart", "%d", iStart);
      traceInputParameter("nEntries", "%d", nEntries);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetLayerPaletteEntries(hDC, iLayerPlane, iStart, nEntries, pcr);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pcr", "%lu[%d]", pcr, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglRealizeLayerPalette(HDC hDC, int iLayerPlane, BOOL bRealize)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglRealizeLayerPalette)
    traceWGL_lookupNativeAddress("wglRealizeLayerPalette", (void **) &traceWGL_Native.wglRealizeLayerPalette);

  traceThis = traceEnabled("wglRealizeLayerPalette",&traceParam);

  if (!traceWGL_Native.wglRealizeLayerPalette)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglRealizeLayerPalette");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("bRealize", "%d", bRealize);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglRealizeLayerPalette(hDC, iLayerPlane, bRealize);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSwapLayerBuffers(HDC hDC, UINT fuPlanes)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSwapLayerBuffers)
    traceWGL_lookupNativeAddress("wglSwapLayerBuffers", (void **) &traceWGL_Native.wglSwapLayerBuffers);

  traceThis = traceEnabled("wglSwapLayerBuffers",&traceParam);

  if (!traceWGL_Native.wglSwapLayerBuffers)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSwapLayerBuffers");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("fuPlanes", "%u", fuPlanes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSwapLayerBuffers(hDC, fuPlanes);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DWORD GLAPIENTRY
wglSwapMultipleBuffers(UINT n, const WGLSWAP *ps)
{
  DWORD ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSwapMultipleBuffers)
    traceWGL_lookupNativeAddress("wglSwapMultipleBuffers", (void **) &traceWGL_Native.wglSwapMultipleBuffers);

  traceThis = traceEnabled("wglSwapMultipleBuffers",&traceParam);

  if (!traceWGL_Native.wglSwapMultipleBuffers)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSwapMultipleBuffers");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("n", "%u", n);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSwapMultipleBuffers(n, ps);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HANDLE GLAPIENTRY
wglCreateBufferRegionARB(HDC hDC, int iLayerPlane, UINT uType)
{
  HANDLE ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateBufferRegionARB)
    traceWGL_lookupNativeAddress("wglCreateBufferRegionARB", (void **) &traceWGL_Native.wglCreateBufferRegionARB);

  traceThis = traceEnabled("wglCreateBufferRegionARB",&traceParam);

  if (!traceWGL_Native.wglCreateBufferRegionARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateBufferRegionARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("uType", "%u", uType);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateBufferRegionARB(hDC, iLayerPlane, uType);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

VOID GLAPIENTRY
wglDeleteBufferRegionARB(HANDLE hRegion)
{
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDeleteBufferRegionARB)
    traceWGL_lookupNativeAddress("wglDeleteBufferRegionARB", (void **) &traceWGL_Native.wglDeleteBufferRegionARB);

  traceThis = traceEnabled("wglDeleteBufferRegionARB",&traceParam);

  if (!traceWGL_Native.wglDeleteBufferRegionARB)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDeleteBufferRegionARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hRegion", "%p", hRegion);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceWGL_Native.wglDeleteBufferRegionARB(hRegion);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

BOOL GLAPIENTRY
wglSaveBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSaveBufferRegionARB)
    traceWGL_lookupNativeAddress("wglSaveBufferRegionARB", (void **) &traceWGL_Native.wglSaveBufferRegionARB);

  traceThis = traceEnabled("wglSaveBufferRegionARB",&traceParam);

  if (!traceWGL_Native.wglSaveBufferRegionARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSaveBufferRegionARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hRegion", "%p", hRegion);
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
      traceInputParameter("width", "%d", width);
      traceInputParameter("height", "%d", height);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSaveBufferRegionARB(hRegion, x, y, width, height);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglRestoreBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglRestoreBufferRegionARB)
    traceWGL_lookupNativeAddress("wglRestoreBufferRegionARB", (void **) &traceWGL_Native.wglRestoreBufferRegionARB);

  traceThis = traceEnabled("wglRestoreBufferRegionARB",&traceParam);

  if (!traceWGL_Native.wglRestoreBufferRegionARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglRestoreBufferRegionARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hRegion", "%p", hRegion);
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
      traceInputParameter("width", "%d", width);
      traceInputParameter("height", "%d", height);
      traceInputParameter("xSrc", "%d", xSrc);
      traceInputParameter("ySrc", "%d", ySrc);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglRestoreBufferRegionARB(hRegion, x, y, width, height, xSrc, ySrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

const char *GLAPIENTRY
wglGetExtensionsStringARB(HDC hDC)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetExtensionsStringARB)
    traceWGL_lookupNativeAddress("wglGetExtensionsStringARB", (void **) &traceWGL_Native.wglGetExtensionsStringARB);

  traceThis = traceEnabled("wglGetExtensionsStringARB",&traceParam);

  if (!traceWGL_Native.wglGetExtensionsStringARB)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetExtensionsStringARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetExtensionsStringARB(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetPixelFormatAttribivARB(HDC hDC, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, int *piValues)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPixelFormatAttribivARB)
    traceWGL_lookupNativeAddress("wglGetPixelFormatAttribivARB", (void **) &traceWGL_Native.wglGetPixelFormatAttribivARB);

  traceThis = traceEnabled("wglGetPixelFormatAttribivARB",&traceParam);

  if (!traceWGL_Native.wglGetPixelFormatAttribivARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPixelFormatAttribivARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("nAttributes", "%u", nAttributes);
      traceInputParameter("piAttributes", "%d[%d]", piAttributes, nAttributes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPixelFormatAttribivARB(hDC, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("piValues", "%d[%d]", piValues, nAttributes);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetPixelFormatAttribfvARB(HDC hDC, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, FLOAT *pfValues)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPixelFormatAttribfvARB)
    traceWGL_lookupNativeAddress("wglGetPixelFormatAttribfvARB", (void **) &traceWGL_Native.wglGetPixelFormatAttribfvARB);

  traceThis = traceEnabled("wglGetPixelFormatAttribfvARB",&traceParam);

  if (!traceWGL_Native.wglGetPixelFormatAttribfvARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPixelFormatAttribfvARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("nAttributes", "%u", nAttributes);
      traceInputParameter("piAttributes", "%d[%d]", piAttributes, nAttributes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPixelFormatAttribfvARB(hDC, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pfValues", "%f[%d]", pfValues, nAttributes);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglChoosePixelFormatARB(HDC hDC, const int *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglChoosePixelFormatARB)
    traceWGL_lookupNativeAddress("wglChoosePixelFormatARB", (void **) &traceWGL_Native.wglChoosePixelFormatARB);

  traceThis = traceEnabled("wglChoosePixelFormatARB",&traceParam);

  if (!traceWGL_Native.wglChoosePixelFormatARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglChoosePixelFormatARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("nMaxFormats", "%u", nMaxFormats);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglChoosePixelFormatARB(hDC, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nNumFormats", "%u[%d]", nNumFormats, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglMakeContextCurrentARB(HDC hDrawDC, HDC hReadDC, HGLRC hglrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglMakeContextCurrentARB)
    traceWGL_lookupNativeAddress("wglMakeContextCurrentARB", (void **) &traceWGL_Native.wglMakeContextCurrentARB);

  traceThis = traceEnabled("wglMakeContextCurrentARB",&traceParam);

  if (!traceWGL_Native.wglMakeContextCurrentARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglMakeContextCurrentARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDrawDC", "%p", hDrawDC);
      traceInputParameter("hReadDC", "%p", hReadDC);
      traceInputParameter("hglrc", "%p", hglrc);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglMakeContextCurrentARB(hDrawDC, hReadDC, hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HDC GLAPIENTRY
wglGetCurrentReadDCARB()
{
  HDC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetCurrentReadDCARB)
    traceWGL_lookupNativeAddress("wglGetCurrentReadDCARB", (void **) &traceWGL_Native.wglGetCurrentReadDCARB);

  traceThis = traceEnabled("wglGetCurrentReadDCARB",&traceParam);

  if (!traceWGL_Native.wglGetCurrentReadDCARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetCurrentReadDCARB");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetCurrentReadDCARB();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HPBUFFERARB GLAPIENTRY
wglCreatePbufferARB(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int *piAttribList)
{
  HPBUFFERARB ret = (HPBUFFERARB) 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreatePbufferARB)
    traceWGL_lookupNativeAddress("wglCreatePbufferARB", (void **) &traceWGL_Native.wglCreatePbufferARB);

  traceThis = traceEnabled("wglCreatePbufferARB",&traceParam);

  if (!traceWGL_Native.wglCreatePbufferARB)
    return (HPBUFFERARB) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreatePbufferARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iWidth", "%d", iWidth);
      traceInputParameter("iHeight", "%d", iHeight);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreatePbufferARB(hDC, iPixelFormat, iWidth, iHeight, piAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HDC GLAPIENTRY
wglGetPbufferDCARB(HPBUFFERARB hPbuffer)
{
  HDC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPbufferDCARB)
    traceWGL_lookupNativeAddress("wglGetPbufferDCARB", (void **) &traceWGL_Native.wglGetPbufferDCARB);

  traceThis = traceEnabled("wglGetPbufferDCARB",&traceParam);

  if (!traceWGL_Native.wglGetPbufferDCARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPbufferDCARB");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPbufferDCARB(hPbuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglReleasePbufferDCARB(HPBUFFERARB hPbuffer, HDC hDC)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleasePbufferDCARB)
    traceWGL_lookupNativeAddress("wglReleasePbufferDCARB", (void **) &traceWGL_Native.wglReleasePbufferDCARB);

  traceThis = traceEnabled("wglReleasePbufferDCARB",&traceParam);

  if (!traceWGL_Native.wglReleasePbufferDCARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleasePbufferDCARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleasePbufferDCARB(hPbuffer, hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDestroyPbufferARB(HPBUFFERARB hPbuffer)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDestroyPbufferARB)
    traceWGL_lookupNativeAddress("wglDestroyPbufferARB", (void **) &traceWGL_Native.wglDestroyPbufferARB);

  traceThis = traceEnabled("wglDestroyPbufferARB",&traceParam);

  if (!traceWGL_Native.wglDestroyPbufferARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDestroyPbufferARB");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDestroyPbufferARB(hPbuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryPbufferARB(HPBUFFERARB hPbuffer, int iAttribute, int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryPbufferARB)
    traceWGL_lookupNativeAddress("wglQueryPbufferARB", (void **) &traceWGL_Native.wglQueryPbufferARB);

  traceThis = traceEnabled("wglQueryPbufferARB",&traceParam);

  if (!traceWGL_Native.wglQueryPbufferARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryPbufferARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iAttribute", "%d", iAttribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryPbufferARB(hPbuffer, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("piValue", "%d[%d]", piValue, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglBindTexImageARB(HPBUFFERARB hPbuffer, int iBuffer)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBindTexImageARB)
    traceWGL_lookupNativeAddress("wglBindTexImageARB", (void **) &traceWGL_Native.wglBindTexImageARB);

  traceThis = traceEnabled("wglBindTexImageARB",&traceParam);

  if (!traceWGL_Native.wglBindTexImageARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBindTexImageARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iBuffer", "%d", iBuffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBindTexImageARB(hPbuffer, iBuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglReleaseTexImageARB(HPBUFFERARB hPbuffer, int iBuffer)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleaseTexImageARB)
    traceWGL_lookupNativeAddress("wglReleaseTexImageARB", (void **) &traceWGL_Native.wglReleaseTexImageARB);

  traceThis = traceEnabled("wglReleaseTexImageARB",&traceParam);

  if (!traceWGL_Native.wglReleaseTexImageARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleaseTexImageARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iBuffer", "%d", iBuffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleaseTexImageARB(hPbuffer, iBuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSetPbufferAttribARB(HPBUFFERARB hPbuffer, const int *piAttribList)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetPbufferAttribARB)
    traceWGL_lookupNativeAddress("wglSetPbufferAttribARB", (void **) &traceWGL_Native.wglSetPbufferAttribARB);

  traceThis = traceEnabled("wglSetPbufferAttribARB",&traceParam);

  if (!traceWGL_Native.wglSetPbufferAttribARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetPbufferAttribARB");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetPbufferAttribARB(hPbuffer, piAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglCreateContextAttribsARB(HDC hDC, HGLRC hShareContext, const int *piAttribList)
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateContextAttribsARB)
    traceWGL_lookupNativeAddress("wglCreateContextAttribsARB", (void **) &traceWGL_Native.wglCreateContextAttribsARB);

  traceThis = traceEnabled("wglCreateContextAttribsARB",&traceParam);

  if (!traceWGL_Native.wglCreateContextAttribsARB)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateContextAttribsARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("hShareContext", "%p", hShareContext);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateContextAttribsARB(hDC, hShareContext, piAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

GLboolean GLAPIENTRY
wglCreateDisplayColorTableEXT(GLushort id)
{
  GLboolean ret = GL_FALSE;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateDisplayColorTableEXT)
    traceWGL_lookupNativeAddress("wglCreateDisplayColorTableEXT", (void **) &traceWGL_Native.wglCreateDisplayColorTableEXT);

  traceThis = traceEnabled("wglCreateDisplayColorTableEXT",&traceParam);

  if (!traceWGL_Native.wglCreateDisplayColorTableEXT)
    return GL_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateDisplayColorTableEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("id", "%hu", id);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateDisplayColorTableEXT(id);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", (unsigned int) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

GLboolean GLAPIENTRY
wglLoadDisplayColorTableEXT(const GLushort *table, GLuint length)
{
  GLboolean ret = GL_FALSE;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglLoadDisplayColorTableEXT)
    traceWGL_lookupNativeAddress("wglLoadDisplayColorTableEXT", (void **) &traceWGL_Native.wglLoadDisplayColorTableEXT);

  traceThis = traceEnabled("wglLoadDisplayColorTableEXT",&traceParam);

  if (!traceWGL_Native.wglLoadDisplayColorTableEXT)
    return GL_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglLoadDisplayColorTableEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("table", "%hu[%d]", table, length);
      traceInputParameter("length", "%u", length);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglLoadDisplayColorTableEXT(table, length);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", (unsigned int) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

GLboolean GLAPIENTRY
wglBindDisplayColorTableEXT(GLushort id)
{
  GLboolean ret = GL_FALSE;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBindDisplayColorTableEXT)
    traceWGL_lookupNativeAddress("wglBindDisplayColorTableEXT", (void **) &traceWGL_Native.wglBindDisplayColorTableEXT);

  traceThis = traceEnabled("wglBindDisplayColorTableEXT",&traceParam);

  if (!traceWGL_Native.wglBindDisplayColorTableEXT)
    return GL_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBindDisplayColorTableEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("id", "%hu", id);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBindDisplayColorTableEXT(id);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", (unsigned int) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

VOID GLAPIENTRY
wglDestroyDisplayColorTableEXT(GLushort id)
{
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDestroyDisplayColorTableEXT)
    traceWGL_lookupNativeAddress("wglDestroyDisplayColorTableEXT", (void **) &traceWGL_Native.wglDestroyDisplayColorTableEXT);

  traceThis = traceEnabled("wglDestroyDisplayColorTableEXT",&traceParam);

  if (!traceWGL_Native.wglDestroyDisplayColorTableEXT)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDestroyDisplayColorTableEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("id", "%hu", id);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceWGL_Native.wglDestroyDisplayColorTableEXT(id);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

const char *GLAPIENTRY
wglGetExtensionsStringEXT()
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetExtensionsStringEXT)
    traceWGL_lookupNativeAddress("wglGetExtensionsStringEXT", (void **) &traceWGL_Native.wglGetExtensionsStringEXT);

  traceThis = traceEnabled("wglGetExtensionsStringEXT",&traceParam);

  if (!traceWGL_Native.wglGetExtensionsStringEXT)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetExtensionsStringEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetExtensionsStringEXT();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglMakeContextCurrentEXT(HDC hDrawDC, HDC hReadDC, HGLRC hglrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglMakeContextCurrentEXT)
    traceWGL_lookupNativeAddress("wglMakeContextCurrentEXT", (void **) &traceWGL_Native.wglMakeContextCurrentEXT);

  traceThis = traceEnabled("wglMakeContextCurrentEXT",&traceParam);

  if (!traceWGL_Native.wglMakeContextCurrentEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglMakeContextCurrentEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDrawDC", "%p", hDrawDC);
      traceInputParameter("hReadDC", "%p", hReadDC);
      traceInputParameter("hglrc", "%p", hglrc);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglMakeContextCurrentEXT(hDrawDC, hReadDC, hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HDC GLAPIENTRY
wglGetCurrentReadDCEXT()
{
  HDC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetCurrentReadDCEXT)
    traceWGL_lookupNativeAddress("wglGetCurrentReadDCEXT", (void **) &traceWGL_Native.wglGetCurrentReadDCEXT);

  traceThis = traceEnabled("wglGetCurrentReadDCEXT",&traceParam);

  if (!traceWGL_Native.wglGetCurrentReadDCEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetCurrentReadDCEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetCurrentReadDCEXT();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetPixelFormatAttribivEXT(HDC hDC, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, int *piValues)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPixelFormatAttribivEXT)
    traceWGL_lookupNativeAddress("wglGetPixelFormatAttribivEXT", (void **) &traceWGL_Native.wglGetPixelFormatAttribivEXT);

  traceThis = traceEnabled("wglGetPixelFormatAttribivEXT",&traceParam);

  if (!traceWGL_Native.wglGetPixelFormatAttribivEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPixelFormatAttribivEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("nAttributes", "%u", nAttributes);
      traceInputParameter("piAttributes", "%d[%d]", piAttributes, nAttributes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPixelFormatAttribivEXT(hDC, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("piValues", "%d[%d]", piValues, nAttributes);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetPixelFormatAttribfvEXT(HDC hDC, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, FLOAT *pfValues)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPixelFormatAttribfvEXT)
    traceWGL_lookupNativeAddress("wglGetPixelFormatAttribfvEXT", (void **) &traceWGL_Native.wglGetPixelFormatAttribfvEXT);

  traceThis = traceEnabled("wglGetPixelFormatAttribfvEXT",&traceParam);

  if (!traceWGL_Native.wglGetPixelFormatAttribfvEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPixelFormatAttribfvEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iLayerPlane", "%d", iLayerPlane);
      traceInputParameter("nAttributes", "%u", nAttributes);
      traceInputParameter("piAttributes", "%d[%d]", piAttributes, nAttributes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPixelFormatAttribfvEXT(hDC, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pfValues", "%f[%d]", pfValues, nAttributes);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglChoosePixelFormatEXT(HDC hDC, const int *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglChoosePixelFormatEXT)
    traceWGL_lookupNativeAddress("wglChoosePixelFormatEXT", (void **) &traceWGL_Native.wglChoosePixelFormatEXT);

  traceThis = traceEnabled("wglChoosePixelFormatEXT",&traceParam);

  if (!traceWGL_Native.wglChoosePixelFormatEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglChoosePixelFormatEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("nMaxFormats", "%u", nMaxFormats);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglChoosePixelFormatEXT(hDC, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nNumFormats", "%u[%d]", nNumFormats, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HPBUFFEREXT GLAPIENTRY
wglCreatePbufferEXT(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int *piAttribList)
{
  HPBUFFEREXT ret = (HPBUFFEREXT) 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreatePbufferEXT)
    traceWGL_lookupNativeAddress("wglCreatePbufferEXT", (void **) &traceWGL_Native.wglCreatePbufferEXT);

  traceThis = traceEnabled("wglCreatePbufferEXT",&traceParam);

  if (!traceWGL_Native.wglCreatePbufferEXT)
    return (HPBUFFEREXT) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreatePbufferEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iPixelFormat", "%d", iPixelFormat);
      traceInputParameter("iWidth", "%d", iWidth);
      traceInputParameter("iHeight", "%d", iHeight);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreatePbufferEXT(hDC, iPixelFormat, iWidth, iHeight, piAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HDC GLAPIENTRY
wglGetPbufferDCEXT(HPBUFFEREXT hPbuffer)
{
  HDC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetPbufferDCEXT)
    traceWGL_lookupNativeAddress("wglGetPbufferDCEXT", (void **) &traceWGL_Native.wglGetPbufferDCEXT);

  traceThis = traceEnabled("wglGetPbufferDCEXT",&traceParam);

  if (!traceWGL_Native.wglGetPbufferDCEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetPbufferDCEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetPbufferDCEXT(hPbuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglReleasePbufferDCEXT(HPBUFFEREXT hPbuffer, HDC hDC)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleasePbufferDCEXT)
    traceWGL_lookupNativeAddress("wglReleasePbufferDCEXT", (void **) &traceWGL_Native.wglReleasePbufferDCEXT);

  traceThis = traceEnabled("wglReleasePbufferDCEXT",&traceParam);

  if (!traceWGL_Native.wglReleasePbufferDCEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleasePbufferDCEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleasePbufferDCEXT(hPbuffer, hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDestroyPbufferEXT(HPBUFFEREXT hPbuffer)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDestroyPbufferEXT)
    traceWGL_lookupNativeAddress("wglDestroyPbufferEXT", (void **) &traceWGL_Native.wglDestroyPbufferEXT);

  traceThis = traceEnabled("wglDestroyPbufferEXT",&traceParam);

  if (!traceWGL_Native.wglDestroyPbufferEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDestroyPbufferEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDestroyPbufferEXT(hPbuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryPbufferEXT(HPBUFFEREXT hPbuffer, int iAttribute, int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryPbufferEXT)
    traceWGL_lookupNativeAddress("wglQueryPbufferEXT", (void **) &traceWGL_Native.wglQueryPbufferEXT);

  traceThis = traceEnabled("wglQueryPbufferEXT",&traceParam);

  if (!traceWGL_Native.wglQueryPbufferEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryPbufferEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iAttribute", "%d", iAttribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryPbufferEXT(hPbuffer, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("piValue", "%d[%d]", piValue, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSwapIntervalEXT(int interval)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSwapIntervalEXT)
    traceWGL_lookupNativeAddress("wglSwapIntervalEXT", (void **) &traceWGL_Native.wglSwapIntervalEXT);

  traceThis = traceEnabled("wglSwapIntervalEXT",&traceParam);

  if (!traceWGL_Native.wglSwapIntervalEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSwapIntervalEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("interval", "%d", interval);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSwapIntervalEXT(interval);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglGetSwapIntervalEXT()
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetSwapIntervalEXT)
    traceWGL_lookupNativeAddress("wglGetSwapIntervalEXT", (void **) &traceWGL_Native.wglGetSwapIntervalEXT);

  traceThis = traceEnabled("wglGetSwapIntervalEXT",&traceParam);

  if (!traceWGL_Native.wglGetSwapIntervalEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetSwapIntervalEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetSwapIntervalEXT();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

void *GLAPIENTRY
wglAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority)
{
  void *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglAllocateMemoryNV)
    traceWGL_lookupNativeAddress("wglAllocateMemoryNV", (void **) &traceWGL_Native.wglAllocateMemoryNV);

  traceThis = traceEnabled("wglAllocateMemoryNV",&traceParam);

  if (!traceWGL_Native.wglAllocateMemoryNV)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglAllocateMemoryNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("size", "%d", size);
      traceInputParameter("readfreq", "%f", readfreq);
      traceInputParameter("writefreq", "%f", writefreq);
      traceInputParameter("priority", "%f", priority);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglAllocateMemoryNV(size, readfreq, writefreq, priority);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

void GLAPIENTRY
wglFreeMemoryNV(void *pointer)
{
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglFreeMemoryNV)
    traceWGL_lookupNativeAddress("wglFreeMemoryNV", (void **) &traceWGL_Native.wglFreeMemoryNV);

  traceThis = traceEnabled("wglFreeMemoryNV",&traceParam);

  if (!traceWGL_Native.wglFreeMemoryNV)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglFreeMemoryNV");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceWGL_Native.wglFreeMemoryNV(pointer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

BOOL GLAPIENTRY
wglGetSyncValuesOML(HDC hDC, INT64 *ust, INT64 *msc, INT64 *sbc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetSyncValuesOML)
    traceWGL_lookupNativeAddress("wglGetSyncValuesOML", (void **) &traceWGL_Native.wglGetSyncValuesOML);

  traceThis = traceEnabled("wglGetSyncValuesOML",&traceParam);

  if (!traceWGL_Native.wglGetSyncValuesOML)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetSyncValuesOML");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetSyncValuesOML(hDC, ust, msc, sbc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetMscRateOML(HDC hDC, INT32 *numerator, INT32 *denominator)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetMscRateOML)
    traceWGL_lookupNativeAddress("wglGetMscRateOML", (void **) &traceWGL_Native.wglGetMscRateOML);

  traceThis = traceEnabled("wglGetMscRateOML",&traceParam);

  if (!traceWGL_Native.wglGetMscRateOML)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetMscRateOML");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetMscRateOML(hDC, numerator, denominator);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("numerator", "%d[%d]", numerator, 1);
      traceOutputParameter("denominator", "%d[%d]", denominator, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

INT64 GLAPIENTRY
wglSwapBuffersMscOML(HDC hDC, INT64 target_msc, INT64 divisor, INT64 remainder)
{
  INT64 ret = (INT64) 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSwapBuffersMscOML)
    traceWGL_lookupNativeAddress("wglSwapBuffersMscOML", (void **) &traceWGL_Native.wglSwapBuffersMscOML);

  traceThis = traceEnabled("wglSwapBuffersMscOML",&traceParam);

  if (!traceWGL_Native.wglSwapBuffersMscOML)
    return (INT64) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSwapBuffersMscOML");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSwapBuffersMscOML(hDC, target_msc, divisor, remainder);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

INT64 GLAPIENTRY
wglSwapLayerBuffersMscOML(HDC hDC, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder)
{
  INT64 ret = (INT64) 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSwapLayerBuffersMscOML)
    traceWGL_lookupNativeAddress("wglSwapLayerBuffersMscOML", (void **) &traceWGL_Native.wglSwapLayerBuffersMscOML);

  traceThis = traceEnabled("wglSwapLayerBuffersMscOML",&traceParam);

  if (!traceWGL_Native.wglSwapLayerBuffersMscOML)
    return (INT64) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSwapLayerBuffersMscOML");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("fuPlanes", "%d", fuPlanes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSwapLayerBuffersMscOML(hDC, fuPlanes, target_msc, divisor, remainder);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglWaitForMscOML(HDC hDC, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 *ust, INT64 *msc, INT64 *sbc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglWaitForMscOML)
    traceWGL_lookupNativeAddress("wglWaitForMscOML", (void **) &traceWGL_Native.wglWaitForMscOML);

  traceThis = traceEnabled("wglWaitForMscOML",&traceParam);

  if (!traceWGL_Native.wglWaitForMscOML)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglWaitForMscOML");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglWaitForMscOML(hDC, target_msc, divisor, remainder, ust, msc, sbc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglWaitForSbcOML(HDC hDC, INT64 target_sbc, INT64 *ust, INT64 *msc, INT64 *sbc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglWaitForSbcOML)
    traceWGL_lookupNativeAddress("wglWaitForSbcOML", (void **) &traceWGL_Native.wglWaitForSbcOML);

  traceThis = traceEnabled("wglWaitForSbcOML",&traceParam);

  if (!traceWGL_Native.wglWaitForSbcOML)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglWaitForSbcOML");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglWaitForSbcOML(hDC, target_sbc, ust, msc, sbc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetDigitalVideoParametersI3D(HDC hDC, int iAttribute, int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetDigitalVideoParametersI3D)
    traceWGL_lookupNativeAddress("wglGetDigitalVideoParametersI3D", (void **) &traceWGL_Native.wglGetDigitalVideoParametersI3D);

  traceThis = traceEnabled("wglGetDigitalVideoParametersI3D",&traceParam);

  if (!traceWGL_Native.wglGetDigitalVideoParametersI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetDigitalVideoParametersI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iAttribute", "%d", iAttribute);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetDigitalVideoParametersI3D(hDC, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSetDigitalVideoParametersI3D(HDC hDC, int iAttribute, const int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetDigitalVideoParametersI3D)
    traceWGL_lookupNativeAddress("wglSetDigitalVideoParametersI3D", (void **) &traceWGL_Native.wglSetDigitalVideoParametersI3D);

  traceThis = traceEnabled("wglSetDigitalVideoParametersI3D",&traceParam);

  if (!traceWGL_Native.wglSetDigitalVideoParametersI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetDigitalVideoParametersI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iAttribute", "%d", iAttribute);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetDigitalVideoParametersI3D(hDC, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetGammaTableParametersI3D(HDC hDC, int iAttribute, int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGammaTableParametersI3D)
    traceWGL_lookupNativeAddress("wglGetGammaTableParametersI3D", (void **) &traceWGL_Native.wglGetGammaTableParametersI3D);

  traceThis = traceEnabled("wglGetGammaTableParametersI3D",&traceParam);

  if (!traceWGL_Native.wglGetGammaTableParametersI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGammaTableParametersI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iAttribute", "%d", iAttribute);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGammaTableParametersI3D(hDC, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSetGammaTableParametersI3D(HDC hDC, int iAttribute, const int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetGammaTableParametersI3D)
    traceWGL_lookupNativeAddress("wglSetGammaTableParametersI3D", (void **) &traceWGL_Native.wglSetGammaTableParametersI3D);

  traceThis = traceEnabled("wglSetGammaTableParametersI3D",&traceParam);

  if (!traceWGL_Native.wglSetGammaTableParametersI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetGammaTableParametersI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iAttribute", "%d", iAttribute);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetGammaTableParametersI3D(hDC, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetGammaTableI3D(HDC hDC, int iEntries, USHORT *puRed, USHORT *puGreen, USHORT *puBlue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGammaTableI3D)
    traceWGL_lookupNativeAddress("wglGetGammaTableI3D", (void **) &traceWGL_Native.wglGetGammaTableI3D);

  traceThis = traceEnabled("wglGetGammaTableI3D",&traceParam);

  if (!traceWGL_Native.wglGetGammaTableI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGammaTableI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGammaTableI3D(hDC, iEntries, puRed, puGreen, puBlue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("iEntries", "%d", iEntries);
      traceOutputParameter("puRed", "%hu[%d]", puRed, iEntries);
      traceOutputParameter("puGreen", "%hu[%d]", puGreen, iEntries);
      traceOutputParameter("puBlue", "%hu[%d]", puBlue, iEntries);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSetGammaTableI3D(HDC hDC, int iEntries, const USHORT *puRed, const USHORT *puGreen, const USHORT *puBlue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetGammaTableI3D)
    traceWGL_lookupNativeAddress("wglSetGammaTableI3D", (void **) &traceWGL_Native.wglSetGammaTableI3D);

  traceThis = traceEnabled("wglSetGammaTableI3D",&traceParam);

  if (!traceWGL_Native.wglSetGammaTableI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetGammaTableI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iEntries", "%d", iEntries);
      traceInputParameter("puRed", "%hu[%d]", puRed, iEntries);
      traceInputParameter("puGreen", "%hu[%d]", puGreen, iEntries);
      traceInputParameter("puBlue", "%hu[%d]", puBlue, iEntries);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetGammaTableI3D(hDC, iEntries, puRed, puGreen, puBlue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglEnableGenlockI3D(HDC hDC)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnableGenlockI3D)
    traceWGL_lookupNativeAddress("wglEnableGenlockI3D", (void **) &traceWGL_Native.wglEnableGenlockI3D);

  traceThis = traceEnabled("wglEnableGenlockI3D",&traceParam);

  if (!traceWGL_Native.wglEnableGenlockI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnableGenlockI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnableGenlockI3D(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDisableGenlockI3D(HDC hDC)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDisableGenlockI3D)
    traceWGL_lookupNativeAddress("wglDisableGenlockI3D", (void **) &traceWGL_Native.wglDisableGenlockI3D);

  traceThis = traceEnabled("wglDisableGenlockI3D",&traceParam);

  if (!traceWGL_Native.wglDisableGenlockI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDisableGenlockI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDisableGenlockI3D(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglIsEnabledGenlockI3D(HDC hDC, BOOL *pFlag)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglIsEnabledGenlockI3D)
    traceWGL_lookupNativeAddress("wglIsEnabledGenlockI3D", (void **) &traceWGL_Native.wglIsEnabledGenlockI3D);

  traceThis = traceEnabled("wglIsEnabledGenlockI3D",&traceParam);

  if (!traceWGL_Native.wglIsEnabledGenlockI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglIsEnabledGenlockI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglIsEnabledGenlockI3D(hDC, pFlag);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pFlag", "%d[%d]", pFlag, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGenlockSourceI3D(HDC hDC, UINT uSource)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGenlockSourceI3D)
    traceWGL_lookupNativeAddress("wglGenlockSourceI3D", (void **) &traceWGL_Native.wglGenlockSourceI3D);

  traceThis = traceEnabled("wglGenlockSourceI3D",&traceParam);

  if (!traceWGL_Native.wglGenlockSourceI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGenlockSourceI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("uSource", "%u", uSource);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGenlockSourceI3D(hDC, uSource);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetGenlockSourceI3D(HDC hDC, UINT *uSource)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGenlockSourceI3D)
    traceWGL_lookupNativeAddress("wglGetGenlockSourceI3D", (void **) &traceWGL_Native.wglGetGenlockSourceI3D);

  traceThis = traceEnabled("wglGetGenlockSourceI3D",&traceParam);

  if (!traceWGL_Native.wglGetGenlockSourceI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGenlockSourceI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGenlockSourceI3D(hDC, uSource);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("uSource", "%u[%d]", uSource, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGenlockSourceEdgeI3D(HDC hDC, UINT uEdge)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGenlockSourceEdgeI3D)
    traceWGL_lookupNativeAddress("wglGenlockSourceEdgeI3D", (void **) &traceWGL_Native.wglGenlockSourceEdgeI3D);

  traceThis = traceEnabled("wglGenlockSourceEdgeI3D",&traceParam);

  if (!traceWGL_Native.wglGenlockSourceEdgeI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGenlockSourceEdgeI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("uEdge", "%u", uEdge);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGenlockSourceEdgeI3D(hDC, uEdge);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetGenlockSourceEdgeI3D(HDC hDC, UINT *uEdge)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGenlockSourceEdgeI3D)
    traceWGL_lookupNativeAddress("wglGetGenlockSourceEdgeI3D", (void **) &traceWGL_Native.wglGetGenlockSourceEdgeI3D);

  traceThis = traceEnabled("wglGetGenlockSourceEdgeI3D",&traceParam);

  if (!traceWGL_Native.wglGetGenlockSourceEdgeI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGenlockSourceEdgeI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGenlockSourceEdgeI3D(hDC, uEdge);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("uEdge", "%u[%d]", uEdge, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGenlockSampleRateI3D(HDC hDC, UINT uRate)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGenlockSampleRateI3D)
    traceWGL_lookupNativeAddress("wglGenlockSampleRateI3D", (void **) &traceWGL_Native.wglGenlockSampleRateI3D);

  traceThis = traceEnabled("wglGenlockSampleRateI3D",&traceParam);

  if (!traceWGL_Native.wglGenlockSampleRateI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGenlockSampleRateI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("uRate", "%u", uRate);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGenlockSampleRateI3D(hDC, uRate);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetGenlockSampleRateI3D(HDC hDC, UINT *uRate)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGenlockSampleRateI3D)
    traceWGL_lookupNativeAddress("wglGetGenlockSampleRateI3D", (void **) &traceWGL_Native.wglGetGenlockSampleRateI3D);

  traceThis = traceEnabled("wglGetGenlockSampleRateI3D",&traceParam);

  if (!traceWGL_Native.wglGetGenlockSampleRateI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGenlockSampleRateI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGenlockSampleRateI3D(hDC, uRate);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("uRate", "%u[%d]", uRate, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGenlockSourceDelayI3D(HDC hDC, UINT uDelay)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGenlockSourceDelayI3D)
    traceWGL_lookupNativeAddress("wglGenlockSourceDelayI3D", (void **) &traceWGL_Native.wglGenlockSourceDelayI3D);

  traceThis = traceEnabled("wglGenlockSourceDelayI3D",&traceParam);

  if (!traceWGL_Native.wglGenlockSourceDelayI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGenlockSourceDelayI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("uDelay", "%u", uDelay);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGenlockSourceDelayI3D(hDC, uDelay);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetGenlockSourceDelayI3D(HDC hDC, UINT *uDelay)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGenlockSourceDelayI3D)
    traceWGL_lookupNativeAddress("wglGetGenlockSourceDelayI3D", (void **) &traceWGL_Native.wglGetGenlockSourceDelayI3D);

  traceThis = traceEnabled("wglGetGenlockSourceDelayI3D",&traceParam);

  if (!traceWGL_Native.wglGetGenlockSourceDelayI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGenlockSourceDelayI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGenlockSourceDelayI3D(hDC, uDelay);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("uDelay", "%u[%d]", uDelay, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryGenlockMaxSourceDelayI3D(HDC hDC, UINT *uMaxLineDelay, UINT *uMaxPixelDelay)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryGenlockMaxSourceDelayI3D)
    traceWGL_lookupNativeAddress("wglQueryGenlockMaxSourceDelayI3D", (void **) &traceWGL_Native.wglQueryGenlockMaxSourceDelayI3D);

  traceThis = traceEnabled("wglQueryGenlockMaxSourceDelayI3D",&traceParam);

  if (!traceWGL_Native.wglQueryGenlockMaxSourceDelayI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryGenlockMaxSourceDelayI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryGenlockMaxSourceDelayI3D(hDC, uMaxLineDelay, uMaxPixelDelay);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("uMaxLineDelay", "%u[%d]", uMaxLineDelay, 1);
      traceOutputParameter("uMaxPixelDelay", "%u[%d]", uMaxPixelDelay, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

LPVOID GLAPIENTRY
wglCreateImageBufferI3D(HDC hDC, DWORD dwSize, UINT uFlags)
{
  LPVOID ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateImageBufferI3D)
    traceWGL_lookupNativeAddress("wglCreateImageBufferI3D", (void **) &traceWGL_Native.wglCreateImageBufferI3D);

  traceThis = traceEnabled("wglCreateImageBufferI3D",&traceParam);

  if (!traceWGL_Native.wglCreateImageBufferI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateImageBufferI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("dwSize", "%lu", dwSize);
      traceInputParameter("uFlags", "%u", uFlags);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateImageBufferI3D(hDC, dwSize, uFlags);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDestroyImageBufferI3D(HDC hDC, LPVOID pAddress)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDestroyImageBufferI3D)
    traceWGL_lookupNativeAddress("wglDestroyImageBufferI3D", (void **) &traceWGL_Native.wglDestroyImageBufferI3D);

  traceThis = traceEnabled("wglDestroyImageBufferI3D",&traceParam);

  if (!traceWGL_Native.wglDestroyImageBufferI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDestroyImageBufferI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("pAddress", "%p", pAddress);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDestroyImageBufferI3D(hDC, pAddress);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglAssociateImageBufferEventsI3D(HDC hDC, const HANDLE *pEvent, const LPVOID *pAddress, const DWORD *pSize, UINT count)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglAssociateImageBufferEventsI3D)
    traceWGL_lookupNativeAddress("wglAssociateImageBufferEventsI3D", (void **) &traceWGL_Native.wglAssociateImageBufferEventsI3D);

  traceThis = traceEnabled("wglAssociateImageBufferEventsI3D",&traceParam);

  if (!traceWGL_Native.wglAssociateImageBufferEventsI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglAssociateImageBufferEventsI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("pSize", "%lu[%d]", pSize, count);
      traceInputParameter("count", "%u", count);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglAssociateImageBufferEventsI3D(hDC, pEvent, pAddress, pSize, count);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglReleaseImageBufferEventsI3D(HDC hDC, const LPVOID *pAddress, UINT count)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleaseImageBufferEventsI3D)
    traceWGL_lookupNativeAddress("wglReleaseImageBufferEventsI3D", (void **) &traceWGL_Native.wglReleaseImageBufferEventsI3D);

  traceThis = traceEnabled("wglReleaseImageBufferEventsI3D",&traceParam);

  if (!traceWGL_Native.wglReleaseImageBufferEventsI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleaseImageBufferEventsI3D");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("count", "%u", count);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleaseImageBufferEventsI3D(hDC, pAddress, count);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglEnableFrameLockI3D()
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnableFrameLockI3D)
    traceWGL_lookupNativeAddress("wglEnableFrameLockI3D", (void **) &traceWGL_Native.wglEnableFrameLockI3D);

  traceThis = traceEnabled("wglEnableFrameLockI3D",&traceParam);

  if (!traceWGL_Native.wglEnableFrameLockI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnableFrameLockI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnableFrameLockI3D();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDisableFrameLockI3D()
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDisableFrameLockI3D)
    traceWGL_lookupNativeAddress("wglDisableFrameLockI3D", (void **) &traceWGL_Native.wglDisableFrameLockI3D);

  traceThis = traceEnabled("wglDisableFrameLockI3D",&traceParam);

  if (!traceWGL_Native.wglDisableFrameLockI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDisableFrameLockI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDisableFrameLockI3D();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglIsEnabledFrameLockI3D(BOOL *pFlag)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglIsEnabledFrameLockI3D)
    traceWGL_lookupNativeAddress("wglIsEnabledFrameLockI3D", (void **) &traceWGL_Native.wglIsEnabledFrameLockI3D);

  traceThis = traceEnabled("wglIsEnabledFrameLockI3D",&traceParam);

  if (!traceWGL_Native.wglIsEnabledFrameLockI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglIsEnabledFrameLockI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglIsEnabledFrameLockI3D(pFlag);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pFlag", "%d[%d]", pFlag, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryFrameLockMasterI3D(BOOL *pFlag)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryFrameLockMasterI3D)
    traceWGL_lookupNativeAddress("wglQueryFrameLockMasterI3D", (void **) &traceWGL_Native.wglQueryFrameLockMasterI3D);

  traceThis = traceEnabled("wglQueryFrameLockMasterI3D",&traceParam);

  if (!traceWGL_Native.wglQueryFrameLockMasterI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryFrameLockMasterI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryFrameLockMasterI3D(pFlag);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pFlag", "%d[%d]", pFlag, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetFrameUsageI3D(float *pUsage)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetFrameUsageI3D)
    traceWGL_lookupNativeAddress("wglGetFrameUsageI3D", (void **) &traceWGL_Native.wglGetFrameUsageI3D);

  traceThis = traceEnabled("wglGetFrameUsageI3D",&traceParam);

  if (!traceWGL_Native.wglGetFrameUsageI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetFrameUsageI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetFrameUsageI3D(pUsage);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pUsage", "%f[%d]", pUsage, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglBeginFrameTrackingI3D()
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBeginFrameTrackingI3D)
    traceWGL_lookupNativeAddress("wglBeginFrameTrackingI3D", (void **) &traceWGL_Native.wglBeginFrameTrackingI3D);

  traceThis = traceEnabled("wglBeginFrameTrackingI3D",&traceParam);

  if (!traceWGL_Native.wglBeginFrameTrackingI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBeginFrameTrackingI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBeginFrameTrackingI3D();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglEndFrameTrackingI3D()
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEndFrameTrackingI3D)
    traceWGL_lookupNativeAddress("wglEndFrameTrackingI3D", (void **) &traceWGL_Native.wglEndFrameTrackingI3D);

  traceThis = traceEnabled("wglEndFrameTrackingI3D",&traceParam);

  if (!traceWGL_Native.wglEndFrameTrackingI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEndFrameTrackingI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEndFrameTrackingI3D();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryFrameTrackingI3D(DWORD *pFrameCount, DWORD *pMissedFrames, float *pLastMissedUsage)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryFrameTrackingI3D)
    traceWGL_lookupNativeAddress("wglQueryFrameTrackingI3D", (void **) &traceWGL_Native.wglQueryFrameTrackingI3D);

  traceThis = traceEnabled("wglQueryFrameTrackingI3D",&traceParam);

  if (!traceWGL_Native.wglQueryFrameTrackingI3D)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryFrameTrackingI3D");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryFrameTrackingI3D(pFrameCount, pMissedFrames, pLastMissedUsage);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pFrameCount", "%lu[%d]", pFrameCount, 1);
      traceOutputParameter("pMissedFrames", "%lu[%d]", pMissedFrames, 1);
      traceOutputParameter("pLastMissedUsage", "%f[%d]", pLastMissedUsage, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSetStereoEmitterState3DL(HDC hDC, UINT uState)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSetStereoEmitterState3DL)
    traceWGL_lookupNativeAddress("wglSetStereoEmitterState3DL", (void **) &traceWGL_Native.wglSetStereoEmitterState3DL);

  traceThis = traceEnabled("wglSetStereoEmitterState3DL",&traceParam);

  if (!traceWGL_Native.wglSetStereoEmitterState3DL)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSetStereoEmitterState3DL");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("uState", "%u", uState);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSetStereoEmitterState3DL(hDC, uState);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

int GLAPIENTRY
wglEnumerateVideoDevicesNV(HDC hDC, HVIDEOOUTPUTDEVICENV *phDeviceList)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnumerateVideoDevicesNV)
    traceWGL_lookupNativeAddress("wglEnumerateVideoDevicesNV", (void **) &traceWGL_Native.wglEnumerateVideoDevicesNV);

  traceThis = traceEnabled("wglEnumerateVideoDevicesNV",&traceParam);

  if (!traceWGL_Native.wglEnumerateVideoDevicesNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnumerateVideoDevicesNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnumerateVideoDevicesNV(hDC, phDeviceList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglBindVideoDeviceNV(HDC hDC, unsigned int uVideoSlot, HVIDEOOUTPUTDEVICENV hVideoDevice, const int *piAttribList)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBindVideoDeviceNV)
    traceWGL_lookupNativeAddress("wglBindVideoDeviceNV", (void **) &traceWGL_Native.wglBindVideoDeviceNV);

  traceThis = traceEnabled("wglBindVideoDeviceNV",&traceParam);

  if (!traceWGL_Native.wglBindVideoDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBindVideoDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("uVideoSlot", "%u", uVideoSlot);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBindVideoDeviceNV(hDC, uVideoSlot, hVideoDevice, piAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryCurrentContextNV(int iAttribute, int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryCurrentContextNV)
    traceWGL_lookupNativeAddress("wglQueryCurrentContextNV", (void **) &traceWGL_Native.wglQueryCurrentContextNV);

  traceThis = traceEnabled("wglQueryCurrentContextNV",&traceParam);

  if (!traceWGL_Native.wglQueryCurrentContextNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryCurrentContextNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iAttribute", "%d", iAttribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryCurrentContextNV(iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetVideoDeviceNV(HDC hDC, int numDevices, HPVIDEODEV *hVideoDevice)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetVideoDeviceNV)
    traceWGL_lookupNativeAddress("wglGetVideoDeviceNV", (void **) &traceWGL_Native.wglGetVideoDeviceNV);

  traceThis = traceEnabled("wglGetVideoDeviceNV",&traceParam);

  if (!traceWGL_Native.wglGetVideoDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetVideoDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("numDevices", "%d", numDevices);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetVideoDeviceNV(hDC, numDevices, hVideoDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglReleaseVideoDeviceNV(HPVIDEODEV hVideoDevice)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleaseVideoDeviceNV)
    traceWGL_lookupNativeAddress("wglReleaseVideoDeviceNV", (void **) &traceWGL_Native.wglReleaseVideoDeviceNV);

  traceThis = traceEnabled("wglReleaseVideoDeviceNV",&traceParam);

  if (!traceWGL_Native.wglReleaseVideoDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleaseVideoDeviceNV");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleaseVideoDeviceNV(hVideoDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglBindVideoImageNV(HPVIDEODEV hVideoDevice, HPBUFFERARB hPbuffer, int iVideoBuffer)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBindVideoImageNV)
    traceWGL_lookupNativeAddress("wglBindVideoImageNV", (void **) &traceWGL_Native.wglBindVideoImageNV);

  traceThis = traceEnabled("wglBindVideoImageNV",&traceParam);

  if (!traceWGL_Native.wglBindVideoImageNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBindVideoImageNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iVideoBuffer", "%d", iVideoBuffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBindVideoImageNV(hVideoDevice, hPbuffer, iVideoBuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglReleaseVideoImageNV(HPBUFFERARB hPbuffer, int iVideoBuffer)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleaseVideoImageNV)
    traceWGL_lookupNativeAddress("wglReleaseVideoImageNV", (void **) &traceWGL_Native.wglReleaseVideoImageNV);

  traceThis = traceEnabled("wglReleaseVideoImageNV",&traceParam);

  if (!traceWGL_Native.wglReleaseVideoImageNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleaseVideoImageNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iVideoBuffer", "%d", iVideoBuffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleaseVideoImageNV(hPbuffer, iVideoBuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglSendPbufferToVideoNV(HPBUFFERARB hPbuffer, int iBufferType, unsigned long *pulCounterPbuffer, BOOL bBlock)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglSendPbufferToVideoNV)
    traceWGL_lookupNativeAddress("wglSendPbufferToVideoNV", (void **) &traceWGL_Native.wglSendPbufferToVideoNV);

  traceThis = traceEnabled("wglSendPbufferToVideoNV",&traceParam);

  if (!traceWGL_Native.wglSendPbufferToVideoNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglSendPbufferToVideoNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("iBufferType", "%d", iBufferType);
      traceInputParameter("bBlock", "%d", bBlock);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglSendPbufferToVideoNV(hPbuffer, iBufferType, pulCounterPbuffer, bBlock);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pulCounterPbuffer", "%lu[%d]", pulCounterPbuffer, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglGetVideoInfoNV(HPVIDEODEV hpVideoDevice, unsigned long *pulCounterOutputPbuffer, unsigned long *pulCounterOutputVideo)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetVideoInfoNV)
    traceWGL_lookupNativeAddress("wglGetVideoInfoNV", (void **) &traceWGL_Native.wglGetVideoInfoNV);

  traceThis = traceEnabled("wglGetVideoInfoNV",&traceParam);

  if (!traceWGL_Native.wglGetVideoInfoNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetVideoInfoNV");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetVideoInfoNV(hpVideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pulCounterOutputPbuffer", "%lu[%d]", pulCounterOutputPbuffer, 1);
      traceOutputParameter("pulCounterOutputVideo", "%lu[%d]", pulCounterOutputVideo, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglJoinSwapGroupNV(HDC hDC, GLuint group)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglJoinSwapGroupNV)
    traceWGL_lookupNativeAddress("wglJoinSwapGroupNV", (void **) &traceWGL_Native.wglJoinSwapGroupNV);

  traceThis = traceEnabled("wglJoinSwapGroupNV",&traceParam);

  if (!traceWGL_Native.wglJoinSwapGroupNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglJoinSwapGroupNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("group", "%u", group);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglJoinSwapGroupNV(hDC, group);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglBindSwapBarrierNV(GLuint group, GLuint barrier)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBindSwapBarrierNV)
    traceWGL_lookupNativeAddress("wglBindSwapBarrierNV", (void **) &traceWGL_Native.wglBindSwapBarrierNV);

  traceThis = traceEnabled("wglBindSwapBarrierNV",&traceParam);

  if (!traceWGL_Native.wglBindSwapBarrierNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBindSwapBarrierNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("group", "%u", group);
      traceInputParameter("barrier", "%u", barrier);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBindSwapBarrierNV(group, barrier);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQuerySwapGroupNV(HDC hDC, GLuint *group, GLuint *barrier)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQuerySwapGroupNV)
    traceWGL_lookupNativeAddress("wglQuerySwapGroupNV", (void **) &traceWGL_Native.wglQuerySwapGroupNV);

  traceThis = traceEnabled("wglQuerySwapGroupNV",&traceParam);

  if (!traceWGL_Native.wglQuerySwapGroupNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQuerySwapGroupNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQuerySwapGroupNV(hDC, group, barrier);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("group", "%u[%d]", group, 1);
      traceOutputParameter("barrier", "%u[%d]", barrier, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryMaxSwapGroupsNV(HDC hDC, GLuint *maxGroups, GLuint *maxBarriers)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryMaxSwapGroupsNV)
    traceWGL_lookupNativeAddress("wglQueryMaxSwapGroupsNV", (void **) &traceWGL_Native.wglQueryMaxSwapGroupsNV);

  traceThis = traceEnabled("wglQueryMaxSwapGroupsNV",&traceParam);

  if (!traceWGL_Native.wglQueryMaxSwapGroupsNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryMaxSwapGroupsNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryMaxSwapGroupsNV(hDC, maxGroups, maxBarriers);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("maxGroups", "%u[%d]", maxGroups, 1);
      traceOutputParameter("maxBarriers", "%u[%d]", maxBarriers, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryFrameCountNV(HDC hDC, GLuint *count)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryFrameCountNV)
    traceWGL_lookupNativeAddress("wglQueryFrameCountNV", (void **) &traceWGL_Native.wglQueryFrameCountNV);

  traceThis = traceEnabled("wglQueryFrameCountNV",&traceParam);

  if (!traceWGL_Native.wglQueryFrameCountNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryFrameCountNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryFrameCountNV(hDC, count);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("count", "%u[%d]", count, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglResetFrameCountNV(HDC hDC)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglResetFrameCountNV)
    traceWGL_lookupNativeAddress("wglResetFrameCountNV", (void **) &traceWGL_Native.wglResetFrameCountNV);

  traceThis = traceEnabled("wglResetFrameCountNV",&traceParam);

  if (!traceWGL_Native.wglResetFrameCountNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglResetFrameCountNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglResetFrameCountNV(hDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglEnumGpusNV(UINT iGpuIndex, HGPUNV *phGpu)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnumGpusNV)
    traceWGL_lookupNativeAddress("wglEnumGpusNV", (void **) &traceWGL_Native.wglEnumGpusNV);

  traceThis = traceEnabled("wglEnumGpusNV",&traceParam);

  if (!traceWGL_Native.wglEnumGpusNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnumGpusNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iGpuIndex", "%u", iGpuIndex);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnumGpusNV(iGpuIndex, phGpu);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglEnumGpuDevicesNV(HGPUNV hGpu, UINT iDeviceIndex, PGPU_DEVICE lpGpuDevice)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnumGpuDevicesNV)
    traceWGL_lookupNativeAddress("wglEnumGpuDevicesNV", (void **) &traceWGL_Native.wglEnumGpuDevicesNV);

  traceThis = traceEnabled("wglEnumGpuDevicesNV",&traceParam);

  if (!traceWGL_Native.wglEnumGpuDevicesNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnumGpuDevicesNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("iDeviceIndex", "%u", iDeviceIndex);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnumGpuDevicesNV(hGpu, iDeviceIndex, lpGpuDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HDC GLAPIENTRY
wglCreateAffinityDCNV(const HGPUNV *phGpuList)
{
  HDC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateAffinityDCNV)
    traceWGL_lookupNativeAddress("wglCreateAffinityDCNV", (void **) &traceWGL_Native.wglCreateAffinityDCNV);

  traceThis = traceEnabled("wglCreateAffinityDCNV",&traceParam);

  if (!traceWGL_Native.wglCreateAffinityDCNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateAffinityDCNV");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateAffinityDCNV(phGpuList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglEnumGpusFromAffinityDCNV(HDC hAffinityDC, UINT iGpuIndex, HGPUNV *hGpu)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnumGpusFromAffinityDCNV)
    traceWGL_lookupNativeAddress("wglEnumGpusFromAffinityDCNV", (void **) &traceWGL_Native.wglEnumGpusFromAffinityDCNV);

  traceThis = traceEnabled("wglEnumGpusFromAffinityDCNV",&traceParam);

  if (!traceWGL_Native.wglEnumGpusFromAffinityDCNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnumGpusFromAffinityDCNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hAffinityDC", "%p", hAffinityDC);
      traceInputParameter("iGpuIndex", "%u", iGpuIndex);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnumGpusFromAffinityDCNV(hAffinityDC, iGpuIndex, hGpu);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDeleteDCNV(HDC hAffinityDC)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDeleteDCNV)
    traceWGL_lookupNativeAddress("wglDeleteDCNV", (void **) &traceWGL_Native.wglDeleteDCNV);

  traceThis = traceEnabled("wglDeleteDCNV",&traceParam);

  if (!traceWGL_Native.wglDeleteDCNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDeleteDCNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hAffinityDC", "%p", hAffinityDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDeleteDCNV(hAffinityDC);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

UINT GLAPIENTRY
wglGetGPUIDsAMD(UINT maxCount, UINT *ids)
{
  UINT ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGPUIDsAMD)
    traceWGL_lookupNativeAddress("wglGetGPUIDsAMD", (void **) &traceWGL_Native.wglGetGPUIDsAMD);

  traceThis = traceEnabled("wglGetGPUIDsAMD",&traceParam);

  if (!traceWGL_Native.wglGetGPUIDsAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGPUIDsAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("maxCount", "%u", maxCount);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGPUIDsAMD(maxCount, ids);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("ids", "%u[%d]", ids, maxCount);
      traceReturn("%u", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

INT GLAPIENTRY
wglGetGPUInfoAMD(UINT id, int property, GLenum dataType, UINT size, void *data)
{
  INT ret = (INT) 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetGPUInfoAMD)
    traceWGL_lookupNativeAddress("wglGetGPUInfoAMD", (void **) &traceWGL_Native.wglGetGPUInfoAMD);

  traceThis = traceEnabled("wglGetGPUInfoAMD",&traceParam);

  if (!traceWGL_Native.wglGetGPUInfoAMD)
    return (INT) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetGPUInfoAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("id", "%u", id);
      traceInputParameter("property", "%d", property);
      traceInputParameter("dataType", "%u", dataType);
      traceInputParameter("size", "%u", size);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetGPUInfoAMD(id, property, dataType, size, data);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("data", "%p", data);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

UINT GLAPIENTRY
wglGetContextGPUIDAMD(HGLRC hglrc)
{
  UINT ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetContextGPUIDAMD)
    traceWGL_lookupNativeAddress("wglGetContextGPUIDAMD", (void **) &traceWGL_Native.wglGetContextGPUIDAMD);

  traceThis = traceEnabled("wglGetContextGPUIDAMD",&traceParam);

  if (!traceWGL_Native.wglGetContextGPUIDAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetContextGPUIDAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hglrc", "%p", hglrc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetContextGPUIDAMD(hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglCreateAssociatedContextAMD(UINT id)
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateAssociatedContextAMD)
    traceWGL_lookupNativeAddress("wglCreateAssociatedContextAMD", (void **) &traceWGL_Native.wglCreateAssociatedContextAMD);

  traceThis = traceEnabled("wglCreateAssociatedContextAMD",&traceParam);

  if (!traceWGL_Native.wglCreateAssociatedContextAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateAssociatedContextAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("id", "%u", id);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateAssociatedContextAMD(id);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglCreateAssociatedContextAttribsAMD(UINT id, HGLRC hShareContext, const int *attribList)
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCreateAssociatedContextAttribsAMD)
    traceWGL_lookupNativeAddress("wglCreateAssociatedContextAttribsAMD", (void **) &traceWGL_Native.wglCreateAssociatedContextAttribsAMD);

  traceThis = traceEnabled("wglCreateAssociatedContextAttribsAMD",&traceParam);

  if (!traceWGL_Native.wglCreateAssociatedContextAttribsAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCreateAssociatedContextAttribsAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("id", "%u", id);
      traceInputParameter("hShareContext", "%p", hShareContext);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCreateAssociatedContextAttribsAMD(id, hShareContext, attribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglDeleteAssociatedContextAMD(HGLRC hglrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglDeleteAssociatedContextAMD)
    traceWGL_lookupNativeAddress("wglDeleteAssociatedContextAMD", (void **) &traceWGL_Native.wglDeleteAssociatedContextAMD);

  traceThis = traceEnabled("wglDeleteAssociatedContextAMD",&traceParam);

  if (!traceWGL_Native.wglDeleteAssociatedContextAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglDeleteAssociatedContextAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hglrc", "%p", hglrc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglDeleteAssociatedContextAMD(hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglMakeAssociatedContextCurrentAMD(HGLRC hglrc)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglMakeAssociatedContextCurrentAMD)
    traceWGL_lookupNativeAddress("wglMakeAssociatedContextCurrentAMD", (void **) &traceWGL_Native.wglMakeAssociatedContextCurrentAMD);

  traceThis = traceEnabled("wglMakeAssociatedContextCurrentAMD",&traceParam);

  if (!traceWGL_Native.wglMakeAssociatedContextCurrentAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglMakeAssociatedContextCurrentAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hglrc", "%p", hglrc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglMakeAssociatedContextCurrentAMD(hglrc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

HGLRC GLAPIENTRY
wglGetCurrentAssociatedContextAMD()
{
  HGLRC ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglGetCurrentAssociatedContextAMD)
    traceWGL_lookupNativeAddress("wglGetCurrentAssociatedContextAMD", (void **) &traceWGL_Native.wglGetCurrentAssociatedContextAMD);

  traceThis = traceEnabled("wglGetCurrentAssociatedContextAMD",&traceParam);

  if (!traceWGL_Native.wglGetCurrentAssociatedContextAMD)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglGetCurrentAssociatedContextAMD");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglGetCurrentAssociatedContextAMD();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

VOID GLAPIENTRY
wglBlitContextFramebufferAMD(HGLRC dstCtx, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBlitContextFramebufferAMD)
    traceWGL_lookupNativeAddress("wglBlitContextFramebufferAMD", (void **) &traceWGL_Native.wglBlitContextFramebufferAMD);

  traceThis = traceEnabled("wglBlitContextFramebufferAMD",&traceParam);

  if (!traceWGL_Native.wglBlitContextFramebufferAMD)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBlitContextFramebufferAMD");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("dstCtx", "%p", dstCtx);
      traceInputParameter("srcX0", "%d", srcX0);
      traceInputParameter("srcY0", "%d", srcY0);
      traceInputParameter("srcX1", "%d", srcX1);
      traceInputParameter("srcY1", "%d", srcY1);
      traceInputParameter("dstX0", "%d", dstX0);
      traceInputParameter("dstY0", "%d", dstY0);
      traceInputParameter("dstX1", "%d", dstX1);
      traceInputParameter("dstY1", "%d", dstY1);
      traceInputParameter("mask", "%u", mask);
      traceInputParameter("filter", "%u", filter);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceWGL_Native.wglBlitContextFramebufferAMD(dstCtx, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

BOOL GLAPIENTRY
wglBindVideoCaptureDeviceNV(UINT uVideoSlot, HVIDEOINPUTDEVICENV hDevice)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglBindVideoCaptureDeviceNV)
    traceWGL_lookupNativeAddress("wglBindVideoCaptureDeviceNV", (void **) &traceWGL_Native.wglBindVideoCaptureDeviceNV);

  traceThis = traceEnabled("wglBindVideoCaptureDeviceNV",&traceParam);

  if (!traceWGL_Native.wglBindVideoCaptureDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglBindVideoCaptureDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("uVideoSlot", "%u", uVideoSlot);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglBindVideoCaptureDeviceNV(uVideoSlot, hDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

UINT GLAPIENTRY
wglEnumerateVideoCaptureDevicesNV(HDC hDC, HVIDEOINPUTDEVICENV *phDeviceList)
{
  UINT ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglEnumerateVideoCaptureDevicesNV)
    traceWGL_lookupNativeAddress("wglEnumerateVideoCaptureDevicesNV", (void **) &traceWGL_Native.wglEnumerateVideoCaptureDevicesNV);

  traceThis = traceEnabled("wglEnumerateVideoCaptureDevicesNV",&traceParam);

  if (!traceWGL_Native.wglEnumerateVideoCaptureDevicesNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglEnumerateVideoCaptureDevicesNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglEnumerateVideoCaptureDevicesNV(hDC, phDeviceList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglLockVideoCaptureDeviceNV(HDC hDC, HVIDEOINPUTDEVICENV hDevice)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglLockVideoCaptureDeviceNV)
    traceWGL_lookupNativeAddress("wglLockVideoCaptureDeviceNV", (void **) &traceWGL_Native.wglLockVideoCaptureDeviceNV);

  traceThis = traceEnabled("wglLockVideoCaptureDeviceNV",&traceParam);

  if (!traceWGL_Native.wglLockVideoCaptureDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglLockVideoCaptureDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglLockVideoCaptureDeviceNV(hDC, hDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglQueryVideoCaptureDeviceNV(HDC hDC, HVIDEOINPUTDEVICENV hDevice, int iAttribute, int *piValue)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglQueryVideoCaptureDeviceNV)
    traceWGL_lookupNativeAddress("wglQueryVideoCaptureDeviceNV", (void **) &traceWGL_Native.wglQueryVideoCaptureDeviceNV);

  traceThis = traceEnabled("wglQueryVideoCaptureDeviceNV",&traceParam);

  if (!traceWGL_Native.wglQueryVideoCaptureDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglQueryVideoCaptureDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hDC", "%p", hDC);
      traceInputParameter("iAttribute", "%d", iAttribute);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglQueryVideoCaptureDeviceNV(hDC, hDevice, iAttribute, piValue);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("piValue", "%d[%d]", piValue, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglReleaseVideoCaptureDeviceNV(HDC hDC, HVIDEOINPUTDEVICENV hDevice)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglReleaseVideoCaptureDeviceNV)
    traceWGL_lookupNativeAddress("wglReleaseVideoCaptureDeviceNV", (void **) &traceWGL_Native.wglReleaseVideoCaptureDeviceNV);

  traceThis = traceEnabled("wglReleaseVideoCaptureDeviceNV",&traceParam);

  if (!traceWGL_Native.wglReleaseVideoCaptureDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglReleaseVideoCaptureDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hDC", "%p", hDC);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglReleaseVideoCaptureDeviceNV(hDC, hDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

BOOL GLAPIENTRY
wglCopyImageSubDataNV(HGLRC hSrcRC, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, HGLRC hDstRC, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)
{
  BOOL ret = 0;
  int traceThis;
  int traceParam;

  if (!traceWGL_initialized)
    traceWGL_init();

  /* Lookup API function pointer. */

  if (!traceWGL_Native.wglCopyImageSubDataNV)
    traceWGL_lookupNativeAddress("wglCopyImageSubDataNV", (void **) &traceWGL_Native.wglCopyImageSubDataNV);

  traceThis = traceEnabled("wglCopyImageSubDataNV",&traceParam);

  if (!traceWGL_Native.wglCopyImageSubDataNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("wglCopyImageSubDataNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hSrcRC", "%p", hSrcRC);
      traceInputParameter("srcName", "%u", srcName);
      traceInputParameter("srcTarget", "%u", srcTarget);
      traceInputParameter("srcLevel", "%d", srcLevel);
      traceInputParameter("srcX", "%d", srcX);
      traceInputParameter("srcY", "%d", srcY);
      traceInputParameter("srcZ", "%d", srcZ);
      traceInputParameter("hDstRC", "%p", hDstRC);
      traceInputParameter("dstName", "%u", dstName);
      traceInputParameter("dstTarget", "%u", dstTarget);
      traceInputParameter("dstLevel", "%d", dstLevel);
      traceInputParameter("dstX", "%d", dstX);
      traceInputParameter("dstY", "%d", dstY);
      traceInputParameter("dstZ", "%d", dstZ);
      traceInputParameter("width", "%d", width);
      traceInputParameter("height", "%d", height);
      traceInputParameter("depth", "%d", depth);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceWGL_Native.wglCopyImageSubDataNV(hSrcRC, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, hDstRC, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

/* WGL proc address maps. */

static const char *traceWGL_apiFuncNames[136] = {
  "wglAllocateMemoryNV",
  "wglAssociateImageBufferEventsI3D",
  "wglBeginFrameTrackingI3D",
  "wglBindDisplayColorTableEXT",
  "wglBindSwapBarrierNV",
  "wglBindTexImageARB",
  "wglBindVideoCaptureDeviceNV",
  "wglBindVideoDeviceNV",
  "wglBindVideoImageNV",
  "wglBlitContextFramebufferAMD",
  "wglChoosePixelFormat",
  "wglChoosePixelFormatARB",
  "wglChoosePixelFormatEXT",
  "wglCopyContext",
  "wglCopyImageSubDataNV",
  "wglCreateAffinityDCNV",
  "wglCreateAssociatedContextAMD",
  "wglCreateAssociatedContextAttribsAMD",
  "wglCreateBufferRegionARB",
  "wglCreateContext",
  "wglCreateContextAttribsARB",
  "wglCreateDisplayColorTableEXT",
  "wglCreateImageBufferI3D",
  "wglCreateLayerContext",
  "wglCreatePbufferARB",
  "wglCreatePbufferEXT",
  "wglDeleteAssociatedContextAMD",
  "wglDeleteBufferRegionARB",
  "wglDeleteContext",
  "wglDeleteDCNV",
  "wglDescribeLayerPlane",
  "wglDescribePixelFormat",
  "wglDestroyDisplayColorTableEXT",
  "wglDestroyImageBufferI3D",
  "wglDestroyPbufferARB",
  "wglDestroyPbufferEXT",
  "wglDisableFrameLockI3D",
  "wglDisableGenlockI3D",
  "wglEnableFrameLockI3D",
  "wglEnableGenlockI3D",
  "wglEndFrameTrackingI3D",
  "wglEnumGpuDevicesNV",
  "wglEnumGpusFromAffinityDCNV",
  "wglEnumGpusNV",
  "wglEnumerateVideoCaptureDevicesNV",
  "wglEnumerateVideoDevicesNV",
  "wglFreeMemoryNV",
  "wglGenlockSampleRateI3D",
  "wglGenlockSourceDelayI3D",
  "wglGenlockSourceEdgeI3D",
  "wglGenlockSourceI3D",
  "wglGetContextGPUIDAMD",
  "wglGetCurrentAssociatedContextAMD",
  "wglGetCurrentContext",
  "wglGetCurrentDC",
  "wglGetCurrentReadDCARB",
  "wglGetCurrentReadDCEXT",
  "wglGetDefaultProcAddress",
  "wglGetDigitalVideoParametersI3D",
  "wglGetExtensionsStringARB",
  "wglGetExtensionsStringEXT",
  "wglGetFrameUsageI3D",
  "wglGetGPUIDsAMD",
  "wglGetGPUInfoAMD",
  "wglGetGammaTableI3D",
  "wglGetGammaTableParametersI3D",
  "wglGetGenlockSampleRateI3D",
  "wglGetGenlockSourceDelayI3D",
  "wglGetGenlockSourceEdgeI3D",
  "wglGetGenlockSourceI3D",
  "wglGetLayerPaletteEntries",
  "wglGetMscRateOML",
  "wglGetPbufferDCARB",
  "wglGetPbufferDCEXT",
  "wglGetPixelFormat",
  "wglGetPixelFormatAttribfvARB",
  "wglGetPixelFormatAttribfvEXT",
  "wglGetPixelFormatAttribivARB",
  "wglGetPixelFormatAttribivEXT",
  "wglGetProcAddress",
  "wglGetSwapIntervalEXT",
  "wglGetSyncValuesOML",
  "wglGetVideoDeviceNV",
  "wglGetVideoInfoNV",
  "wglIsEnabledFrameLockI3D",
  "wglIsEnabledGenlockI3D",
  "wglJoinSwapGroupNV",
  "wglLoadDisplayColorTableEXT",
  "wglLockVideoCaptureDeviceNV",
  "wglMakeAssociatedContextCurrentAMD",
  "wglMakeContextCurrentARB",
  "wglMakeContextCurrentEXT",
  "wglMakeCurrent",
  "wglQueryCurrentContextNV",
  "wglQueryFrameCountNV",
  "wglQueryFrameLockMasterI3D",
  "wglQueryFrameTrackingI3D",
  "wglQueryGenlockMaxSourceDelayI3D",
  "wglQueryMaxSwapGroupsNV",
  "wglQueryPbufferARB",
  "wglQueryPbufferEXT",
  "wglQuerySwapGroupNV",
  "wglQueryVideoCaptureDeviceNV",
  "wglRealizeLayerPalette",
  "wglReleaseImageBufferEventsI3D",
  "wglReleasePbufferDCARB",
  "wglReleasePbufferDCEXT",
  "wglReleaseTexImageARB",
  "wglReleaseVideoCaptureDeviceNV",
  "wglReleaseVideoDeviceNV",
  "wglReleaseVideoImageNV",
  "wglResetFrameCountNV",
  "wglRestoreBufferRegionARB",
  "wglSaveBufferRegionARB",
  "wglSendPbufferToVideoNV",
  "wglSetDigitalVideoParametersI3D",
  "wglSetGammaTableI3D",
  "wglSetGammaTableParametersI3D",
  "wglSetLayerPaletteEntries",
  "wglSetPbufferAttribARB",
  "wglSetPixelFormat",
  "wglSetStereoEmitterState3DL",
  "wglShareLists",
  "wglSwapBuffers",
  "wglSwapBuffersMscOML",
  "wglSwapIntervalEXT",
  "wglSwapLayerBuffers",
  "wglSwapLayerBuffersMscOML",
  "wglSwapMultipleBuffers",
  "wglUseFontBitmapsA",
  "wglUseFontBitmapsW",
  "wglUseFontOutlinesA",
  "wglUseFontOutlinesW",
  "wglWaitForMscOML",
  "wglWaitForSbcOML",
  NULL
};

static void *traceWGL_WrapperArray[136] = {
  (void *) wglAllocateMemoryNV,
  (void *) wglAssociateImageBufferEventsI3D,
  (void *) wglBeginFrameTrackingI3D,
  (void *) wglBindDisplayColorTableEXT,
  (void *) wglBindSwapBarrierNV,
  (void *) wglBindTexImageARB,
  (void *) wglBindVideoCaptureDeviceNV,
  (void *) wglBindVideoDeviceNV,
  (void *) wglBindVideoImageNV,
  (void *) wglBlitContextFramebufferAMD,
  (void *) wglChoosePixelFormat,
  (void *) wglChoosePixelFormatARB,
  (void *) wglChoosePixelFormatEXT,
  (void *) wglCopyContext,
  (void *) wglCopyImageSubDataNV,
  (void *) wglCreateAffinityDCNV,
  (void *) wglCreateAssociatedContextAMD,
  (void *) wglCreateAssociatedContextAttribsAMD,
  (void *) wglCreateBufferRegionARB,
  (void *) wglCreateContext,
  (void *) wglCreateContextAttribsARB,
  (void *) wglCreateDisplayColorTableEXT,
  (void *) wglCreateImageBufferI3D,
  (void *) wglCreateLayerContext,
  (void *) wglCreatePbufferARB,
  (void *) wglCreatePbufferEXT,
  (void *) wglDeleteAssociatedContextAMD,
  (void *) wglDeleteBufferRegionARB,
  (void *) wglDeleteContext,
  (void *) wglDeleteDCNV,
  (void *) wglDescribeLayerPlane,
  (void *) wglDescribePixelFormat,
  (void *) wglDestroyDisplayColorTableEXT,
  (void *) wglDestroyImageBufferI3D,
  (void *) wglDestroyPbufferARB,
  (void *) wglDestroyPbufferEXT,
  (void *) wglDisableFrameLockI3D,
  (void *) wglDisableGenlockI3D,
  (void *) wglEnableFrameLockI3D,
  (void *) wglEnableGenlockI3D,
  (void *) wglEndFrameTrackingI3D,
  (void *) wglEnumGpuDevicesNV,
  (void *) wglEnumGpusFromAffinityDCNV,
  (void *) wglEnumGpusNV,
  (void *) wglEnumerateVideoCaptureDevicesNV,
  (void *) wglEnumerateVideoDevicesNV,
  (void *) wglFreeMemoryNV,
  (void *) wglGenlockSampleRateI3D,
  (void *) wglGenlockSourceDelayI3D,
  (void *) wglGenlockSourceEdgeI3D,
  (void *) wglGenlockSourceI3D,
  (void *) wglGetContextGPUIDAMD,
  (void *) wglGetCurrentAssociatedContextAMD,
  (void *) wglGetCurrentContext,
  (void *) wglGetCurrentDC,
  (void *) wglGetCurrentReadDCARB,
  (void *) wglGetCurrentReadDCEXT,
  (void *) wglGetDefaultProcAddress,
  (void *) wglGetDigitalVideoParametersI3D,
  (void *) wglGetExtensionsStringARB,
  (void *) wglGetExtensionsStringEXT,
  (void *) wglGetFrameUsageI3D,
  (void *) wglGetGPUIDsAMD,
  (void *) wglGetGPUInfoAMD,
  (void *) wglGetGammaTableI3D,
  (void *) wglGetGammaTableParametersI3D,
  (void *) wglGetGenlockSampleRateI3D,
  (void *) wglGetGenlockSourceDelayI3D,
  (void *) wglGetGenlockSourceEdgeI3D,
  (void *) wglGetGenlockSourceI3D,
  (void *) wglGetLayerPaletteEntries,
  (void *) wglGetMscRateOML,
  (void *) wglGetPbufferDCARB,
  (void *) wglGetPbufferDCEXT,
  (void *) wglGetPixelFormat,
  (void *) wglGetPixelFormatAttribfvARB,
  (void *) wglGetPixelFormatAttribfvEXT,
  (void *) wglGetPixelFormatAttribivARB,
  (void *) wglGetPixelFormatAttribivEXT,
  (void *) wglGetProcAddress,
  (void *) wglGetSwapIntervalEXT,
  (void *) wglGetSyncValuesOML,
  (void *) wglGetVideoDeviceNV,
  (void *) wglGetVideoInfoNV,
  (void *) wglIsEnabledFrameLockI3D,
  (void *) wglIsEnabledGenlockI3D,
  (void *) wglJoinSwapGroupNV,
  (void *) wglLoadDisplayColorTableEXT,
  (void *) wglLockVideoCaptureDeviceNV,
  (void *) wglMakeAssociatedContextCurrentAMD,
  (void *) wglMakeContextCurrentARB,
  (void *) wglMakeContextCurrentEXT,
  (void *) wglMakeCurrent,
  (void *) wglQueryCurrentContextNV,
  (void *) wglQueryFrameCountNV,
  (void *) wglQueryFrameLockMasterI3D,
  (void *) wglQueryFrameTrackingI3D,
  (void *) wglQueryGenlockMaxSourceDelayI3D,
  (void *) wglQueryMaxSwapGroupsNV,
  (void *) wglQueryPbufferARB,
  (void *) wglQueryPbufferEXT,
  (void *) wglQuerySwapGroupNV,
  (void *) wglQueryVideoCaptureDeviceNV,
  (void *) wglRealizeLayerPalette,
  (void *) wglReleaseImageBufferEventsI3D,
  (void *) wglReleasePbufferDCARB,
  (void *) wglReleasePbufferDCEXT,
  (void *) wglReleaseTexImageARB,
  (void *) wglReleaseVideoCaptureDeviceNV,
  (void *) wglReleaseVideoDeviceNV,
  (void *) wglReleaseVideoImageNV,
  (void *) wglResetFrameCountNV,
  (void *) wglRestoreBufferRegionARB,
  (void *) wglSaveBufferRegionARB,
  (void *) wglSendPbufferToVideoNV,
  (void *) wglSetDigitalVideoParametersI3D,
  (void *) wglSetGammaTableI3D,
  (void *) wglSetGammaTableParametersI3D,
  (void *) wglSetLayerPaletteEntries,
  (void *) wglSetPbufferAttribARB,
  (void *) wglSetPixelFormat,
  (void *) wglSetStereoEmitterState3DL,
  (void *) wglShareLists,
  (void *) wglSwapBuffers,
  (void *) wglSwapBuffersMscOML,
  (void *) wglSwapIntervalEXT,
  (void *) wglSwapLayerBuffers,
  (void *) wglSwapLayerBuffersMscOML,
  (void *) wglSwapMultipleBuffers,
  (void *) wglUseFontBitmapsA,
  (void *) wglUseFontBitmapsW,
  (void *) wglUseFontOutlinesA,
  (void *) wglUseFontOutlinesW,
  (void *) wglWaitForMscOML,
  (void *) wglWaitForSbcOML,
  NULL
};

static void **traceWGL_NativeArray = (void **) &traceWGL_Native;

/* Lookup native proc address for API function and update traceWGL_NativeArray. */

void
traceWGL_lookupNativeAddress(const char *name, void **procPtr)
{
  void *proc = NULL;
  size_t index = procPtr - traceWGL_NativeArray;

  assert(name);
  assert(index < 135);
  assert(!strcmp(name, traceWGL_apiFuncNames[index]));

  if (!traceWGL_Native.wglGetProcAddress)
  {
    traceWarning("Cannot load function with traceWGL_Native.wglGetProcAddress.");
    traceWGL_NativeArray[index] = NULL;
  }

  /* Check if API function address already loaded. */

  if (traceWGL_NativeArray[index])
    return;

  /* Obtain proc address using WGL GetProcAddress API function. */

  proc = traceWGL_Native.wglGetProcAddress(name);

  /* Check if API function address loaded from traceWGL. */

  if (proc == traceWGL_WrapperArray[index])
  {
    traceWarning("Ignoring %s loaded from traceWGL library.", name);
    proc = NULL;
  }

  traceWGL_NativeArray[index] = proc;
}

/* Binary search function for proc address lookup. */

static int CompareStrcmp(const void *a, const void *b)
{
  return strcmp(*(const char **) a, *(const char **) b);
}

void *traceGL_lookupWrapperAddress(const char *name, void *proc);

/* Lookup wrapper proc address for the WGL API function. */

void *
traceWGL_lookupWrapperAddress(const char *name, void *proc)
{
  const char **res = NULL;

  if (!proc)
    return NULL;

  if (!name)
  {
    traceWarning("Cannot load function without name.");
    return NULL;
  }

  if (!strncmp(name, "gl", 2))
    return traceGL_lookupWrapperAddress(name, proc);

  res = (const char **) bsearch(&name, traceWGL_apiFuncNames, 134, sizeof(const char *), CompareStrcmp);
  if (res)
    return traceWGL_WrapperArray[(size_t) (res - traceWGL_apiFuncNames)];

  traceWarning("Trace does not support %s.", name);
  return proc;
}
