/* NOTE: Do not edit this file, it is generated by a script:
   ExportTrace.py --api glx 0 --prefix traceGLX -t traverseTraceGLX --library GLX -o traceGLX.c -e GLAPIENTRY
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "trace.h"

#ifdef _WIN32
# define DLLEXPORT __declspec(dllexport)
#elif defined(__GNUC__) && __GNUC__>=4
# define DLLEXPORT __attribute__ ((visibility("default")))
#elif defined(__SUNPRO_C) || defined(__SUNPRO_CC)
# define DLLEXPORT __global
#else
# define DLLEXPORT
#endif

/* Define GLX calling convention. */

#if defined(__MINGW32__) || defined(__CYGWIN32__) || defined(__CYGWIN__) || defined(_MSC_VER)
# define GLAPIENTRY __stdcall
#else
# define GLAPIENTRY
#endif

/* Include X headers. */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* Include GLX headers and types. */

#ifndef GL_FALSE
#define GL_FALSE 0
#endif

typedef unsigned int GLenum;
typedef unsigned int GLuint;
typedef int GLint;
typedef int GLsizei;
typedef unsigned char GLboolean;
typedef unsigned char GLubyte;
typedef unsigned long GLulong;
typedef float GLfloat;
typedef void GLvoid;

typedef XID GLXDrawable;
typedef XID GLXPixmap;
#ifdef __sun
typedef struct __glXContextRec *GLXContext;
#else
typedef struct __GLXcontextRec *GLXContext;
#endif

typedef unsigned int GLXVideoDeviceNV;

typedef XID GLXWindow;
typedef XID GLXPbuffer;

#define GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX 80

typedef struct {
  char pipeName[GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX];
  int  networkId;
} GLXHyperpipeNetworkSGIX;

typedef struct {
  char pipeName[GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX];
  int channel;
  unsigned int participationType;
  int timeSlice;
} GLXHyperpipeConfigSGIX;

typedef XID GLXFBConfigID;
typedef struct __GLXFBConfigRec *GLXFBConfig;

typedef XID GLXContextID;

typedef XID GLXFBConfigIDSGIX;
typedef struct __GLXFBConfigRec *GLXFBConfigSGIX;

typedef XID GLXPbufferSGIX;

/* Declare GLX API functions. */

DLLEXPORT Bool GLAPIENTRY glXQueryExtension(Display *, int *, int *);
DLLEXPORT Bool GLAPIENTRY glXQueryVersion(Display *, int *, int *);
DLLEXPORT int GLAPIENTRY glXGetConfig(Display *, XVisualInfo *, int, int *);
DLLEXPORT XVisualInfo *GLAPIENTRY glXChooseVisual(Display *, int, int *);
DLLEXPORT GLXPixmap GLAPIENTRY glXCreateGLXPixmap(Display *, XVisualInfo *, Pixmap);
DLLEXPORT void GLAPIENTRY glXDestroyGLXPixmap(Display *, GLXPixmap);
DLLEXPORT GLXContext GLAPIENTRY glXCreateContext(Display *, XVisualInfo *, GLXContext, Bool);
DLLEXPORT void GLAPIENTRY glXDestroyContext(Display *, GLXContext);
DLLEXPORT Bool GLAPIENTRY glXIsDirect(Display *, GLXContext);
DLLEXPORT void GLAPIENTRY glXCopyContext(Display *, GLXContext, GLXContext, unsigned long);
DLLEXPORT Bool GLAPIENTRY glXMakeCurrent(Display *, GLXDrawable, GLXContext);
DLLEXPORT GLXContext GLAPIENTRY glXGetCurrentContext(void);
DLLEXPORT GLXDrawable GLAPIENTRY glXGetCurrentDrawable(void);
DLLEXPORT void GLAPIENTRY glXWaitGL(void);
DLLEXPORT void GLAPIENTRY glXWaitX(void);
DLLEXPORT void GLAPIENTRY glXSwapBuffers(Display *, GLXDrawable);
DLLEXPORT void GLAPIENTRY glXUseXFont(Font, int, int, int);
DLLEXPORT const char *GLAPIENTRY glXQueryExtensionsString(Display *, int);
DLLEXPORT const char *GLAPIENTRY glXGetClientString(Display *, int);
DLLEXPORT const char *GLAPIENTRY glXQueryServerString(Display *, int, int);
DLLEXPORT Display *GLAPIENTRY glXGetCurrentDisplay(void);
DLLEXPORT GLXFBConfig *GLAPIENTRY glXChooseFBConfig(Display *, int, const int *, int *);
DLLEXPORT GLXFBConfig *GLAPIENTRY glXGetFBConfigs(Display *, int, int *);
DLLEXPORT XVisualInfo *GLAPIENTRY glXGetVisualFromFBConfig(Display *, GLXFBConfig);
DLLEXPORT int GLAPIENTRY glXGetFBConfigAttrib(Display *, GLXFBConfig, int, int *);
DLLEXPORT GLXWindow GLAPIENTRY glXCreateWindow(Display *, GLXFBConfig, Window, const int *);
DLLEXPORT void GLAPIENTRY glXDestroyWindow(Display *, GLXWindow);
DLLEXPORT GLXPixmap GLAPIENTRY glXCreatePixmap(Display *, GLXFBConfig, Pixmap, const int *);
DLLEXPORT void GLAPIENTRY glXDestroyPixmap(Display *, GLXPixmap);
DLLEXPORT GLXPbuffer GLAPIENTRY glXCreatePbuffer(Display *, GLXFBConfig, const int *);
DLLEXPORT void GLAPIENTRY glXDestroyPbuffer(Display *, GLXPbuffer);
DLLEXPORT void GLAPIENTRY glXQueryDrawable(Display *, GLXDrawable, int, unsigned int *);
DLLEXPORT GLXContext GLAPIENTRY glXCreateNewContext(Display *, GLXFBConfig, int, GLXContext, Bool);
DLLEXPORT Bool GLAPIENTRY glXMakeContextCurrent(Display *, GLXDrawable, GLXDrawable, GLXContext);
DLLEXPORT GLXDrawable GLAPIENTRY glXGetCurrentReadDrawable(void);
DLLEXPORT int GLAPIENTRY glXQueryContext(Display *, GLXContext, int, int *);
DLLEXPORT void GLAPIENTRY glXSelectEvent(Display *, GLXDrawable, unsigned long);
DLLEXPORT void GLAPIENTRY glXGetSelectedEvent(Display *, GLXDrawable, unsigned long *);
DLLEXPORT void *GLAPIENTRY glXGetProcAddress(const GLubyte *);
DLLEXPORT void *GLAPIENTRY glXGetProcAddressARB(const GLubyte *);
DLLEXPORT GLXContext GLAPIENTRY glXCreateContextAttribsARB(Display *, GLXFBConfig, GLXContext, Bool, const int *);
DLLEXPORT int GLAPIENTRY glXSwapIntervalSGI(int);
DLLEXPORT int GLAPIENTRY glXGetVideoSyncSGI(unsigned int *);
DLLEXPORT int GLAPIENTRY glXWaitVideoSyncSGI(int, int, unsigned int *);
DLLEXPORT GLXDrawable GLAPIENTRY glXGetCurrentReadDrawableSGI(void);
DLLEXPORT Bool GLAPIENTRY glXMakeCurrentReadSGI(Display *, GLXDrawable, GLXDrawable, GLXContext);
DLLEXPORT void GLAPIENTRY glXFreeContextEXT(Display *, GLXContext);
DLLEXPORT GLXContextID GLAPIENTRY glXGetContextIDEXT(const GLXContext);
DLLEXPORT GLXContext GLAPIENTRY glXImportContextEXT(Display *, GLXContextID);
DLLEXPORT int GLAPIENTRY glXQueryContextInfoEXT(Display *, GLXContext, int, int *);
DLLEXPORT GLXFBConfigSGIX *GLAPIENTRY glXChooseFBConfigSGIX(Display *, int, const int *, int *);
DLLEXPORT GLXContext GLAPIENTRY glXCreateContextWithConfigSGIX(Display *, GLXFBConfig, int, GLXContext, Bool);
DLLEXPORT GLXPixmap GLAPIENTRY glXCreateGLXPixmapWithConfigSGIX(Display *, GLXFBConfig, Pixmap);
DLLEXPORT int GLAPIENTRY glXGetFBConfigAttribSGIX(Display *, GLXFBConfigSGIX, int, int *);
DLLEXPORT GLXFBConfigSGIX GLAPIENTRY glXGetFBConfigFromVisualSGIX(Display *, XVisualInfo *);
DLLEXPORT XVisualInfo *GLAPIENTRY glXGetVisualFromFBConfigSGIX(Display *, GLXFBConfig);
DLLEXPORT GLXPbuffer GLAPIENTRY glXCreateGLXPbufferSGIX(Display *, GLXFBConfig, unsigned int, unsigned int, int *);
DLLEXPORT void GLAPIENTRY glXDestroyGLXPbufferSGIX(Display *, GLXPbuffer);
DLLEXPORT void GLAPIENTRY glXGetSelectedEventSGIX(Display *, GLXDrawable, unsigned long *);
DLLEXPORT void GLAPIENTRY glXQueryGLXPbufferSGIX(Display *, GLXPbuffer, int, unsigned int *);
DLLEXPORT void GLAPIENTRY glXSelectEventSGIX(Display *, GLXDrawable, unsigned long);
DLLEXPORT void GLAPIENTRY glXCushionSGI(Display *, Window, float);
DLLEXPORT int GLAPIENTRY glXBindChannelToWindowSGIX(Display *, int, int, Window);
DLLEXPORT int GLAPIENTRY glXChannelRectSGIX(Display *, int, int, int, int, int, int);
DLLEXPORT int GLAPIENTRY glXChannelRectSyncSGIX(Display *, int, int, GLenum);
DLLEXPORT int GLAPIENTRY glXQueryChannelDeltasSGIX(Display *, int, int, int *, int *, int *, int *);
DLLEXPORT int GLAPIENTRY glXQueryChannelRectSGIX(Display *, int, int, int *, int *, int *, int *);
DLLEXPORT void GLAPIENTRY glXJoinSwapGroupSGIX(Display *, GLXDrawable, GLXDrawable);
DLLEXPORT void GLAPIENTRY glXBindSwapBarrierSGIX(Display *, GLXDrawable, int);
DLLEXPORT Bool GLAPIENTRY glXQueryMaxSwapBarriersSGIX(Display *, int, int *);
DLLEXPORT Status GLAPIENTRY glXGetTransparentIndexSUN(Display *, Window, Window, unsigned long *);
DLLEXPORT void *GLAPIENTRY glXAllocateMemoryNV(GLsizei, GLfloat, GLfloat, GLfloat);
DLLEXPORT void GLAPIENTRY glXFreeMemoryNV(void *);
DLLEXPORT void GLAPIENTRY glXCopySubBufferMESA(Display *, GLXDrawable, int, int, int, int);
DLLEXPORT GLXPixmap GLAPIENTRY glXCreateGLXPixmapMESA(Display *, XVisualInfo *, Pixmap, Colormap);
DLLEXPORT Bool GLAPIENTRY glXReleaseBuffersMESA(Display *, GLXDrawable);
DLLEXPORT GLboolean GLAPIENTRY glXSet3DfxModeMESA(GLint);
DLLEXPORT Bool GLAPIENTRY glXGetMscRateOML(Display *, GLXDrawable, int32_t *, int32_t *);
DLLEXPORT Bool GLAPIENTRY glXGetSyncValuesOML(Display *, GLXDrawable, int64_t *, int64_t *, int64_t *);
DLLEXPORT int64_t GLAPIENTRY glXSwapBuffersMscOML(Display *, GLXDrawable, int64_t, int64_t, int64_t);
DLLEXPORT Bool GLAPIENTRY glXWaitForMscOML(Display *, GLXDrawable, int64_t, int64_t, int64_t, int64_t *, int64_t *, int64_t *);
DLLEXPORT Bool GLAPIENTRY glXWaitForSbcOML(Display *, GLXDrawable, int64_t, int64_t *, int64_t *, int64_t *);
DLLEXPORT GLXHyperpipeNetworkSGIX *GLAPIENTRY glXQueryHyperpipeNetworkSGIX(Display *, int *);
DLLEXPORT int GLAPIENTRY glXHyperpipeConfigSGIX(Display *, int, int, GLXHyperpipeConfigSGIX *, int *);
DLLEXPORT GLXHyperpipeConfigSGIX *GLAPIENTRY glXQueryHyperpipeConfigSGIX(Display *, int, int *);
DLLEXPORT int GLAPIENTRY glXDestroyHyperpipeConfigSGIX(Display *, int);
DLLEXPORT int GLAPIENTRY glXBindHyperpipeSGIX(Display *, int);
DLLEXPORT int GLAPIENTRY glXQueryHyperpipeBestAttribSGIX(Display *, int, int, int, void *, void *);
DLLEXPORT int GLAPIENTRY glXHyperpipeAttribSGIX(Display *, int, int, int, void *);
DLLEXPORT int GLAPIENTRY glXQueryHyperpipeAttribSGIX(Display *, int, int, int, void *);
DLLEXPORT unsigned int GLAPIENTRY glXGetAGPOffsetMESA(const void *);
DLLEXPORT void GLAPIENTRY glXBindTexImageEXT(Display *, GLXDrawable, int, const int *);
DLLEXPORT void GLAPIENTRY glXReleaseTexImageEXT(Display *, GLXDrawable, int);
DLLEXPORT int GLAPIENTRY glXBindVideoDeviceNV(Display *, unsigned int, unsigned int, const int *);
DLLEXPORT unsigned int *GLAPIENTRY glXEnumerateVideoDevicesNV(Display *, int, int *);
DLLEXPORT int GLAPIENTRY glXBindVideoImageNV(Display *, GLXVideoDeviceNV, GLXPbuffer, int);
DLLEXPORT int GLAPIENTRY glXGetVideoDeviceNV(Display *, int, int, GLXVideoDeviceNV *);
DLLEXPORT int GLAPIENTRY glXGetVideoInfoNV(Display *, int, GLXVideoDeviceNV, unsigned long *, unsigned long *);
DLLEXPORT int GLAPIENTRY glXReleaseVideoDeviceNV(Display *, int, GLXVideoDeviceNV);
DLLEXPORT int GLAPIENTRY glXReleaseVideoImageNV(Display *, GLXPbuffer);
DLLEXPORT int GLAPIENTRY glXSendPbufferToVideoNV(Display *, GLXPbuffer, int, unsigned long *, GLboolean);
DLLEXPORT Bool GLAPIENTRY glXBindSwapBarrierNV(Display *, GLuint, GLuint);
DLLEXPORT Bool GLAPIENTRY glXJoinSwapGroupNV(Display *, GLXDrawable, GLuint);
DLLEXPORT Bool GLAPIENTRY glXQueryFrameCountNV(Display *, int, GLuint *);
DLLEXPORT Bool GLAPIENTRY glXQueryMaxSwapGroupsNV(Display *, int, GLuint *, GLuint *);
DLLEXPORT Bool GLAPIENTRY glXQuerySwapGroupNV(Display *, GLXDrawable, GLuint *, GLuint *);
DLLEXPORT Bool GLAPIENTRY glXResetFrameCountNV(Display *, int);
DLLEXPORT void GLAPIENTRY glXSwapIntervalEXT(Display *, GLXDrawable, int);
DLLEXPORT void GLAPIENTRY glXCopyImageSubDataNV(Display *, GLXContext, GLuint, GLenum, GLint, GLint, GLint, GLint, GLXContext, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
DLLEXPORT void GLAPIENTRY glXBindTexImageATI(Display *, GLXPbuffer, int);
DLLEXPORT void GLAPIENTRY glXReleaseTexImageATI(Display *, GLXPbuffer, int);
DLLEXPORT void GLAPIENTRY glXDrawableAttribATI(Display *, GLXDrawable, const int *);
DLLEXPORT int GLAPIENTRY glXVideoResizeSUN(Display *, GLXDrawable, float);
DLLEXPORT int GLAPIENTRY glXGetVideoResizeSUN(Display *, GLXDrawable, float *);

/* Load GLX library. */

#if defined(_WIN32)
# if !defined(WIN32_LEAN_AND_MEAN)
#   define WIN32_LEAN_AND_MEAN 1
# endif
# if !defined(NOGDI)
#   define NOGDI 1
# endif
# include <windows.h>
# undef WIN32_LEAN_AND_MEAN
# undef NOGDI
#elif defined(__APPLE__)
# include <AvailabilityMacros.h>
# if !defined(MAC_OS_X_VERSION_10_3)
#   include <mach-o/dyld.h>
# else
#   include <dlfcn.h>
# endif
#else
# include <dlfcn.h>
#endif

typedef struct _TraceGLX_Handle *TraceGLX_Handle;

static TraceGLX_Handle
traceGLX_LoadLibrary(const char *filename)
{
#if defined(_WIN32)
  return (TraceGLX_Handle) LoadLibrary(filename);
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return (TraceGLX_Handle) NSAddImage(filename, NSADDIMAGE_OPTION_NONE);
#else
  return (TraceGLX_Handle) dlopen(filename, RTLD_LAZY);
#endif
}

static int
traceGLX_FreeLibrary(TraceGLX_Handle handle)
{
#if defined(_WIN32)
  return FreeLibrary((HMODULE)handle) ? 1 : 0;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return 1;
#else
  return dlclose(handle) ? 0 : 1;
#endif
}

static void *
traceGLX_GetProcAddress(TraceGLX_Handle handle, const char *name)
{
#if defined(_WIN32)
  return handle ? GetProcAddress((HMODULE)handle, name) : NULL;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return NSIsSymbolNameDefined(name) ? NSAddressOfSymbol(NSLookupAndBindSymbol(name)) : NULL;
#else
  return dlsym(handle, name);
#endif
}

static int traceGLX_initialized = 0;
static TraceGLX_Handle traceGLX_handle = NULL;

/* GLX API function pointers. */

struct TraceGLX_Functions
{
  void *(GLAPIENTRY *glXAllocateMemoryNV)(GLsizei, GLfloat, GLfloat, GLfloat);
  int (GLAPIENTRY *glXBindChannelToWindowSGIX)(Display *, int, int, Window);
  int (GLAPIENTRY *glXBindHyperpipeSGIX)(Display *, int);
  Bool (GLAPIENTRY *glXBindSwapBarrierNV)(Display *, GLuint, GLuint);
  void (GLAPIENTRY *glXBindSwapBarrierSGIX)(Display *, GLXDrawable, int);
  void (GLAPIENTRY *glXBindTexImageATI)(Display *, GLXPbuffer, int);
  void (GLAPIENTRY *glXBindTexImageEXT)(Display *, GLXDrawable, int, const int *);
  int (GLAPIENTRY *glXBindVideoDeviceNV)(Display *, unsigned int, unsigned int, const int *);
  int (GLAPIENTRY *glXBindVideoImageNV)(Display *, GLXVideoDeviceNV, GLXPbuffer, int);
  int (GLAPIENTRY *glXChannelRectSGIX)(Display *, int, int, int, int, int, int);
  int (GLAPIENTRY *glXChannelRectSyncSGIX)(Display *, int, int, GLenum);
  GLXFBConfig *(GLAPIENTRY *glXChooseFBConfig)(Display *, int, const int *, int *);
  GLXFBConfigSGIX *(GLAPIENTRY *glXChooseFBConfigSGIX)(Display *, int, const int *, int *);
  XVisualInfo *(GLAPIENTRY *glXChooseVisual)(Display *, int, int *);
  void (GLAPIENTRY *glXCopyContext)(Display *, GLXContext, GLXContext, unsigned long);
  void (GLAPIENTRY *glXCopyImageSubDataNV)(Display *, GLXContext, GLuint, GLenum, GLint, GLint, GLint, GLint, GLXContext, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
  void (GLAPIENTRY *glXCopySubBufferMESA)(Display *, GLXDrawable, int, int, int, int);
  GLXContext (GLAPIENTRY *glXCreateContext)(Display *, XVisualInfo *, GLXContext, Bool);
  GLXContext (GLAPIENTRY *glXCreateContextAttribsARB)(Display *, GLXFBConfig, GLXContext, Bool, const int *);
  GLXContext (GLAPIENTRY *glXCreateContextWithConfigSGIX)(Display *, GLXFBConfig, int, GLXContext, Bool);
  GLXPbuffer (GLAPIENTRY *glXCreateGLXPbufferSGIX)(Display *, GLXFBConfig, unsigned int, unsigned int, int *);
  GLXPixmap (GLAPIENTRY *glXCreateGLXPixmap)(Display *, XVisualInfo *, Pixmap);
  GLXPixmap (GLAPIENTRY *glXCreateGLXPixmapMESA)(Display *, XVisualInfo *, Pixmap, Colormap);
  GLXPixmap (GLAPIENTRY *glXCreateGLXPixmapWithConfigSGIX)(Display *, GLXFBConfig, Pixmap);
  GLXContext (GLAPIENTRY *glXCreateNewContext)(Display *, GLXFBConfig, int, GLXContext, Bool);
  GLXPbuffer (GLAPIENTRY *glXCreatePbuffer)(Display *, GLXFBConfig, const int *);
  GLXPixmap (GLAPIENTRY *glXCreatePixmap)(Display *, GLXFBConfig, Pixmap, const int *);
  GLXWindow (GLAPIENTRY *glXCreateWindow)(Display *, GLXFBConfig, Window, const int *);
  void (GLAPIENTRY *glXCushionSGI)(Display *, Window, float);
  void (GLAPIENTRY *glXDestroyContext)(Display *, GLXContext);
  void (GLAPIENTRY *glXDestroyGLXPbufferSGIX)(Display *, GLXPbuffer);
  void (GLAPIENTRY *glXDestroyGLXPixmap)(Display *, GLXPixmap);
  int (GLAPIENTRY *glXDestroyHyperpipeConfigSGIX)(Display *, int);
  void (GLAPIENTRY *glXDestroyPbuffer)(Display *, GLXPbuffer);
  void (GLAPIENTRY *glXDestroyPixmap)(Display *, GLXPixmap);
  void (GLAPIENTRY *glXDestroyWindow)(Display *, GLXWindow);
  void (GLAPIENTRY *glXDrawableAttribATI)(Display *, GLXDrawable, const int *);
  unsigned int *(GLAPIENTRY *glXEnumerateVideoDevicesNV)(Display *, int, int *);
  void (GLAPIENTRY *glXFreeContextEXT)(Display *, GLXContext);
  void (GLAPIENTRY *glXFreeMemoryNV)(void *);
  unsigned int (GLAPIENTRY *glXGetAGPOffsetMESA)(const void *);
  const char *(GLAPIENTRY *glXGetClientString)(Display *, int);
  int (GLAPIENTRY *glXGetConfig)(Display *, XVisualInfo *, int, int *);
  GLXContextID (GLAPIENTRY *glXGetContextIDEXT)(const GLXContext);
  GLXContext (GLAPIENTRY *glXGetCurrentContext)(void);
  Display *(GLAPIENTRY *glXGetCurrentDisplay)(void);
  GLXDrawable (GLAPIENTRY *glXGetCurrentDrawable)(void);
  GLXDrawable (GLAPIENTRY *glXGetCurrentReadDrawable)(void);
  GLXDrawable (GLAPIENTRY *glXGetCurrentReadDrawableSGI)(void);
  int (GLAPIENTRY *glXGetFBConfigAttrib)(Display *, GLXFBConfig, int, int *);
  int (GLAPIENTRY *glXGetFBConfigAttribSGIX)(Display *, GLXFBConfigSGIX, int, int *);
  GLXFBConfigSGIX (GLAPIENTRY *glXGetFBConfigFromVisualSGIX)(Display *, XVisualInfo *);
  GLXFBConfig *(GLAPIENTRY *glXGetFBConfigs)(Display *, int, int *);
  Bool (GLAPIENTRY *glXGetMscRateOML)(Display *, GLXDrawable, int32_t *, int32_t *);
  void *(GLAPIENTRY *glXGetProcAddress)(const GLubyte *);
  void *(GLAPIENTRY *glXGetProcAddressARB)(const GLubyte *);
  void (GLAPIENTRY *glXGetSelectedEvent)(Display *, GLXDrawable, unsigned long *);
  void (GLAPIENTRY *glXGetSelectedEventSGIX)(Display *, GLXDrawable, unsigned long *);
  Bool (GLAPIENTRY *glXGetSyncValuesOML)(Display *, GLXDrawable, int64_t *, int64_t *, int64_t *);
  Status (GLAPIENTRY *glXGetTransparentIndexSUN)(Display *, Window, Window, unsigned long *);
  int (GLAPIENTRY *glXGetVideoDeviceNV)(Display *, int, int, GLXVideoDeviceNV *);
  int (GLAPIENTRY *glXGetVideoInfoNV)(Display *, int, GLXVideoDeviceNV, unsigned long *, unsigned long *);
  int (GLAPIENTRY *glXGetVideoResizeSUN)(Display *, GLXDrawable, float *);
  int (GLAPIENTRY *glXGetVideoSyncSGI)(unsigned int *);
  XVisualInfo *(GLAPIENTRY *glXGetVisualFromFBConfig)(Display *, GLXFBConfig);
  XVisualInfo *(GLAPIENTRY *glXGetVisualFromFBConfigSGIX)(Display *, GLXFBConfig);
  int (GLAPIENTRY *glXHyperpipeAttribSGIX)(Display *, int, int, int, void *);
  int (GLAPIENTRY *glXHyperpipeConfigSGIX)(Display *, int, int, GLXHyperpipeConfigSGIX *, int *);
  GLXContext (GLAPIENTRY *glXImportContextEXT)(Display *, GLXContextID);
  Bool (GLAPIENTRY *glXIsDirect)(Display *, GLXContext);
  Bool (GLAPIENTRY *glXJoinSwapGroupNV)(Display *, GLXDrawable, GLuint);
  void (GLAPIENTRY *glXJoinSwapGroupSGIX)(Display *, GLXDrawable, GLXDrawable);
  Bool (GLAPIENTRY *glXMakeContextCurrent)(Display *, GLXDrawable, GLXDrawable, GLXContext);
  Bool (GLAPIENTRY *glXMakeCurrent)(Display *, GLXDrawable, GLXContext);
  Bool (GLAPIENTRY *glXMakeCurrentReadSGI)(Display *, GLXDrawable, GLXDrawable, GLXContext);
  int (GLAPIENTRY *glXQueryChannelDeltasSGIX)(Display *, int, int, int *, int *, int *, int *);
  int (GLAPIENTRY *glXQueryChannelRectSGIX)(Display *, int, int, int *, int *, int *, int *);
  int (GLAPIENTRY *glXQueryContext)(Display *, GLXContext, int, int *);
  int (GLAPIENTRY *glXQueryContextInfoEXT)(Display *, GLXContext, int, int *);
  void (GLAPIENTRY *glXQueryDrawable)(Display *, GLXDrawable, int, unsigned int *);
  Bool (GLAPIENTRY *glXQueryExtension)(Display *, int *, int *);
  const char *(GLAPIENTRY *glXQueryExtensionsString)(Display *, int);
  Bool (GLAPIENTRY *glXQueryFrameCountNV)(Display *, int, GLuint *);
  void (GLAPIENTRY *glXQueryGLXPbufferSGIX)(Display *, GLXPbuffer, int, unsigned int *);
  int (GLAPIENTRY *glXQueryHyperpipeAttribSGIX)(Display *, int, int, int, void *);
  int (GLAPIENTRY *glXQueryHyperpipeBestAttribSGIX)(Display *, int, int, int, void *, void *);
  GLXHyperpipeConfigSGIX *(GLAPIENTRY *glXQueryHyperpipeConfigSGIX)(Display *, int, int *);
  GLXHyperpipeNetworkSGIX *(GLAPIENTRY *glXQueryHyperpipeNetworkSGIX)(Display *, int *);
  Bool (GLAPIENTRY *glXQueryMaxSwapBarriersSGIX)(Display *, int, int *);
  Bool (GLAPIENTRY *glXQueryMaxSwapGroupsNV)(Display *, int, GLuint *, GLuint *);
  const char *(GLAPIENTRY *glXQueryServerString)(Display *, int, int);
  Bool (GLAPIENTRY *glXQuerySwapGroupNV)(Display *, GLXDrawable, GLuint *, GLuint *);
  Bool (GLAPIENTRY *glXQueryVersion)(Display *, int *, int *);
  Bool (GLAPIENTRY *glXReleaseBuffersMESA)(Display *, GLXDrawable);
  void (GLAPIENTRY *glXReleaseTexImageATI)(Display *, GLXPbuffer, int);
  void (GLAPIENTRY *glXReleaseTexImageEXT)(Display *, GLXDrawable, int);
  int (GLAPIENTRY *glXReleaseVideoDeviceNV)(Display *, int, GLXVideoDeviceNV);
  int (GLAPIENTRY *glXReleaseVideoImageNV)(Display *, GLXPbuffer);
  Bool (GLAPIENTRY *glXResetFrameCountNV)(Display *, int);
  void (GLAPIENTRY *glXSelectEvent)(Display *, GLXDrawable, unsigned long);
  void (GLAPIENTRY *glXSelectEventSGIX)(Display *, GLXDrawable, unsigned long);
  int (GLAPIENTRY *glXSendPbufferToVideoNV)(Display *, GLXPbuffer, int, unsigned long *, GLboolean);
  GLboolean (GLAPIENTRY *glXSet3DfxModeMESA)(GLint);
  void (GLAPIENTRY *glXSwapBuffers)(Display *, GLXDrawable);
  int64_t (GLAPIENTRY *glXSwapBuffersMscOML)(Display *, GLXDrawable, int64_t, int64_t, int64_t);
  void (GLAPIENTRY *glXSwapIntervalEXT)(Display *, GLXDrawable, int);
  int (GLAPIENTRY *glXSwapIntervalSGI)(int);
  void (GLAPIENTRY *glXUseXFont)(Font, int, int, int);
  int (GLAPIENTRY *glXVideoResizeSUN)(Display *, GLXDrawable, float);
  Bool (GLAPIENTRY *glXWaitForMscOML)(Display *, GLXDrawable, int64_t, int64_t, int64_t, int64_t *, int64_t *, int64_t *);
  Bool (GLAPIENTRY *glXWaitForSbcOML)(Display *, GLXDrawable, int64_t, int64_t *, int64_t *, int64_t *);
  void (GLAPIENTRY *glXWaitGL)(void);
  int (GLAPIENTRY *glXWaitVideoSyncSGI)(int, int, unsigned int *);
  void (GLAPIENTRY *glXWaitX)(void);
};

static struct TraceGLX_Functions traceGLX_Native;

/* GLX proc address related functions. */

static void  traceGLX_lookupNativeAddress(const char *name, void **procPtr);
static void *traceGLX_lookupWrapperAddress(const char *name, void *proc);

/* Initialize TraceGLX. */

void
traceGLX_init(void)
{
  const char *library = "GLX";
  const char *filename = NULL;

  if (traceGLX_initialized)
    return;

  /* Do pre-initialization */

  /* Load the native library */

  filename = traceLibraryLocation(library);
  traceGLX_handle = traceGLX_LoadLibrary(filename);
  if (!traceGLX_handle)
  {
    traceError("Failed to load %s from %s", library, filename);
    return;
  }
  traceInfo("Loaded %s from %s", library, filename);

  /* Load GLX API functions. */

  memset(&traceGLX_Native, 0, sizeof(struct TraceGLX_Functions));

  traceGLX_Native.glXQueryExtension = (Bool (GLAPIENTRY *)(Display *, int *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryExtension");
  traceGLX_Native.glXQueryVersion = (Bool (GLAPIENTRY *)(Display *, int *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryVersion");
  traceGLX_Native.glXGetConfig = (int (GLAPIENTRY *)(Display *, XVisualInfo *, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetConfig");
  traceGLX_Native.glXChooseVisual = (XVisualInfo *(GLAPIENTRY *)(Display *, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXChooseVisual");
  traceGLX_Native.glXCreateGLXPixmap = (GLXPixmap (GLAPIENTRY *)(Display *, XVisualInfo *, Pixmap)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateGLXPixmap");
  traceGLX_Native.glXDestroyGLXPixmap = (void (GLAPIENTRY *)(Display *, GLXPixmap)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyGLXPixmap");
  traceGLX_Native.glXCreateContext = (GLXContext (GLAPIENTRY *)(Display *, XVisualInfo *, GLXContext, Bool)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateContext");
  traceGLX_Native.glXDestroyContext = (void (GLAPIENTRY *)(Display *, GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyContext");
  traceGLX_Native.glXIsDirect = (Bool (GLAPIENTRY *)(Display *, GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXIsDirect");
  traceGLX_Native.glXCopyContext = (void (GLAPIENTRY *)(Display *, GLXContext, GLXContext, unsigned long)) traceGLX_GetProcAddress(traceGLX_handle, "glXCopyContext");
  traceGLX_Native.glXMakeCurrent = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXMakeCurrent");
  traceGLX_Native.glXGetCurrentContext = (GLXContext (GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetCurrentContext");
  traceGLX_Native.glXGetCurrentDrawable = (GLXDrawable (GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetCurrentDrawable");
  traceGLX_Native.glXWaitGL = (void (GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXWaitGL");
  traceGLX_Native.glXWaitX = (void (GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXWaitX");
  traceGLX_Native.glXSwapBuffers = (void (GLAPIENTRY *)(Display *, GLXDrawable)) traceGLX_GetProcAddress(traceGLX_handle, "glXSwapBuffers");
  traceGLX_Native.glXUseXFont = (void (GLAPIENTRY *)(Font, int, int, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXUseXFont");
  traceGLX_Native.glXQueryExtensionsString = (const char *(GLAPIENTRY *)(Display *, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryExtensionsString");
  traceGLX_Native.glXGetClientString = (const char *(GLAPIENTRY *)(Display *, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetClientString");
  traceGLX_Native.glXQueryServerString = (const char *(GLAPIENTRY *)(Display *, int, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryServerString");
  traceGLX_Native.glXGetCurrentDisplay = (Display *(GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetCurrentDisplay");
  traceGLX_Native.glXChooseFBConfig = (GLXFBConfig *(GLAPIENTRY *)(Display *, int, const int *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXChooseFBConfig");
  traceGLX_Native.glXGetFBConfigs = (GLXFBConfig *(GLAPIENTRY *)(Display *, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetFBConfigs");
  traceGLX_Native.glXGetVisualFromFBConfig = (XVisualInfo *(GLAPIENTRY *)(Display *, GLXFBConfig)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetVisualFromFBConfig");
  traceGLX_Native.glXGetFBConfigAttrib = (int (GLAPIENTRY *)(Display *, GLXFBConfig, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetFBConfigAttrib");
  traceGLX_Native.glXCreateWindow = (GLXWindow (GLAPIENTRY *)(Display *, GLXFBConfig, Window, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateWindow");
  traceGLX_Native.glXDestroyWindow = (void (GLAPIENTRY *)(Display *, GLXWindow)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyWindow");
  traceGLX_Native.glXCreatePixmap = (GLXPixmap (GLAPIENTRY *)(Display *, GLXFBConfig, Pixmap, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreatePixmap");
  traceGLX_Native.glXDestroyPixmap = (void (GLAPIENTRY *)(Display *, GLXPixmap)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyPixmap");
  traceGLX_Native.glXCreatePbuffer = (GLXPbuffer (GLAPIENTRY *)(Display *, GLXFBConfig, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreatePbuffer");
  traceGLX_Native.glXDestroyPbuffer = (void (GLAPIENTRY *)(Display *, GLXPbuffer)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyPbuffer");
  traceGLX_Native.glXQueryDrawable = (void (GLAPIENTRY *)(Display *, GLXDrawable, int, unsigned int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryDrawable");
  traceGLX_Native.glXCreateNewContext = (GLXContext (GLAPIENTRY *)(Display *, GLXFBConfig, int, GLXContext, Bool)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateNewContext");
  traceGLX_Native.glXMakeContextCurrent = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, GLXDrawable, GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXMakeContextCurrent");
  traceGLX_Native.glXGetCurrentReadDrawable = (GLXDrawable (GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetCurrentReadDrawable");
  traceGLX_Native.glXQueryContext = (int (GLAPIENTRY *)(Display *, GLXContext, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryContext");
  traceGLX_Native.glXSelectEvent = (void (GLAPIENTRY *)(Display *, GLXDrawable, unsigned long)) traceGLX_GetProcAddress(traceGLX_handle, "glXSelectEvent");
  traceGLX_Native.glXGetSelectedEvent = (void (GLAPIENTRY *)(Display *, GLXDrawable, unsigned long *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetSelectedEvent");
  traceGLX_Native.glXGetProcAddress = (void *(GLAPIENTRY *)(const GLubyte *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetProcAddress");
  traceGLX_Native.glXGetProcAddressARB = (void *(GLAPIENTRY *)(const GLubyte *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetProcAddressARB");
  traceGLX_Native.glXCreateContextAttribsARB = (GLXContext (GLAPIENTRY *)(Display *, GLXFBConfig, GLXContext, Bool, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateContextAttribsARB");
  traceGLX_Native.glXSwapIntervalSGI = (int (GLAPIENTRY *)(int)) traceGLX_GetProcAddress(traceGLX_handle, "glXSwapIntervalSGI");
  traceGLX_Native.glXGetVideoSyncSGI = (int (GLAPIENTRY *)(unsigned int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetVideoSyncSGI");
  traceGLX_Native.glXWaitVideoSyncSGI = (int (GLAPIENTRY *)(int, int, unsigned int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXWaitVideoSyncSGI");
  traceGLX_Native.glXGetCurrentReadDrawableSGI = (GLXDrawable (GLAPIENTRY *)(void)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetCurrentReadDrawableSGI");
  traceGLX_Native.glXMakeCurrentReadSGI = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, GLXDrawable, GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXMakeCurrentReadSGI");
  traceGLX_Native.glXFreeContextEXT = (void (GLAPIENTRY *)(Display *, GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXFreeContextEXT");
  traceGLX_Native.glXGetContextIDEXT = (GLXContextID (GLAPIENTRY *)(const GLXContext)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetContextIDEXT");
  traceGLX_Native.glXImportContextEXT = (GLXContext (GLAPIENTRY *)(Display *, GLXContextID)) traceGLX_GetProcAddress(traceGLX_handle, "glXImportContextEXT");
  traceGLX_Native.glXQueryContextInfoEXT = (int (GLAPIENTRY *)(Display *, GLXContext, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryContextInfoEXT");
  traceGLX_Native.glXChooseFBConfigSGIX = (GLXFBConfigSGIX *(GLAPIENTRY *)(Display *, int, const int *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXChooseFBConfigSGIX");
  traceGLX_Native.glXCreateContextWithConfigSGIX = (GLXContext (GLAPIENTRY *)(Display *, GLXFBConfig, int, GLXContext, Bool)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateContextWithConfigSGIX");
  traceGLX_Native.glXCreateGLXPixmapWithConfigSGIX = (GLXPixmap (GLAPIENTRY *)(Display *, GLXFBConfig, Pixmap)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateGLXPixmapWithConfigSGIX");
  traceGLX_Native.glXGetFBConfigAttribSGIX = (int (GLAPIENTRY *)(Display *, GLXFBConfigSGIX, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetFBConfigAttribSGIX");
  traceGLX_Native.glXGetFBConfigFromVisualSGIX = (GLXFBConfigSGIX (GLAPIENTRY *)(Display *, XVisualInfo *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetFBConfigFromVisualSGIX");
  traceGLX_Native.glXGetVisualFromFBConfigSGIX = (XVisualInfo *(GLAPIENTRY *)(Display *, GLXFBConfig)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetVisualFromFBConfigSGIX");
  traceGLX_Native.glXCreateGLXPbufferSGIX = (GLXPbuffer (GLAPIENTRY *)(Display *, GLXFBConfig, unsigned int, unsigned int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateGLXPbufferSGIX");
  traceGLX_Native.glXDestroyGLXPbufferSGIX = (void (GLAPIENTRY *)(Display *, GLXPbuffer)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyGLXPbufferSGIX");
  traceGLX_Native.glXGetSelectedEventSGIX = (void (GLAPIENTRY *)(Display *, GLXDrawable, unsigned long *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetSelectedEventSGIX");
  traceGLX_Native.glXQueryGLXPbufferSGIX = (void (GLAPIENTRY *)(Display *, GLXPbuffer, int, unsigned int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryGLXPbufferSGIX");
  traceGLX_Native.glXSelectEventSGIX = (void (GLAPIENTRY *)(Display *, GLXDrawable, unsigned long)) traceGLX_GetProcAddress(traceGLX_handle, "glXSelectEventSGIX");
  traceGLX_Native.glXCushionSGI = (void (GLAPIENTRY *)(Display *, Window, float)) traceGLX_GetProcAddress(traceGLX_handle, "glXCushionSGI");
  traceGLX_Native.glXBindChannelToWindowSGIX = (int (GLAPIENTRY *)(Display *, int, int, Window)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindChannelToWindowSGIX");
  traceGLX_Native.glXChannelRectSGIX = (int (GLAPIENTRY *)(Display *, int, int, int, int, int, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXChannelRectSGIX");
  traceGLX_Native.glXChannelRectSyncSGIX = (int (GLAPIENTRY *)(Display *, int, int, GLenum)) traceGLX_GetProcAddress(traceGLX_handle, "glXChannelRectSyncSGIX");
  traceGLX_Native.glXQueryChannelDeltasSGIX = (int (GLAPIENTRY *)(Display *, int, int, int *, int *, int *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryChannelDeltasSGIX");
  traceGLX_Native.glXQueryChannelRectSGIX = (int (GLAPIENTRY *)(Display *, int, int, int *, int *, int *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryChannelRectSGIX");
  traceGLX_Native.glXJoinSwapGroupSGIX = (void (GLAPIENTRY *)(Display *, GLXDrawable, GLXDrawable)) traceGLX_GetProcAddress(traceGLX_handle, "glXJoinSwapGroupSGIX");
  traceGLX_Native.glXBindSwapBarrierSGIX = (void (GLAPIENTRY *)(Display *, GLXDrawable, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindSwapBarrierSGIX");
  traceGLX_Native.glXQueryMaxSwapBarriersSGIX = (Bool (GLAPIENTRY *)(Display *, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryMaxSwapBarriersSGIX");
  traceGLX_Native.glXGetTransparentIndexSUN = (Status (GLAPIENTRY *)(Display *, Window, Window, unsigned long *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetTransparentIndexSUN");
  traceGLX_Native.glXAllocateMemoryNV = (void *(GLAPIENTRY *)(GLsizei, GLfloat, GLfloat, GLfloat)) traceGLX_GetProcAddress(traceGLX_handle, "glXAllocateMemoryNV");
  traceGLX_Native.glXFreeMemoryNV = (void (GLAPIENTRY *)(void *)) traceGLX_GetProcAddress(traceGLX_handle, "glXFreeMemoryNV");
  traceGLX_Native.glXCopySubBufferMESA = (void (GLAPIENTRY *)(Display *, GLXDrawable, int, int, int, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXCopySubBufferMESA");
  traceGLX_Native.glXCreateGLXPixmapMESA = (GLXPixmap (GLAPIENTRY *)(Display *, XVisualInfo *, Pixmap, Colormap)) traceGLX_GetProcAddress(traceGLX_handle, "glXCreateGLXPixmapMESA");
  traceGLX_Native.glXReleaseBuffersMESA = (Bool (GLAPIENTRY *)(Display *, GLXDrawable)) traceGLX_GetProcAddress(traceGLX_handle, "glXReleaseBuffersMESA");
  traceGLX_Native.glXSet3DfxModeMESA = (GLboolean (GLAPIENTRY *)(GLint)) traceGLX_GetProcAddress(traceGLX_handle, "glXSet3DfxModeMESA");
  traceGLX_Native.glXGetMscRateOML = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, int32_t *, int32_t *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetMscRateOML");
  traceGLX_Native.glXGetSyncValuesOML = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, int64_t *, int64_t *, int64_t *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetSyncValuesOML");
  traceGLX_Native.glXSwapBuffersMscOML = (int64_t (GLAPIENTRY *)(Display *, GLXDrawable, int64_t, int64_t, int64_t)) traceGLX_GetProcAddress(traceGLX_handle, "glXSwapBuffersMscOML");
  traceGLX_Native.glXWaitForMscOML = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, int64_t, int64_t, int64_t, int64_t *, int64_t *, int64_t *)) traceGLX_GetProcAddress(traceGLX_handle, "glXWaitForMscOML");
  traceGLX_Native.glXWaitForSbcOML = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, int64_t, int64_t *, int64_t *, int64_t *)) traceGLX_GetProcAddress(traceGLX_handle, "glXWaitForSbcOML");
  traceGLX_Native.glXQueryHyperpipeNetworkSGIX = (GLXHyperpipeNetworkSGIX *(GLAPIENTRY *)(Display *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryHyperpipeNetworkSGIX");
  traceGLX_Native.glXHyperpipeConfigSGIX = (int (GLAPIENTRY *)(Display *, int, int, GLXHyperpipeConfigSGIX *, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXHyperpipeConfigSGIX");
  traceGLX_Native.glXQueryHyperpipeConfigSGIX = (GLXHyperpipeConfigSGIX *(GLAPIENTRY *)(Display *, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryHyperpipeConfigSGIX");
  traceGLX_Native.glXDestroyHyperpipeConfigSGIX = (int (GLAPIENTRY *)(Display *, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXDestroyHyperpipeConfigSGIX");
  traceGLX_Native.glXBindHyperpipeSGIX = (int (GLAPIENTRY *)(Display *, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindHyperpipeSGIX");
  traceGLX_Native.glXQueryHyperpipeBestAttribSGIX = (int (GLAPIENTRY *)(Display *, int, int, int, void *, void *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryHyperpipeBestAttribSGIX");
  traceGLX_Native.glXHyperpipeAttribSGIX = (int (GLAPIENTRY *)(Display *, int, int, int, void *)) traceGLX_GetProcAddress(traceGLX_handle, "glXHyperpipeAttribSGIX");
  traceGLX_Native.glXQueryHyperpipeAttribSGIX = (int (GLAPIENTRY *)(Display *, int, int, int, void *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryHyperpipeAttribSGIX");
  traceGLX_Native.glXGetAGPOffsetMESA = (unsigned int (GLAPIENTRY *)(const void *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetAGPOffsetMESA");
  traceGLX_Native.glXBindTexImageEXT = (void (GLAPIENTRY *)(Display *, GLXDrawable, int, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindTexImageEXT");
  traceGLX_Native.glXReleaseTexImageEXT = (void (GLAPIENTRY *)(Display *, GLXDrawable, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXReleaseTexImageEXT");
  traceGLX_Native.glXBindVideoDeviceNV = (int (GLAPIENTRY *)(Display *, unsigned int, unsigned int, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindVideoDeviceNV");
  traceGLX_Native.glXEnumerateVideoDevicesNV = (unsigned int *(GLAPIENTRY *)(Display *, int, int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXEnumerateVideoDevicesNV");
  traceGLX_Native.glXBindVideoImageNV = (int (GLAPIENTRY *)(Display *, GLXVideoDeviceNV, GLXPbuffer, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindVideoImageNV");
  traceGLX_Native.glXGetVideoDeviceNV = (int (GLAPIENTRY *)(Display *, int, int, GLXVideoDeviceNV *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetVideoDeviceNV");
  traceGLX_Native.glXGetVideoInfoNV = (int (GLAPIENTRY *)(Display *, int, GLXVideoDeviceNV, unsigned long *, unsigned long *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetVideoInfoNV");
  traceGLX_Native.glXReleaseVideoDeviceNV = (int (GLAPIENTRY *)(Display *, int, GLXVideoDeviceNV)) traceGLX_GetProcAddress(traceGLX_handle, "glXReleaseVideoDeviceNV");
  traceGLX_Native.glXReleaseVideoImageNV = (int (GLAPIENTRY *)(Display *, GLXPbuffer)) traceGLX_GetProcAddress(traceGLX_handle, "glXReleaseVideoImageNV");
  traceGLX_Native.glXSendPbufferToVideoNV = (int (GLAPIENTRY *)(Display *, GLXPbuffer, int, unsigned long *, GLboolean)) traceGLX_GetProcAddress(traceGLX_handle, "glXSendPbufferToVideoNV");
  traceGLX_Native.glXBindSwapBarrierNV = (Bool (GLAPIENTRY *)(Display *, GLuint, GLuint)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindSwapBarrierNV");
  traceGLX_Native.glXJoinSwapGroupNV = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, GLuint)) traceGLX_GetProcAddress(traceGLX_handle, "glXJoinSwapGroupNV");
  traceGLX_Native.glXQueryFrameCountNV = (Bool (GLAPIENTRY *)(Display *, int, GLuint *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryFrameCountNV");
  traceGLX_Native.glXQueryMaxSwapGroupsNV = (Bool (GLAPIENTRY *)(Display *, int, GLuint *, GLuint *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQueryMaxSwapGroupsNV");
  traceGLX_Native.glXQuerySwapGroupNV = (Bool (GLAPIENTRY *)(Display *, GLXDrawable, GLuint *, GLuint *)) traceGLX_GetProcAddress(traceGLX_handle, "glXQuerySwapGroupNV");
  traceGLX_Native.glXResetFrameCountNV = (Bool (GLAPIENTRY *)(Display *, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXResetFrameCountNV");
  traceGLX_Native.glXSwapIntervalEXT = (void (GLAPIENTRY *)(Display *, GLXDrawable, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXSwapIntervalEXT");
  traceGLX_Native.glXCopyImageSubDataNV = (void (GLAPIENTRY *)(Display *, GLXContext, GLuint, GLenum, GLint, GLint, GLint, GLint, GLXContext, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei)) traceGLX_GetProcAddress(traceGLX_handle, "glXCopyImageSubDataNV");
  traceGLX_Native.glXBindTexImageATI = (void (GLAPIENTRY *)(Display *, GLXPbuffer, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXBindTexImageATI");
  traceGLX_Native.glXReleaseTexImageATI = (void (GLAPIENTRY *)(Display *, GLXPbuffer, int)) traceGLX_GetProcAddress(traceGLX_handle, "glXReleaseTexImageATI");
  traceGLX_Native.glXDrawableAttribATI = (void (GLAPIENTRY *)(Display *, GLXDrawable, const int *)) traceGLX_GetProcAddress(traceGLX_handle, "glXDrawableAttribATI");
  traceGLX_Native.glXVideoResizeSUN = (int (GLAPIENTRY *)(Display *, GLXDrawable, float)) traceGLX_GetProcAddress(traceGLX_handle, "glXVideoResizeSUN");
  traceGLX_Native.glXGetVideoResizeSUN = (int (GLAPIENTRY *)(Display *, GLXDrawable, float *)) traceGLX_GetProcAddress(traceGLX_handle, "glXGetVideoResizeSUN");

  /* Validate GLX API functions. */

  traceGLX_initialized = 1;
}

/* GLX API wrapper functions. */

DLLEXPORT Bool GLAPIENTRY
glXQueryExtension(Display *dpy, int *errorBase, int *eventBase)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryExtension)
    traceGLX_lookupNativeAddress("glXQueryExtension", (void **) &traceGLX_Native.glXQueryExtension);

  traceThis = traceEnabled("glXQueryExtension",&traceParam);

  if (!traceGLX_Native.glXQueryExtension)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryExtension");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryExtension(dpy, errorBase, eventBase);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXQueryVersion(Display *dpy, int *major, int *minor)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryVersion)
    traceGLX_lookupNativeAddress("glXQueryVersion", (void **) &traceGLX_Native.glXQueryVersion);

  traceThis = traceEnabled("glXQueryVersion",&traceParam);

  if (!traceGLX_Native.glXQueryVersion)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryVersion");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryVersion(dpy, major, minor);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetConfig(Display *dpy, XVisualInfo *vis, int attrib, int *value)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetConfig)
    traceGLX_lookupNativeAddress("glXGetConfig", (void **) &traceGLX_Native.glXGetConfig);

  traceThis = traceEnabled("glXGetConfig",&traceParam);

  if (!traceGLX_Native.glXGetConfig)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetConfig");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("attrib", "%d", attrib);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetConfig(dpy, vis, attrib, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT XVisualInfo *GLAPIENTRY
glXChooseVisual(Display *dpy, int screen, int *attribList)
{
  XVisualInfo *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXChooseVisual)
    traceGLX_lookupNativeAddress("glXChooseVisual", (void **) &traceGLX_Native.glXChooseVisual);

  traceThis = traceEnabled("glXChooseVisual",&traceParam);

  if (!traceGLX_Native.glXChooseVisual)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXChooseVisual");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXChooseVisual(dpy, screen, attribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXPixmap GLAPIENTRY
glXCreateGLXPixmap(Display *dpy, XVisualInfo *vis, Pixmap pixmap)
{
  GLXPixmap ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateGLXPixmap)
    traceGLX_lookupNativeAddress("glXCreateGLXPixmap", (void **) &traceGLX_Native.glXCreateGLXPixmap);

  traceThis = traceEnabled("glXCreateGLXPixmap",&traceParam);

  if (!traceGLX_Native.glXCreateGLXPixmap)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateGLXPixmap");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pixmap", "%lu", pixmap);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateGLXPixmap(dpy, vis, pixmap);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXDestroyGLXPixmap(Display *dpy, GLXPixmap pix)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyGLXPixmap)
    traceGLX_lookupNativeAddress("glXDestroyGLXPixmap", (void **) &traceGLX_Native.glXDestroyGLXPixmap);

  traceThis = traceEnabled("glXDestroyGLXPixmap",&traceParam);

  if (!traceGLX_Native.glXDestroyGLXPixmap)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyGLXPixmap");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pix", "%lu", pix);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDestroyGLXPixmap(dpy, pix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLXContext GLAPIENTRY
glXCreateContext(Display *dpy, XVisualInfo *vis, GLXContext shareList, Bool direct)
{
  GLXContext ret = (GLXContext) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateContext)
    traceGLX_lookupNativeAddress("glXCreateContext", (void **) &traceGLX_Native.glXCreateContext);

  traceThis = traceEnabled("glXCreateContext",&traceParam);

  if (!traceGLX_Native.glXCreateContext)
    return (GLXContext) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateContext");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateContext(dpy, vis, shareList, direct);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXDestroyContext(Display *dpy, GLXContext ctx)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyContext)
    traceGLX_lookupNativeAddress("glXDestroyContext", (void **) &traceGLX_Native.glXDestroyContext);

  traceThis = traceEnabled("glXDestroyContext",&traceParam);

  if (!traceGLX_Native.glXDestroyContext)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyContext");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDestroyContext(dpy, ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT Bool GLAPIENTRY
glXIsDirect(Display *dpy, GLXContext ctx)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXIsDirect)
    traceGLX_lookupNativeAddress("glXIsDirect", (void **) &traceGLX_Native.glXIsDirect);

  traceThis = traceEnabled("glXIsDirect",&traceParam);

  if (!traceGLX_Native.glXIsDirect)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXIsDirect");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXIsDirect(dpy, ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXCopyContext(Display *dpy, GLXContext src, GLXContext dst, unsigned long mask)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCopyContext)
    traceGLX_lookupNativeAddress("glXCopyContext", (void **) &traceGLX_Native.glXCopyContext);

  traceThis = traceEnabled("glXCopyContext",&traceParam);

  if (!traceGLX_Native.glXCopyContext)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCopyContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("mask", "%lu", mask);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXCopyContext(dpy, src, dst, mask);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT Bool GLAPIENTRY
glXMakeCurrent(Display *dpy, GLXDrawable drawable, GLXContext ctx)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXMakeCurrent)
    traceGLX_lookupNativeAddress("glXMakeCurrent", (void **) &traceGLX_Native.glXMakeCurrent);

  traceThis = traceEnabled("glXMakeCurrent",&traceParam);

  if (!traceGLX_Native.glXMakeCurrent)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXMakeCurrent");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXMakeCurrent(dpy, drawable, ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXContext GLAPIENTRY
glXGetCurrentContext()
{
  GLXContext ret = (GLXContext) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetCurrentContext)
    traceGLX_lookupNativeAddress("glXGetCurrentContext", (void **) &traceGLX_Native.glXGetCurrentContext);

  traceThis = traceEnabled("glXGetCurrentContext",&traceParam);

  if (!traceGLX_Native.glXGetCurrentContext)
    return (GLXContext) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetCurrentContext");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetCurrentContext();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXDrawable GLAPIENTRY
glXGetCurrentDrawable()
{
  GLXDrawable ret = (GLXDrawable) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetCurrentDrawable)
    traceGLX_lookupNativeAddress("glXGetCurrentDrawable", (void **) &traceGLX_Native.glXGetCurrentDrawable);

  traceThis = traceEnabled("glXGetCurrentDrawable",&traceParam);

  if (!traceGLX_Native.glXGetCurrentDrawable)
    return (GLXDrawable) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetCurrentDrawable");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetCurrentDrawable();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXWaitGL()
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXWaitGL)
    traceGLX_lookupNativeAddress("glXWaitGL", (void **) &traceGLX_Native.glXWaitGL);

  traceThis = traceEnabled("glXWaitGL",&traceParam);

  if (!traceGLX_Native.glXWaitGL)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXWaitGL");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXWaitGL();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXWaitX()
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXWaitX)
    traceGLX_lookupNativeAddress("glXWaitX", (void **) &traceGLX_Native.glXWaitX);

  traceThis = traceEnabled("glXWaitX",&traceParam);

  if (!traceGLX_Native.glXWaitX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXWaitX");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXWaitX();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXSwapBuffers(Display *dpy, GLXDrawable drawable)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSwapBuffers)
    traceGLX_lookupNativeAddress("glXSwapBuffers", (void **) &traceGLX_Native.glXSwapBuffers);

  traceThis = traceEnabled("glXSwapBuffers",&traceParam);

  if (!traceGLX_Native.glXSwapBuffers)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSwapBuffers");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXSwapBuffers(dpy, drawable);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXUseXFont(Font font, int first, int count, int listBase)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXUseXFont)
    traceGLX_lookupNativeAddress("glXUseXFont", (void **) &traceGLX_Native.glXUseXFont);

  traceThis = traceEnabled("glXUseXFont",&traceParam);

  if (!traceGLX_Native.glXUseXFont)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXUseXFont");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("font", "%lu", font);
      traceInputParameter("first", "%d", first);
      traceInputParameter("count", "%d", count);
      traceInputParameter("listBase", "%d", listBase);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXUseXFont(font, first, count, listBase);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT const char *GLAPIENTRY
glXQueryExtensionsString(Display *dpy, int screen)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryExtensionsString)
    traceGLX_lookupNativeAddress("glXQueryExtensionsString", (void **) &traceGLX_Native.glXQueryExtensionsString);

  traceThis = traceEnabled("glXQueryExtensionsString",&traceParam);

  if (!traceGLX_Native.glXQueryExtensionsString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryExtensionsString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryExtensionsString(dpy, screen);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *GLAPIENTRY
glXGetClientString(Display *dpy, int name)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetClientString)
    traceGLX_lookupNativeAddress("glXGetClientString", (void **) &traceGLX_Native.glXGetClientString);

  traceThis = traceEnabled("glXGetClientString",&traceParam);

  if (!traceGLX_Native.glXGetClientString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetClientString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("name", "%d", name);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetClientString(dpy, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *GLAPIENTRY
glXQueryServerString(Display *dpy, int screen, int name)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryServerString)
    traceGLX_lookupNativeAddress("glXQueryServerString", (void **) &traceGLX_Native.glXQueryServerString);

  traceThis = traceEnabled("glXQueryServerString",&traceParam);

  if (!traceGLX_Native.glXQueryServerString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryServerString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("name", "%d", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryServerString(dpy, screen, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Display *GLAPIENTRY
glXGetCurrentDisplay()
{
  Display *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetCurrentDisplay)
    traceGLX_lookupNativeAddress("glXGetCurrentDisplay", (void **) &traceGLX_Native.glXGetCurrentDisplay);

  traceThis = traceEnabled("glXGetCurrentDisplay",&traceParam);

  if (!traceGLX_Native.glXGetCurrentDisplay)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetCurrentDisplay");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetCurrentDisplay();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXFBConfig *GLAPIENTRY
glXChooseFBConfig(Display *dpy, int screen, const int *attrib_list, int *nelements)
{
  GLXFBConfig *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXChooseFBConfig)
    traceGLX_lookupNativeAddress("glXChooseFBConfig", (void **) &traceGLX_Native.glXChooseFBConfig);

  traceThis = traceEnabled("glXChooseFBConfig",&traceParam);

  if (!traceGLX_Native.glXChooseFBConfig)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXChooseFBConfig");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXChooseFBConfig(dpy, screen, attrib_list, nelements);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("nelements", "%d[%d]", nelements, 1);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXFBConfig *GLAPIENTRY
glXGetFBConfigs(Display *dpy, int screen, int *nelements)
{
  GLXFBConfig *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetFBConfigs)
    traceGLX_lookupNativeAddress("glXGetFBConfigs", (void **) &traceGLX_Native.glXGetFBConfigs);

  traceThis = traceEnabled("glXGetFBConfigs",&traceParam);

  if (!traceGLX_Native.glXGetFBConfigs)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetFBConfigs");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetFBConfigs(dpy, screen, nelements);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("nelements", "%d[%d]", nelements, 1);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT XVisualInfo *GLAPIENTRY
glXGetVisualFromFBConfig(Display *dpy, GLXFBConfig config)
{
  XVisualInfo *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetVisualFromFBConfig)
    traceGLX_lookupNativeAddress("glXGetVisualFromFBConfig", (void **) &traceGLX_Native.glXGetVisualFromFBConfig);

  traceThis = traceEnabled("glXGetVisualFromFBConfig",&traceParam);

  if (!traceGLX_Native.glXGetVisualFromFBConfig)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetVisualFromFBConfig");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetVisualFromFBConfig(dpy, config);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetFBConfigAttrib(Display *dpy, GLXFBConfig config, int attribute, int *value)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetFBConfigAttrib)
    traceGLX_lookupNativeAddress("glXGetFBConfigAttrib", (void **) &traceGLX_Native.glXGetFBConfigAttrib);

  traceThis = traceEnabled("glXGetFBConfigAttrib",&traceParam);

  if (!traceGLX_Native.glXGetFBConfigAttrib)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetFBConfigAttrib");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("attribute", "%d", attribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetFBConfigAttrib(dpy, config, attribute, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("value", "%d[%d]", value, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXWindow GLAPIENTRY
glXCreateWindow(Display *dpy, GLXFBConfig config, Window win, const int *attrib_list)
{
  GLXWindow ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateWindow)
    traceGLX_lookupNativeAddress("glXCreateWindow", (void **) &traceGLX_Native.glXCreateWindow);

  traceThis = traceEnabled("glXCreateWindow",&traceParam);

  if (!traceGLX_Native.glXCreateWindow)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateWindow");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateWindow(dpy, config, win, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXDestroyWindow(Display *dpy, GLXWindow win)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyWindow)
    traceGLX_lookupNativeAddress("glXDestroyWindow", (void **) &traceGLX_Native.glXDestroyWindow);

  traceThis = traceEnabled("glXDestroyWindow",&traceParam);

  if (!traceGLX_Native.glXDestroyWindow)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyWindow");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("win", "%lu", win);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDestroyWindow(dpy, win);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLXPixmap GLAPIENTRY
glXCreatePixmap(Display *dpy, GLXFBConfig config, Pixmap pixmap, const int *attrib_list)
{
  GLXPixmap ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreatePixmap)
    traceGLX_lookupNativeAddress("glXCreatePixmap", (void **) &traceGLX_Native.glXCreatePixmap);

  traceThis = traceEnabled("glXCreatePixmap",&traceParam);

  if (!traceGLX_Native.glXCreatePixmap)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreatePixmap");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pixmap", "%lu", pixmap);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreatePixmap(dpy, config, pixmap, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXDestroyPixmap(Display *dpy, GLXPixmap pixmap)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyPixmap)
    traceGLX_lookupNativeAddress("glXDestroyPixmap", (void **) &traceGLX_Native.glXDestroyPixmap);

  traceThis = traceEnabled("glXDestroyPixmap",&traceParam);

  if (!traceGLX_Native.glXDestroyPixmap)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyPixmap");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pixmap", "%lu", pixmap);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDestroyPixmap(dpy, pixmap);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLXPbuffer GLAPIENTRY
glXCreatePbuffer(Display *dpy, GLXFBConfig config, const int *attrib_list)
{
  GLXPbuffer ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreatePbuffer)
    traceGLX_lookupNativeAddress("glXCreatePbuffer", (void **) &traceGLX_Native.glXCreatePbuffer);

  traceThis = traceEnabled("glXCreatePbuffer",&traceParam);

  if (!traceGLX_Native.glXCreatePbuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreatePbuffer");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreatePbuffer(dpy, config, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXDestroyPbuffer(Display *dpy, GLXPbuffer pbuf)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyPbuffer)
    traceGLX_lookupNativeAddress("glXDestroyPbuffer", (void **) &traceGLX_Native.glXDestroyPbuffer);

  traceThis = traceEnabled("glXDestroyPbuffer",&traceParam);

  if (!traceGLX_Native.glXDestroyPbuffer)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyPbuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pbuf", "%lu", pbuf);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDestroyPbuffer(dpy, pbuf);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXQueryDrawable(Display *dpy, GLXDrawable draw, int attribute, unsigned int *value)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryDrawable)
    traceGLX_lookupNativeAddress("glXQueryDrawable", (void **) &traceGLX_Native.glXQueryDrawable);

  traceThis = traceEnabled("glXQueryDrawable",&traceParam);

  if (!traceGLX_Native.glXQueryDrawable)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryDrawable");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("attribute", "%d", attribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXQueryDrawable(dpy, draw, attribute, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("value", "%u[%d]", value, 1);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLXContext GLAPIENTRY
glXCreateNewContext(Display *dpy, GLXFBConfig config, int render_type, GLXContext share_list, Bool direct)
{
  GLXContext ret = (GLXContext) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateNewContext)
    traceGLX_lookupNativeAddress("glXCreateNewContext", (void **) &traceGLX_Native.glXCreateNewContext);

  traceThis = traceEnabled("glXCreateNewContext",&traceParam);

  if (!traceGLX_Native.glXCreateNewContext)
    return (GLXContext) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateNewContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("render_type", "%d", render_type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateNewContext(dpy, config, render_type, share_list, direct);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXMakeContextCurrent(Display *display, GLXDrawable draw, GLXDrawable read, GLXContext ctx)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXMakeContextCurrent)
    traceGLX_lookupNativeAddress("glXMakeContextCurrent", (void **) &traceGLX_Native.glXMakeContextCurrent);

  traceThis = traceEnabled("glXMakeContextCurrent",&traceParam);

  if (!traceGLX_Native.glXMakeContextCurrent)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXMakeContextCurrent");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXMakeContextCurrent(display, draw, read, ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXDrawable GLAPIENTRY
glXGetCurrentReadDrawable()
{
  GLXDrawable ret = (GLXDrawable) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetCurrentReadDrawable)
    traceGLX_lookupNativeAddress("glXGetCurrentReadDrawable", (void **) &traceGLX_Native.glXGetCurrentReadDrawable);

  traceThis = traceEnabled("glXGetCurrentReadDrawable",&traceParam);

  if (!traceGLX_Native.glXGetCurrentReadDrawable)
    return (GLXDrawable) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetCurrentReadDrawable");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetCurrentReadDrawable();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXQueryContext(Display *dpy, GLXContext ctx, int attribute, int *value)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryContext)
    traceGLX_lookupNativeAddress("glXQueryContext", (void **) &traceGLX_Native.glXQueryContext);

  traceThis = traceEnabled("glXQueryContext",&traceParam);

  if (!traceGLX_Native.glXQueryContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("attribute", "%d", attribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryContext(dpy, ctx, attribute, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("value", "%d[%d]", value, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXSelectEvent(Display *dpy, GLXDrawable draw, unsigned long event_mask)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSelectEvent)
    traceGLX_lookupNativeAddress("glXSelectEvent", (void **) &traceGLX_Native.glXSelectEvent);

  traceThis = traceEnabled("glXSelectEvent",&traceParam);

  if (!traceGLX_Native.glXSelectEvent)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSelectEvent");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("event_mask", "%lu", event_mask);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXSelectEvent(dpy, draw, event_mask);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXGetSelectedEvent(Display *dpy, GLXDrawable draw, unsigned long *event_mask)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetSelectedEvent)
    traceGLX_lookupNativeAddress("glXGetSelectedEvent", (void **) &traceGLX_Native.glXGetSelectedEvent);

  traceThis = traceEnabled("glXGetSelectedEvent",&traceParam);

  if (!traceGLX_Native.glXGetSelectedEvent)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetSelectedEvent");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXGetSelectedEvent(dpy, draw, event_mask);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("event_mask", "%lu[%d]", event_mask, 1);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void *GLAPIENTRY
glXGetProcAddress(const GLubyte *procName)
{
  void *ret = NULL;
  void *retSwap = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetProcAddress)
    traceGLX_lookupNativeAddress("glXGetProcAddress", (void **) &traceGLX_Native.glXGetProcAddress);

  traceThis = traceEnabled("glXGetProcAddress",&traceParam);

  if (!traceGLX_Native.glXGetProcAddress)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetProcAddress");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("procName", "%s", procName);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetProcAddress(procName);
  retSwap = traceGLX_lookupWrapperAddress((const char *) procName, ret);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return retSwap;
}

DLLEXPORT void *GLAPIENTRY
glXGetProcAddressARB(const GLubyte *procName)
{
  void *ret = NULL;
  void *retSwap = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetProcAddressARB)
    traceGLX_lookupNativeAddress("glXGetProcAddressARB", (void **) &traceGLX_Native.glXGetProcAddressARB);

  traceThis = traceEnabled("glXGetProcAddressARB",&traceParam);

  if (!traceGLX_Native.glXGetProcAddressARB)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetProcAddressARB");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("procName", "%s", procName);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetProcAddressARB(procName);
  retSwap = traceGLX_lookupWrapperAddress((const char *) procName, ret);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return retSwap;
}

DLLEXPORT GLXContext GLAPIENTRY
glXCreateContextAttribsARB(Display *dpy, GLXFBConfig config, GLXContext share_context, Bool direct, const int *attrib_list)
{
  GLXContext ret = (GLXContext) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateContextAttribsARB)
    traceGLX_lookupNativeAddress("glXCreateContextAttribsARB", (void **) &traceGLX_Native.glXCreateContextAttribsARB);

  traceThis = traceEnabled("glXCreateContextAttribsARB",&traceParam);

  if (!traceGLX_Native.glXCreateContextAttribsARB)
    return (GLXContext) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateContextAttribsARB");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateContextAttribsARB(dpy, config, share_context, direct, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXSwapIntervalSGI(int interval)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSwapIntervalSGI)
    traceGLX_lookupNativeAddress("glXSwapIntervalSGI", (void **) &traceGLX_Native.glXSwapIntervalSGI);

  traceThis = traceEnabled("glXSwapIntervalSGI",&traceParam);

  if (!traceGLX_Native.glXSwapIntervalSGI)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSwapIntervalSGI");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("interval", "%d", interval);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXSwapIntervalSGI(interval);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetVideoSyncSGI(unsigned int *count)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetVideoSyncSGI)
    traceGLX_lookupNativeAddress("glXGetVideoSyncSGI", (void **) &traceGLX_Native.glXGetVideoSyncSGI);

  traceThis = traceEnabled("glXGetVideoSyncSGI",&traceParam);

  if (!traceGLX_Native.glXGetVideoSyncSGI)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetVideoSyncSGI");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetVideoSyncSGI(count);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("count", "%u[%d]", count, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXWaitVideoSyncSGI(int divisor, int remainder, unsigned int *count)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXWaitVideoSyncSGI)
    traceGLX_lookupNativeAddress("glXWaitVideoSyncSGI", (void **) &traceGLX_Native.glXWaitVideoSyncSGI);

  traceThis = traceEnabled("glXWaitVideoSyncSGI",&traceParam);

  if (!traceGLX_Native.glXWaitVideoSyncSGI)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXWaitVideoSyncSGI");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("divisor", "%d", divisor);
      traceInputParameter("remainder", "%d", remainder);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXWaitVideoSyncSGI(divisor, remainder, count);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("count", "%u[%d]", count, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXDrawable GLAPIENTRY
glXGetCurrentReadDrawableSGI()
{
  GLXDrawable ret = (GLXDrawable) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetCurrentReadDrawableSGI)
    traceGLX_lookupNativeAddress("glXGetCurrentReadDrawableSGI", (void **) &traceGLX_Native.glXGetCurrentReadDrawableSGI);

  traceThis = traceEnabled("glXGetCurrentReadDrawableSGI",&traceParam);

  if (!traceGLX_Native.glXGetCurrentReadDrawableSGI)
    return (GLXDrawable) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetCurrentReadDrawableSGI");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetCurrentReadDrawableSGI();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXMakeCurrentReadSGI(Display *dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXMakeCurrentReadSGI)
    traceGLX_lookupNativeAddress("glXMakeCurrentReadSGI", (void **) &traceGLX_Native.glXMakeCurrentReadSGI);

  traceThis = traceEnabled("glXMakeCurrentReadSGI",&traceParam);

  if (!traceGLX_Native.glXMakeCurrentReadSGI)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXMakeCurrentReadSGI");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXMakeCurrentReadSGI(dpy, draw, read, ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXFreeContextEXT(Display *dpy, GLXContext context)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXFreeContextEXT)
    traceGLX_lookupNativeAddress("glXFreeContextEXT", (void **) &traceGLX_Native.glXFreeContextEXT);

  traceThis = traceEnabled("glXFreeContextEXT",&traceParam);

  if (!traceGLX_Native.glXFreeContextEXT)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXFreeContextEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXFreeContextEXT(dpy, context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLXContextID GLAPIENTRY
glXGetContextIDEXT(const GLXContext context)
{
  GLXContextID ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetContextIDEXT)
    traceGLX_lookupNativeAddress("glXGetContextIDEXT", (void **) &traceGLX_Native.glXGetContextIDEXT);

  traceThis = traceEnabled("glXGetContextIDEXT",&traceParam);

  if (!traceGLX_Native.glXGetContextIDEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetContextIDEXT");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetContextIDEXT(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXContext GLAPIENTRY
glXImportContextEXT(Display *dpy, GLXContextID contextID)
{
  GLXContext ret = (GLXContext) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXImportContextEXT)
    traceGLX_lookupNativeAddress("glXImportContextEXT", (void **) &traceGLX_Native.glXImportContextEXT);

  traceThis = traceEnabled("glXImportContextEXT",&traceParam);

  if (!traceGLX_Native.glXImportContextEXT)
    return (GLXContext) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXImportContextEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("contextID", "%lu", contextID);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXImportContextEXT(dpy, contextID);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXQueryContextInfoEXT(Display *dpy, GLXContext context, int attribute, int *value)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryContextInfoEXT)
    traceGLX_lookupNativeAddress("glXQueryContextInfoEXT", (void **) &traceGLX_Native.glXQueryContextInfoEXT);

  traceThis = traceEnabled("glXQueryContextInfoEXT",&traceParam);

  if (!traceGLX_Native.glXQueryContextInfoEXT)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryContextInfoEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("attribute", "%d", attribute);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryContextInfoEXT(dpy, context, attribute, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("value", "%d[%d]", value, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXFBConfigSGIX *GLAPIENTRY
glXChooseFBConfigSGIX(Display *dpy, int screen, const int *attrib_list, int *nelements)
{
  GLXFBConfigSGIX *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXChooseFBConfigSGIX)
    traceGLX_lookupNativeAddress("glXChooseFBConfigSGIX", (void **) &traceGLX_Native.glXChooseFBConfigSGIX);

  traceThis = traceEnabled("glXChooseFBConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXChooseFBConfigSGIX)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXChooseFBConfigSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXChooseFBConfigSGIX(dpy, screen, attrib_list, nelements);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXContext GLAPIENTRY
glXCreateContextWithConfigSGIX(Display *dpy, GLXFBConfig config, int render_type, GLXContext share_list, Bool direct)
{
  GLXContext ret = (GLXContext) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateContextWithConfigSGIX)
    traceGLX_lookupNativeAddress("glXCreateContextWithConfigSGIX", (void **) &traceGLX_Native.glXCreateContextWithConfigSGIX);

  traceThis = traceEnabled("glXCreateContextWithConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXCreateContextWithConfigSGIX)
    return (GLXContext) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateContextWithConfigSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("render_type", "%d", render_type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateContextWithConfigSGIX(dpy, config, render_type, share_list, direct);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXPixmap GLAPIENTRY
glXCreateGLXPixmapWithConfigSGIX(Display *dpy, GLXFBConfig config, Pixmap pixmap)
{
  GLXPixmap ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateGLXPixmapWithConfigSGIX)
    traceGLX_lookupNativeAddress("glXCreateGLXPixmapWithConfigSGIX", (void **) &traceGLX_Native.glXCreateGLXPixmapWithConfigSGIX);

  traceThis = traceEnabled("glXCreateGLXPixmapWithConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXCreateGLXPixmapWithConfigSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateGLXPixmapWithConfigSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pixmap", "%lu", pixmap);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateGLXPixmapWithConfigSGIX(dpy, config, pixmap);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetFBConfigAttribSGIX(Display *dpy, GLXFBConfigSGIX config, int attribute, int *value)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetFBConfigAttribSGIX)
    traceGLX_lookupNativeAddress("glXGetFBConfigAttribSGIX", (void **) &traceGLX_Native.glXGetFBConfigAttribSGIX);

  traceThis = traceEnabled("glXGetFBConfigAttribSGIX",&traceParam);

  if (!traceGLX_Native.glXGetFBConfigAttribSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetFBConfigAttribSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("attribute", "%d", attribute);
      traceInputParameter("value", "%d[%d]", value, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetFBConfigAttribSGIX(dpy, config, attribute, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXFBConfigSGIX GLAPIENTRY
glXGetFBConfigFromVisualSGIX(Display *dpy, XVisualInfo *vis)
{
  GLXFBConfigSGIX ret = (GLXFBConfigSGIX) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetFBConfigFromVisualSGIX)
    traceGLX_lookupNativeAddress("glXGetFBConfigFromVisualSGIX", (void **) &traceGLX_Native.glXGetFBConfigFromVisualSGIX);

  traceThis = traceEnabled("glXGetFBConfigFromVisualSGIX",&traceParam);

  if (!traceGLX_Native.glXGetFBConfigFromVisualSGIX)
    return (GLXFBConfigSGIX) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetFBConfigFromVisualSGIX");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetFBConfigFromVisualSGIX(dpy, vis);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT XVisualInfo *GLAPIENTRY
glXGetVisualFromFBConfigSGIX(Display *dpy, GLXFBConfig config)
{
  XVisualInfo *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetVisualFromFBConfigSGIX)
    traceGLX_lookupNativeAddress("glXGetVisualFromFBConfigSGIX", (void **) &traceGLX_Native.glXGetVisualFromFBConfigSGIX);

  traceThis = traceEnabled("glXGetVisualFromFBConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXGetVisualFromFBConfigSGIX)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetVisualFromFBConfigSGIX");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetVisualFromFBConfigSGIX(dpy, config);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXPbuffer GLAPIENTRY
glXCreateGLXPbufferSGIX(Display *dpy, GLXFBConfig config, unsigned int width, unsigned int height, int *attrib_list)
{
  GLXPbuffer ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateGLXPbufferSGIX)
    traceGLX_lookupNativeAddress("glXCreateGLXPbufferSGIX", (void **) &traceGLX_Native.glXCreateGLXPbufferSGIX);

  traceThis = traceEnabled("glXCreateGLXPbufferSGIX",&traceParam);

  if (!traceGLX_Native.glXCreateGLXPbufferSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateGLXPbufferSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("width", "%u", width);
      traceInputParameter("height", "%u", height);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateGLXPbufferSGIX(dpy, config, width, height, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXDestroyGLXPbufferSGIX(Display *dpy, GLXPbuffer pbuf)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyGLXPbufferSGIX)
    traceGLX_lookupNativeAddress("glXDestroyGLXPbufferSGIX", (void **) &traceGLX_Native.glXDestroyGLXPbufferSGIX);

  traceThis = traceEnabled("glXDestroyGLXPbufferSGIX",&traceParam);

  if (!traceGLX_Native.glXDestroyGLXPbufferSGIX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyGLXPbufferSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pbuf", "%lu", pbuf);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDestroyGLXPbufferSGIX(dpy, pbuf);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXGetSelectedEventSGIX(Display *dpy, GLXDrawable drawable, unsigned long *mask)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetSelectedEventSGIX)
    traceGLX_lookupNativeAddress("glXGetSelectedEventSGIX", (void **) &traceGLX_Native.glXGetSelectedEventSGIX);

  traceThis = traceEnabled("glXGetSelectedEventSGIX",&traceParam);

  if (!traceGLX_Native.glXGetSelectedEventSGIX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetSelectedEventSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("mask", "%lu[%d]", mask, 1);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXGetSelectedEventSGIX(dpy, drawable, mask);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXQueryGLXPbufferSGIX(Display *dpy, GLXPbuffer pbuf, int attribute, unsigned int *value)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryGLXPbufferSGIX)
    traceGLX_lookupNativeAddress("glXQueryGLXPbufferSGIX", (void **) &traceGLX_Native.glXQueryGLXPbufferSGIX);

  traceThis = traceEnabled("glXQueryGLXPbufferSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryGLXPbufferSGIX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryGLXPbufferSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pbuf", "%lu", pbuf);
      traceInputParameter("attribute", "%d", attribute);
      traceInputParameter("value", "%u[%d]", value, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXQueryGLXPbufferSGIX(dpy, pbuf, attribute, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXSelectEventSGIX(Display *dpy, GLXDrawable drawable, unsigned long mask)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSelectEventSGIX)
    traceGLX_lookupNativeAddress("glXSelectEventSGIX", (void **) &traceGLX_Native.glXSelectEventSGIX);

  traceThis = traceEnabled("glXSelectEventSGIX",&traceParam);

  if (!traceGLX_Native.glXSelectEventSGIX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSelectEventSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("mask", "%lu", mask);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXSelectEventSGIX(dpy, drawable, mask);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXCushionSGI(Display *dpy, Window window, float cushion)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCushionSGI)
    traceGLX_lookupNativeAddress("glXCushionSGI", (void **) &traceGLX_Native.glXCushionSGI);

  traceThis = traceEnabled("glXCushionSGI",&traceParam);

  if (!traceGLX_Native.glXCushionSGI)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCushionSGI");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("cushion", "%f", cushion);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXCushionSGI(dpy, window, cushion);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT int GLAPIENTRY
glXBindChannelToWindowSGIX(Display *display, int screen, int channel, Window window)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindChannelToWindowSGIX)
    traceGLX_lookupNativeAddress("glXBindChannelToWindowSGIX", (void **) &traceGLX_Native.glXBindChannelToWindowSGIX);

  traceThis = traceEnabled("glXBindChannelToWindowSGIX",&traceParam);

  if (!traceGLX_Native.glXBindChannelToWindowSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindChannelToWindowSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("channel", "%d", channel);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXBindChannelToWindowSGIX(display, screen, channel, window);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXChannelRectSGIX(Display *display, int screen, int channel, int x, int y, int w, int h)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXChannelRectSGIX)
    traceGLX_lookupNativeAddress("glXChannelRectSGIX", (void **) &traceGLX_Native.glXChannelRectSGIX);

  traceThis = traceEnabled("glXChannelRectSGIX",&traceParam);

  if (!traceGLX_Native.glXChannelRectSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXChannelRectSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("channel", "%d", channel);
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
      traceInputParameter("w", "%d", w);
      traceInputParameter("h", "%d", h);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXChannelRectSGIX(display, screen, channel, x, y, w, h);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXChannelRectSyncSGIX(Display *display, int screen, int channel, GLenum synctype)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXChannelRectSyncSGIX)
    traceGLX_lookupNativeAddress("glXChannelRectSyncSGIX", (void **) &traceGLX_Native.glXChannelRectSyncSGIX);

  traceThis = traceEnabled("glXChannelRectSyncSGIX",&traceParam);

  if (!traceGLX_Native.glXChannelRectSyncSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXChannelRectSyncSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("channel", "%d", channel);
      traceInputParameter("synctype", "%u", synctype);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXChannelRectSyncSGIX(display, screen, channel, synctype);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXQueryChannelDeltasSGIX(Display *display, int screen, int channel, int *x, int *y, int *w, int *h)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryChannelDeltasSGIX)
    traceGLX_lookupNativeAddress("glXQueryChannelDeltasSGIX", (void **) &traceGLX_Native.glXQueryChannelDeltasSGIX);

  traceThis = traceEnabled("glXQueryChannelDeltasSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryChannelDeltasSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryChannelDeltasSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("channel", "%d", channel);
      traceInputParameter("x", "%d[%d]", x, 1);
      traceInputParameter("y", "%d[%d]", y, 1);
      traceInputParameter("w", "%d[%d]", w, 1);
      traceInputParameter("h", "%d[%d]", h, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryChannelDeltasSGIX(display, screen, channel, x, y, w, h);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXQueryChannelRectSGIX(Display *display, int screen, int channel, int *dx, int *dy, int *dw, int *dh)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryChannelRectSGIX)
    traceGLX_lookupNativeAddress("glXQueryChannelRectSGIX", (void **) &traceGLX_Native.glXQueryChannelRectSGIX);

  traceThis = traceEnabled("glXQueryChannelRectSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryChannelRectSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryChannelRectSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("channel", "%d", channel);
      traceInputParameter("dx", "%d[%d]", dx, 1);
      traceInputParameter("dy", "%d[%d]", dy, 1);
      traceInputParameter("dw", "%d[%d]", dw, 1);
      traceInputParameter("dh", "%d[%d]", dh, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryChannelRectSGIX(display, screen, channel, dx, dy, dw, dh);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXJoinSwapGroupSGIX(Display *dpy, GLXDrawable drawable, GLXDrawable member)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXJoinSwapGroupSGIX)
    traceGLX_lookupNativeAddress("glXJoinSwapGroupSGIX", (void **) &traceGLX_Native.glXJoinSwapGroupSGIX);

  traceThis = traceEnabled("glXJoinSwapGroupSGIX",&traceParam);

  if (!traceGLX_Native.glXJoinSwapGroupSGIX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXJoinSwapGroupSGIX");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXJoinSwapGroupSGIX(dpy, drawable, member);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXBindSwapBarrierSGIX(Display *dpy, GLXDrawable drawable, int barrier)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindSwapBarrierSGIX)
    traceGLX_lookupNativeAddress("glXBindSwapBarrierSGIX", (void **) &traceGLX_Native.glXBindSwapBarrierSGIX);

  traceThis = traceEnabled("glXBindSwapBarrierSGIX",&traceParam);

  if (!traceGLX_Native.glXBindSwapBarrierSGIX)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindSwapBarrierSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("barrier", "%d", barrier);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXBindSwapBarrierSGIX(dpy, drawable, barrier);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT Bool GLAPIENTRY
glXQueryMaxSwapBarriersSGIX(Display *dpy, int screen, int *max)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryMaxSwapBarriersSGIX)
    traceGLX_lookupNativeAddress("glXQueryMaxSwapBarriersSGIX", (void **) &traceGLX_Native.glXQueryMaxSwapBarriersSGIX);

  traceThis = traceEnabled("glXQueryMaxSwapBarriersSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryMaxSwapBarriersSGIX)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryMaxSwapBarriersSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryMaxSwapBarriersSGIX(dpy, screen, max);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("max", "%d[%d]", max, 1);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Status GLAPIENTRY
glXGetTransparentIndexSUN(Display *dpy, Window overlay, Window underlay, unsigned long *pTransparentIndex)
{
  Status ret = (Status) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetTransparentIndexSUN)
    traceGLX_lookupNativeAddress("glXGetTransparentIndexSUN", (void **) &traceGLX_Native.glXGetTransparentIndexSUN);

  traceThis = traceEnabled("glXGetTransparentIndexSUN",&traceParam);

  if (!traceGLX_Native.glXGetTransparentIndexSUN)
    return (Status) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetTransparentIndexSUN");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pTransparentIndex", "%lu[%d]", pTransparentIndex, 1);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetTransparentIndexSUN(dpy, overlay, underlay, pTransparentIndex);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void *GLAPIENTRY
glXAllocateMemoryNV(GLsizei size, GLfloat readFrequency, GLfloat writeFrequency, GLfloat priority)
{
  void *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXAllocateMemoryNV)
    traceGLX_lookupNativeAddress("glXAllocateMemoryNV", (void **) &traceGLX_Native.glXAllocateMemoryNV);

  traceThis = traceEnabled("glXAllocateMemoryNV",&traceParam);

  if (!traceGLX_Native.glXAllocateMemoryNV)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXAllocateMemoryNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("size", "%d", size);
      traceInputParameter("readFrequency", "%f", readFrequency);
      traceInputParameter("writeFrequency", "%f", writeFrequency);
      traceInputParameter("priority", "%f", priority);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXAllocateMemoryNV(size, readFrequency, writeFrequency, priority);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXFreeMemoryNV(void *pointer)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXFreeMemoryNV)
    traceGLX_lookupNativeAddress("glXFreeMemoryNV", (void **) &traceGLX_Native.glXFreeMemoryNV);

  traceThis = traceEnabled("glXFreeMemoryNV",&traceParam);

  if (!traceGLX_Native.glXFreeMemoryNV)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXFreeMemoryNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pointer", "%p", pointer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXFreeMemoryNV(pointer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXCopySubBufferMESA(Display *dpy, GLXDrawable drawable, int x, int y, int width, int height)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCopySubBufferMESA)
    traceGLX_lookupNativeAddress("glXCopySubBufferMESA", (void **) &traceGLX_Native.glXCopySubBufferMESA);

  traceThis = traceEnabled("glXCopySubBufferMESA",&traceParam);

  if (!traceGLX_Native.glXCopySubBufferMESA)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCopySubBufferMESA");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
      traceInputParameter("width", "%d", width);
      traceInputParameter("height", "%d", height);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXCopySubBufferMESA(dpy, drawable, x, y, width, height);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLXPixmap GLAPIENTRY
glXCreateGLXPixmapMESA(Display *dpy, XVisualInfo *visual, Pixmap pixmap, Colormap cmap)
{
  GLXPixmap ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCreateGLXPixmapMESA)
    traceGLX_lookupNativeAddress("glXCreateGLXPixmapMESA", (void **) &traceGLX_Native.glXCreateGLXPixmapMESA);

  traceThis = traceEnabled("glXCreateGLXPixmapMESA",&traceParam);

  if (!traceGLX_Native.glXCreateGLXPixmapMESA)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCreateGLXPixmapMESA");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pixmap", "%lu", pixmap);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXCreateGLXPixmapMESA(dpy, visual, pixmap, cmap);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXReleaseBuffersMESA(Display *dpy, GLXDrawable d)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXReleaseBuffersMESA)
    traceGLX_lookupNativeAddress("glXReleaseBuffersMESA", (void **) &traceGLX_Native.glXReleaseBuffersMESA);

  traceThis = traceEnabled("glXReleaseBuffersMESA",&traceParam);

  if (!traceGLX_Native.glXReleaseBuffersMESA)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXReleaseBuffersMESA");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXReleaseBuffersMESA(dpy, d);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLboolean GLAPIENTRY
glXSet3DfxModeMESA(GLint mode)
{
  GLboolean ret = GL_FALSE;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSet3DfxModeMESA)
    traceGLX_lookupNativeAddress("glXSet3DfxModeMESA", (void **) &traceGLX_Native.glXSet3DfxModeMESA);

  traceThis = traceEnabled("glXSet3DfxModeMESA",&traceParam);

  if (!traceGLX_Native.glXSet3DfxModeMESA)
    return GL_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSet3DfxModeMESA");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("mode", "%d", mode);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXSet3DfxModeMESA(mode);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", (unsigned int) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXGetMscRateOML(Display *dpy, GLXDrawable drawable, int32_t *numerator, int32_t *denominator)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetMscRateOML)
    traceGLX_lookupNativeAddress("glXGetMscRateOML", (void **) &traceGLX_Native.glXGetMscRateOML);

  traceThis = traceEnabled("glXGetMscRateOML",&traceParam);

  if (!traceGLX_Native.glXGetMscRateOML)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetMscRateOML");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetMscRateOML(dpy, drawable, numerator, denominator);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXGetSyncValuesOML(Display *dpy, GLXDrawable drawable, int64_t *ust, int64_t *msc, int64_t *sbc)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetSyncValuesOML)
    traceGLX_lookupNativeAddress("glXGetSyncValuesOML", (void **) &traceGLX_Native.glXGetSyncValuesOML);

  traceThis = traceEnabled("glXGetSyncValuesOML",&traceParam);

  if (!traceGLX_Native.glXGetSyncValuesOML)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetSyncValuesOML");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetSyncValuesOML(dpy, drawable, ust, msc, sbc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int64_t GLAPIENTRY
glXSwapBuffersMscOML(Display *dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder)
{
  int64_t ret = (int64_t) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSwapBuffersMscOML)
    traceGLX_lookupNativeAddress("glXSwapBuffersMscOML", (void **) &traceGLX_Native.glXSwapBuffersMscOML);

  traceThis = traceEnabled("glXSwapBuffersMscOML",&traceParam);

  if (!traceGLX_Native.glXSwapBuffersMscOML)
    return (int64_t) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSwapBuffersMscOML");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXSwapBuffersMscOML(dpy, drawable, target_msc, divisor, remainder);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXWaitForMscOML(Display *dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder, int64_t *ust, int64_t *msc, int64_t *sbc)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXWaitForMscOML)
    traceGLX_lookupNativeAddress("glXWaitForMscOML", (void **) &traceGLX_Native.glXWaitForMscOML);

  traceThis = traceEnabled("glXWaitForMscOML",&traceParam);

  if (!traceGLX_Native.glXWaitForMscOML)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXWaitForMscOML");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXWaitForMscOML(dpy, drawable, target_msc, divisor, remainder, ust, msc, sbc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXWaitForSbcOML(Display *dpy, GLXDrawable drawable, int64_t target_sbc, int64_t *ust, int64_t *msc, int64_t *sbc)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXWaitForSbcOML)
    traceGLX_lookupNativeAddress("glXWaitForSbcOML", (void **) &traceGLX_Native.glXWaitForSbcOML);

  traceThis = traceEnabled("glXWaitForSbcOML",&traceParam);

  if (!traceGLX_Native.glXWaitForSbcOML)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXWaitForSbcOML");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXWaitForSbcOML(dpy, drawable, target_sbc, ust, msc, sbc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXHyperpipeNetworkSGIX *GLAPIENTRY
glXQueryHyperpipeNetworkSGIX(Display *dpy, int *npipes)
{
  GLXHyperpipeNetworkSGIX *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryHyperpipeNetworkSGIX)
    traceGLX_lookupNativeAddress("glXQueryHyperpipeNetworkSGIX", (void **) &traceGLX_Native.glXQueryHyperpipeNetworkSGIX);

  traceThis = traceEnabled("glXQueryHyperpipeNetworkSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryHyperpipeNetworkSGIX)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryHyperpipeNetworkSGIX");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryHyperpipeNetworkSGIX(dpy, npipes);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("npipes", "%d[%d]", npipes, 1);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXHyperpipeConfigSGIX(Display *dpy, int networkId, int npipes, GLXHyperpipeConfigSGIX *cfg, int *hpId)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXHyperpipeConfigSGIX)
    traceGLX_lookupNativeAddress("glXHyperpipeConfigSGIX", (void **) &traceGLX_Native.glXHyperpipeConfigSGIX);

  traceThis = traceEnabled("glXHyperpipeConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXHyperpipeConfigSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXHyperpipeConfigSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("networkId", "%d", networkId);
      traceInputParameter("npipes", "%d", npipes);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXHyperpipeConfigSGIX(dpy, networkId, npipes, cfg, hpId);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("hpId", "%d[%d]", hpId, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLXHyperpipeConfigSGIX *GLAPIENTRY
glXQueryHyperpipeConfigSGIX(Display *dpy, int hpId, int *npipes)
{
  GLXHyperpipeConfigSGIX *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryHyperpipeConfigSGIX)
    traceGLX_lookupNativeAddress("glXQueryHyperpipeConfigSGIX", (void **) &traceGLX_Native.glXQueryHyperpipeConfigSGIX);

  traceThis = traceEnabled("glXQueryHyperpipeConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryHyperpipeConfigSGIX)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryHyperpipeConfigSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("hpId", "%d", hpId);
      traceInputParameter("npipes", "%d[%d]", npipes, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryHyperpipeConfigSGIX(dpy, hpId, npipes);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXDestroyHyperpipeConfigSGIX(Display *dpy, int hpId)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDestroyHyperpipeConfigSGIX)
    traceGLX_lookupNativeAddress("glXDestroyHyperpipeConfigSGIX", (void **) &traceGLX_Native.glXDestroyHyperpipeConfigSGIX);

  traceThis = traceEnabled("glXDestroyHyperpipeConfigSGIX",&traceParam);

  if (!traceGLX_Native.glXDestroyHyperpipeConfigSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDestroyHyperpipeConfigSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hpId", "%d", hpId);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXDestroyHyperpipeConfigSGIX(dpy, hpId);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXBindHyperpipeSGIX(Display *dpy, int hpId)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindHyperpipeSGIX)
    traceGLX_lookupNativeAddress("glXBindHyperpipeSGIX", (void **) &traceGLX_Native.glXBindHyperpipeSGIX);

  traceThis = traceEnabled("glXBindHyperpipeSGIX",&traceParam);

  if (!traceGLX_Native.glXBindHyperpipeSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindHyperpipeSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("hpId", "%d", hpId);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXBindHyperpipeSGIX(dpy, hpId);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXQueryHyperpipeBestAttribSGIX(Display *dpy, int timeSlice, int attrib, int size, void *attribList, void *returnAttribList)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryHyperpipeBestAttribSGIX)
    traceGLX_lookupNativeAddress("glXQueryHyperpipeBestAttribSGIX", (void **) &traceGLX_Native.glXQueryHyperpipeBestAttribSGIX);

  traceThis = traceEnabled("glXQueryHyperpipeBestAttribSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryHyperpipeBestAttribSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryHyperpipeBestAttribSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("timeSlice", "%d", timeSlice);
      traceInputParameter("attrib", "%d", attrib);
      traceInputParameter("size", "%d", size);
      traceInputParameter("attribList", "%p", attribList);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryHyperpipeBestAttribSGIX(dpy, timeSlice, attrib, size, attribList, returnAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("returnAttribList", "%p", returnAttribList);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXHyperpipeAttribSGIX(Display *dpy, int timeSlice, int attrib, int size, void *attribList)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXHyperpipeAttribSGIX)
    traceGLX_lookupNativeAddress("glXHyperpipeAttribSGIX", (void **) &traceGLX_Native.glXHyperpipeAttribSGIX);

  traceThis = traceEnabled("glXHyperpipeAttribSGIX",&traceParam);

  if (!traceGLX_Native.glXHyperpipeAttribSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXHyperpipeAttribSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("timeSlice", "%d", timeSlice);
      traceInputParameter("attrib", "%d", attrib);
      traceInputParameter("size", "%d", size);
      traceInputParameter("attribList", "%p", attribList);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXHyperpipeAttribSGIX(dpy, timeSlice, attrib, size, attribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXQueryHyperpipeAttribSGIX(Display *dpy, int timeSlice, int attrib, int size, void *returnAttribList)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryHyperpipeAttribSGIX)
    traceGLX_lookupNativeAddress("glXQueryHyperpipeAttribSGIX", (void **) &traceGLX_Native.glXQueryHyperpipeAttribSGIX);

  traceThis = traceEnabled("glXQueryHyperpipeAttribSGIX",&traceParam);

  if (!traceGLX_Native.glXQueryHyperpipeAttribSGIX)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryHyperpipeAttribSGIX");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("timeSlice", "%d", timeSlice);
      traceInputParameter("attrib", "%d", attrib);
      traceInputParameter("size", "%d", size);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryHyperpipeAttribSGIX(dpy, timeSlice, attrib, size, returnAttribList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("returnAttribList", "%p", returnAttribList);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT unsigned int GLAPIENTRY
glXGetAGPOffsetMESA(const void *pointer)
{
  unsigned int ret = 0u;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetAGPOffsetMESA)
    traceGLX_lookupNativeAddress("glXGetAGPOffsetMESA", (void **) &traceGLX_Native.glXGetAGPOffsetMESA);

  traceThis = traceEnabled("glXGetAGPOffsetMESA",&traceParam);

  if (!traceGLX_Native.glXGetAGPOffsetMESA)
    return 0u;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetAGPOffsetMESA");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetAGPOffsetMESA(pointer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXBindTexImageEXT(Display *display, GLXDrawable drawable, int buffer, const int *attrib_list)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindTexImageEXT)
    traceGLX_lookupNativeAddress("glXBindTexImageEXT", (void **) &traceGLX_Native.glXBindTexImageEXT);

  traceThis = traceEnabled("glXBindTexImageEXT",&traceParam);

  if (!traceGLX_Native.glXBindTexImageEXT)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindTexImageEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("buffer", "%d", buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXBindTexImageEXT(display, drawable, buffer, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXReleaseTexImageEXT(Display *display, GLXDrawable drawable, int buffer)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXReleaseTexImageEXT)
    traceGLX_lookupNativeAddress("glXReleaseTexImageEXT", (void **) &traceGLX_Native.glXReleaseTexImageEXT);

  traceThis = traceEnabled("glXReleaseTexImageEXT",&traceParam);

  if (!traceGLX_Native.glXReleaseTexImageEXT)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXReleaseTexImageEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("buffer", "%d", buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXReleaseTexImageEXT(display, drawable, buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT int GLAPIENTRY
glXBindVideoDeviceNV(Display *dpy, unsigned int video_slot, unsigned int video_device, const int *attrib_list)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindVideoDeviceNV)
    traceGLX_lookupNativeAddress("glXBindVideoDeviceNV", (void **) &traceGLX_Native.glXBindVideoDeviceNV);

  traceThis = traceEnabled("glXBindVideoDeviceNV",&traceParam);

  if (!traceGLX_Native.glXBindVideoDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindVideoDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("video_slot", "%u", video_slot);
      traceInputParameter("video_device", "%u", video_device);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXBindVideoDeviceNV(dpy, video_slot, video_device, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT unsigned int *GLAPIENTRY
glXEnumerateVideoDevicesNV(Display *dpy, int screen, int *nelements)
{
  unsigned int *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXEnumerateVideoDevicesNV)
    traceGLX_lookupNativeAddress("glXEnumerateVideoDevicesNV", (void **) &traceGLX_Native.glXEnumerateVideoDevicesNV);

  traceThis = traceEnabled("glXEnumerateVideoDevicesNV",&traceParam);

  if (!traceGLX_Native.glXEnumerateVideoDevicesNV)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXEnumerateVideoDevicesNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXEnumerateVideoDevicesNV(dpy, screen, nelements);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nelements", "%d[%d]", nelements, 1);
      traceReturn("%u[%d]", ret, (*nelements));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXBindVideoImageNV(Display *dpy, GLXVideoDeviceNV VideoDevice, GLXPbuffer pbuf, int iVideoBuffer)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindVideoImageNV)
    traceGLX_lookupNativeAddress("glXBindVideoImageNV", (void **) &traceGLX_Native.glXBindVideoImageNV);

  traceThis = traceEnabled("glXBindVideoImageNV",&traceParam);

  if (!traceGLX_Native.glXBindVideoImageNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindVideoImageNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("VideoDevice", "%u", VideoDevice);
      traceInputParameter("pbuf", "%lu", pbuf);
      traceInputParameter("iVideoBuffer", "%d", iVideoBuffer);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXBindVideoImageNV(dpy, VideoDevice, pbuf, iVideoBuffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetVideoDeviceNV(Display *dpy, int screen, int numVideoDevices, GLXVideoDeviceNV *pVideoDevice)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetVideoDeviceNV)
    traceGLX_lookupNativeAddress("glXGetVideoDeviceNV", (void **) &traceGLX_Native.glXGetVideoDeviceNV);

  traceThis = traceEnabled("glXGetVideoDeviceNV",&traceParam);

  if (!traceGLX_Native.glXGetVideoDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetVideoDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("numVideoDevices", "%d", numVideoDevices);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetVideoDeviceNV(dpy, screen, numVideoDevices, pVideoDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pVideoDevice", "%u[%d]", pVideoDevice, numVideoDevices);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetVideoInfoNV(Display *dpy, int screen, GLXVideoDeviceNV VideoDevice, unsigned long *pulCounterOutputPbuffer, unsigned long *pulCounterOutputVideo)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetVideoInfoNV)
    traceGLX_lookupNativeAddress("glXGetVideoInfoNV", (void **) &traceGLX_Native.glXGetVideoInfoNV);

  traceThis = traceEnabled("glXGetVideoInfoNV",&traceParam);

  if (!traceGLX_Native.glXGetVideoInfoNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetVideoInfoNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("VideoDevice", "%u", VideoDevice);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetVideoInfoNV(dpy, screen, VideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pulCounterOutputPbuffer", "%lu[%d]", pulCounterOutputPbuffer, 1);
      traceOutputParameter("pulCounterOutputVideo", "%lu[%d]", pulCounterOutputVideo, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXReleaseVideoDeviceNV(Display *dpy, int screen, GLXVideoDeviceNV VideoDevice)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXReleaseVideoDeviceNV)
    traceGLX_lookupNativeAddress("glXReleaseVideoDeviceNV", (void **) &traceGLX_Native.glXReleaseVideoDeviceNV);

  traceThis = traceEnabled("glXReleaseVideoDeviceNV",&traceParam);

  if (!traceGLX_Native.glXReleaseVideoDeviceNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXReleaseVideoDeviceNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("screen", "%d", screen);
      traceInputParameter("VideoDevice", "%u", VideoDevice);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXReleaseVideoDeviceNV(dpy, screen, VideoDevice);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXReleaseVideoImageNV(Display *dpy, GLXPbuffer pbuf)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXReleaseVideoImageNV)
    traceGLX_lookupNativeAddress("glXReleaseVideoImageNV", (void **) &traceGLX_Native.glXReleaseVideoImageNV);

  traceThis = traceEnabled("glXReleaseVideoImageNV",&traceParam);

  if (!traceGLX_Native.glXReleaseVideoImageNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXReleaseVideoImageNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pbuf", "%lu", pbuf);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXReleaseVideoImageNV(dpy, pbuf);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXSendPbufferToVideoNV(Display *dpy, GLXPbuffer pbuf, int iBufferType, unsigned long *pulCounterPbuffer, GLboolean bBlock)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSendPbufferToVideoNV)
    traceGLX_lookupNativeAddress("glXSendPbufferToVideoNV", (void **) &traceGLX_Native.glXSendPbufferToVideoNV);

  traceThis = traceEnabled("glXSendPbufferToVideoNV",&traceParam);

  if (!traceGLX_Native.glXSendPbufferToVideoNV)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSendPbufferToVideoNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pbuf", "%lu", pbuf);
      traceInputParameter("iBufferType", "%d", iBufferType);
      traceInputParameter("bBlock", "%u", (unsigned int) bBlock);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXSendPbufferToVideoNV(dpy, pbuf, iBufferType, pulCounterPbuffer, bBlock);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("pulCounterPbuffer", "%lu[%d]", pulCounterPbuffer, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXBindSwapBarrierNV(Display *dpy, GLuint group, GLuint barrier)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindSwapBarrierNV)
    traceGLX_lookupNativeAddress("glXBindSwapBarrierNV", (void **) &traceGLX_Native.glXBindSwapBarrierNV);

  traceThis = traceEnabled("glXBindSwapBarrierNV",&traceParam);

  if (!traceGLX_Native.glXBindSwapBarrierNV)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindSwapBarrierNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("group", "%u", group);
      traceInputParameter("barrier", "%u", barrier);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXBindSwapBarrierNV(dpy, group, barrier);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXJoinSwapGroupNV(Display *dpy, GLXDrawable drawable, GLuint group)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXJoinSwapGroupNV)
    traceGLX_lookupNativeAddress("glXJoinSwapGroupNV", (void **) &traceGLX_Native.glXJoinSwapGroupNV);

  traceThis = traceEnabled("glXJoinSwapGroupNV",&traceParam);

  if (!traceGLX_Native.glXJoinSwapGroupNV)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXJoinSwapGroupNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("group", "%u", group);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXJoinSwapGroupNV(dpy, drawable, group);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXQueryFrameCountNV(Display *dpy, int screen, GLuint *count)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryFrameCountNV)
    traceGLX_lookupNativeAddress("glXQueryFrameCountNV", (void **) &traceGLX_Native.glXQueryFrameCountNV);

  traceThis = traceEnabled("glXQueryFrameCountNV",&traceParam);

  if (!traceGLX_Native.glXQueryFrameCountNV)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryFrameCountNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryFrameCountNV(dpy, screen, count);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("count", "%u[%d]", count, 1);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXQueryMaxSwapGroupsNV(Display *dpy, int screen, GLuint *maxGroups, GLuint *maxBarriers)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQueryMaxSwapGroupsNV)
    traceGLX_lookupNativeAddress("glXQueryMaxSwapGroupsNV", (void **) &traceGLX_Native.glXQueryMaxSwapGroupsNV);

  traceThis = traceEnabled("glXQueryMaxSwapGroupsNV",&traceParam);

  if (!traceGLX_Native.glXQueryMaxSwapGroupsNV)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQueryMaxSwapGroupsNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQueryMaxSwapGroupsNV(dpy, screen, maxGroups, maxBarriers);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("maxGroups", "%u[%d]", maxGroups, 1);
      traceOutputParameter("maxBarriers", "%u[%d]", maxBarriers, 1);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXQuerySwapGroupNV(Display *dpy, GLXDrawable drawable, GLuint *group, GLuint *barrier)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXQuerySwapGroupNV)
    traceGLX_lookupNativeAddress("glXQuerySwapGroupNV", (void **) &traceGLX_Native.glXQuerySwapGroupNV);

  traceThis = traceEnabled("glXQuerySwapGroupNV",&traceParam);

  if (!traceGLX_Native.glXQuerySwapGroupNV)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXQuerySwapGroupNV");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXQuerySwapGroupNV(dpy, drawable, group, barrier);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("group", "%u[%d]", group, 1);
      traceOutputParameter("barrier", "%u[%d]", barrier, 1);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT Bool GLAPIENTRY
glXResetFrameCountNV(Display *dpy, int screen)
{
  Bool ret = (Bool) 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXResetFrameCountNV)
    traceGLX_lookupNativeAddress("glXResetFrameCountNV", (void **) &traceGLX_Native.glXResetFrameCountNV);

  traceThis = traceEnabled("glXResetFrameCountNV",&traceParam);

  if (!traceGLX_Native.glXResetFrameCountNV)
    return (Bool) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXResetFrameCountNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("screen", "%d", screen);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXResetFrameCountNV(dpy, screen);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void GLAPIENTRY
glXSwapIntervalEXT(Display *dpy, GLXDrawable drawable, int interval)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXSwapIntervalEXT)
    traceGLX_lookupNativeAddress("glXSwapIntervalEXT", (void **) &traceGLX_Native.glXSwapIntervalEXT);

  traceThis = traceEnabled("glXSwapIntervalEXT",&traceParam);

  if (!traceGLX_Native.glXSwapIntervalEXT)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXSwapIntervalEXT");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("interval", "%d", interval);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXSwapIntervalEXT(dpy, drawable, interval);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXCopyImageSubDataNV(Display *dpy, GLXContext srcCtx, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLXContext dstCtx, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXCopyImageSubDataNV)
    traceGLX_lookupNativeAddress("glXCopyImageSubDataNV", (void **) &traceGLX_Native.glXCopyImageSubDataNV);

  traceThis = traceEnabled("glXCopyImageSubDataNV",&traceParam);

  if (!traceGLX_Native.glXCopyImageSubDataNV)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXCopyImageSubDataNV");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("srcName", "%u", srcName);
      traceInputParameter("srcTarget", "%u", srcTarget);
      traceInputParameter("srcLevel", "%d", srcLevel);
      traceInputParameter("srcX", "%d", srcX);
      traceInputParameter("srcY", "%d", srcY);
      traceInputParameter("srcZ", "%d", srcZ);
      traceInputParameter("dstName", "%u", dstName);
      traceInputParameter("dstTarget", "%u", dstTarget);
      traceInputParameter("dstLevel", "%d", dstLevel);
      traceInputParameter("dstX", "%d", dstX);
      traceInputParameter("dstY", "%d", dstY);
      traceInputParameter("dstZ", "%d", dstZ);
      traceInputParameter("width", "%d", width);
      traceInputParameter("height", "%d", height);
      traceInputParameter("depth", "%d", depth);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXCopyImageSubDataNV(dpy, srcCtx, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstCtx, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXBindTexImageATI(Display *dpy, GLXPbuffer pbuf, int buffer)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXBindTexImageATI)
    traceGLX_lookupNativeAddress("glXBindTexImageATI", (void **) &traceGLX_Native.glXBindTexImageATI);

  traceThis = traceEnabled("glXBindTexImageATI",&traceParam);

  if (!traceGLX_Native.glXBindTexImageATI)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXBindTexImageATI");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pbuf", "%lu", pbuf);
      traceInputParameter("buffer", "%d", buffer);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXBindTexImageATI(dpy, pbuf, buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXReleaseTexImageATI(Display *dpy, GLXPbuffer pbuf, int buffer)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXReleaseTexImageATI)
    traceGLX_lookupNativeAddress("glXReleaseTexImageATI", (void **) &traceGLX_Native.glXReleaseTexImageATI);

  traceThis = traceEnabled("glXReleaseTexImageATI",&traceParam);

  if (!traceGLX_Native.glXReleaseTexImageATI)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXReleaseTexImageATI");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pbuf", "%lu", pbuf);
      traceInputParameter("buffer", "%d", buffer);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXReleaseTexImageATI(dpy, pbuf, buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void GLAPIENTRY
glXDrawableAttribATI(Display *dpy, GLXDrawable draw, const int *attrib_list)
{
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXDrawableAttribATI)
    traceGLX_lookupNativeAddress("glXDrawableAttribATI", (void **) &traceGLX_Native.glXDrawableAttribATI);

  traceThis = traceEnabled("glXDrawableAttribATI",&traceParam);

  if (!traceGLX_Native.glXDrawableAttribATI)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXDrawableAttribATI");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceGLX_Native.glXDrawableAttribATI(dpy, draw, attrib_list);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT int GLAPIENTRY
glXVideoResizeSUN(Display *display, GLXDrawable window, float factor)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXVideoResizeSUN)
    traceGLX_lookupNativeAddress("glXVideoResizeSUN", (void **) &traceGLX_Native.glXVideoResizeSUN);

  traceThis = traceEnabled("glXVideoResizeSUN",&traceParam);

  if (!traceGLX_Native.glXVideoResizeSUN)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXVideoResizeSUN");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("factor", "%f", factor);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXVideoResizeSUN(display, window, factor);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int GLAPIENTRY
glXGetVideoResizeSUN(Display *display, GLXDrawable window, float *factor)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceGLX_initialized)
    traceGLX_init();

  /* Lookup API function pointer. */

  if (!traceGLX_Native.glXGetVideoResizeSUN)
    traceGLX_lookupNativeAddress("glXGetVideoResizeSUN", (void **) &traceGLX_Native.glXGetVideoResizeSUN);

  traceThis = traceEnabled("glXGetVideoResizeSUN",&traceParam);

  if (!traceGLX_Native.glXGetVideoResizeSUN)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("glXGetVideoResizeSUN");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceGLX_Native.glXGetVideoResizeSUN(display, window, factor);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("factor", "%f[%d]", factor, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

/* GLX proc address maps. */

static const char *traceGLX_apiFuncNames[115] = {
  "glXAllocateMemoryNV",
  "glXBindChannelToWindowSGIX",
  "glXBindHyperpipeSGIX",
  "glXBindSwapBarrierNV",
  "glXBindSwapBarrierSGIX",
  "glXBindTexImageATI",
  "glXBindTexImageEXT",
  "glXBindVideoDeviceNV",
  "glXBindVideoImageNV",
  "glXChannelRectSGIX",
  "glXChannelRectSyncSGIX",
  "glXChooseFBConfig",
  "glXChooseFBConfigSGIX",
  "glXChooseVisual",
  "glXCopyContext",
  "glXCopyImageSubDataNV",
  "glXCopySubBufferMESA",
  "glXCreateContext",
  "glXCreateContextAttribsARB",
  "glXCreateContextWithConfigSGIX",
  "glXCreateGLXPbufferSGIX",
  "glXCreateGLXPixmap",
  "glXCreateGLXPixmapMESA",
  "glXCreateGLXPixmapWithConfigSGIX",
  "glXCreateNewContext",
  "glXCreatePbuffer",
  "glXCreatePixmap",
  "glXCreateWindow",
  "glXCushionSGI",
  "glXDestroyContext",
  "glXDestroyGLXPbufferSGIX",
  "glXDestroyGLXPixmap",
  "glXDestroyHyperpipeConfigSGIX",
  "glXDestroyPbuffer",
  "glXDestroyPixmap",
  "glXDestroyWindow",
  "glXDrawableAttribATI",
  "glXEnumerateVideoDevicesNV",
  "glXFreeContextEXT",
  "glXFreeMemoryNV",
  "glXGetAGPOffsetMESA",
  "glXGetClientString",
  "glXGetConfig",
  "glXGetContextIDEXT",
  "glXGetCurrentContext",
  "glXGetCurrentDisplay",
  "glXGetCurrentDrawable",
  "glXGetCurrentReadDrawable",
  "glXGetCurrentReadDrawableSGI",
  "glXGetFBConfigAttrib",
  "glXGetFBConfigAttribSGIX",
  "glXGetFBConfigFromVisualSGIX",
  "glXGetFBConfigs",
  "glXGetMscRateOML",
  "glXGetProcAddress",
  "glXGetProcAddressARB",
  "glXGetSelectedEvent",
  "glXGetSelectedEventSGIX",
  "glXGetSyncValuesOML",
  "glXGetTransparentIndexSUN",
  "glXGetVideoDeviceNV",
  "glXGetVideoInfoNV",
  "glXGetVideoResizeSUN",
  "glXGetVideoSyncSGI",
  "glXGetVisualFromFBConfig",
  "glXGetVisualFromFBConfigSGIX",
  "glXHyperpipeAttribSGIX",
  "glXHyperpipeConfigSGIX",
  "glXImportContextEXT",
  "glXIsDirect",
  "glXJoinSwapGroupNV",
  "glXJoinSwapGroupSGIX",
  "glXMakeContextCurrent",
  "glXMakeCurrent",
  "glXMakeCurrentReadSGI",
  "glXQueryChannelDeltasSGIX",
  "glXQueryChannelRectSGIX",
  "glXQueryContext",
  "glXQueryContextInfoEXT",
  "glXQueryDrawable",
  "glXQueryExtension",
  "glXQueryExtensionsString",
  "glXQueryFrameCountNV",
  "glXQueryGLXPbufferSGIX",
  "glXQueryHyperpipeAttribSGIX",
  "glXQueryHyperpipeBestAttribSGIX",
  "glXQueryHyperpipeConfigSGIX",
  "glXQueryHyperpipeNetworkSGIX",
  "glXQueryMaxSwapBarriersSGIX",
  "glXQueryMaxSwapGroupsNV",
  "glXQueryServerString",
  "glXQuerySwapGroupNV",
  "glXQueryVersion",
  "glXReleaseBuffersMESA",
  "glXReleaseTexImageATI",
  "glXReleaseTexImageEXT",
  "glXReleaseVideoDeviceNV",
  "glXReleaseVideoImageNV",
  "glXResetFrameCountNV",
  "glXSelectEvent",
  "glXSelectEventSGIX",
  "glXSendPbufferToVideoNV",
  "glXSet3DfxModeMESA",
  "glXSwapBuffers",
  "glXSwapBuffersMscOML",
  "glXSwapIntervalEXT",
  "glXSwapIntervalSGI",
  "glXUseXFont",
  "glXVideoResizeSUN",
  "glXWaitForMscOML",
  "glXWaitForSbcOML",
  "glXWaitGL",
  "glXWaitVideoSyncSGI",
  "glXWaitX",
  NULL
};

static void *traceGLX_WrapperArray[115] = {
  (void *) glXAllocateMemoryNV,
  (void *) glXBindChannelToWindowSGIX,
  (void *) glXBindHyperpipeSGIX,
  (void *) glXBindSwapBarrierNV,
  (void *) glXBindSwapBarrierSGIX,
  (void *) glXBindTexImageATI,
  (void *) glXBindTexImageEXT,
  (void *) glXBindVideoDeviceNV,
  (void *) glXBindVideoImageNV,
  (void *) glXChannelRectSGIX,
  (void *) glXChannelRectSyncSGIX,
  (void *) glXChooseFBConfig,
  (void *) glXChooseFBConfigSGIX,
  (void *) glXChooseVisual,
  (void *) glXCopyContext,
  (void *) glXCopyImageSubDataNV,
  (void *) glXCopySubBufferMESA,
  (void *) glXCreateContext,
  (void *) glXCreateContextAttribsARB,
  (void *) glXCreateContextWithConfigSGIX,
  (void *) glXCreateGLXPbufferSGIX,
  (void *) glXCreateGLXPixmap,
  (void *) glXCreateGLXPixmapMESA,
  (void *) glXCreateGLXPixmapWithConfigSGIX,
  (void *) glXCreateNewContext,
  (void *) glXCreatePbuffer,
  (void *) glXCreatePixmap,
  (void *) glXCreateWindow,
  (void *) glXCushionSGI,
  (void *) glXDestroyContext,
  (void *) glXDestroyGLXPbufferSGIX,
  (void *) glXDestroyGLXPixmap,
  (void *) glXDestroyHyperpipeConfigSGIX,
  (void *) glXDestroyPbuffer,
  (void *) glXDestroyPixmap,
  (void *) glXDestroyWindow,
  (void *) glXDrawableAttribATI,
  (void *) glXEnumerateVideoDevicesNV,
  (void *) glXFreeContextEXT,
  (void *) glXFreeMemoryNV,
  (void *) glXGetAGPOffsetMESA,
  (void *) glXGetClientString,
  (void *) glXGetConfig,
  (void *) glXGetContextIDEXT,
  (void *) glXGetCurrentContext,
  (void *) glXGetCurrentDisplay,
  (void *) glXGetCurrentDrawable,
  (void *) glXGetCurrentReadDrawable,
  (void *) glXGetCurrentReadDrawableSGI,
  (void *) glXGetFBConfigAttrib,
  (void *) glXGetFBConfigAttribSGIX,
  (void *) glXGetFBConfigFromVisualSGIX,
  (void *) glXGetFBConfigs,
  (void *) glXGetMscRateOML,
  (void *) glXGetProcAddress,
  (void *) glXGetProcAddressARB,
  (void *) glXGetSelectedEvent,
  (void *) glXGetSelectedEventSGIX,
  (void *) glXGetSyncValuesOML,
  (void *) glXGetTransparentIndexSUN,
  (void *) glXGetVideoDeviceNV,
  (void *) glXGetVideoInfoNV,
  (void *) glXGetVideoResizeSUN,
  (void *) glXGetVideoSyncSGI,
  (void *) glXGetVisualFromFBConfig,
  (void *) glXGetVisualFromFBConfigSGIX,
  (void *) glXHyperpipeAttribSGIX,
  (void *) glXHyperpipeConfigSGIX,
  (void *) glXImportContextEXT,
  (void *) glXIsDirect,
  (void *) glXJoinSwapGroupNV,
  (void *) glXJoinSwapGroupSGIX,
  (void *) glXMakeContextCurrent,
  (void *) glXMakeCurrent,
  (void *) glXMakeCurrentReadSGI,
  (void *) glXQueryChannelDeltasSGIX,
  (void *) glXQueryChannelRectSGIX,
  (void *) glXQueryContext,
  (void *) glXQueryContextInfoEXT,
  (void *) glXQueryDrawable,
  (void *) glXQueryExtension,
  (void *) glXQueryExtensionsString,
  (void *) glXQueryFrameCountNV,
  (void *) glXQueryGLXPbufferSGIX,
  (void *) glXQueryHyperpipeAttribSGIX,
  (void *) glXQueryHyperpipeBestAttribSGIX,
  (void *) glXQueryHyperpipeConfigSGIX,
  (void *) glXQueryHyperpipeNetworkSGIX,
  (void *) glXQueryMaxSwapBarriersSGIX,
  (void *) glXQueryMaxSwapGroupsNV,
  (void *) glXQueryServerString,
  (void *) glXQuerySwapGroupNV,
  (void *) glXQueryVersion,
  (void *) glXReleaseBuffersMESA,
  (void *) glXReleaseTexImageATI,
  (void *) glXReleaseTexImageEXT,
  (void *) glXReleaseVideoDeviceNV,
  (void *) glXReleaseVideoImageNV,
  (void *) glXResetFrameCountNV,
  (void *) glXSelectEvent,
  (void *) glXSelectEventSGIX,
  (void *) glXSendPbufferToVideoNV,
  (void *) glXSet3DfxModeMESA,
  (void *) glXSwapBuffers,
  (void *) glXSwapBuffersMscOML,
  (void *) glXSwapIntervalEXT,
  (void *) glXSwapIntervalSGI,
  (void *) glXUseXFont,
  (void *) glXVideoResizeSUN,
  (void *) glXWaitForMscOML,
  (void *) glXWaitForSbcOML,
  (void *) glXWaitGL,
  (void *) glXWaitVideoSyncSGI,
  (void *) glXWaitX,
  NULL
};

static void **traceGLX_NativeArray = (void **) &traceGLX_Native;

/* Lookup native proc address for API function and update traceGLX_NativeArray. */

void
traceGLX_lookupNativeAddress(const char *name, void **procPtr)
{
  void *proc = NULL;
  size_t index = procPtr - traceGLX_NativeArray;

  assert(name);
  assert(index < 114);
  assert(!strcmp(name, traceGLX_apiFuncNames[index]));

  if (!traceGLX_Native.glXGetProcAddress)
  {
    traceWarning("Cannot load function with traceGLX_Native.glXGetProcAddress.");
    traceGLX_NativeArray[index] = NULL;
  }

  /* Check if API function address already loaded. */

  if (traceGLX_NativeArray[index])
    return;

  /* Obtain proc address using GLX GetProcAddress API function. */

  proc = traceGLX_Native.glXGetProcAddress((const unsigned char *) name);

  /* Check if API function address loaded from traceGLX. */

  if (proc == traceGLX_WrapperArray[index])
  {
    traceWarning("Ignoring %s loaded from traceGLX library.", name);
    proc = NULL;
  }

  traceGLX_NativeArray[index] = proc;
}

/* Binary search function for proc address lookup. */

static int CompareStrcmp(const void *a, const void *b)
{
  return strcmp(*(const char **) a, *(const char **) b);
}

void *traceGL_lookupWrapperAddress(const char *name, void *proc);

/* Lookup wrapper proc address for the GLX API function. */

void *
traceGLX_lookupWrapperAddress(const char *name, void *proc)
{
  const char **res = NULL;

  if (!proc)
    return NULL;

  if (!name)
  {
    traceWarning("Cannot load function without name.");
    return NULL;
  }

  if (!strncmp(name, "gl", 2))
    return traceGL_lookupWrapperAddress(name, proc);

  res = (const char **) bsearch(&name, traceGLX_apiFuncNames, 113, sizeof(const char *), CompareStrcmp);
  if (res)
    return traceGLX_WrapperArray[(size_t) (res - traceGLX_apiFuncNames)];

  traceWarning("Trace does not support %s.", name);
  return proc;
}
