/**
 * The CSSImportRule interface represents a @import rule within a CSS style sheet. The @import rule is used to import style rules from other style sheets.
 */
var CSSImportRule = {
}
/**
 * The style sheet referred to by this rule, if it has been loaded. The value of this attribute is null if the style sheet has not yet been loaded or if it will not be loaded (e.g. if the style sheet is for a media type not supported by the user agent).
 * @syntax cSSImportRule.styleSheet
 * @returns {CSSStyleSheet} 
 */
CSSImportRule.prototype.styleSheet = new CSSStyleSheet();

/**
 * The location of the style sheet to be imported. The attribute will not contain the "url(...)" specifier around the URI.
 * @syntax cSSImportRule.href
 * @returns {String} 
 */
CSSImportRule.prototype.href = new String();

/**
 * A list of media types for which this style sheet may be used.
 * @syntax cSSImportRule.media
 * @returns {stylesheets::MediaList} 
 */
CSSImportRule.prototype.media = new stylesheets::MediaList();

/**
 * Represents the CSSImportRule prototype object.
 * @syntax CSSImportRule.prototype
 * @static
 */
CSSImportRule.prototype;

