
package org.llvm.adt.aliases;

import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import org.clank.support.JavaDifferentiators.*;
import static org.clank.java.built_in.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.clank.java.std_pair.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import static org.clank.support.Unsigned.*;
import org.clank.support.NativeCallback.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;
import org.llvm.cl.*;
import static org.llvm.cl.impl.CommandLineStatics.*;
import org.clank.java.stdimpl.aliases.*;
import org.llvm.support.sys.*;


/// This class implements a map that also provides access to all stored values
/// in a deterministic order. The values are kept in a std::vector and the
/// mapping is done with DenseMap from Keys to indexes in that vector.
/*template <typename KeyT, typename ValueT, typename MapType = llvm::DenseMap<KeyT, unsigned int>, typename VectorType = std::vector<std::pair<KeyT, ValueT> >> TEMPLATE*/
//<editor-fold defaultstate="collapsed" desc="llvm::MapVector">
@Converted(kind = Converted.Kind.AUTO,
 source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 29,
 FQN="llvm::MapVector", NM="_ZN4llvm9MapVectorE",
 cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVectorE")
//</editor-fold>
public class ${FILE_NAME}${CLASS_SUFFIX}  {
  /*typedef typename VectorType::size_type size_type*/
//  public final class size_type extends  VectorType.size_type{ };
  
  @Converted(kind = Converted.Kind.MANUAL_ADDED)
  private final ${VALUE_TYPE} defaultValue;
  
  private ${MAP_TYPE} Map;
  private ${VECTOR_TYPE} Vector;
/*public:*/
  /*typedef typename VectorType::iterator iterator*/
//  public final class iterator extends  VectorType.iterator{ };
  /*typedef typename VectorType::const_iterator const_iterator*/
//  public final class const_iterator extends  VectorType.const_iterator{ };
  /*typedef typename VectorType::reverse_iterator reverse_iterator*/
//  public final class reverse_iterator extends  VectorType.reverse_iterator{ };
  /*typedef typename VectorType::const_reverse_iterator const_reverse_iterator*/
//  public final class const_reverse_iterator extends  VectorType.const_reverse_iterator{ };

  @Converted(kind = Converted.Kind.MANUAL_ADDED)
  public ${FILE_NAME}(${VALUE_TYPE} defaultValue) {
    this.defaultValue = defaultValue;
  }
  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::size">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 44,
   FQN="llvm::MapVector::size", NM="_ZNK4llvm9MapVector4sizeEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector4sizeEv")
  //</editor-fold>
  public  int size() /*const*/ {
    return Vector.size();
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::begin">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 46,
   FQN="llvm::MapVector::begin", NM="_ZN4llvm9MapVector5beginEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector5beginEv")
  //</editor-fold>
  public  ${VECTOR_ITER} begin() {
    return Vector.begin();
  }

  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::begin">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 47,
//   FQN="llvm::MapVector::begin", NM="_ZNK4llvm9MapVector5beginEv",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector5beginEv")
//  //</editor-fold>
//  public  VectorType.const_iterator begin() /*const*/ {
//    return Vector.begin();
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::end">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 48,
   FQN="llvm::MapVector::end", NM="_ZN4llvm9MapVector3endEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector3endEv")
  //</editor-fold>
  public  ${VECTOR_ITER} end() {
    return Vector.end();
  }

  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::end">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 49,
//   FQN="llvm::MapVector::end", NM="_ZNK4llvm9MapVector3endEv",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector3endEv")
//  //</editor-fold>
//  public  VectorType.const_iterator end() /*const*/ {
//    return Vector.end();
//  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::rbegin">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 51,
   FQN="llvm::MapVector::rbegin", NM="_ZN4llvm9MapVector6rbeginEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector6rbeginEv")
  //</editor-fold>
  public  ${VECTOR_REVERSE_ITER} rbegin() {
    return Vector.rbegin();
  }

  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::rbegin">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 52,
//   FQN="llvm::MapVector::rbegin", NM="_ZNK4llvm9MapVector6rbeginEv",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector6rbeginEv")
//  //</editor-fold>
//  public  VectorType.const_reverse_iterator rbegin() /*const*/ {
//    return Vector.rbegin();
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::rend">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 53,
   FQN="llvm::MapVector::rend", NM="_ZN4llvm9MapVector4rendEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector4rendEv")
  //</editor-fold>
  public  ${VECTOR_REVERSE_ITER} rend() {
    return Vector.rend();
  }

  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::rend">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 54,
//   FQN="llvm::MapVector::rend", NM="_ZNK4llvm9MapVector4rendEv",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector4rendEv")
//  //</editor-fold>
//  public  VectorType.const_reverse_iterator rend() /*const*/ {
//    return Vector.rend();
//  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::empty">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 56,
   FQN="llvm::MapVector::empty", NM="_ZNK4llvm9MapVector5emptyEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector5emptyEv")
  //</editor-fold>
  public boolean empty() /*const*/ {
    return Vector.empty();
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::front">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 60,
   FQN="llvm::MapVector::front", NM="_ZN4llvm9MapVector5frontEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector5frontEv")
  //</editor-fold>
  public ${VECTOR_PAIR} /*&*/ front() {
    return Vector.front();
  }

  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::front">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 61,
//   FQN="llvm::MapVector::front", NM="_ZNK4llvm9MapVector5frontEv",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector5frontEv")
//  //</editor-fold>
//  public /*const*/ std.pair<KeyT, ValueT> /*&*/ front() /*const*/ {
//    return Vector.front();
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::back">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 62,
   FQN="llvm::MapVector::back", NM="_ZN4llvm9MapVector4backEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector4backEv")
  //</editor-fold>
  public ${VECTOR_PAIR} /*&*/ back() {
    return Vector.back();
  }

  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::back">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 63,
//   FQN="llvm::MapVector::back", NM="_ZNK4llvm9MapVector4backEv",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector4backEv")
//  //</editor-fold>
//  public /*const*/ std.pair<KeyT, ValueT> /*&*/ back() /*const*/ {
//    return Vector.back();
//  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::clear">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 65,
   FQN="llvm::MapVector::clear", NM="_ZN4llvm9MapVector5clearEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector5clearEv")
  //</editor-fold>
  public void clear() {
    Map.clear();
    Vector.clear();
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::swap">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 70,
   FQN="llvm::MapVector::swap", NM="_ZN4llvm9MapVector4swapERNS_9MapVectorIT_T0_T1_T2_EE",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector4swapERNS_9MapVectorIT_T0_T1_T2_EE")
  //</editor-fold>
  public void swap(${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) {
    //std.swap(Map, RHS.Map);
    ${MAP_TYPE} tempMap = this.Map;
    this.Map = RHS.Map;
    RHS.Map = tempMap;
    //std.swap(Vector, RHS.Vector);
    ${VECTOR_TYPE} tempVector = this.Vector;
    this.Vector = RHS.Vector;
    RHS.Vector = tempVector;
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::operator[]">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 75,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 70,
   FQN="llvm::MapVector::operator[]", NM="_ZN4llvm9MapVectorixERKT_",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVectorixERKT_")
  //</editor-fold>
  public ${VALUE_TYPE} /*&*/ $at(/*const*/ ${KEY_TYPE} /*&*/ Key) {
    ${MAP_PAIR} Pair = new ${MAP_PAIR}(Key, 0);
    std.pairTypeBool<${MAP_ITER}> Result = Map.insert(Pair);
    /*uint*/int I = Result.first.$arrow().second;
    if (Result.second) {
      Vector.push_back(new ${VECTOR_PAIR}(Key, $ValueT()));
      Result.first.$arrow().second = Vector.size() - 1;
    }
    return Vector.$at(I).second;
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::lookup">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 86,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 81,
   FQN="llvm::MapVector::lookup", NM="_ZNK4llvm9MapVector6lookupERKT_",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector6lookupERKT_")
  //</editor-fold>
  public ${VALUE_TYPE} lookup(/*const*/ ${KEY_TYPE} /*&*/ Key) /*const*/ {
    ${MAP_ITER} Pos = Map.find(Key);
    return Native.$eq(Pos, Map.end()) ? $ValueT() : Vector.$at(Pos.$arrow().second).second;
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::insert">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 91,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 86,
   FQN="llvm::MapVector::insert", NM="_ZN4llvm9MapVector6insertERKSt4pairIT_T0_E",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector6insertERKSt4pairIT_T0_E")
  //</editor-fold>
  public std.pairTypeBool<${VECTOR_ITER}> insert(/*const*/ ${VECTOR_PAIR} /*&*/ KV) {
    ${MAP_PAIR} Pair = new ${MAP_PAIR}(KV.first, 0);
    std.pairTypeBool<${MAP_ITER}> Result = Map.insert(Pair);
    int/*uint &*/ I = Result.first.$arrow().second;
    if (Result.second) {
      Vector.push_back(new ${VECTOR_PAIR}(KV.first, KV.second));
      Result.first.$arrow().second = Vector.size() - 1;
      return std.make_pair_T_bool(std.prev(end()), true);
    }
    return std.make_pair_T_bool(begin().$add(I), false);
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::count">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 103,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 98,
   FQN="llvm::MapVector::count", NM="_ZNK4llvm9MapVector5countERKT_",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector5countERKT_")
  //</editor-fold>
  public  int count(/*const*/ ${KEY_TYPE} /*&*/ Key) /*const*/ {
    ${MAP_ITER} Pos = Map.find(Key);
    return Native.$eq(Pos, Map.end()) ? 0 : 1;
  }

  
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::find">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 108,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 103,
   FQN="llvm::MapVector::find", NM="_ZN4llvm9MapVector4findERKT_",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector4findERKT_")
  //</editor-fold>
  public  ${VECTOR_ITER} find(/*const*/ ${KEY_TYPE} /*&*/ Key) {
    ${MAP_ITER} Pos = Map.find(Key);
    return Native.$eq(Pos, Map.end()) ? Vector.end() : (Vector.begin().$add(Pos.$arrow().second));
  }

  
  ////<editor-fold defaultstate="collapsed" desc="llvm::MapVector::find">
//  @Converted(kind = Converted.Kind.AUTO,
//   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 114,
//   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 109,
//   FQN="llvm::MapVector::find", NM="_ZNK4llvm9MapVector4findERKT_",
//   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZNK4llvm9MapVector4findERKT_")
//  //</editor-fold>
//  public  VectorType.const_iterator find(/*const*/ KeyT /*&*/ Key) /*const*/ {
//     MapType.const_iterator Pos = Map.find(Key);
//    return Native.$eq(Pos, Map.end()) ? Vector.end() : (Native.$add(Vector.begin(), Pos.second));
//  }

  
  /// \brief Remove the last element from the vector.
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::pop_back">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 121,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 116,
   FQN="llvm::MapVector::pop_back", NM="_ZN4llvm9MapVector8pop_backEv",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector8pop_backEv")
  //</editor-fold>
  public void pop_back() {
    ${MAP_ITER} Pos = Map.find(Vector.back().first);
    Map.erase(Pos);
    Vector.pop_back();
  }

  
  /// \brief Remove the element given by Iterator.
  ///
  /// Returns an iterator to the element following the one which was removed,
  /// which may be end().
  ///
  /// \note This is a deceivingly expensive operation (linear time).  It's
  /// usually better to use \a remove_if() if possible.
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::erase">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 134,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 129,
   FQN="llvm::MapVector::erase", NM="_ZN4llvm9MapVector5eraseENT2_8iteratorE",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector5eraseENT2_8iteratorE")
  //</editor-fold>
  public  ${VECTOR_ITER} erase( ${VECTOR_ITER} Iterator) {
    Map.erase(Iterator.$arrow().first);
    ${VECTOR_ITER} Next = Vector.erase(Iterator);
    if (Native.$eq(Next, Vector.end())) {
      return Next;
    }
    
    // Update indices in the map.
    /*size_t*/int Index = Next.$sub(Vector.begin());
    for (${MAP_PAIR} /*&*/ I : Map) {
      assert (Native.$noteq(I.second, Index)) : "Index was already erased!";
      if (Native.$greater(I.second, Index)) {
        --I.second;
      }
    }
    return Next;
  }

  
  /// \brief Remove all elements with the key value Key.
  ///
  /// Returns the number of elements removed.
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::erase">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 153,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 148,
   FQN="llvm::MapVector::erase", NM="_ZN4llvm9MapVector5eraseERKT_",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=_ZN4llvm9MapVector5eraseERKT_")
  //</editor-fold>
  public  int erase(/*const*/ ${KEY_TYPE} /*&*/ Key) {
    ${VECTOR_ITER} Iterator = find(Key);
    if (Native.$eq(Iterator, end())) {
      return 0;
    }
    erase(Iterator);
    return 1;
  }

  
  /// \brief Remove the elements that match the predicate.
  ///
  /// Erase all elements that match \c Pred in a single pass.  Takes linear
  /// time.
  /*template <class Predicate> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::MapVector::remove_if">
  @Converted(kind = Converted.Kind.AUTO,
   source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", line = 168,
   old_source = "${LLVM_SRC}/llvm/include/llvm/ADT/MapVector.h", old_line = 164,
   FQN="llvm::MapVector::remove_if", NM="Tpl__ZN4llvm9MapVector9remove_ifET_",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/MC/MCSection.cpp -nm=Tpl__ZN4llvm9MapVector9remove_ifET_")
  //</editor-fold>
  public void remove_if(BoolPredicate<${VECTOR_PAIR}> Pred) {
    ${VECTOR_ITER} O = Vector.begin();
    for (${VECTOR_ITER} I = $tryClone(O), E = Vector.end(); Native.$noteq(I, E); I.$preInc()) {
      if (Pred.$call(/*Deref*/I.$star())) {
        // Erase from the map.
        Map.erase(I.$arrow().first);
        continue;
      }
      if (Native.$noteq(I, O)) {
        // Move the value and update the index in the map.
        O.$star().$assign(std.move(/*Deref*/I.$star()));
        Map.ref$at(O.$arrow().first).$set(O.$sub(Vector.begin()));
      }
      O.$preInc();
    }
    // Erase trailing entries in the vector.
    Vector.erase(O, Vector.end());
  }
  
  private ${VALUE_TYPE} $ValueT() {
    return ${DEFAULT_VALUE};
  }  

  @Converted(kind = Converted.Kind.MANUAL_ADDED)
  private boolean isDataPointerLike() {
    return ${IS_DATA_POINTER_LIKE};
  }
  
  public String toString() {
    return "" + "Map=" + Map // NOI18N
              + ", Vector=" + Vector; // NOI18N
  }
}
