/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.model.ClassifierNode;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.Children;

public class ClassNode
extends ClassifierNode {
    private CharSequence name;
    private CharSequence qname;

    public ClassNode(CsmClass cls, Children.Array key) {
        super((CsmCompoundClassifier)cls, key);
        this.init(cls);
    }

    private void init(final CsmClass cls) {
        final CharSequence old = this.name;
        this.name = CsmKindUtilities.isTemplate((CsmObject)cls) ? ((CsmTemplate)cls).getDisplayName() : cls.getName();
        final CharSequence oldQ = this.qname;
        this.qname = CsmKindUtilities.isTemplate((CsmObject)cls) ? cls.getQualifiedName() + "<>" : cls.getQualifiedName();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    if (old == null || !old.equals(ClassNode.this.name)) {
                        ClassNode.this.fireNameChange(old == null ? null : old.toString(), ClassNode.this.name == null ? null : ClassNode.this.name.toString());
                        ClassNode.this.fireDisplayNameChange(old == null ? null : old.toString(), ClassNode.this.name == null ? null : ClassNode.this.name.toString());
                    }
                    if (oldQ == null || !oldQ.equals(ClassNode.this.qname)) {
                        ClassNode.this.fireShortDescriptionChange(oldQ == null ? null : oldQ.toString(), ClassNode.this.qname == null ? null : ClassNode.this.qname.toString());
                    }
                    ClassNode.this.fireIconChange();
                    ClassNode.this.fireOpenedIconChange();
                } else {
                    ClassNode.this.resetIcon(CsmImageLoader.getImage((CsmObject)cls));
                    SwingUtilities.invokeLater(this);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(runnable);
        } else {
            runnable.run();
        }
    }

    public String getName() {
        return this.name.toString();
    }

    public String getDisplayName() {
        return this.name.toString();
    }

    public String getShortDescription() {
        return this.qname.toString();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o instanceof CsmClass) {
            CsmClass cls = (CsmClass)o;
            this.setObject((CsmOffsetableDeclaration)cls);
            this.init(cls);
        } else if (o != null) {
            System.err.println("Expected CsmClass. Actually event contains " + o.toString());
        }
    }
}

