/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class UIUtils {
    public static final String PROP_EXPANSION_TRANSACTION = "expansion_transaction";
    public static Dimension DIMENSION_SMALLEST = new Dimension(0, 0);
    private static final Logger LOGGER = Logger.getLogger(UIUtils.class.getName());
    public static final float ALTERNATE_ROW_DARKER_FACTOR = 0.96f;
    private static final int MAX_TREE_AUTOEXPAND_LINES = 50;
    private static boolean toolTipValuesInitialized = false;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    private static Color disabledLineColor;
    private static Map<Integer, Color> DARKER_CACHE;
    private static Color profilerResultsBackground;
    private static Boolean darkResultsBackground;

    public static void decorateProfilerPanel(JPanel panel) {
        Color panelBackground = UIManager.getColor("ProfilerPanels.background");
        if (panelBackground != null) {
            panel.setOpaque(true);
            panel.setBackground(panelBackground);
        }
    }

    public static JPanel createFillerPanel() {
        JPanel fillerPanel = new JPanel(null){

            @Override
            public Dimension getPreferredSize() {
                return DIMENSION_SMALLEST;
            }
        };
        fillerPanel.setOpaque(false);
        return fillerPanel;
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator horizontalSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        return horizontalSeparator;
    }

    public static JSeparator createHorizontalLine(Color background) {
        final boolean customPaint = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel();
        JSeparator separator = new JSeparator(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }

            @Override
            public void paint(Graphics g) {
                if (customPaint) {
                    g.setColor(UIUtils.getDisabledLineColor());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    super.paint(g);
                }
            }
        };
        separator.setBackground(background);
        return separator;
    }

    public static boolean isAquaLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Aqua");
    }

    public static Color getDarker(Color c) {
        int rgb;
        Color d;
        if (DARKER_CACHE == null) {
            DARKER_CACHE = new HashMap<Integer, Color>();
        }
        if ((d = DARKER_CACHE.get(rgb = c.getRGB())) == null) {
            d = c.equals(Color.WHITE) ? new Color(244, 244, 244) : UIUtils.getSafeColor((int)((float)c.getRed() * 0.96f), (int)((float)c.getGreen() * 0.96f), (int)((float)c.getBlue() * 0.96f));
            DARKER_CACHE.put(rgb, d);
        }
        return d;
    }

    public static Color getDarkerLine(Color c, float alternateRowDarkerFactor) {
        return UIUtils.getSafeColor((int)((float)c.getRed() * alternateRowDarkerFactor), (int)((float)c.getGreen() * alternateRowDarkerFactor), (int)((float)c.getBlue() * alternateRowDarkerFactor));
    }

    public static Color getDisabledForeground(Color c) {
        Color b = c.brighter();
        if (c.getRGB() == b.getRGB()) {
            return b;
        }
        if (UIUtils.isNimbusLookAndFeel()) {
            return UIManager.getColor("nimbusDisabledText").darker();
        }
        if (UIUtils.isMetalLookAndFeel()) {
            return UIManager.getColor("Label.disabledForeground");
        }
        if (Color.BLACK.getRGB() == c.getRGB()) {
            return Color.GRAY;
        }
        return b;
    }

    public static int getDefaultRowHeight() {
        return new JLabel((String)"X").getPreferredSize().height + 2;
    }

    public static boolean isGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Nimbus");
    }

    public static boolean isNimbusGTKTheme() {
        return UIUtils.isGTKLookAndFeel() && "nimbus".equals(Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Net/ThemeName"));
    }

    public static boolean isNimbus() {
        return UIUtils.isNimbusLookAndFeel() || UIUtils.isNimbusGTKTheme();
    }

    public static boolean isMetalLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Metal");
    }

    public static int getNextSubTabIndex(JTabbedPane tabs, int tabIndex) {
        int nextTabIndex = tabIndex;
        for (int i = 0; i < tabs.getComponentCount(); ++i) {
            if (++nextTabIndex == tabs.getComponentCount()) {
                nextTabIndex = 0;
            }
            if (tabs.isEnabledAt(nextTabIndex)) break;
        }
        return nextTabIndex;
    }

    public static Window getParentWindow(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    public static int getPreviousSubTabIndex(JTabbedPane tabs, int tabIndex) {
        int previousTabIndex = tabIndex;
        for (int i = 0; i < tabs.getComponentCount(); ++i) {
            if (--previousTabIndex < 0) {
                previousTabIndex = tabs.getComponentCount() - 1;
            }
            if (tabs.isEnabledAt(previousTabIndex)) break;
        }
        return previousTabIndex;
    }

    public static Color getSafeColor(int red, int green, int blue) {
        red = Math.max(red, 0);
        red = Math.min(red, 255);
        green = Math.max(green, 0);
        green = Math.min(green, 255);
        blue = Math.max(blue, 0);
        blue = Math.min(blue, 255);
        return new Color(red, green, blue);
    }

    public static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    public static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    private static Color getGTKProfilerResultsBackground() {
        int[] pixels = new int[]{-1};
        JTextArea textArea = new JTextArea();
        textArea.setSize(new Dimension(10, 10));
        textArea.doLayout();
        BufferedImage image = new BufferedImage(textArea.getSize().width, textArea.getSize().height, 1);
        textArea.printAll(((Image)image).getGraphics());
        PixelGrabber pixelGrabber = new PixelGrabber(image, 5, 5, 1, 1, pixels, 0, 1);
        try {
            pixelGrabber.grabPixels();
            if (pixels[0] == -1) {
                return Color.WHITE;
            }
        }
        catch (InterruptedException e) {
            return UIUtils.getNonGTKProfilerResultsBackground();
        }
        return pixels[0] != -1 ? new Color(pixels[0]) : UIUtils.getNonGTKProfilerResultsBackground();
    }

    private static Color getNonGTKProfilerResultsBackground() {
        return UIManager.getColor("Table.background");
    }

    public static Color getProfilerResultsBackground() {
        if (profilerResultsBackground == null && (profilerResultsBackground = UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel() ? UIUtils.getGTKProfilerResultsBackground() : UIUtils.getNonGTKProfilerResultsBackground()) == null) {
            profilerResultsBackground = Color.WHITE;
        }
        return profilerResultsBackground;
    }

    public static boolean isDarkResultsBackground() {
        if (darkResultsBackground == null) {
            Color c = UIUtils.getProfilerResultsBackground();
            int b = (int)(0.3 * (double)c.getRed() + 0.59 * (double)c.getGreen() + 0.11 * (double)c.getBlue());
            darkResultsBackground = b < 85;
        }
        return darkResultsBackground;
    }

    public static boolean isWindowsClassicLookAndFeel() {
        if ("Windows Classic".equals(UIManager.getLookAndFeel().getName())) {
            return true;
        }
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        return !UIUtils.isWindowsXPLookAndFeel();
    }

    public static boolean isWindowsLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isWindowsXPLookAndFeel() {
        if (!UIUtils.isWindowsLookAndFeel()) {
            return false;
        }
        boolean xpThemeActiveOS = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        boolean xpThemeDisabled = System.getProperty("swing.noxp") != null;
        return xpThemeActiveOS && !xpThemeDisabled;
    }

    public static boolean isWindowsModernLookAndFeel() {
        if (!UIUtils.isWindowsXPLookAndFeel()) {
            return false;
        }
        String osName = System.getProperty("os.name");
        return osName != null && (osName.contains("Windows 8") || osName.contains("Windows 10"));
    }

    public static boolean isOracleLookAndFeel() {
        return UIManager.getLookAndFeel().getID().contains("Oracle");
    }

    public static void autoExpand(JTree tree, TreePath path, int maxLines, int maxChildToExpand, boolean dontExpandToLeafs) {
        TreeModel model = tree.getModel();
        Object node = path.getLastPathComponent();
        TreePath newPath = path;
        int currentLines = 0;
        block0: while (currentLines++ < maxLines && !model.isLeaf(node) && model.getChildCount(node) > 0 && model.getChildCount(node) <= maxChildToExpand) {
            for (int i = 0; i < model.getChildCount(node); ++i) {
                node = tree.getModel().getChild(node, i);
                if (model.isLeaf(node)) continue;
                if (dontExpandToLeafs && UIUtils.hasOnlyLeafs(tree, node)) continue block0;
                newPath = newPath.pathByAddingChild(node);
                continue block0;
            }
        }
        tree.expandPath(newPath);
    }

    public static void autoExpandRoot(JTree tree) {
        UIUtils.autoExpandRoot(tree, 1);
    }

    public static void autoExpandRoot(JTree tree, int maxChildToExpand) {
        Object root = tree.getModel().getRoot();
        if (root == null) {
            return;
        }
        TreePath rootPath = new TreePath(root);
        UIUtils.autoExpand(tree, rootPath, 50, maxChildToExpand, false);
    }

    public static long[] copyArray(long[] array) {
        if (array == null) {
            return new long[0];
        }
        if (array.length == 0) {
            return new long[0];
        }
        long[] ret = new long[array.length];
        System.arraycopy(array, 0, ret, 0, array.length);
        return ret;
    }

    public static int[] copyArray(int[] array) {
        if (array == null) {
            return new int[0];
        }
        if (array.length == 0) {
            return new int[0];
        }
        int[] ret = new int[array.length];
        System.arraycopy(array, 0, ret, 0, array.length);
        return ret;
    }

    public static float[] copyArray(float[] array) {
        if (array == null) {
            return new float[0];
        }
        if (array.length == 0) {
            return new float[0];
        }
        float[] ret = new float[array.length];
        System.arraycopy(array, 0, ret, 0, array.length);
        return ret;
    }

    public static void ensureMinimumSize(Component comp) {
        if ((comp = UIUtils.getParentWindow(comp)) != null) {
            final Component top = comp;
            top.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = top.getSize();
                    Dimension min = top.getMinimumSize();
                    if (d.width < min.width || d.height < min.height) {
                        top.setSize(Math.max(d.width, min.width), Math.max(d.height, min.height));
                    }
                }
            });
        }
    }

    public static void fixButtonUI(AbstractButton button) {
    }

    public static boolean hasOnlyLeafs(JTree tree, Object node) {
        TreeModel model = tree.getModel();
        for (int i = 0; i < model.getChildCount(node); ++i) {
            if (model.isLeaf(model.getChild(node, i))) continue;
            return false;
        }
        return true;
    }

    public static void makeTreeAutoExpandable(JTree tree) {
        UIUtils.makeTreeAutoExpandable(tree, 1, false);
    }

    public static void makeTreeAutoExpandable(JTree tree, boolean dontExpandToLeafs) {
        UIUtils.makeTreeAutoExpandable(tree, 1, dontExpandToLeafs);
    }

    public static void makeTreeAutoExpandable(JTree tree, int maxChildToExpand) {
        UIUtils.makeTreeAutoExpandable(tree, maxChildToExpand, false);
    }

    public static void makeTreeAutoExpandable(final JTree tree, final int maxChildToExpand, final boolean dontExpandToLeafs) {
        tree.addTreeExpansionListener(new TreeExpansionListener(){
            boolean internalChange = false;

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (this.internalChange || Boolean.TRUE.equals(tree.getClientProperty(UIUtils.PROP_EXPANSION_TRANSACTION))) {
                    return;
                }
                TreePath path = event.getPath();
                JTree tree2 = (JTree)event.getSource();
                this.internalChange = true;
                UIUtils.autoExpand(tree2, path, 50, maxChildToExpand, dontExpandToLeafs);
                this.internalChange = false;
            }
        });
    }

    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException e) {
                LOGGER.severe(e.getMessage());
            }
            catch (InterruptedException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public static void addBorder(JComponent c, Border b) {
        Border cb = c.getBorder();
        Border nb = cb == null ? b : new CompoundBorder(cb, b);
        c.setBorder(nb);
    }

    public static Color getDisabledLineColor() {
        if (disabledLineColor == null) {
            disabledLineColor = UIManager.getColor(UIUtils.isAquaLookAndFeel() ? "controlShadow" : "Label.disabledForeground");
            if (disabledLineColor == null) {
                disabledLineColor = UIManager.getColor("Label.disabledText");
            }
            if (disabledLineColor == null || disabledLineColor.equals(UIUtils.getProfilerResultsBackground())) {
                disabledLineColor = Color.GRAY;
            }
        }
        return disabledLineColor;
    }

    public static BufferedImage createScreenshot(Component component) {
        assert (SwingUtilities.isEventDispatchThread());
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            return UIUtils.createComponentScreenshot(scrollPane.getViewport());
        }
        return UIUtils.createComponentScreenshot(component);
    }

    private static BufferedImage createComponentScreenshot(Component component) {
        if (component instanceof JTable || component instanceof JViewport && ((JViewport)component).getView() instanceof JTable) {
            return UIUtils.createTableScreenshot(component);
        }
        return UIUtils.createGeneralComponentScreenshot(component);
    }

    private static BufferedImage createGeneralComponentScreenshot(Component component) {
        Dimension sourceSize;
        Component source;
        if (component instanceof JViewport) {
            JViewport viewport = (JViewport)component;
            Component contents = viewport.getView();
            if (contents.getSize().height > viewport.getSize().height) {
                source = component;
                sourceSize = component.getSize();
            } else {
                source = contents;
                sourceSize = contents.getSize();
            }
        } else {
            source = component;
            sourceSize = component.getSize();
        }
        BufferedImage componentScreenshot = new BufferedImage(sourceSize.width, sourceSize.height, 1);
        Graphics componentScreenshotGraphics = componentScreenshot.getGraphics();
        source.printAll(componentScreenshotGraphics);
        return componentScreenshot;
    }

    private static BufferedImage createTableScreenshot(Component component) {
        Dimension sourceSize;
        JComponent source;
        JTable table;
        if (component instanceof JTable) {
            table = (JTable)component;
            if (table.getTableHeader() == null || !table.getTableHeader().isVisible()) {
                return UIUtils.createGeneralComponentScreenshot(component);
            }
            source = table;
            sourceSize = table.getSize();
        } else if (component instanceof JViewport && ((JViewport)component).getView() instanceof JTable) {
            JViewport viewport = (JViewport)component;
            table = (JTable)viewport.getView();
            if (table.getTableHeader() == null || !table.getTableHeader().isVisible()) {
                return UIUtils.createGeneralComponentScreenshot(component);
            }
            if (table.getSize().height > viewport.getSize().height) {
                source = viewport;
                sourceSize = viewport.getSize();
            } else {
                source = table;
                sourceSize = table.getSize();
            }
        } else {
            throw new IllegalArgumentException("Component can only be JTable or JViewport holding JTable");
        }
        JTableHeader tableHeader = table.getTableHeader();
        Dimension tableHeaderSize = tableHeader.getSize();
        BufferedImage tableScreenshot = new BufferedImage(sourceSize.width, tableHeaderSize.height + sourceSize.height, 1);
        Graphics tableScreenshotGraphics = tableScreenshot.getGraphics();
        tableHeader.printAll(tableScreenshotGraphics);
        tableScreenshotGraphics.translate(0, tableHeaderSize.height);
        ((Component)source).printAll(tableScreenshotGraphics);
        return tableScreenshot;
    }
}

