/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.refactoring.actions.RefactoringKind;
import org.netbeans.modules.cnd.refactoring.hints.IntroduceVariableFix;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceVariablePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

final class ExtendedIntroduceVariableFix
extends IntroduceVariableFix {
    private final int numDuplicates;
    private final RefactoringKind kind = RefactoringKind.CREATE_VARIABLE;
    private boolean replaceOccurrences = false;
    private final List<Pair<Integer, Integer>> occurrences;
    private String type;

    public ExtendedIntroduceVariableFix(CsmStatement st, CsmOffsetable expression, List<Pair<Integer, Integer>> occurrences, Document doc, JTextComponent comp, FileObject fo) {
        super(st, expression, doc, comp, fo);
        this.occurrences = occurrences;
        this.numDuplicates = occurrences.size();
    }

    public String getKeyExt() {
        switch (this.kind) {
            case CREATE_CONSTANT: {
                return "IntroduceConstant";
            }
            case CREATE_VARIABLE: {
                return "IntroduceVariable";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getText() {
        return NbBundle.getMessage(ExtendedIntroduceVariableFix.class, (String)("FIX_" + this.getKeyExt()));
    }

    @Override
    protected boolean isInstanceRename() {
        return false;
    }

    @Override
    protected List<Pair<Integer, Integer>> replaceOccurrences() {
        if (!this.replaceOccurrences) {
            return Collections.emptyList();
        }
        return this.occurrences;
    }

    @Override
    protected String getType() {
        return this.type;
    }

    @Override
    protected String suggestName() {
        String guessedName = super.suggestName();
        this.type = super.getType();
        JButton btnOk = new JButton(NbBundle.getMessage(ExtendedIntroduceVariableFix.class, (String)"LBL_Ok"));
        JButton btnCancel = new JButton(NbBundle.getMessage(ExtendedIntroduceVariableFix.class, (String)"LBL_Cancel"));
        IntroduceVariablePanel panel = new IntroduceVariablePanel(this.numDuplicates, this.type, guessedName, this.kind == RefactoringKind.CREATE_CONSTANT, btnOk);
        String caption = NbBundle.getMessage(ExtendedIntroduceVariableFix.class, (String)("CAP_" + this.getKeyExt()));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
            return null;
        }
        guessedName = panel.getVariableName();
        this.replaceOccurrences = panel.isReplaceAll();
        this.type = panel.getType();
        return guessedName;
    }
}

