/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.refactoring.actions.InstantRenamePerformer;
import org.netbeans.modules.cnd.refactoring.hints.IntroduceVariableBaseFix;
import org.netbeans.modules.cnd.refactoring.hints.SuggestionFactoryTask;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class IntroduceVariableFix
extends IntroduceVariableBaseFix {
    final CsmStatement st;
    final FileObject fo;
    final JTextComponent comp;
    private String type;

    public IntroduceVariableFix(CsmStatement st, CsmOffsetable expression, Document doc, JTextComponent comp, FileObject fo) {
        super(expression, doc);
        this.fo = fo;
        this.st = st;
        this.comp = comp;
    }

    public String getText() {
        return NbBundle.getMessage(SuggestionFactoryTask.class, (String)"FIX_IntroduceVariable");
    }

    @Override
    protected boolean isC() {
        return "text/x-c".equals(this.fo.getMIMEType());
    }

    @Override
    protected boolean isInstanceRename() {
        return true;
    }

    @Override
    protected List<Pair<Integer, Integer>> replaceOccurrences() {
        return Collections.emptyList();
    }

    @Override
    protected String getType() {
        return this.type;
    }

    public ChangeInfo implement() throws Exception {
        this.type = this.suggestType();
        if (this.type == null) {
            return null;
        }
        final String aName = this.suggestName();
        if (aName == null) {
            return null;
        }
        final List<Pair<Integer, Integer>> replaceOccurrences = this.replaceOccurrences();
        final String exprText = this.expression.getText().toString();
        final ChangeInfo changeInfo = new ChangeInfo();
        final String typeTextPrefix = this.getType() + " ";
        final String text = typeTextPrefix + aName + " = " + this.expression.getText() + ";\n";
        this.doc.runAtomicAsUser(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArrayList<Pair> other = new ArrayList<Pair>();
                    for (int i = replaceOccurrences.size() - 1; i >= 0; --i) {
                        Pair occurrence = (Pair)replaceOccurrences.get(i);
                        IntroduceVariableFix.this.doc.remove(((Integer)occurrence.first()).intValue(), (Integer)occurrence.second() - (Integer)occurrence.first());
                        IntroduceVariableFix.this.doc.insertString(((Integer)occurrence.first()).intValue(), aName, null);
                        Position exprStart = NbDocument.createPosition((Document)IntroduceVariableFix.this.doc, (int)((Integer)occurrence.first()), (Position.Bias)Position.Bias.Forward);
                        Position exprEnd = NbDocument.createPosition((Document)IntroduceVariableFix.this.doc, (int)((Integer)occurrence.first() + aName.length()), (Position.Bias)Position.Bias.Backward);
                        other.add(Pair.of((Object)exprStart, (Object)exprEnd));
                    }
                    IntroduceVariableFix.this.doc.remove(IntroduceVariableFix.this.expression.getStartOffset(), exprText.length());
                    IntroduceVariableFix.this.doc.insertString(IntroduceVariableFix.this.expression.getStartOffset(), aName, null);
                    Position exprStart = NbDocument.createPosition((Document)IntroduceVariableFix.this.doc, (int)IntroduceVariableFix.this.expression.getStartOffset(), (Position.Bias)Position.Bias.Forward);
                    Position exprEnd = NbDocument.createPosition((Document)IntroduceVariableFix.this.doc, (int)(IntroduceVariableFix.this.expression.getStartOffset() + aName.length()), (Position.Bias)Position.Bias.Backward);
                    IntroduceVariableFix.this.doc.insertString(IntroduceVariableFix.this.st.getStartOffset(), text, null);
                    Position stmtStart = NbDocument.createPosition((Document)IntroduceVariableFix.this.doc, (int)(IntroduceVariableFix.this.st.getStartOffset() + typeTextPrefix.length()), (Position.Bias)Position.Bias.Forward);
                    Position stmtEnd = NbDocument.createPosition((Document)IntroduceVariableFix.this.doc, (int)(IntroduceVariableFix.this.st.getStartOffset() + typeTextPrefix.length() + aName.length()), (Position.Bias)Position.Bias.Backward);
                    changeInfo.add(IntroduceVariableFix.this.fo, stmtStart, stmtEnd);
                    changeInfo.add(IntroduceVariableFix.this.fo, exprStart, exprEnd);
                    for (Pair pos : other) {
                        changeInfo.add(IntroduceVariableFix.this.fo, (Position)pos.first(), (Position)pos.second());
                    }
                    Indent indent = Indent.get((Document)IntroduceVariableFix.this.doc);
                    indent.lock();
                    try {
                        indent.reindent(IntroduceVariableFix.this.st.getStartOffset() + text.length() + 1);
                    }
                    finally {
                        indent.unlock();
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        if (this.comp != null && this.isInstanceRename()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IntroduceVariableFix.this.comp.setCaretPosition(changeInfo.get(0).getEnd().getOffset());
                        InstantRenamePerformer.invokeInstantRename(IntroduceVariableFix.this.comp, changeInfo);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        return changeInfo;
    }
}

