/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Pair;

public abstract class IntroduceVariableBaseFix
implements Fix {
    protected final CsmOffsetable expression;
    protected final BaseDocument doc;
    protected String name;

    protected IntroduceVariableBaseFix(CsmOffsetable expression, Document doc) {
        this.expression = expression;
        this.doc = (BaseDocument)doc;
    }

    protected abstract boolean isC();

    protected abstract boolean isInstanceRename();

    protected abstract List<Pair<Integer, Integer>> replaceOccurrences();

    protected abstract String getType();

    protected String suggestName() {
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy hi = TokenHierarchy.get((Document)IntroduceVariableBaseFix.this.doc);
                TokenSequence ts = hi.tokenSequence();
                ts.move(IntroduceVariableBaseFix.this.expression.getStartOffset());
                String lastCandidate = null;
                String bestCandidate = null;
                int parenDepth = 0;
                while (ts.moveNext()) {
                    Token token = ts.token();
                    if (ts.offset() > IntroduceVariableBaseFix.this.expression.getEndOffset()) break;
                    if (CppTokenId.IDENTIFIER.equals((Object)token.id())) {
                        lastCandidate = token.text().toString();
                        continue;
                    }
                    if (CppTokenId.LPAREN.equals((Object)token.id())) {
                        if (parenDepth == 0) {
                            bestCandidate = lastCandidate;
                        }
                        ++parenDepth;
                        continue;
                    }
                    if (!CppTokenId.RPAREN.equals((Object)token.id())) continue;
                    --parenDepth;
                }
                IntroduceVariableBaseFix.this.name = bestCandidate != null ? bestCandidate : lastCandidate;
            }
        });
        if (this.name == null) {
            this.name = "variable";
        } else if ((this.name.toLowerCase().startsWith("get") || this.name.toLowerCase().startsWith("has")) && this.name.length() > 3) {
            this.name = this.name.substring(3);
        } else if (this.name.toLowerCase().startsWith("is") && this.name.length() > 2) {
            this.name = this.name.substring(2);
        }
        return this.name;
    }

    protected String suggestType() {
        CharSequence typeText = this.getExpressionType();
        if (typeText == null || "void".contentEquals(typeText)) {
            return null;
        }
        return typeText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getExpressionType() {
        CsmCacheManager.enter();
        try {
            CsmClassifier classifier;
            CsmType resolveType = CsmExpressionResolver.resolveType((CsmOffsetable)this.expression, null);
            if (resolveType == null) {
                CharSequence charSequence = null;
                return charSequence;
            }
            CharSequence typeText = CsmInstantiationProvider.getDefault().getInstantiatedText(resolveType);
            if (this.isC() && (classifier = resolveType.getClassifier()) != null && classifier.getKind() == CsmDeclaration.Kind.STRUCT && !CharSequenceUtils.startsWith((CharSequence)typeText, (CharSequence)"struct")) {
                typeText = "struct " + typeText;
            }
            CharSequence charSequence = typeText;
            return charSequence;
        }
        finally {
            CsmCacheManager.leave();
        }
    }
}

