/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.codegen.ConstructorGenerator;
import org.netbeans.modules.cnd.refactoring.codegen.ui.OperatorsPanel;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class OperatorGenerator
implements CodeGenerator {
    private final JTextComponent component;
    private final ElementNode.Description operators;
    private final CsmContext contextPath;
    private final CsmClass type;
    private final String id;

    private OperatorGenerator(JTextComponent component, CsmContext path, CsmClass type, ElementNode.Description operators, String id) {
        this.component = component;
        this.operators = operators;
        this.contextPath = path;
        this.type = type;
        this.id = id;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConstructorGenerator.class, (String)this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{"GENERATE", "CONSTRUCTOR"});
        if (this.operators != null) {
            OperatorsPanel panel = new OperatorsPanel(this.operators);
            DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_operator"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            try {
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                if (!(th.getCause() instanceof InterruptedException)) {
                    throw new RuntimeException(th);
                }
                dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
            }
            finally {
                dialog.dispose();
            }
            if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
                return;
            }
            GeneratorUtils.generateOperators(this.contextPath, this.type, panel.getOperatorsToGenerate());
        }
    }

    private static final class StubFriendImpl
    extends StubFunctionImpl
    implements CsmFriendFunction {
        public StubFriendImpl(CsmClass parent, CsmFunction.OperatorKind kind, boolean isConst, boolean constOperator) {
            super(parent, kind, isConst, constOperator);
        }

        public CsmFunction getReferencedFunction() {
            throw new UnsupportedOperationException();
        }

        public CsmClass getContainingClass() {
            return this.parent;
        }
    }

    private static final class StubMethodImpl
    extends StubFunctionImpl
    implements CsmMethod {
        public StubMethodImpl(CsmClass parent, CsmFunction.OperatorKind kind, boolean constResult, boolean constOperator) {
            super(parent, kind, constResult, constOperator);
        }

        public StubMethodImpl(CsmClass parent, CsmFunction.OperatorKind kind, boolean constResult, boolean constOperator, int postfix) {
            super(parent, kind, constResult, constOperator, postfix);
        }

        @Override
        public CsmDeclaration.Kind getKind() {
            return CsmDeclaration.Kind.FUNCTION_FRIEND;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isVirtual() {
            return false;
        }

        public boolean isOverride() {
            return false;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isExplicit() {
            return false;
        }

        public boolean isConst() {
            return false;
        }

        public CsmClass getContainingClass() {
            return this.parent;
        }

        public CsmVisibility getVisibility() {
            return CsmVisibility.NONE;
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    private static abstract class StubFunctionImpl
    implements CsmFunction {
        protected final CsmClass parent;
        private final CsmFunction.OperatorKind kind;
        private final boolean constResult;
        private final boolean constOperator;
        private final int posfix;
        private String name;
        private String parameters;
        private String specifiers;
        private String returns;
        private String body;

        public StubFunctionImpl(CsmClass parent, CsmFunction.OperatorKind kind, boolean constResult, boolean constOperator) {
            this.parent = parent;
            this.kind = kind;
            this.constResult = constResult;
            this.constOperator = constOperator;
            this.posfix = 0;
            this.init();
        }

        public StubFunctionImpl(CsmClass parent, CsmFunction.OperatorKind kind, boolean constResult, boolean constOperator, int postfix) {
            this.parent = parent;
            this.kind = kind;
            this.constResult = constResult;
            this.constOperator = constOperator;
            this.posfix = 1;
            this.init();
        }

        private void init() {
            switch (this.kind) {
                case MOD_EQ: {
                    this.name = "operator %=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MOD_EQ", (Object)this.getTemplateType());
                    break;
                }
                case MOD: {
                    this.name = "operator %";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MOD", (Object)this.getTemplateType());
                    break;
                }
                case DIV_EQ: {
                    this.name = "operator /=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"DIV_EQ", (Object)this.getTemplateType());
                    break;
                }
                case DIV: {
                    this.name = "operator /";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"DIV", (Object)this.getTemplateType());
                    break;
                }
                case MUL_EQ: {
                    this.name = "operator *=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MUL_EQ", (Object)this.getTemplateType());
                    break;
                }
                case MUL: {
                    this.name = "operator *";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MUL", (Object)this.getTemplateType());
                    break;
                }
                case PLUS_EQ: {
                    this.name = "operator +=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"PLUS_EQ", (Object)this.getTemplateType());
                    break;
                }
                case PLUS: {
                    this.name = "operator +";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"PLUS", (Object)this.getTemplateType());
                    break;
                }
                case MINUS_EQ: {
                    this.name = "operator -=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MINUS_EQ", (Object)this.getTemplateType());
                    break;
                }
                case MINUS: {
                    this.name = "operator -";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MINUS", (Object)this.getTemplateType());
                    break;
                }
                case PLUS_PLUS: {
                    this.name = "operator ++";
                    if (this.posfix == 0) {
                        this.parameters = "";
                        this.returns = this.getTemplateType() + "&";
                        this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"PLUS_PLUS", (Object)this.getTemplateType());
                        break;
                    }
                    this.parameters = "int";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"PLUS_PLUS_POSTFIX", (Object)this.getTemplateType());
                    break;
                }
                case MINUS_MINUS: {
                    this.name = "operator --";
                    if (this.posfix == 0) {
                        this.parameters = "";
                        this.returns = this.getTemplateType() + "&";
                        this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MINUS_MINUS", (Object)this.getTemplateType());
                        break;
                    }
                    this.parameters = "int";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"MINUS_MINUS_POSTFIX", (Object)this.getTemplateType());
                    break;
                }
                case TILDE: {
                    this.name = "operator ~";
                    this.parameters = "";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"TILDE", (Object)this.getTemplateType());
                    break;
                }
                case AND_EQ: {
                    this.name = "operator &=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"AND_EQ", (Object)this.getTemplateType());
                    break;
                }
                case AND: {
                    this.name = "operator &";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"AND", (Object)this.getTemplateType());
                    break;
                }
                case OR_EQ: {
                    this.name = "operator |=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"OR_EQ", (Object)this.getTemplateType());
                    break;
                }
                case OR: {
                    this.name = "operator |";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"OR", (Object)this.getTemplateType());
                    break;
                }
                case XOR_EQ: {
                    this.name = "operator ^=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"XOR_EQ", (Object)this.getTemplateType());
                    break;
                }
                case XOR: {
                    this.name = "operator ^";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType();
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"XOR", (Object)this.getTemplateType());
                    break;
                }
                case EQ_EQ: {
                    this.name = "operator ==";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"EQ_EQ", (Object)this.getTemplateType());
                    break;
                }
                case NOT_EQ: {
                    this.name = "operator !=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"NOT_EQ", (Object)this.getTemplateType());
                    break;
                }
                case EQ: {
                    this.name = "operator =";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = this.getTemplateType() + "&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"ASSIGNMENT", (Object)this.getTemplateType());
                    break;
                }
                case GREATER: {
                    this.name = "operator >";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"GREATER", (Object)this.getTemplateType());
                    break;
                }
                case GREATER_EQ: {
                    this.name = "operator >=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"GREATER_EQ", (Object)this.getTemplateType());
                    break;
                }
                case LESS: {
                    this.name = "operator <";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"LESS", (Object)this.getTemplateType());
                    break;
                }
                case LESS_EQ: {
                    this.name = "operator <=";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"LESS_EQ", (Object)this.getTemplateType());
                    break;
                }
                case NOT: {
                    this.name = "operator !";
                    this.parameters = "";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"NOT", (Object)this.getTemplateType());
                    break;
                }
                case OR_OR: {
                    this.name = "operator ||";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"OR_OR", (Object)this.getTemplateType());
                    break;
                }
                case AND_AND: {
                    this.name = "operator &&";
                    this.parameters = "const " + this.getTemplateType() + "& right";
                    this.returns = "bool";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"AND_AND", (Object)this.getTemplateType());
                    break;
                }
                case LEFT_SHIFT: {
                    this.specifiers = this.getTemplatePrefix("friend");
                    this.name = "operator <<";
                    this.parameters = "std::ostream& os, const " + this.getTemplateType() + "& obj";
                    this.returns = "std::ostream&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"LEFT_SHIFT", (Object)this.getTemplateType());
                    break;
                }
                case RIGHT_SHIFT: {
                    this.specifiers = this.getTemplatePrefix("friend");
                    this.name = "operator >>";
                    this.parameters = "std::ostream& is, const " + this.getTemplateType() + "& obj";
                    this.returns = "std::ostream&";
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"RIGHT_SHIFT", (Object)this.getTemplateType());
                    break;
                }
                case ARROW: {
                    this.name = "operator ->";
                    this.parameters = "";
                    this.returns = "value_t*";
                    if (this.constOperator) {
                        this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"ARROW_CONST", (Object)this.getTemplateType());
                        break;
                    }
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"ARROW", (Object)this.getTemplateType());
                    break;
                }
                case POINTER: {
                    this.name = "operator *";
                    this.parameters = "";
                    this.returns = "value_t&";
                    if (this.constOperator) {
                        this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"POINTER_CONST", (Object)this.getTemplateType());
                        break;
                    }
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"POINTER", (Object)this.getTemplateType());
                    break;
                }
                case ARRAY: {
                    this.name = "operator []";
                    this.parameters = "std::size_t index";
                    this.returns = "value_t&";
                    if (this.constOperator) {
                        this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"ARRAY_CONST", (Object)this.getTemplateType());
                        break;
                    }
                    this.body = NbBundle.getMessage(ConstructorGenerator.class, (String)"ARRAY", (Object)this.getTemplateType());
                    break;
                }
                case ADDRESS: {
                    this.name = "operator &";
                    this.parameters = "";
                    this.returns = "value_t";
                    this.body = this.constOperator ? NbBundle.getMessage(ConstructorGenerator.class, (String)"ADDRESS_CONST", (Object)this.getTemplateType()) : NbBundle.getMessage(ConstructorGenerator.class, (String)"ADDRESS", (Object)this.getTemplateType());
                }
            }
        }

        private String getTemplatePrefix(String prefix) {
            CsmTemplate template;
            List templateParameters;
            StringBuilder res = new StringBuilder();
            if (CsmKindUtilities.isTemplate((CsmObject)this.parent) && (templateParameters = (template = (CsmTemplate)this.parent).getTemplateParameters()).size() > 0) {
                res.append("template<");
                boolean first = true;
                for (CsmTemplateParameter param : templateParameters) {
                    if (!first) {
                        res.append(", ");
                    }
                    first = false;
                    res.append(param.getName());
                }
                res.append(">");
                res.append('\n');
            }
            res.append(prefix);
            return res.toString();
        }

        private String getTemplateType() {
            CsmTemplate template;
            List templateParameters;
            StringBuilder res = new StringBuilder();
            res.append(this.parent.getName());
            if (CsmKindUtilities.isTemplate((CsmObject)this.parent) && (templateParameters = (template = (CsmTemplate)this.parent).getTemplateParameters()).size() > 0) {
                res.append("<");
                boolean first = true;
                for (CsmTemplateParameter param : templateParameters) {
                    if (!first) {
                        res.append(", ");
                    }
                    first = false;
                    res.append(param.getName());
                }
                res.append(">");
            }
            return res.toString();
        }

        public boolean isStatic() {
            return false;
        }

        public CsmDeclaration.Kind getKind() {
            return CsmDeclaration.Kind.FUNCTION;
        }

        public CharSequence getUniqueName() {
            return "F:" + this.name;
        }

        public CharSequence getQualifiedName() {
            return this.name;
        }

        public CharSequence getName() {
            return this.name;
        }

        public CsmScope getScope() {
            return this.parent;
        }

        public boolean isValid() {
            return true;
        }

        public CsmFile getContainingFile() {
            return this.parent.getContainingFile();
        }

        public int getStartOffset() {
            return -1;
        }

        public int getEndOffset() {
            return -1;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getText() {
            StringBuilder buf = new StringBuilder();
            if (this.specifiers != null) {
                buf.append(this.specifiers);
                buf.append(' ');
            }
            if (this.constResult) {
                buf.append("const ");
            }
            buf.append(this.returns);
            buf.append(' ');
            buf.append(this.name);
            buf.append('(');
            buf.append(this.parameters);
            buf.append(")");
            if (this.constOperator) {
                buf.append(" const");
            }
            buf.append(" {\n");
            buf.append(this.body);
            buf.append("\n}");
            return buf.toString();
        }

        public CharSequence getDeclarationText() {
            return this.getText();
        }

        public CsmFunctionDefinition getDefinition() {
            return null;
        }

        public CsmFunction getDeclaration() {
            return this;
        }

        public boolean isOperator() {
            return true;
        }

        public CsmFunction.OperatorKind getOperatorKind() {
            return this.kind;
        }

        public boolean isInline() {
            return true;
        }

        public CsmFunctionParameterList getParameterList() {
            throw new UnsupportedOperationException();
        }

        public CsmType getReturnType() {
            return new CsmType(){

                public CsmClassifier getClassifier() {
                    throw new UnsupportedOperationException();
                }

                public CharSequence getClassifierText() {
                    return StubFunctionImpl.this.returns;
                }

                public boolean isInstantiation() {
                    return false;
                }

                public boolean hasInstantiationParams() {
                    return false;
                }

                public List<CsmSpecializationParameter> getInstantiationParams() {
                    return Collections.emptyList();
                }

                public int getArrayDepth() {
                    return 0;
                }

                public boolean isPointer() {
                    return false;
                }

                public int getPointerDepth() {
                    return 0;
                }

                public boolean isReference() {
                    return false;
                }

                public boolean isRValueReference() {
                    return false;
                }

                public boolean isConst() {
                    return false;
                }

                public boolean isVolatile() {
                    return false;
                }

                public boolean isPackExpansion() {
                    return false;
                }

                public boolean isBuiltInBased(boolean resolveTypeChain) {
                    return false;
                }

                public boolean isTemplateBased() {
                    return false;
                }

                public CharSequence getCanonicalText() {
                    return StubFunctionImpl.this.returns;
                }

                public CsmFile getContainingFile() {
                    return StubFunctionImpl.this.parent.getContainingFile();
                }

                public int getStartOffset() {
                    return -1;
                }

                public int getEndOffset() {
                    return -1;
                }

                public CsmOffsetable.Position getStartPosition() {
                    throw new UnsupportedOperationException();
                }

                public CsmOffsetable.Position getEndPosition() {
                    throw new UnsupportedOperationException();
                }

                public CharSequence getText() {
                    return StubFunctionImpl.this.returns;
                }
            };
        }

        public Collection<CsmParameter> getParameters() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getSignature() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.name);
            buf.append('(');
            buf.append(this.parameters);
            buf.append(")");
            if (this.constOperator) {
                buf.append(" const");
            }
            return buf.toString();
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return Collections.emptyList();
        }
    }

    public static final class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<OperatorGenerator> ret = new ArrayList<OperatorGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CsmContext path = (CsmContext)context.lookup(CsmContext.class);
            if (component == null || path == null) {
                return ret;
            }
            CsmClass typeElement = path.getEnclosingClass();
            if (typeElement == null) {
                return ret;
            }
            List<CsmObject> pathList = path.getPath();
            CsmObject last = pathList.get(pathList.size() - 1);
            if (!CsmKindUtilities.isClass((CsmObject)last) && !CsmKindUtilities.isField((CsmObject)last)) {
                return ret;
            }
            ArrayList<ElementNode.Description> operators = new ArrayList<ElementNode.Description>();
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.EQ, false, false), null, (boolean)true, (boolean)false));
            ElementNode.Description operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorAssignment"));
            operators = new ArrayList();
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MOD_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MOD, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.DIV_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.DIV, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MUL_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MUL, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.PLUS_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.PLUS, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MINUS_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MINUS, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.PLUS_PLUS, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.PLUS_PLUS, false, false, 1), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MINUS_MINUS, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.MINUS_MINUS, false, false, 1), null, (boolean)true, (boolean)false));
            operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorArithmetic"));
            operators = new ArrayList();
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.TILDE, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.AND_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.AND, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.OR_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.OR, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.XOR_EQ, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.XOR, false, true), null, (boolean)true, (boolean)false));
            operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorBitwise"));
            operators = new ArrayList();
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.ARROW, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.ARROW, true, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.ARRAY, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.ARRAY, true, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.POINTER, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.POINTER, true, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.ADDRESS, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.ADDRESS, true, true), null, (boolean)true, (boolean)false));
            operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorPointer"));
            operators = new ArrayList();
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.EQ_EQ, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.NOT_EQ, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.GREATER, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.GREATER_EQ, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.LESS, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.LESS_EQ, false, true), null, (boolean)true, (boolean)false));
            operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorRelational"));
            operators = new ArrayList();
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.NOT, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.AND_AND, false, true), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubMethodImpl(typeElement, CsmFunction.OperatorKind.OR_OR, false, true), null, (boolean)true, (boolean)false));
            operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorLogical"));
            operators = new ArrayList();
            operators.add(ElementNode.Description.create((CsmObject)new StubFriendImpl(typeElement, CsmFunction.OperatorKind.LEFT_SHIFT, false, false), null, (boolean)true, (boolean)false));
            operators.add(ElementNode.Description.create((CsmObject)new StubFriendImpl(typeElement, CsmFunction.OperatorKind.RIGHT_SHIFT, false, false), null, (boolean)true, (boolean)false));
            operatorsDescription = ElementNode.Description.create((CsmObject)typeElement, Collections.singletonList(ElementNode.Description.create((CsmObject)typeElement, operators, (boolean)false, (boolean)false)), (boolean)false, (boolean)false);
            ret.add(new OperatorGenerator(component, path, typeElement, operatorsDescription, "LBL_operatorFriendStream"));
            return ret;
        }
    }
}

