/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class LibletInfo {
    private ClassPathSupport.Item item;
    private Requirement requirement;
    private LibletType type;
    private String url;
    private String name;
    private String vendor;
    private String version;
    private boolean extractClasses;

    private LibletInfo(ClassPathSupport.Item item, String name, String vendor, String version) {
        this.item = item;
        this.name = name;
        this.vendor = vendor;
        this.version = version;
        this.type = LibletType.LIBLET;
        this.requirement = Requirement.OPTIONAL;
        this.url = "";
        this.extractClasses = false;
    }

    public LibletInfo(LibletType type, String name, String vendor, String version, Requirement requirement, String url, boolean extractClasses) {
        this.type = type;
        this.name = name;
        this.vendor = vendor;
        this.version = version;
        this.requirement = requirement;
        this.item = null;
        this.url = url;
        this.extractClasses = extractClasses;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LibletInfo) {
            LibletInfo lib = (LibletInfo)obj;
            return this.type == lib.getType() && this.name.equals(lib.getName()) && this.vendor.equals(lib.getVendor());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode((Object)this.type);
        hash = 47 * hash + Objects.hashCode(this.name);
        hash = 47 * hash + Objects.hashCode(this.vendor);
        return hash;
    }

    public static LibletInfo createLibletInfoForJar(ClassPathSupport.Item item) {
        LibletInfo li = null;
        try {
            JarFile jar = new JarFile(item.getResolvedFile());
            Attributes manifestAttributes = jar.getManifest().getMainAttributes();
            String name = manifestAttributes.getValue("LIBlet-Name");
            String vendor = manifestAttributes.getValue("LIBlet-Vendor");
            String version = manifestAttributes.getValue("LIBlet-Version");
            li = new LibletInfo(item, name, vendor, version);
            FileObject jarFO = FileUtil.toFileObject((File)item.getResolvedFile());
            if (jarFO.existsExt("jad")) {
                li.setUrl("lib/" + jarFO.getName() + ".jad");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return li;
    }

    public static LibletInfo createLibletInfoForProject(ClassPathSupport.Item item) {
        boolean liblet;
        J2MEProject j2meProj;
        String propVal;
        Project project;
        LibletInfo li = null;
        AntArtifact artifact = item.getArtifact();
        if (artifact != null && (project = artifact.getProject()) != null && project instanceof J2MEProject && (propVal = (j2meProj = (J2MEProject)project).evaluator().getProperty("manifest.is.liblet")) != null && (liblet = Boolean.parseBoolean(propVal))) {
            String libletDetails = j2meProj.evaluator().getProperty("manifest.others");
            if (libletDetails == null) {
                return null;
            }
            String[] splittedDetails = libletDetails.split("\n");
            String name = "";
            String vendor = "";
            String version = "";
            for (String s : splittedDetails) {
                if (s.startsWith("LIBlet-Name:")) {
                    name = s.substring(s.indexOf(":") + 1).trim();
                } else if (s.startsWith("LIBlet-Vendor:")) {
                    vendor = s.substring(s.indexOf(":") + 1).trim();
                }
                if (!s.startsWith("LIBlet-Version:")) continue;
                version = s.substring(s.indexOf(":") + 1).trim();
            }
            li = new LibletInfo(item, name, vendor, version);
            String jadName = j2meProj.evaluator().getProperty("dist.jad");
            if (jadName != null) {
                li.setUrl("lib/" + jadName);
            }
        }
        return li;
    }

    public ClassPathSupport.Item getItem() {
        return this.item;
    }

    public void setItem(ClassPathSupport.Item item) {
        this.item = item;
    }

    public LibletType getType() {
        return this.type;
    }

    public void setType(LibletType type) {
        this.type = type;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public void setRequirement(Requirement requirement) {
        this.requirement = requirement;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isExtractClasses() {
        return this.extractClasses;
    }

    public void setExtractClasses(boolean extractClasses) {
        this.extractClasses = extractClasses;
    }

    public static enum LibletType {
        LIBLET,
        STANDARD,
        SERVICE,
        PROPRIETARY;

    }

    public static enum Requirement {
        OPTIONAL,
        REQUIRED;

    }
}

