/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.trace.NativeProjectProvider;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModelFileFilter;
import org.netbeans.modules.cnd.repository.support.RepositoryTestUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class TraceModelBase {
    private boolean useCSysIncludes = Boolean.getBoolean("cnd.modelimpl.c.include");
    private boolean useCSysDefines = Boolean.getBoolean("cnd.modelimpl.c.define");
    private boolean useCppSysIncludes = Boolean.getBoolean("cnd.modelimpl.cpp.include");
    private boolean useCppSysDefines = Boolean.getBoolean("cnd.modelimpl.cpp.define");
    private final ModelImpl model;
    private CsmUID<CsmProject> projectUID;
    private List<String> quoteIncludePaths = new ArrayList<String>();
    private final List<String> currentIncludeFiles = new ArrayList<String>();
    private List<String> systemIncludePaths = new ArrayList<String>();
    private List<String> libProjectsPaths = new ArrayList<String>();
    private final List<File> files = new ArrayList<File>();
    private List<String> currentIncludePaths = null;
    private final List<String> macros = new ArrayList<String>();
    private final List<String> undefinedMacros = new ArrayList<String>();
    private boolean pathsRelCurFile = false;
    private final TraceModelFileFilter filter;

    public TraceModelBase(boolean clearCache) {
        this(clearCache, null);
    }

    @SuppressWarnings(value={"LG"})
    public TraceModelBase(boolean clearCache, TraceModelFileFilter filter) {
        Logger openideLogger = Logger.getLogger("org.openide.loaders");
        openideLogger.setLevel(Level.SEVERE);
        Logger.getLogger("org.openide.filesystems.FileUtil").setLevel(Level.OFF);
        this.model = TraceModelBase.createModel();
        this.model.startup();
        if (clearCache) {
            RepositoryTestUtils.deleteDefaultCacheLocation();
        }
        this.currentIncludePaths = this.quoteIncludePaths;
        this.filter = filter == null ? new TraceModelFileFilter(){

            @Override
            public boolean isProjectFile(String filename) {
                return true;
            }
        } : filter;
    }

    private static ModelImpl createModel() {
        ModelImpl m = (ModelImpl)CsmModelAccessor.getModel();
        if (m == null) {
            m = new ModelImpl();
        }
        return m;
    }

    protected final void setIncludePaths(List<String> sysIncludes, List<String> usrIncludes, List<String> libProjectsPaths) {
        this.quoteIncludePaths = usrIncludes;
        this.systemIncludePaths = sysIncludes;
        this.currentIncludePaths = this.quoteIncludePaths;
        this.libProjectsPaths = libProjectsPaths;
    }

    public void shutdown(boolean clearCache) {
        this.model.shutdown();
        if (clearCache) {
            RepositoryTestUtils.deleteDefaultCacheLocation();
        }
    }

    public void processArguments(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                this.processFlag(args[i].substring(2));
                continue;
            }
            if (args[i].startsWith("-")) {
                ProcessFlagResult res;
                for (int charIdx = 1; charIdx < args[i].length() && (res = this.processFlag(args[i].charAt(charIdx), args[i].substring(charIdx + 1))) != ProcessFlagResult.ALL_PROCESSED; ++charIdx) {
                }
                continue;
            }
            this.addFile(this.files, new File(args[i]));
        }
    }

    protected ProcessFlagResult processFlag(char flag, String argRest) {
        ProcessFlagResult result = ProcessFlagResult.CHAR_PROCESSED;
        switch (flag) {
            case 'I': {
                if (argRest.length() <= 0) break;
                if (argRest.charAt(0) == '-') {
                    this.currentIncludePaths = this.currentIncludePaths == this.quoteIncludePaths ? this.systemIncludePaths : this.quoteIncludePaths;
                    argRest = argRest.substring(1);
                }
                String includePath = argRest;
                this.currentIncludePaths.add(includePath);
                result = ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            case 'D': {
                this.macros.add(argRest);
                result = ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            case 'U': {
                this.undefinedMacros.add(argRest);
                result = ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            default: {
                result = ProcessFlagResult.NONE_PROCESSED;
            }
        }
        return result;
    }

    protected boolean processFlag(String flag) {
        if ("relpath".equals(flag)) {
            this.pathsRelCurFile = true;
            return true;
        }
        return false;
    }

    private void addFile(List<File> files, File file) {
        if (file.isDirectory()) {
            String[] list = file.list();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    if (!this.filter.isProjectFile(list[i])) continue;
                    this.addFile(files, new File(file, list[i]));
                }
            }
        } else {
            files.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase getProject() {
        TraceModelBase traceModelBase = this;
        synchronized (traceModelBase) {
            if (this.projectUID == null) {
                try {
                    this.projectUID = this.createProject().getUID();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return this.projectUID == null ? null : (ProjectBase)this.projectUID.getObject();
    }

    public ProjectBase reopenProject(NativeProject platformProject) {
        ProjectBase reopened = this.model.addProject(platformProject, platformProject.getProjectDisplayName(), true);
        this.projectUID = reopened.getUID();
        return reopened;
    }

    public static void enableProjectListeners(CsmProject p, boolean enable) {
        ((ProjectBase)p).enableProjectListeners(enable);
    }

    public static void shutdownModel(CsmModel model) {
        if (model instanceof ModelImpl) {
            ((ModelImpl)model).shutdown();
        } else {
            CndUtils.assertTrueInConsole((boolean)false, (String)"unexpected model instance ", (Object)model);
        }
    }

    public static CsmProject addNativeProject(NativeProject np) {
        CsmModel model = CsmModelAccessor.getModel();
        ProjectBase csmProject = null;
        if (model instanceof ModelImpl) {
            csmProject = ((ModelImpl)model).addProject(np, np.getProjectDisplayName(), true);
        } else {
            CndUtils.assertTrueInConsole((boolean)false, (String)"unexpected model instance ", (Object)model);
        }
        return csmProject;
    }

    public static void closeNativeProject(NativeProject np) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model instanceof ModelImpl) {
            ((ModelImpl)model).closeProject(np);
        } else {
            CndUtils.assertTrueInConsole((boolean)false, (String)"unexpected model instance ", (Object)model);
        }
    }

    public static void closeProject(CsmProject project) {
        TraceModelBase.closeProject(project, false);
    }

    public static void closeProject(CsmProject project, boolean cleanRepository) {
        boolean hasProject;
        Object platformProject = project.getPlatformProject();
        assert (platformProject != null);
        ((ModelImpl)CsmModelAccessor.getModel()).closeProject(platformProject, cleanRepository);
        RequestProcessor.Task waitTask = ((ModelImpl)CsmModelAccessor.getModel()).enqueueModelTask(new Runnable(){

            @Override
            public void run() {
            }
        }, "");
        waitTask.waitFinished();
        block2: do {
            hasProject = false;
            for (CsmProject csmProject : ((ModelImpl)CsmModelAccessor.getModel()).projects()) {
                if (!platformProject.equals(csmProject.getPlatformProject())) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                hasProject = true;
                continue block2;
            }
        } while (hasProject);
    }

    public void resetProject() {
        this.resetProject(false);
    }

    public void resetProject(boolean cleanRepository) {
        ProjectBase aProject = this.getProject();
        if (aProject != null) {
            TraceModelBase.closeProject(aProject, cleanRepository);
        }
        this.projectUID = null;
        this.files.clear();
    }

    private ProjectBase createProject() throws IOException {
        NativeProject np = null;
        if (this.files.size() == 1 && this.files.get(0).getName().equals("project.xml")) {
            try {
                FileObject projectDir = CndFileUtils.toFileObject((File)this.files.get(0).getParentFile().getParentFile());
                Project p = ProjectManager.getDefault().findProject(projectDir);
                np = (NativeProject)p.getLookup().lookup(NativeProject.class);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        } else {
            String projectRoot = this.files.isEmpty() ? File.separator : this.files.get(0).getParentFile().getAbsolutePath();
            np = NativeProjectProvider.createProject(projectRoot, this.files, this.libProjectsPaths, this.getSystemIncludes(), this.quoteIncludePaths, this.getSystemIncludeHeaders(), this.currentIncludeFiles, this.getSysMacros(), this.macros, this.undefinedMacros, this.pathsRelCurFile);
        }
        ProjectBase out = this.model.addProject(np, np.getProjectDisplayName(), true);
        TraceModelBase.waitProjectParsed(out, false);
        return out;
    }

    public static void waitProjectParsed(ProjectBase main, boolean trace) {
        boolean wasWait = true;
        while (wasWait) {
            wasWait = TraceModelBase.waitParsed(main, trace);
            if (main.getLibraries().size() <= 0) continue;
            if (trace) {
                System.err.println("checking libraries for " + main);
            }
            for (CsmProject lib : main.getLibraries()) {
                if (trace) {
                    System.err.println("checking library " + lib.getName());
                }
                wasWait |= TraceModelBase.waitParsed((ProjectBase)lib, trace);
            }
        }
    }

    private static boolean waitParsed(ProjectBase project, boolean trace) {
        boolean wasWait = false;
        project.waitParse();
        return wasWait;
    }

    protected final List<String> getSystemIncludes() {
        HashSet<String> all = new HashSet<String>(this.systemIncludePaths);
        if (this.useCppSysIncludes) {
            if ((Utilities.getOperatingSystem() & 8) != 0) {
                all.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/../../../../include/c++/3.4.3");
                all.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/../../../../include/c++/3.4.3/i386-pc-solaris2.10");
                all.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/../../../../include/c++/3.4.3/backward");
                all.add("/usr/local/include");
                all.add("/usr/sfw/include");
                all.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/include");
                all.add("/usr/include");
            } else {
                all.add("/usr/include/g++");
                all.add("/usr/include/g++/i586-suse-linux");
                all.add("/usr/include/g++/backward");
                all.add("/usr/local/include");
                all.add("/usr/lib/gcc-lib/i586-suse-linux/3.3.4/include");
                all.add("/usr/i586-suse-linux/include");
                all.add("/usr/include");
            }
        } else if (this.useCSysIncludes) {
            all.add("/usr/local/include");
            all.add("/usr/lib/gcc-lib/i586-suse-linux/3.3.4/include");
            all.add("/usr/i586-suse-linux/include");
            all.add("/usr/include");
        }
        return new ArrayList<String>(all);
    }

    private List<String> getSystemIncludeHeaders() {
        return new ArrayList<String>();
    }

    protected List<String> getSysMacros() {
        HashSet<String> all = new HashSet<String>();
        if (this.useCppSysDefines) {
            if ((Utilities.getOperatingSystem() & 8) != 0) {
                all.add("__DBL_MIN_EXP__=(-1021)");
                all.add("__EXTENSIONS__=1");
                all.add("__FLT_MIN__=1.17549435e-38F");
                all.add("__CHAR_BIT__=8");
                all.add("_XOPEN_SOURCE=500");
                all.add("__WCHAR_MAX__=2147483647");
                all.add("__DBL_DENORM_MIN__=4.9406564584124654e-324");
                all.add("__FLT_EVAL_METHOD__=2");
                all.add("__DBL_MIN_10_EXP__=(-307)");
                all.add("__FINITE_MATH_ONLY__=0");
                all.add("__GNUC_PATCHLEVEL__=3");
                all.add("__SHRT_MAX__=32767");
                all.add("__LDBL_MAX__=1.18973149535723176502e+4932L");
                all.add("__unix=1");
                all.add("__LDBL_MAX_EXP__=16384");
                all.add("__SCHAR_MAX__=127");
                all.add("__USER_LABEL_PREFIX__=");
                all.add("__STDC_HOSTED__=1");
                all.add("_LARGEFILE64_SOURCE=1");
                all.add("__LDBL_HAS_INFINITY__=1");
                all.add("__DBL_DIG__=15");
                all.add("__FLT_EPSILON__=1.19209290e-7F");
                all.add("__GXX_WEAK__=1");
                all.add("__LDBL_MIN__=3.36210314311209350626e-4932L");
                all.add("__unix__=1");
                all.add("__DECIMAL_DIG__=21");
                all.add("_LARGEFILE_SOURCE=1");
                all.add("__LDBL_HAS_QUIET_NAN__=1");
                all.add("__GNUC__=3");
                all.add("__DBL_MAX__=1.7976931348623157e+308");
                all.add("__DBL_HAS_INFINITY__=1");
                all.add("__SVR4=1");
                all.add("__cplusplus=1");
                all.add("__DEPRECATED=1");
                all.add("__DBL_MAX_EXP__=1024");
                all.add("__GNUG__=3");
                all.add("__LONG_LONG_MAX__=9223372036854775807LL");
                all.add("__GXX_ABI_VERSION=1002");
                all.add("__FLT_MIN_EXP__=(-125)");
                all.add("__DBL_MIN__=2.2250738585072014e-308");
                all.add("__FLT_MIN_10_EXP__=(-37)");
                all.add("__DBL_HAS_QUIET_NAN__=1");
                all.add("__tune_i386__=1");
                all.add("__sun=1");
                all.add("__REGISTER_PREFIX__=");
                all.add("__NO_INLINE__=1");
                all.add("__i386=1");
                all.add("__FLT_MANT_DIG__=24");
                all.add("__VERSION__=\"3.4.3(csl-sol210-3_4-branch+sol_rpath)\"");
                all.add("i386=1");
                all.add("sun=1");
                all.add("unix=1");
                all.add("__i386__=1");
                all.add("__SIZE_TYPE__=unsignedint");
                all.add("__ELF__=1");
                all.add("__FLT_RADIX__=2");
                all.add("__LDBL_EPSILON__=1.08420217248550443401e-19L");
                all.add("__FLT_HAS_QUIET_NAN__=1");
                all.add("__FLT_MAX_10_EXP__=38");
                all.add("__LONG_MAX__=2147483647L");
                all.add("__FLT_HAS_INFINITY__=1");
                all.add("__PRAGMA_REDEFINE_EXTNAME=1");
                all.add("__EXCEPTIONS=1");
                all.add("__LDBL_MANT_DIG__=64");
                all.add("__WCHAR_TYPE__=longint");
                all.add("__FLT_DIG__=6");
                all.add("__INT_MAX__=2147483647");
                all.add("__FLT_MAX_EXP__=128");
                all.add("__DBL_MANT_DIG__=53");
                all.add("__WINT_TYPE__=longint");
                all.add("__LDBL_MIN_EXP__=(-16381)");
                all.add("__LDBL_MAX_10_EXP__=4932");
                all.add("__DBL_EPSILON__=2.2204460492503131e-16");
                all.add("__sun__=1");
                all.add("__svr4__=1");
                all.add("__FLT_DENORM_MIN__=1.40129846e-45F");
                all.add("__FLT_MAX__=3.40282347e+38F");
                all.add("__GNUC_MINOR__=4");
                all.add("__DBL_MAX_10_EXP__=308");
                all.add("__LDBL_DENORM_MIN__=3.64519953188247460253e-4951L");
                all.add("__PTRDIFF_TYPE__=int");
                all.add("__LDBL_MIN_10_EXP__=(-4931)");
                all.add("__LDBL_DIG__=18");
            } else {
                all.add("__CHAR_BIT__=8");
                all.add("__cplusplus=1");
                all.add("__DBL_DENORM_MIN__=4.9406564584124654e-324");
                all.add("__DBL_DIG__=15");
                all.add("__DBL_EPSILON__=2.2204460492503131e-16");
                all.add("__DBL_MANT_DIG__=53");
                all.add("__DBL_MAX_10_EXP__=308");
                all.add("__DBL_MAX__=1.7976931348623157e+308");
                all.add("__DBL_MAX_EXP__=1024");
                all.add("__DBL_MIN_10_EXP__=(-307)");
                all.add("__DBL_MIN__=2.2250738585072014e-308");
                all.add("__DBL_MIN_EXP__=(-1021)");
                all.add("__DECIMAL_DIG__=21");
                all.add("__DEPRECATED=1");
                all.add("__ELF__=1");
                all.add("__EXCEPTIONS=1");
                all.add("__FINITE_MATH_ONLY__=0");
                all.add("__FLT_DENORM_MIN__=1.40129846e-45F");
                all.add("__FLT_DIG__=6");
                all.add("__FLT_EPSILON__=1.19209290e-7F");
                all.add("__FLT_EVAL_METHOD__=2");
                all.add("__FLT_MANT_DIG__=24");
                all.add("__FLT_MAX_10_EXP__=38");
                all.add("__FLT_MAX__=3.40282347e+38F");
                all.add("__FLT_MAX_EXP__=128");
                all.add("__FLT_MIN_10_EXP__=(-37)");
                all.add("__FLT_MIN__=1.17549435e-38F");
                all.add("__FLT_MIN_EXP__=(-125)");
                all.add("__FLT_RADIX__=2");
                all.add("__GNUC__=3");
                all.add("__GNUC_MINOR__=3");
                all.add("__GNUC_PATCHLEVEL__=4");
                all.add("__GNUG__=3");
                all.add("__gnu_linux__=1");
                all.add("_GNU_SOURCE=1");
                all.add("__GXX_ABI_VERSION=102");
                all.add("__GXX_WEAK__=1");
                all.add("__i386=1");
                all.add("__i386__=1");
                all.add("i386=1");
                all.add("__INT_MAX__=2147483647");
                all.add("__LDBL_DENORM_MIN__=3.64519953188247460253e-4951L");
                all.add("__LDBL_DIG__=18");
                all.add("__LDBL_EPSILON__=1.08420217248550443401e-19L");
                all.add("__LDBL_MANT_DIG__=64");
                all.add("__LDBL_MAX_10_EXP__=4932");
                all.add("__LDBL_MAX__=1.18973149535723176502e+4932L");
                all.add("__LDBL_MAX_EXP__=16384");
                all.add("__LDBL_MIN_10_EXP__=(-4931)");
                all.add("__LDBL_MIN__=3.36210314311209350626e-4932L");
                all.add("__LDBL_MIN_EXP__=(-16381)");
                all.add("__linux=1");
                all.add("__linux__=1");
                all.add("linux=1");
                all.add("__LONG_LONG_MAX__=9223372036854775807LL");
                all.add("__LONG_MAX__=2147483647L");
                all.add("__NO_INLINE__=1");
                all.add("__PTRDIFF_TYPE__=int");
                all.add("__REGISTER_PREFIX__");
                all.add("__SCHAR_MAX__=127");
                all.add("__SHRT_MAX__=32767");
                all.add("__SIZE_TYPE__=unsigned int");
                all.add("__STDC_HOSTED__=1");
                all.add("__tune_i586__=1");
                all.add("__tune_pentium__=1");
                all.add("__unix=1");
                all.add("__unix__=1");
                all.add("unix=1");
                all.add("__USER_LABEL_PREFIX__");
                all.add("__VERSION__=\"3.3.4 (pre 3.3.5 20040809)\"");
                all.add("__WCHAR_MAX__=2147483647");
                all.add("__WCHAR_TYPE__=long int");
                all.add("__WINT_TYPE__=unsigned int");
            }
        } else if (this.useCSysDefines) {
            all.add("__DBL_MIN_EXP__=(-1021)");
            all.add("__FLT_MIN__=1.17549435e-38F");
            all.add("__CHAR_BIT__=8");
            all.add("__WCHAR_MAX__=2147483647");
            all.add("__DBL_DENORM_MIN__=4.9406564584124654e-324");
            all.add("__FLT_EVAL_METHOD__=2");
            all.add("__unix__=1");
            all.add("unix=1");
            all.add("__i386__=1");
            all.add("__SIZE_TYPE__=unsigned=int");
            all.add("__ELF__=1");
            all.add("__DBL_MIN_10_EXP__=(-307)");
            all.add("__FINITE_MATH_ONLY__=0");
            all.add("__GNUC_PATCHLEVEL__=4");
            all.add("__FLT_RADIX__=2");
            all.add("__LDBL_EPSILON__=1.08420217248550443401e-19L");
            all.add("__SHRT_MAX__=32767");
            all.add("__LDBL_MAX__=1.18973149535723176502e+4932L");
            all.add("__linux=1");
            all.add("__unix=1");
            all.add("__LDBL_MAX_EXP__=16384");
            all.add("__LONG_MAX__=2147483647L");
            all.add("__linux__=1");
            all.add("__SCHAR_MAX__=127");
            all.add("__DBL_DIG__=15");
            all.add("__USER_LABEL_PREFIX__");
            all.add("linux=1");
            all.add("__tune_pentium__=1");
            all.add("__STDC_HOSTED__=1");
            all.add("__LDBL_MANT_DIG__=64");
            all.add("__FLT_EPSILON__=1.19209290e-7F");
            all.add("__LDBL_MIN__=3.36210314311209350626e-4932L");
            all.add("__WCHAR_TYPE__=long int");
            all.add("__FLT_DIG__=6");
            all.add("__FLT_MAX_10_EXP__=38");
            all.add("__INT_MAX__=2147483647");
            all.add("__gnu_linux__=1");
            all.add("__FLT_MAX_EXP__=128");
            all.add("__DECIMAL_DIG__=21");
            all.add("__DBL_MANT_DIG__=53");
            all.add("__WINT_TYPE__=unsigned int");
            all.add("__GNUC__=3");
            all.add("__LDBL_MIN_EXP__=(-16381)");
            all.add("__tune_i586__=1");
            all.add("__LDBL_MAX_10_EXP__=4932");
            all.add("__DBL_EPSILON__=2.2204460492503131e-16");
            all.add("__DBL_MAX__=1.7976931348623157e+308");
            all.add("__DBL_MAX_EXP__=1024");
            all.add("__FLT_DENORM_MIN__=1.40129846e-45F");
            all.add("__LONG_LONG_MAX__=9223372036854775807LL");
            all.add("__FLT_MAX__=3.40282347e+38F");
            all.add("__GXX_ABI_VERSION=102");
            all.add("__FLT_MIN_10_EXP__=(-37)");
            all.add("__FLT_MIN_EXP__=(-125)");
            all.add("i386=1");
            all.add("__GNUC_MINOR__=3");
            all.add("__DBL_MAX_10_EXP__=308");
            all.add("__LDBL_DENORM_MIN__=3.64519953188247460253e-4951L");
            all.add("__DBL_MIN__=2.2250738585072014e-308");
            all.add("__PTRDIFF_TYPE__=int");
            all.add("__LDBL_MIN_10_EXP__=(-4931)");
            all.add("__REGISTER_PREFIX__");
            all.add("__LDBL_DIG__=18");
            all.add("__NO_INLINE__=1");
            all.add("__i386=1");
            all.add("__FLT_MANT_DIG__=24");
            all.add("__VERSION__=\"3.3.4 (pre 3.3.5 20040809)\"");
        }
        return new ArrayList<String>(all);
    }

    public ModelImpl getModel() {
        return this.model;
    }

    public List<String> getMacros() {
        return Collections.unmodifiableList(this.macros);
    }

    public boolean isPathsRelCurFile() {
        return this.pathsRelCurFile;
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public List<String> getQuoteIncludePaths() {
        return this.quoteIncludePaths;
    }

    public void setUseCSysDefines(boolean set) {
        this.useCSysDefines = set;
    }

    public void setUseCSysIncludes(boolean set) {
        this.useCSysIncludes = set;
    }

    public void setUseCppSysDefines(boolean set) {
        this.useCppSysDefines = set;
    }

    public void setUseCppSysIncludes(boolean set) {
        this.useCppSysIncludes = set;
    }

    public void setUseSysPredefined(boolean set) {
        this.setUseCSysDefines(set);
        this.setUseCSysIncludes(set);
        this.setUseCppSysDefines(set);
        this.setUseCppSysIncludes(set);
    }

    protected final void initDataObjects() {
        ProjectBase prj = this.getProject();
        if (prj != null) {
            HashSet<CsmFile> allFiles = new HashSet<CsmFile>(prj.getAllFiles());
            for (CsmProject lib : prj.getLibraries()) {
                allFiles.addAll(lib.getAllFiles());
            }
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    try {
                        FileImpl impl = (FileImpl)csmFile;
                        NativeFileItem item = impl.getNativeFileItem();
                        FileObject fo = item == null ? CndFileUtils.toFileObject((CharSequence)impl.getAbsolutePath()) : item.getFileObject();
                        DataObject dobj = fo == null || !fo.isValid() ? null : DataObject.find((FileObject)fo);
                        NativeProjectProvider.registerItemInDataObject(dobj, item);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                System.err.println("unexpected file " + csmFile);
            }
        }
    }

    protected static enum ProcessFlagResult {
        NONE_PROCESSED,
        CHAR_PROCESSED,
        ALL_PROCESSED;

    }
}

