/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThread;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ParserThreadManager {
    private static ParserThreadManager instance;
    private static final String threadNameBase = "Code Model Parser";
    private RequestProcessor processor;
    private final Set<Wrapper> wrappers = new CopyOnWriteArraySet<Wrapper>();
    private int currThread = 0;
    private boolean started = false;

    private ParserThreadManager() {
    }

    public static synchronized ParserThreadManager instance() {
        if (instance == null) {
            instance = new ParserThreadManager();
        }
        return instance;
    }

    public boolean isStandalone() {
        return this.processor == null;
    }

    synchronized void startup(boolean standalone) {
        if (this.started) {
            this.shutdown();
        }
        ParserQueue.instance().startup();
        int threadCount = CndUtils.getNumberCndWorkerThreads();
        if (!standalone) {
            this.processor = new RequestProcessor(threadNameBase, threadCount);
        }
        for (int i = 0; i < threadCount; ++i) {
            Wrapper r = new Wrapper(new ParserThread());
            if (standalone) {
                new Thread(r).start();
                continue;
            }
            this.processor.post((Runnable)r);
        }
        this.started = true;
    }

    synchronized void shutdown() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("=== ParserThreadManager.shutdown");
        }
        for (Wrapper wrapper : this.wrappers) {
            wrapper.stop();
        }
        ParserQueue.instance().shutdown();
        for (Wrapper wrapper : this.wrappers) {
            while (!wrapper.isStoped()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        this.currThread = 0;
        this.started = false;
    }

    public boolean isParserThread() {
        if (this.isStandalone()) {
            Thread current = Thread.currentThread();
            for (Wrapper wrapper : this.wrappers) {
                if (wrapper.thread != current) continue;
                return true;
            }
            return false;
        }
        return this.processor.isRequestProcessorThread();
    }

    public void waitEmptyProjectQueue(ProjectBase prj) {
        ParserQueue.instance().waitEmpty(prj);
    }

    private class Wrapper
    implements Runnable {
        private final ParserThread delegate;
        private Thread thread;

        public Wrapper(ParserThread delegate) {
            this.delegate = delegate;
        }

        public void stop() {
            assert (this.delegate != null);
            this.delegate.stop();
        }

        public boolean isStoped() {
            assert (this.delegate != null);
            return this.delegate.isStoped();
        }

        @Override
        public void run() {
            try {
                this.thread = Thread.currentThread();
                this.thread.setName("Code Model Parser " + ParserThreadManager.this.currThread++);
                ParserThreadManager.this.wrappers.add(this);
                this.delegate.run();
            }
            catch (Throwable thr) {
                DiagnosticExceptoins.register(thr);
            }
            finally {
                ParserThreadManager.this.wrappers.remove(this);
            }
        }
    }
}

