/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.content.project.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardEnum;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public abstract class DeclarationContainer
extends ProjectComponent {
    private final TreeMap<CharSequence, Object> declarations;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();

    protected DeclarationContainer(Key key) {
        super(key);
        this.declarations = new TreeMap(CharSequences.comparator());
    }

    protected DeclarationContainer(RepositoryDataInput input) throws IOException {
        super(input);
        this.declarations = UIDObjectFactory.getDefaultFactory().readStringToArrayUIDMap(input, UniqueNameCache.getManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclaration(CsmOffsetableDeclaration decl) {
        CharSequence uniqueName = CharSequences.create((CharSequence)decl.getUniqueName());
        CsmUID<CsmOffsetableDeclaration> anUid = UIDCsmConverter.declarationToUID(decl);
        try {
            this.declarationsLock.writeLock().lock();
            Object o = this.declarations.get(uniqueName);
            if (o instanceof CsmUID[]) {
                CsmUID[] uids = (CsmUID[])o;
                int size = uids.length;
                CsmUID res = null;
                int k = size;
                for (int i = 0; i < size; ++i) {
                    CsmUID uid = uids[i];
                    if (anUid.equals((Object)uid)) {
                        uids[i] = null;
                        --k;
                        continue;
                    }
                    res = uid;
                }
                if (k == 0) {
                    this.declarations.remove(uniqueName);
                } else if (k == 1) {
                    this.declarations.put(uniqueName, res);
                } else {
                    CsmUID[] newUids = new CsmUID[k];
                    k = 0;
                    for (int i = 0; i < size; ++i) {
                        CsmUID uid = uids[i];
                        if (uid == null) continue;
                        newUids[k] = uid;
                        ++k;
                    }
                    this.declarations.put(uniqueName, newUids);
                }
            } else if (o instanceof CsmUID) {
                this.declarations.remove(uniqueName);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.onRemoveDeclaration(decl);
        this.put();
    }

    protected void onRemoveDeclaration(CsmOffsetableDeclaration decl) {
    }

    protected ReadWriteLock getLock() {
        return this.declarationsLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeclaration(CsmOffsetableDeclaration decl) {
        CharSequence name = UniqueNameCache.getManager().getString(decl.getUniqueName());
        CsmUID<CsmOffsetableDeclaration> uid = RepositoryUtils.put(decl);
        assert (uid != null);
        if (!(uid instanceof SelfPersistent)) {
            String line = " [" + decl.getStartPosition().getLine() + ":" + decl.getStartPosition().getColumn() + "-" + decl.getEndPosition().getLine() + ":" + decl.getEndPosition().getColumn() + "]";
            new Exception("attempt to put local declaration " + decl + line).printStackTrace(System.err);
        }
        try {
            this.declarationsLock.writeLock().lock();
            Object o = this.declarations.get(name);
            if (o != null && (ForwardClass.isForwardClass((CsmObject)decl) || ForwardEnum.isForwardEnum((CsmObject)decl))) {
                return;
            }
            if (o instanceof CsmUID[]) {
                CsmUID[] uids = (CsmUID[])o;
                boolean found = false;
                for (int i = 0; i < uids.length; ++i) {
                    if (!UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)uids[i], uid) && !UIDUtilities.isForwardClass(uids[i])) continue;
                    uids[i] = uid;
                    found = true;
                    break;
                }
                if (!found) {
                    CsmUID[] res = new CsmUID[uids.length + 1];
                    res[0] = uid;
                    System.arraycopy(uids, 0, res, 1, uids.length);
                    this.declarations.put(name, res);
                }
            } else if (o instanceof CsmUID) {
                CsmUID oldUid = (CsmUID)o;
                if (UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)oldUid, uid) || UIDUtilities.isForwardClass(oldUid)) {
                    this.declarations.put(name, uid);
                } else {
                    CsmUID[] uids = new CsmUID[]{uid, oldUid};
                    this.declarations.put(name, uids);
                }
            } else {
                this.declarations.put(name, uid);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.onPutDeclaration(decl);
        this.put();
    }

    protected void onPutDeclaration(CsmOffsetableDeclaration decl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUIDsRange(CharSequence from, CharSequence to) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> list = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        from = CharSequences.create((CharSequence)from);
        to = CharSequences.create((CharSequence)to);
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(from, to).entrySet()) {
                DeclarationContainer.addAll(list, entry.getValue());
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> findExternalUIDsFile(CsmFile file) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> list = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        int fileID = UIDUtilities.getFileID(UIDs.get((Object)file));
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, Object> entry : this.declarations.entrySet()) {
                CsmUID uid;
                Object o = entry.getValue();
                if (o instanceof CsmUID[]) {
                    CsmUID[] uids;
                    for (CsmUID u : uids = (CsmUID[])o) {
                        if (UIDUtilities.getFileID(u) != fileID || CharSequenceUtilities.indexOf((CharSequence)UIDUtilities.getName(u, true), (CharSequence)"###") <= 0) continue;
                        list.add((CsmUID<CsmOffsetableDeclaration>)u);
                    }
                    continue;
                }
                if (!(o instanceof CsmUID) || UIDUtilities.getFileID(uid = (CsmUID)o) != fileID || CharSequenceUtilities.indexOf((CharSequence)UIDUtilities.getName(uid, true), (CharSequence)"###") <= 0) continue;
                list.add((CsmUID<CsmOffsetableDeclaration>)uid);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUIDsFQN(CharSequence fqn, CsmDeclaration.Kind[] kinds) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> list = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        char maxChar = '\u00ff';
        for (CsmDeclaration.Kind kind : kinds) {
            String prefix = CharSequenceUtils.toString((CharSequence)("" + Utils.getCsmDeclarationKindkey(kind)), (char)':', (CharSequence)fqn);
            CharSequence from = CharSequences.create((CharSequence)prefix);
            CharSequence to = CharSequences.create((CharSequence)(prefix + maxChar));
            try {
                this.declarationsLock.readLock().lock();
                for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(from, to).entrySet()) {
                    DeclarationContainer.addAll(list, entry.getValue());
                }
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
        }
        return list;
    }

    public SortedMap<CharSequence, Object> getTestDeclarations() {
        try {
            this.declarationsLock.readLock().lock();
            TreeMap<CharSequence, Object> treeMap = new TreeMap<CharSequence, Object>((SortedMap<CharSequence, Object>)this.declarations);
            return treeMap;
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    private static void addAll(Collection<CsmUID<CsmOffsetableDeclaration>> list, Object o) {
        if (o instanceof CsmUID[]) {
            CsmUID[] uids = (CsmUID[])o;
            list.addAll(Arrays.asList(uids));
        } else if (o instanceof CsmUID) {
            CsmUID uid = (CsmUID)o;
            list.add((CsmUID<CsmOffsetableDeclaration>)uid);
        }
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence from, CharSequence to) {
        return UIDCsmConverter.UIDsToDeclarations(this.getUIDsRange(from, to));
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence fqn, CsmDeclaration.Kind[] kinds) {
        return UIDCsmConverter.UIDsToDeclarations(this.getUIDsFQN(fqn, kinds));
    }

    public Collection<CsmOffsetableDeclaration> findExternalDeclarations(CsmFile file) {
        return UIDCsmConverter.UIDsToDeclarations(this.findExternalUIDsFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarationsUIDs() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> list = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        try {
            this.declarationsLock.readLock().lock();
            for (Object o : this.declarations.values()) {
                DeclarationContainer.addAll(list, o);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return list;
    }

    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence uniqueName) {
        ArrayList list = new ArrayList();
        uniqueName = CharSequences.create((CharSequence)uniqueName);
        try {
            this.declarationsLock.readLock().lock();
            DeclarationContainer.addAll(list, this.declarations.get(uniqueName));
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmDeclaration getDeclaration(CharSequence uniqueName) {
        CsmUID uid = null;
        uniqueName = CharSequences.create((CharSequence)uniqueName);
        try {
            this.declarationsLock.readLock().lock();
            Object o = this.declarations.get(uniqueName);
            if (o instanceof CsmUID[]) {
                CsmUID[] uids = (CsmUID[])o;
                uid = uids[0];
            } else if (o instanceof CsmUID) {
                CsmUID uidt;
                uid = uidt = (CsmUID)o;
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        Object result = UIDCsmConverter.UIDtoDeclaration(uid);
        if (uid != null && result == null) {
            DiagnosticExceptoins.registerIllegalRepositoryStateException("no declaration for UID ", uid);
        }
        return result;
    }

    public void clearDeclarations() {
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.clear();
            this.put();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToArrayUIDMap(this.declarations, aStream, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }
}

