/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.LogCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.cli.progress.RevisionInfoListener;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class StashListCommand
extends GitCommand {
    private final List<GitRevisionInfo> revisions = new ArrayList<GitRevisionInfo>();
    private final RevisionInfoListener listener;
    private final ProgressMonitor monitor;

    public StashListCommand(JGitRepository repository, GitClassFactory accessor, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, accessor, monitor);
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "stash");
        this.addArgument(0, "list");
        this.addArgument(0, "--raw");
        this.addArgument(0, "--pretty=raw");
    }

    public GitRevisionInfo[] getRevisions() {
        return this.revisions.toArray(new GitRevisionInfo[this.revisions.size()]);
    }

    private void addRevision(GitRevisionInfo info) {
        this.revisions.add(info);
        this.listener.notifyRevisionInfo(info);
    }

    @Override
    protected void run() throws GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap statuses = new LinkedHashMap();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        LogCommand.parseLog(output, statuses);
                    }
                }.runCLI();
                for (Map.Entry entry : statuses.entrySet()) {
                    this.addRevision(this.getClassFactory().createRevisionInfo((GitRevisionInfo.GitRevCommit)entry.getValue(), this.getRepository()));
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }
}

