/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class ListBranchCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final boolean all;
    private final ProgressMonitor monitor;
    private Map<String, GitBranch> branches;

    public ListBranchCommand(JGitRepository repository, GitClassFactory gitFactory, boolean all, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.all = all;
        this.monitor = monitor;
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "branch");
        this.addArgument(0, "-v");
        this.addArgument(0, "-v");
        if (this.all) {
            this.addArgument(0, "-a");
        }
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.branches = new LinkedHashMap<String, GitBranch>();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        ListBranchCommand.parseBranches(output, ListBranchCommand.this.getClassFactory(), ListBranchCommand.this.branches);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        throw new GitException("It seems the config file for repository at [" + ListBranchCommand.this.getRepository().getLocation().getPath() + "] is corrupted.\nEnsure it's valid.");
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    static void parseBranches(String output, GitClassFactory factory, Map<String, GitBranch> branches) {
        HashMap<String, String> links = new HashMap<String, String>();
        for (String line : output.split("\n")) {
            GitBranch createBranch;
            boolean remote;
            String[] s;
            if (!line.startsWith("* ") && !line.startsWith("  ")) continue;
            boolean def = '*' == line.charAt(0);
            line = line.substring(2);
            String branchName = null;
            if (line.startsWith("(no branch)")) {
                branchName = "(no branch)";
                line = "(no_branch)" + line.substring(11);
            }
            if ((s = line.split("\\s+")).length > 1 && "->".equals(s[1])) continue;
            if (branchName == null) {
                branchName = s[0];
            }
            if (remote = branchName.startsWith("remotes/")) {
                branchName = branchName.substring(8);
            }
            if (s.length > 1) {
                int i = line.indexOf(91);
                int j = line.indexOf(93);
                if (i > 0 && j > 0 && i < j) {
                    String link = line.substring(i + 1, j);
                    int k = link.indexOf(58);
                    if (k > 0) {
                        links.put(branchName, link.substring(0, k));
                    } else {
                        links.put(branchName, link);
                    }
                }
                createBranch = factory.createBranch(branchName, remote, def, s[1]);
            } else {
                createBranch = factory.createBranch(branchName, remote, def, "HEAD");
            }
            branches.put(branchName, createBranch);
        }
        for (Map.Entry entry : links.entrySet()) {
            GitBranch orig = branches.get(entry.getKey());
            GitBranch link = branches.get(entry.getValue());
            if (orig == null || link == null || !link.isRemote()) continue;
            factory.setBranchTracking(orig, link);
        }
    }
}

