/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListBranchCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class CreateBranchCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final String revision;
    private final String branchName;
    private GitBranch branch;
    private final ProgressMonitor monitor;
    private static final Logger LOG = Logger.getLogger(CreateBranchCommand.class.getName());

    public CreateBranchCommand(JGitRepository repository, GitClassFactory gitFactory, String branchName, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.branchName = branchName;
        this.revision = revision;
        this.monitor = monitor;
    }

    public GitBranch getBranch() {
        return this.branch;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(3);
        super.prepare();
        this.addArgument(0, "branch");
        this.addArgument(0, this.branchName);
        this.addArgument(0, this.revision);
        this.addArgument(1, "branch");
        this.addArgument(1, this.branchName);
        this.addArgument(2, "branch");
        this.addArgument(2, "-v");
        this.addArgument(2, "-v");
        this.addArgument(2, "-a");
    }

    @Override
    protected void run() throws GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap branches = new LinkedHashMap();
                final AtomicBoolean failed = new AtomicBoolean(false);
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CreateBranchCommand.this.parseTrackBranch(output, branches);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        if (error.contains("fatal: Cannot setup tracking information; starting point is not a branch.")) {
                            failed.set(true);
                        }
                    }
                }.runCLI();
                if (failed.get()) {
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CreateBranchCommand.this.parseTrackBranch(output, branches);
                        }
                    }.runCLI();
                }
                new GitCommand.Runner(canceled, 2){

                    @Override
                    public void outputParser(String output) throws GitException {
                        ListBranchCommand.parseBranches(output, CreateBranchCommand.this.getClassFactory(), branches);
                    }
                }.runCLI();
                this.branch = (GitBranch)branches.get(this.branchName);
                if (this.branch == null) {
                    LOG.log(Level.WARNING, "Branch {0}/{1} probably created but not in the branch list: {2}", new Object[]{this.branchName, this.branchName, branches.keySet()});
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    private void parseTrackBranch(String output, Map<String, GitBranch> branches) {
    }
}

