/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.antlr.ANTLRLexer;
import org.netbeans.modules.cnd.antlr.ANTLRParser;
import org.netbeans.modules.cnd.antlr.CodeGenerator;
import org.netbeans.modules.cnd.antlr.DefaultToolErrorHandler;
import org.netbeans.modules.cnd.antlr.FileCopyException;
import org.netbeans.modules.cnd.antlr.FileLineFormatter;
import org.netbeans.modules.cnd.antlr.LLkAnalyzer;
import org.netbeans.modules.cnd.antlr.MakeGrammar;
import org.netbeans.modules.cnd.antlr.NameSpace;
import org.netbeans.modules.cnd.antlr.PreservingFileWriter;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.antlr.StringUtils;
import org.netbeans.modules.cnd.antlr.TokenBuffer;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.ToolErrorHandler;
import org.netbeans.modules.cnd.antlr.Utils;
import org.netbeans.modules.cnd.antlr.collections.impl.BitSet;
import org.netbeans.modules.cnd.antlr.collections.impl.Vector;

public class Tool {
    public static String version = "";
    ToolErrorHandler errorHandler;
    protected boolean hasError = false;
    boolean genDiagnostics = false;
    boolean genDocBook = false;
    boolean genHTML = false;
    protected String outputDir = ".";
    protected String grammarFile;
    transient Reader f = new InputStreamReader(System.in);
    protected String literalsPrefix = "LITERAL_";
    protected boolean upperCaseMangledLiterals = false;
    protected NameSpace nameSpace = null;
    protected String namespaceAntlr = null;
    protected String namespaceStd = null;
    protected boolean genHashLines = true;
    protected boolean noConstructors = false;
    public static boolean memoization = false;
    public static boolean localLACache = true;
    public static boolean avoidLAMatch = true;
    public static boolean cloneGuessing = true;
    public static boolean extendedErrors = true;
    public static boolean agressive = false;
    private BitSet cmdLineArgValid = new BitSet();

    public Tool() {
        this.errorHandler = new DefaultToolErrorHandler(this);
    }

    public String getGrammarFile() {
        return this.grammarFile;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public String getNamespaceStd() {
        return this.namespaceStd;
    }

    public String getNamespaceAntlr() {
        return this.namespaceAntlr;
    }

    public boolean getGenHashLines() {
        return this.genHashLines;
    }

    public String getLiteralsPrefix() {
        return this.literalsPrefix;
    }

    public boolean getUpperCaseMangledLiterals() {
        return this.upperCaseMangledLiterals;
    }

    public void setFileLineFormatter(FileLineFormatter formatter) {
        FileLineFormatter.setFormatter(formatter);
    }

    protected void checkForInvalidArguments(String[] args, BitSet cmdLineArgValid) {
        for (int a = 0; a < args.length; ++a) {
            if (cmdLineArgValid.member(a)) continue;
            this.warning("invalid command-line argument: " + args[a] + "; ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFile(String source_name, String dest_name) throws IOException {
        File source_file = new File(source_name);
        File destination_file = new File(dest_name);
        Reader source = null;
        Writer destination = null;
        try {
            if (!source_file.exists() || !source_file.isFile()) {
                throw new FileCopyException("FileCopy: no such source file: " + source_name);
            }
            if (!source_file.canRead()) {
                throw new FileCopyException("FileCopy: source file is unreadable: " + source_name);
            }
            if (destination_file.exists()) {
                if (!destination_file.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + dest_name);
                DataInputStream in = new DataInputStream(System.in);
                if (!destination_file.canWrite()) {
                    throw new FileCopyException("FileCopy: destination file is unwriteable: " + dest_name);
                }
            } else {
                File parentdir = this.parent(destination_file);
                if (!parentdir.exists()) {
                    throw new FileCopyException("FileCopy: destination directory doesn't exist: " + dest_name);
                }
                if (!parentdir.canWrite()) {
                    throw new FileCopyException("FileCopy: destination directory is unwriteable: " + dest_name);
                }
            }
            source = new BufferedReader(new FileReader(source_file));
            destination = new BufferedWriter(new FileWriter(destination_file));
            char[] buffer = new char[1024];
            while (true) {
                int bytes_read;
                if ((bytes_read = source.read(buffer, 0, 1024)) == -1) {
                    return;
                }
                destination.write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void doEverythingWrapper(String[] args) {
        int exitCode = this.doEverything(args);
        System.exit(exitCode);
    }

    public int doEverything(String[] args) {
        org.netbeans.modules.cnd.antlr.preprocessor.Tool preTool = new org.netbeans.modules.cnd.antlr.preprocessor.Tool(this, args);
        boolean preprocess_ok = preTool.preprocess();
        String[] modifiedArgs = preTool.preprocessedArgList();
        this.processArguments(modifiedArgs);
        if (!preprocess_ok) {
            return 1;
        }
        this.f = this.getGrammarReader();
        ANTLRLexer lexer = new ANTLRLexer(this.f);
        TokenBuffer tokenBuf = new TokenBuffer(lexer);
        LLkAnalyzer analyzer = new LLkAnalyzer(this);
        MakeGrammar behavior = new MakeGrammar(this, args, analyzer);
        try {
            ANTLRParser p = new ANTLRParser(tokenBuf, behavior, this);
            p.setFilename(this.grammarFile);
            p.grammar();
            if (this.hasError()) {
                this.fatalError("Exiting due to errors.");
            }
            this.checkForInvalidArguments(modifiedArgs, this.cmdLineArgValid);
            String codeGenClassName = "org.netbeans.modules.cnd.antlr." + this.getLanguage(behavior) + "CodeGenerator";
            try {
                CodeGenerator codeGen = (CodeGenerator)Utils.createInstanceOf(codeGenClassName);
                codeGen.setBehavior(behavior);
                codeGen.setAnalyzer(analyzer);
                codeGen.setTool(this);
                codeGen.gen();
            }
            catch (ClassNotFoundException cnfe) {
                this.fatalError("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (InstantiationException ie) {
                this.fatalError("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalArgumentException ie) {
                this.fatalError("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalAccessException iae) {
                this.fatalError("code-generator class '" + codeGenClassName + "' is not accessible");
            }
        }
        catch (RecognitionException pe) {
            this.fatalError("Unhandled parser error: " + pe.getMessage());
        }
        catch (TokenStreamException io) {
            this.fatalError("TokenStreamException: " + io.getMessage());
        }
        return 0;
    }

    public void error(String s) {
        this.hasError = true;
        System.err.println("error: " + s);
    }

    public void error(String s, String file, int line, int column) {
        this.hasError = true;
        System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + s);
    }

    public String fileMinusPath(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return f;
        }
        return f.substring(endOfPath + 1);
    }

    public String getLanguage(MakeGrammar behavior) {
        if (this.genDiagnostics) {
            return "Diagnostic";
        }
        if (this.genHTML) {
            return "HTML";
        }
        if (this.genDocBook) {
            return "DocBook";
        }
        return behavior.language;
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    private static void help() {
        System.err.println("usage: java org.netbeans.modules.cnd.antlr.Tool [args] file.g");
        System.err.println("  -o outputDir       specify output directory where all output generated.");
        System.err.println("  -glib superGrammar specify location of supergrammar file.");
        System.err.println("  -debug             launch the ParseView debugger upon parser invocation.");
        System.err.println("  -html              generate a html file from your grammar.");
        System.err.println("  -docbook           generate a docbook sgml file from your grammar.");
        System.err.println("  -diagnostic        generate a textfile with diagnostics.");
        System.err.println("  -trace             have all rules call traceIn/traceOut.");
        System.err.println("  -traceLexer        have lexer rules call traceIn/traceOut.");
        System.err.println("  -traceParser       have parser rules call traceIn/traceOut.");
        System.err.println("  -traceTreeParser   have tree parser rules call traceIn/traceOut.");
        System.err.println("  -memoize           turn on rule memoization");
        System.err.println("  -h|-help|--help    this message");
    }

    public static void main(String[] args) {
        System.err.println("ANTLR Parser Generator   Version Sun-2.7.7(NoEx) (2006-01-29)   1989-2005");
        version = "Sun-2.7.7(NoEx) (2006-01-29)";
        try {
            boolean showHelp = false;
            if (args.length == 0) {
                showHelp = true;
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("-h") && !args[i].equals("-help") && !args[i].equals("--help")) continue;
                    showHelp = true;
                    break;
                }
            }
            if (showHelp) {
                Tool.help();
            } else {
                Tool theTool = new Tool();
                theTool.doEverything(args);
                Object var2_4 = null;
            }
        }
        catch (Exception e) {
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator"));
            System.err.println("#$%%*&@# internal error: " + e.toString());
            System.err.println("[complain to nearest government official");
            System.err.println(" or send hate-mail to parrt@org.netbeans.modules.cnd.antlr.org;");
            System.err.println(" please send stack trace with report.]" + System.getProperty("line.separator"));
            e.printStackTrace();
        }
    }

    public PrintWriter openOutputFile(String f) throws IOException {
        File out_dir;
        if (this.outputDir != "." && !(out_dir = new File(this.outputDir)).exists()) {
            out_dir.mkdirs();
        }
        return new PrintWriter(new PreservingFileWriter(this.outputDir + System.getProperty("file.separator") + f));
    }

    public Reader getGrammarReader() {
        BufferedReader f = null;
        try {
            if (this.grammarFile != null) {
                f = new BufferedReader(new FileReader(this.grammarFile));
            }
        }
        catch (IOException e) {
            this.fatalError("cannot open grammar file " + this.grammarFile);
        }
        return f;
    }

    public void reportException(Exception e, String message) {
        System.err.println(message == null ? e.getMessage() : message + ": " + e.getMessage());
    }

    public void reportProgress(String message) {
        System.out.println(message);
    }

    public void fatalError(String message) {
        System.err.println(message);
        Utils.error(message);
    }

    public void panic() {
        this.fatalError("panic");
    }

    public void panic(String s) {
        this.fatalError("panic: " + s);
    }

    public File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    public static Vector parseSeparatedList(String list, char separator) {
        StringTokenizer st = new StringTokenizer(list, String.valueOf(separator));
        Vector v = new Vector(10);
        while (st.hasMoreTokens()) {
            v.appendElement(st.nextToken());
        }
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    public String pathToFile(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return "." + System.getProperty("file.separator");
        }
        return f.substring(0, endOfPath + 1);
    }

    protected void processArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-diagnostic")) {
                this.genDiagnostics = true;
                this.genHTML = false;
                this.setArgOK(i);
            }
            if (args[i].equals("-memoize")) {
                memoization = true;
                this.setArgOK(i);
                continue;
            }
            if (args[i].equals("-o")) {
                this.setArgOK(i);
                if (i + 1 >= args.length) {
                    this.error("missing output directory with -o option; ignoring");
                    continue;
                }
                this.setOutputDirectory(args[++i]);
                this.setArgOK(i);
                continue;
            }
            if (args[i].equals("-html")) {
                this.genHTML = true;
                this.genDiagnostics = false;
                this.setArgOK(i);
                continue;
            }
            if (args[i].equals("-docbook")) {
                this.genDocBook = true;
                this.genDiagnostics = false;
                this.setArgOK(i);
                continue;
            }
            if (args[i].charAt(0) == '-') continue;
            this.grammarFile = args[i];
            this.setArgOK(i);
        }
    }

    public void setArgOK(int i) {
        this.cmdLineArgValid.add(i);
    }

    public void setOutputDirectory(String o) {
        this.outputDir = o;
    }

    public void toolError(String s) {
        System.err.println("error: " + s);
    }

    public void warning(String s) {
        System.err.println("warning: " + s);
    }

    public void warning(String s, String file, int line, int column) {
        System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + "warning:" + s);
    }

    public void warning(String[] s, String file, int line, int column) {
        if (s == null || s.length == 0) {
            this.fatalError("Bad multi-line message to Tool.warning");
        }
        System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + "warning:" + s[0]);
        for (int i = 1; i < s.length; ++i) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + "    " + s[i]);
        }
    }

    public void setNameSpace(String name) {
        if (null == this.nameSpace) {
            this.nameSpace = new NameSpace(StringUtils.stripFrontBack(name, "\"", "\""));
        }
    }
}

