/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.ui.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.html.ojet.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.network.NetworkSupport;
import org.netbeans.modules.web.clientproject.createprojectapi.ClientSideProjectGenerator;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Pair;

public final class NewProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(NewProjectWizardIterator.class.getName());
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String XHTML_MIME_TYPE = "text/xhtml";
    private final String displayName;
    private final String zipUrl;
    private final File tmpFile;
    private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> baseWizard;
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor wizardDescriptor;

    private NewProjectWizardIterator(String displayName, String projectDirName, String zipUrl, File tmpFile) {
        assert (displayName != null);
        assert (projectDirName != null);
        assert (zipUrl != null);
        assert (tmpFile != null);
        this.displayName = displayName;
        this.zipUrl = zipUrl;
        this.tmpFile = tmpFile;
        this.baseWizard = CreateProjectUtils.createBaseWizardPanel((String)projectDirName);
    }

    public static NewProjectWizardIterator newOracleJETBaseDistribution() {
        return new NewProjectWizardIterator(Bundle.NewProjectWizardIterator_newOracleJETBaseDistribution_displayName(), "OracleJETApplication", "http://www.oracle.com/webfolder/technetwork/jet/code/oraclejet.zip", new File(System.getProperty("java.io.tmpdir"), "oraclejet.zip"));
    }

    public static NewProjectWizardIterator newOracleJETQuickStartBasic() {
        return new NewProjectWizardIterator(Bundle.NewProjectWizardIterator_newOracleJETQuickStartBasic_displayName(), "OracleJETQuickStartBasic", "http://www.oracle.com/webfolder/technetwork/jet/public_samples/OracleJET_QuickStartBasic.zip", new File(System.getProperty("java.io.tmpdir"), "OracleJET_QuickStartBasic.zip"));
    }

    public static NewProjectWizardIterator newComponentInteractionSample() {
        return new NewProjectWizardIterator(Bundle.NewProjectWizardIterator_newComponentInteractionSample_displayName(), "OracleJETComponentInteraction", "http://www.oracle.com/webfolder/technetwork/jet/public_samples/JET-ComponentInteraction.zip", new File(System.getProperty("java.io.tmpdir"), "JET-ComponentInteraction.zip"));
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(Bundle.NewProjectWizardIterator_progress_creating());
        HashSet<FileObject> files = new HashSet<FileObject>();
        File projectDir = FileUtil.normalizeFile((File)((File)this.wizardDescriptor.getProperty("PROJECT_DIRECTORY")));
        if (!projectDir.isDirectory() && !projectDir.mkdirs()) {
            throw new IOException("Cannot create project directory: " + projectDir);
        }
        FileObject projectDirectory = FileUtil.toFileObject((File)projectDir);
        assert (projectDirectory != null) : "FileObject must be found for " + projectDir;
        files.add(projectDirectory);
        this.setupOjetFiles(handle, files, projectDirectory);
        CreateProjectProperties createProperties = new CreateProjectProperties(projectDirectory, (String)this.wizardDescriptor.getProperty("NAME")).setSiteRootFolder("");
        ClientSideProjectGenerator.createProject((CreateProjectProperties)createProperties);
        this.hackIgnoreSCSSErrorsInOJET(projectDirectory);
        handle.finish();
        return files;
    }

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizardDescriptor = wizard;
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                NewProjectWizardIterator.this.initializeInternal();
            }
        });
    }

    void initializeInternal() {
        assert (EventQueue.isDispatchThread());
        this.index = 0;
        this.panels = new WizardDescriptor.Panel[]{(WizardDescriptor.Panel)this.baseWizard.first()};
        List<String> steps = Arrays.asList((String)this.baseWizard.second());
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            assert (steps.get(i) != null) : "Missing name for step: " + i;
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps.toArray(new String[0]));
            jc.setName(steps.get(i));
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizardDescriptor.putProperty("PROJECT_DIRECTORY", null);
        this.wizardDescriptor.putProperty("NAME", null);
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.wizardDescriptor.putProperty("NewProjectWizard_Title", (Object)this.displayName);
        return this.panels[this.index];
    }

    public String name() {
        return Bundle.NewProjectWizardIterator_name(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private void setupOjetFiles(ProgressHandle handle, Set<FileObject> files, FileObject projectDirectory) throws IOException {
        block10: {
            try {
                handle.progress(Bundle.NewProjectWizardIterator_progress_downloading());
                NetworkSupport.downloadWithProgress((String)this.zipUrl, (File)this.tmpFile, (String)Bundle.NewProjectWizardIterator_progress_downloading());
                if (NewProjectWizardIterator.isHtmlFile(this.tmpFile)) {
                    if (NetworkSupport.showNetworkErrorDialog((String)this.displayName)) {
                        this.setupOjetFiles(handle, files, projectDirectory);
                    }
                } else {
                    handle.progress(Bundle.NewProjectWizardIterator_progress_unpacking());
                    NewProjectWizardIterator.unzip(this.tmpFile.getAbsolutePath(), FileUtil.toFile((FileObject)projectDirectory));
                    FileObject indexFile = projectDirectory.getFileObject("index.html");
                    if (indexFile != null) {
                        files.add(indexFile);
                    } else {
                        FileObject readmeFile = projectDirectory.getFileObject("README.md");
                        if (readmeFile != null) {
                            files.add(readmeFile);
                        }
                    }
                }
            }
            catch (NetworkException ex) {
                LOGGER.log(Level.INFO, "Failed to download OJET archive", ex);
                if (NetworkSupport.showNetworkErrorDialog((String)this.displayName)) {
                    this.setupOjetFiles(handle, files, projectDirectory);
                }
            }
            catch (InterruptedException ex) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
    }

    private static boolean isHtmlFile(File file) {
        assert (file != null);
        if (!file.exists()) {
            return false;
        }
        String mimeType = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)file), (String[])new String[]{HTML_MIME_TYPE, XHTML_MIME_TYPE});
        return HTML_MIME_TYPE.equals(mimeType) || XHTML_MIME_TYPE.equals(mimeType);
    }

    private static void unzip(String zipPath, File targetDirectory) throws IOException {
        assert (zipPath != null);
        assert (targetDirectory != null);
        try (ZipFile zipFile = new ZipFile(zipPath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                File destinationFile = new File(targetDirectory, zipEntry.getName());
                NewProjectWizardIterator.ensureParentExists(destinationFile);
                NewProjectWizardIterator.copyZipEntry(zipFile, zipEntry, destinationFile);
            }
        }
    }

    private static void ensureParentExists(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Cannot create parent directories for " + file.getAbsolutePath());
        }
    }

    private static void copyZipEntry(ZipFile zipFile, ZipEntry zipEntry, File destinationFile) throws IOException {
        if (zipEntry.isDirectory()) {
            return;
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);
             FileOutputStream outputStream = new FileOutputStream(destinationFile);){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    private void hackIgnoreSCSSErrorsInOJET(FileObject projectDirectory) {
        Enumeration children = projectDirectory.getChildren(true);
        while (children.hasMoreElements()) {
            FileObject file = (FileObject)children.nextElement();
            if (!"scss".equals(file.getName())) continue;
            try {
                file.setAttribute("disable_error_checking_CSS", (Object)Boolean.TRUE.toString());
                break;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

