/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMDeliveryAssurance;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.rm.AckRequestInterval;
import org.netbeans.modules.websvc.wsitmodelext.rm.AllowDuplicates;
import org.netbeans.modules.websvc.wsitmodelext.rm.CloseTimeout;
import org.netbeans.modules.websvc.wsitmodelext.rm.DeliveryAssurance;
import org.netbeans.modules.websvc.wsitmodelext.rm.FlowControl;
import org.netbeans.modules.websvc.wsitmodelext.rm.InOrder;
import org.netbeans.modules.websvc.wsitmodelext.rm.InactivityTimeout;
import org.netbeans.modules.websvc.wsitmodelext.rm.MaxReceiveBufferSize;
import org.netbeans.modules.websvc.wsitmodelext.rm.Ordered;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMAssertion;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMMS13QName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMMSQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMSunClientQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMSunQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.ResendInterval;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;

public class RMModelHelper {
    public static final String DEFAULT_INACT_TIMEOUT = "600000";
    public static final String DEFAULT_MAXRCVBUFFERSIZE = "32";
    public static final String DEFAULT_ACKINTERVAL = "200";
    private static HashMap<ConfigVersion, RMModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private RMModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final synchronized RMModelHelper getInstance(ConfigVersion configVersion) {
        RMModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new RMModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    private RMAssertion getRMAssertion(Policy p) {
        return (RMAssertion)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, RMAssertion.class, false);
    }

    private RMAssertion getRMAssertion(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        return this.getRMAssertion(p);
    }

    public boolean isRMEnabled(WSDLComponent c) {
        if (c instanceof Operation) {
            Operation o = (Operation)c;
            Binding b = (Binding)o.getParent();
            return this.isRMEnabledB(b);
        }
        if (c instanceof Binding) {
            return this.isRMEnabledB((Binding)c);
        }
        return false;
    }

    private boolean isRMEnabledB(Binding b) {
        return this.getRMAssertion(b) != null;
    }

    public void enableRM(Binding b, boolean enable) {
        if (enable) {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            All a = pmh.createPolicy((WSDLComponent)b, true);
            pmh.createElement((WSDLComponent)a, RMQName.RMASSERTION.getQName(this.configVersion), RMAssertion.class, false);
        } else {
            RMAssertion rm = this.getRMAssertion(b);
            if (rm != null) {
                PolicyModelHelper.removeElement((WSDLComponent)rm.getParent(), RMAssertion.class, false);
            }
            this.enableOrdered(b, false);
            this.enableFlowControl(b, false);
            this.enableAllowDuplicates(b, false);
            this.setSequenceBinding(b, null);
            this.setInactivityTimeout(b, null);
            RMModelHelper.setMaxReceiveBufferSize(b, null);
            PolicyModelHelper.cleanPolicies((WSDLComponent)b);
        }
    }

    public String getInactivityTimeout(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        RMAssertion rm = this.getRMAssertion(p);
        return this.getInactivityTimeout(rm);
    }

    public void setInactivityTimeout(Binding b, String value) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (value != null) {
            this.enableRM(b, true);
        }
        RMAssertion rm = this.getRMAssertion(p);
        this.setInactivityTimeout(rm, value);
    }

    private String getInactivityTimeout(RMAssertion rm) {
        String timeout = null;
        if (rm != null) {
            if (ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion)) {
                List time = rm.getExtensibilityElements(InactivityTimeout.class);
                if (time != null && time.size() > 0) {
                    timeout = ((InactivityTimeout)time.get(0)).getMilliseconds();
                }
            } else {
                List time = ((WSDLComponent)rm.getParent()).getExtensibilityElements(InactivityTimeout.class);
                if (time != null && time.size() > 0) {
                    timeout = ((InactivityTimeout)time.get(0)).getMilliseconds();
                }
            }
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInactivityTimeout(RMAssertion rm, String value) {
        if (rm != null) {
            WSDLModel model = rm.getModel();
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                if (ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion)) {
                    List time = rm.getExtensibilityElements(InactivityTimeout.class);
                    InactivityTimeout iTimeout = null;
                    if (time != null && time.size() > 0) {
                        iTimeout = (InactivityTimeout)time.get(0);
                    }
                    if (iTimeout == null) {
                        if (value != null) {
                            WSDLComponentFactory wcf = rm.getModel().getFactory();
                            InactivityTimeout inT = null;
                            inT = (InactivityTimeout)wcf.create((WSDLComponent)rm, RMMS13QName.INACTIVITYTIMEOUT.getQName(this.configVersion));
                            inT.setMilliseconds(value);
                            rm.addExtensibilityElement((ExtensibilityElement)inT);
                        }
                    } else if (value == null) {
                        rm.removeExtensibilityElement(iTimeout);
                    } else {
                        iTimeout.setMilliseconds(value);
                    }
                } else {
                    InactivityTimeout time = (InactivityTimeout)PolicyModelHelper.getTopLevelElement((WSDLComponent)rm.getParent(), InactivityTimeout.class, false);
                    if (value != null) {
                        if (time == null) {
                            WSDLComponentFactory wcf = rm.getModel().getFactory();
                            InactivityTimeout inT = null;
                            inT = (InactivityTimeout)wcf.create((WSDLComponent)rm.getParent(), RMMS13QName.INACTIVITYTIMEOUT.getQName(this.configVersion));
                            inT.setMilliseconds(value);
                            ((WSDLComponent)rm.getParent()).addExtensibilityElement((ExtensibilityElement)inT);
                        } else {
                            time.setMilliseconds(value);
                        }
                    } else if (time != null) {
                        ((WSDLComponent)rm.getParent()).removeExtensibilityElement((ExtensibilityElement)time);
                    }
                }
            }
            finally {
                if (!isTransaction) {
                    WSITModelSupport.doEndTransaction((Model)model);
                }
            }
        }
    }

    public void enableFlowControl(Binding b, boolean enable) {
        if (enable) {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            All a = pmh.createPolicy((WSDLComponent)b, true);
            pmh.createElement((WSDLComponent)a, RMMSQName.RMFLOWCONTROL.getQName(), FlowControl.class, false);
        } else {
            Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
            FlowControl fc = RMModelHelper.getFlowControl(p);
            if (fc != null) {
                PolicyModelHelper.removeElement((WSDLComponent)fc.getParent(), FlowControl.class, false);
            }
            PolicyModelHelper.cleanPolicies((WSDLComponent)b);
        }
    }

    public static boolean isFlowControl(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (p != null) {
            FlowControl fc = RMModelHelper.getFlowControl(p);
            return fc != null;
        }
        return false;
    }

    public void enableAllowDuplicates(Binding b, boolean enable) {
        if (enable) {
            assert (ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion));
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            All a = pmh.createPolicy((WSDLComponent)b, true);
            pmh.createElement((WSDLComponent)a, RMSunQName.ALLOWDUPLICATES.getQName(), AllowDuplicates.class, false);
        } else {
            Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
            AllowDuplicates ad = RMModelHelper.getAllowDuplicates(p);
            if (ad != null) {
                PolicyModelHelper.removeElement((WSDLComponent)ad.getParent(), AllowDuplicates.class, false);
            }
            PolicyModelHelper.cleanPolicies((WSDLComponent)b);
        }
    }

    public static boolean isAllowDuplicates(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (p != null) {
            AllowDuplicates dup = RMModelHelper.getAllowDuplicates(p);
            return dup != null;
        }
        return false;
    }

    public boolean isSequenceBinding(Binding b, RMSequenceBinding seq) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (p != null) {
            RMAssertion ass = this.getRMAssertion(PolicyModelHelper.getPolicyForElement((WSDLComponent)b));
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)ass, seq.getAssertionClass(), false) != null;
        }
        return false;
    }

    public boolean isDeliveryAssurance(Binding b, RMDeliveryAssurance assurance) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (p != null) {
            RMAssertion ass = this.getRMAssertion(PolicyModelHelper.getPolicyForElement((WSDLComponent)b));
            DeliveryAssurance delivery = (DeliveryAssurance)PolicyModelHelper.getTopLevelElement((WSDLComponent)ass, DeliveryAssurance.class, true);
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)delivery, assurance.getAssertionClass(), true) != null;
        }
        return false;
    }

    public void setSequenceBinding(Binding b, RMSequenceBinding newValue) {
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        RMAssertion rmAssertion = this.getRMAssertion(b);
        if (newValue == null) {
            if (rmAssertion != null) {
                for (RMSequenceBinding seq : RMSequenceBinding.values()) {
                    PolicyModelHelper.removeElement((WSDLComponent)rmAssertion, seq.getAssertionClass(), true);
                }
                PolicyModelHelper.cleanPolicies((WSDLComponent)b);
            }
            return;
        }
        pmh.createElement((WSDLComponent)rmAssertion, newValue.getQName(), newValue.getAssertionClass(), true);
    }

    public void setDeliveryAssurance(Binding b, RMDeliveryAssurance newValue) {
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        RMAssertion rmAssertion = this.getRMAssertion(b);
        if (newValue == null || RMDeliveryAssurance.getDefault().equals((Object)newValue)) {
            DeliveryAssurance dAssurance = (DeliveryAssurance)PolicyModelHelper.getTopLevelElement((WSDLComponent)rmAssertion, DeliveryAssurance.class, true);
            if (dAssurance != null) {
                for (RMDeliveryAssurance seq : RMDeliveryAssurance.values()) {
                    PolicyModelHelper.removeElement((WSDLComponent)dAssurance, seq.getAssertionClass(), true);
                }
                if (PolicyModelHelper.isEmpty((WSDLComponent)dAssurance)) {
                    PolicyModelHelper.removeElement((WSDLComponent)rmAssertion, DeliveryAssurance.class, true);
                }
            }
            PolicyModelHelper.cleanPolicies((WSDLComponent)b);
            return;
        }
        DeliveryAssurance dAssurance = (DeliveryAssurance)pmh.createElement((WSDLComponent)rmAssertion, RMQName.DELIVERYASSURANCE.getQName(this.configVersion), DeliveryAssurance.class, true);
        pmh.createElement((WSDLComponent)dAssurance, newValue.getQName(), newValue.getAssertionClass(), true);
    }

    public static void setMaxReceiveBufferSize(Binding b, String value) {
        FlowControl fc = RMModelHelper.getFlowControl(b);
        RMModelHelper.setMaxReceiveBufferSize(fc, value);
    }

    public static String getMaxReceiveBufferSize(Binding b) {
        FlowControl fc = RMModelHelper.getFlowControl(b);
        return RMModelHelper.getMaxReceiveBufferSize(fc);
    }

    private static FlowControl getFlowControl(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        return RMModelHelper.getFlowControl(p);
    }

    private static FlowControl getFlowControl(Policy p) {
        return (FlowControl)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, FlowControl.class, false);
    }

    private static String getMaxReceiveBufferSize(FlowControl fc) {
        MaxReceiveBufferSize maxBuf;
        String max = null;
        if (fc != null && (maxBuf = fc.getMaxReceiveBufferSize()) != null) {
            max = maxBuf.getMaxReceiveBufferSize();
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMaxReceiveBufferSize(FlowControl fc, String value) {
        if (fc != null) {
            WSDLModel model = fc.getModel();
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                MaxReceiveBufferSize maxBufSize = fc.getMaxReceiveBufferSize();
                if (maxBufSize == null) {
                    if (value != null) {
                        WSDLComponentFactory wcf = fc.getModel().getFactory();
                        MaxReceiveBufferSize maxBuf = (MaxReceiveBufferSize)wcf.create((WSDLComponent)fc, RMMSQName.MAXRECEIVEBUFFERSIZE.getQName());
                        maxBuf.setMaxReceiveBufferSize(value);
                        fc.addExtensibilityElement((ExtensibilityElement)maxBuf);
                    }
                } else if (value == null) {
                    fc.removeMaxReceiveBufferSize(maxBufSize);
                } else {
                    maxBufSize.setMaxReceiveBufferSize(value);
                }
            }
            finally {
                if (!isTransaction) {
                    WSITModelSupport.doEndTransaction((Model)model);
                }
            }
        }
    }

    public void enableOrdered(Binding b, boolean enable) {
        if (this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0)) {
            if (enable) {
                PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
                All a = pmh.createPolicy((WSDLComponent)b, true);
                pmh.createElement((WSDLComponent)a, RMSunQName.ORDERED.getQName(), Ordered.class, false);
            } else {
                Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
                Ordered ord = this.getOrdered(p);
                if (ord != null) {
                    PolicyModelHelper.removeElement((WSDLComponent)ord.getParent(), Ordered.class, false);
                }
                PolicyModelHelper.cleanPolicies((WSDLComponent)b);
            }
        } else {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
            RMAssertion rm = this.getRMAssertion(p);
            if (enable) {
                DeliveryAssurance delAssurance = (DeliveryAssurance)pmh.createElement((WSDLComponent)rm, RMQName.DELIVERYASSURANCE.getQName(this.configVersion), DeliveryAssurance.class, true);
                pmh.createElement((WSDLComponent)delAssurance, RMQName.INORDER.getQName(this.configVersion), InOrder.class, true);
            } else if (rm != null) {
                DeliveryAssurance delAssurance = this.getDeliveryAssurance(b);
                if (delAssurance != null) {
                    PolicyModelHelper.removeElement((WSDLComponent)delAssurance, InOrder.class, true);
                }
                if (PolicyModelHelper.isEmpty((WSDLComponent)delAssurance)) {
                    PolicyModelHelper.removeElement((WSDLComponent)rm, DeliveryAssurance.class, true);
                }
            }
        }
    }

    public boolean isOrderedEnabled(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (p != null) {
            if (this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0)) {
                Ordered ord = this.getOrdered(p);
                return ord != null;
            }
            DeliveryAssurance delAssurance = this.getDeliveryAssurance(b);
            if (delAssurance == null) {
                return false;
            }
            InOrder order = (InOrder)PolicyModelHelper.getTopLevelElement((WSDLComponent)delAssurance, InOrder.class, true);
            return order != null;
        }
        return false;
    }

    private DeliveryAssurance getDeliveryAssurance(Binding b) {
        RMAssertion rm = this.getRMAssertion(b);
        if (rm != null) {
            return (DeliveryAssurance)PolicyModelHelper.getTopLevelElement((WSDLComponent)rm, DeliveryAssurance.class, true);
        }
        return null;
    }

    private Ordered getOrdered(Policy p) {
        return (Ordered)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, Ordered.class, false);
    }

    private static AllowDuplicates getAllowDuplicates(Policy p) {
        return (AllowDuplicates)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, AllowDuplicates.class, false);
    }

    public static String getResendInterval(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        ResendInterval ri = (ResendInterval)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, ResendInterval.class, false);
        if (ri != null) {
            return ri.getResendInterval();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResendInterval(Binding b, String value) {
        WSDLModel model = b.getModel();
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        All all = pmh.createPolicy((WSDLComponent)b, false);
        ResendInterval ri = (ResendInterval)pmh.createElement((WSDLComponent)all, RMSunClientQName.RESENDINTERVAL.getQName(), ResendInterval.class, false);
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            if (ri != null) {
                if (value == null) {
                    PolicyModelHelper.removeElement((WSDLComponent)ri);
                } else {
                    ri.setResendInterval(value);
                }
            }
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }

    public static String getCloseTimeout(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        CloseTimeout ct = (CloseTimeout)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, CloseTimeout.class, false);
        if (ct != null) {
            return ct.getCloseTimeout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseTimeout(Binding b, String value) {
        WSDLModel model = b.getModel();
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        All all = pmh.createPolicy((WSDLComponent)b, false);
        CloseTimeout ct = (CloseTimeout)pmh.createElement((WSDLComponent)all, RMSunClientQName.CLOSETIMEOUT.getQName(), CloseTimeout.class, false);
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            if (ct != null) {
                if (value == null) {
                    PolicyModelHelper.removeElement((WSDLComponent)ct);
                } else {
                    ct.setCloseTimeout(value);
                }
            }
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }

    public static String getAckRequestInterval(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        AckRequestInterval ri = (AckRequestInterval)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, AckRequestInterval.class, false);
        if (ri != null) {
            return ri.getAckRequestInterval();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAckRequestInterval(Binding b, String value) {
        WSDLModel model = b.getModel();
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        All all = pmh.createPolicy((WSDLComponent)b, false);
        AckRequestInterval ri = (AckRequestInterval)pmh.createElement((WSDLComponent)all, RMSunClientQName.ACKREQUESTINTERVAL.getQName(), AckRequestInterval.class, false);
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            if (ri != null) {
                if (value == null) {
                    PolicyModelHelper.removeElement((WSDLComponent)ri);
                } else {
                    ri.setAckRequestInterval(value);
                }
            }
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }
}

