/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client.subpanels;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.wsitconf.ui.client.PanelEnabler;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StaticCredsPanel
extends JPanel
implements PanelEnabler {
    private boolean inSync = false;
    private Binding binding;
    private boolean enable;
    private JPasswordField defaultPasswordField;
    private JLabel defaultPasswordLabel;
    private JLabel defaultUsernameLabel;
    private JTextField defaultUsernameTextField;

    public StaticCredsPanel(Binding b, boolean enable) {
        this.binding = b;
        this.enable = enable;
        this.initComponents();
        this.sync();
    }

    public void sync() {
        String defaultPassword;
        this.inSync = true;
        String defaultUsername = ProprietarySecurityPolicyModelHelper.getDefaultUsername(this.binding);
        if (defaultUsername != null) {
            this.setDefaultUsername(defaultUsername);
        }
        if ((defaultPassword = ProprietarySecurityPolicyModelHelper.getDefaultPassword(this.binding)) != null) {
            this.setDefaultPassword(defaultPassword);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private String getDefaultPassword() {
        return String.copyValueOf(this.defaultPasswordField.getPassword());
    }

    private void setDefaultPassword(String passwd) {
        this.defaultPasswordField.setText(passwd);
    }

    private String getDefaultUsername() {
        return this.defaultUsernameTextField.getText();
    }

    private void setDefaultUsername(String username) {
        this.defaultUsernameTextField.setText(username);
    }

    public void setValue(JComponent source, Object value) {
        if (this.inSync) {
            return;
        }
        if (source.equals(this.defaultUsernameTextField)) {
            String u = this.getDefaultUsername();
            if (u != null && u.length() == 0) {
                u = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "usernameHandler", null, u, true);
        } else if (source.equals(this.defaultPasswordField)) {
            String p = this.getDefaultPassword();
            if (p != null && p.length() == 0) {
                p = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "passwordHandler", null, p, true);
        }
        this.enableDisable();
    }

    private void enableDisable() {
        this.defaultPasswordField.setEnabled(this.isPanelEnabled());
        this.defaultPasswordLabel.setEnabled(this.isPanelEnabled());
        this.defaultUsernameLabel.setEnabled(this.isPanelEnabled());
        this.defaultUsernameTextField.setEnabled(this.isPanelEnabled());
    }

    @Override
    public boolean isPanelEnabled() {
        return this.enable;
    }

    @Override
    public void enablePanel(boolean doEnable) {
        this.enable = doEnable;
    }

    private void initComponents() {
        this.defaultPasswordLabel = new JLabel();
        this.defaultUsernameLabel = new JLabel();
        this.defaultUsernameTextField = new JTextField();
        this.defaultPasswordField = new JPasswordField();
        Mnemonics.setLocalizedText((JLabel)this.defaultPasswordLabel, (String)NbBundle.getMessage(StaticCredsPanel.class, (String)"LBL_DefaultPasswordLabel"));
        Mnemonics.setLocalizedText((JLabel)this.defaultUsernameLabel, (String)NbBundle.getMessage(StaticCredsPanel.class, (String)"LBL_DefaultUsernameLabel"));
        this.defaultUsernameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StaticCredsPanel.this.defaultUsernameTextFieldKeyReleased(evt);
            }
        });
        this.defaultPasswordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StaticCredsPanel.this.defaultPasswordFieldKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultUsernameLabel).addComponent(this.defaultPasswordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultUsernameTextField, -1, 279, Short.MAX_VALUE).addComponent(this.defaultPasswordField, -1, 279, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultUsernameTextField, -2, -1, -2).addComponent(this.defaultUsernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultPasswordField, -2, 19, -2).addComponent(this.defaultPasswordLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.defaultPasswordField, this.defaultUsernameTextField);
    }

    private void defaultPasswordFieldKeyReleased(KeyEvent evt) {
        this.setValue(this.defaultPasswordField, null);
    }

    private void defaultUsernameTextFieldKeyReleased(KeyEvent evt) {
        this.setValue(this.defaultUsernameTextField, null);
    }
}

